/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.preferences;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.PreferenceRegistry;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class PreferenceSetCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final OptionKey OPT_KEY = new OptionKey("key");
    public static final OptionKey OPT_VALUE = new OptionKey("value");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_KEY, "key", 1, 1), Messages.PreferenceSetCmd_KeyHelp);
        options.addOption((IPositionalOptionDefinition)new PositionalOptionDefinition((IOptionKey)OPT_VALUE, "value", 1, 1), Messages.PreferenceSetCmd_ValueHelp);
        return options;
    }

    public void run() throws FileSystemException {
        String key;
        Set validPreferences = PreferenceRegistry.getDefaultPreferences().keySet();
        if (!validPreferences.contains(key = this.config.getSubcommandCommandLine().getOption((IOptionKey)OPT_KEY))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.PreferenceGetCmd_InvalidKey, (Object)key, (Object)this.config.getContext().getAppName()));
        }
        String value = this.config.getSubcommandCommandLine().getOption((IOptionKey)OPT_VALUE);
        try {
            ((ScmClientConfiguration)this.config).getPersistentPreferences().setPreference(key, value);
        }
        catch (Exception e) {
            StatusHelper.failure((String)e.getLocalizedMessage(), (Throwable)e);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        out.println((CharSequence)NLS.bind((String)Messages.PropertySetCmd_KeySuccessfullySetToValue, (Object)key, (Object)value));
    }
}

