/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.preferences;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.PreferenceRegistry;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class PreferenceListCmd
extends AbstractSubcommand
implements IOptionSource {
    Map<String, String> currentPreferences;
    Map<String, PreferenceRegistry.PreferenceModel> defaultPreferences;

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.PreferenceListCmd_VerboseHelp);
        return options;
    }

    public void run() throws FileSystemException {
        this.currentPreferences = ((ScmClientConfiguration)this.config).getPersistentPreferences().getRegistryContents();
        this.defaultPreferences = PreferenceRegistry.getDefaultPreferences();
        List<String> validPreferences = new ArrayList<String>();
        validPreferences.addAll(this.defaultPreferences.keySet());
        Collections.sort(validPreferences);
        String key = this.getKey(validPreferences);
        if (key != null) {
            validPreferences = Collections.singletonList(key);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        IndentingPrintStream indent = out.indent();
        if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            int maxWidth = Messages.PreferenceListCmd_DefaultValue.length();
            int termWidth = SubcommandUtil.getTerminalWidth((IClientConfiguration)this.config);
            String nameText = StringUtil.pad((CharSequence)Messages.PreferenceListCmd_Name, (int)maxWidth).toString();
            String descriptionText = StringUtil.pad((CharSequence)Messages.PreferenceListCmd_Description, (int)maxWidth).toString();
            for (String preferenceName : validPreferences) {
                PreferenceRegistry.PreferenceModel defaultPreference = this.defaultPreferences.get(preferenceName);
                List<String> preferenceValueString = this.getPreferenceValueString(preferenceName);
                indent.println();
                indent.println((CharSequence)NLS.bind((String)Messages.PreferenceListCmd_SectionText, (Object)nameText, (Object)preferenceName));
                String alignText = ": ";
                int index = 0;
                while (index < defaultPreference.getDescription().length) {
                    String desc = defaultPreference.getDescription()[index];
                    Collection lines = null;
                    if (index == 0) {
                        lines = StringUtil.wrapAndIndent((String)NLS.bind((String)Messages.PreferenceListCmd_SectionText, (Object)descriptionText, (Object)desc), (String)alignText, (int)(termWidth - out.getIndent()));
                    } else {
                        int indentLen = descriptionText.length() + alignText.length() + 1;
                        lines = StringUtil.wrapAndIndent((String)desc, (int)(termWidth - out.getIndent()), (int)indentLen);
                    }
                    for (String line : lines) {
                        indent.println((CharSequence)line);
                    }
                    ++index;
                }
                indent.println((CharSequence)NLS.bind((String)Messages.PreferenceListCmd_SectionText, (Object)Messages.PreferenceListCmd_DefaultValue, (Object)preferenceValueString.get(1)));
                indent.println((CharSequence)NLS.bind((String)Messages.PreferenceListCmd_SectionText, (Object)Messages.PreferenceListCmd_CurrentValue, (Object)preferenceValueString.get(0)));
            }
        } else {
            int maxWidth = 0;
            for (String preferenceName : validPreferences) {
                maxWidth = Math.max(maxWidth, preferenceName.length());
            }
            for (String preferenceName : validPreferences) {
                List<String> preferenceValueString = this.getPreferenceValueString(preferenceName);
                indent.println((CharSequence)NLS.bind((String)Messages.PreferenceListCmd_KeyValue, (Object)StringUtil.pad((CharSequence)preferenceName, (int)maxWidth), (Object)preferenceValueString.get(0)));
            }
        }
    }

    protected String getKey(List<String> validPreferences) throws CLIFileSystemClientException {
        return null;
    }

    private List<String> getPreferenceValueString(String preferenceName) throws FileSystemException {
        PreferenceRegistry.PreferenceModel defaultPreference = this.defaultPreferences.get(preferenceName);
        String defaultPreferenceValue = defaultPreference.getDefaultValue();
        String preferenceValue = this.currentPreferences.get(preferenceName);
        String preferenceUnits = defaultPreference.getUnits();
        if (preferenceName.equalsIgnoreCase("trace.dir") && preferenceValue == null) {
            defaultPreferenceValue = this.config.getConfigDirectory().getAbsolutePath();
        }
        if (preferenceValue == null) {
            preferenceValue = defaultPreferenceValue == null || defaultPreferenceValue.length() == 0 ? defaultPreference.getDefaultDisplayValue() : defaultPreferenceValue;
        }
        ArrayList<String> preferenceValueString = new ArrayList<String>();
        if (preferenceUnits != null && preferenceUnits.trim().length() != 0) {
            preferenceValueString.add(NLS.bind((String)Messages.PreferenceListCmd_Value_Units, (Object)preferenceValue, (Object)preferenceUnits));
            preferenceValueString.add(NLS.bind((String)Messages.PreferenceListCmd_Value_Units, (Object)defaultPreferenceValue, (Object)preferenceUnits));
        } else {
            preferenceValueString.add(preferenceValue);
            if (defaultPreferenceValue == null || defaultPreferenceValue.length() == 0) {
                preferenceValueString.add(defaultPreference.getDefaultDisplayValue());
            } else {
                preferenceValueString.add(defaultPreferenceValue);
            }
        }
        return preferenceValueString;
    }
}

