/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.UpdateCurrentPatchResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PortUndoCmd
extends AbstractPortSubcommand {
    protected static final PositionalOptionDefinition OPT_COMPONENT = new PositionalOptionDefinition("component", 1, 1);
    public static final NamedOptionDefinition OPT_CHANGES = new NamedOptionDefinition("c", "changes", -1, "@");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE);
        options.addOption((INamedOptionDefinition)OPT_CHANGES, Messages.PortUndoCmdOption_CHANGES_TO_UNDO);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PortResolveCmdOption_SEPARATOR, (Object)OPT_CHANGES.getName(), (Object[])new Object[0]));
        options.addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName(), (Object[])new Object[0]));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashSet<String> changesToUndo = new HashSet<String>();
        if (cli.hasOption((IOptionKey)OPT_CHANGES)) {
            List argChanges = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_CHANGES), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)argChanges, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.VERSIONABLE, RepoUtil.ItemType.CHANGE});
            List selChanges = RepoUtil.getSelectors((List)argChanges);
            int i = 0;
            while (i < selChanges.size()) {
                UUID uuid = RepoUtil.lookupUuid((String)((String)selChanges.get(i)));
                if (uuid == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.UndoCmd_0, selChanges.get(i), (Object[])new Object[0]));
                }
                changesToUndo.add(uuid.getUuidValue());
                ++i;
            }
        }
        if (changesToUndo.isEmpty()) {
            throw StatusHelper.argSyntax((String)Messages.PortUndoCmd_NO_CHANGES);
        }
        String action = "undo";
        ParmsUpdateCurrentPatch parms = new ParmsUpdateCurrentPatch();
        parms.workspace = targetWs;
        parms.componentItemId = componentDto.getItemId();
        parms.changeIds = changesToUndo.toArray(new String[changesToUndo.size()]);
        parms.action = action;
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        try {
            UpdateCurrentPatchResultDTO resultDto = client.postUpdateCurrentPatch(parms, null);
            this.printResult(resultDto, out);
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortUndoCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
        if (this.hasVerboseOption(cli)) {
            PortUndoCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
        }
    }

    @Override
    protected void validateCommonArguments(ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument workspace = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)workspace, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument component = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)component, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
    }

    private void printResult(UpdateCurrentPatchResultDTO result, IndentingPrintStream out) {
        if (result.isSetUpdateDilemma()) {
            out.println((CharSequence)Messages.PortUndoCmd_FAILURE);
        } else {
            out.println((CharSequence)Messages.PortUndoCmd_SUCCESS);
        }
    }
}

