/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.GapInPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.client.internal.portcommand.CurrentPortCmd;
import com.ibm.team.filesystem.cli.client.internal.portcommand.PortResolveCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProcessAcceptQueue;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ProcessAcceptQueueResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.VersionableChangeDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class PortStartCmd
extends AbstractPortSubcommand {
    private static final NamedOptionDefinition OPT_CURRENT = new NamedOptionDefinition("c", "current", 0);
    private static final NamedOptionDefinition OPT_SINGLE = new NamedOptionDefinition("s", "single", 0);
    public static final NamedOptionDefinition OPT_INPLACE_CONFLICT_HANDLER = new NamedOptionDefinition("i", "in-place-markers", 0);

    public void run() throws FileSystemException {
        int noOfUncheckedInChanges;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ParmsProcessAcceptQueue parmsStart = new ParmsProcessAcceptQueue();
        parmsStart.workspace = targetWs;
        parmsStart.componentItemId = componentDto.getItemId();
        if (cli.hasOption((IOptionKey)OPT_CURRENT) && cli.hasOption((IOptionKey)OPT_SINGLE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)OPT_CURRENT.getName(), (Object)OPT_SINGLE.getName()));
        }
        parmsStart.action = cli.hasOption((IOptionKey)OPT_CURRENT) ? "create_current_patch" : (cli.hasOption((IOptionKey)OPT_SINGLE) ? "create_current_patch_with_auto" : "initiate_auto_patch");
        parmsStart.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parmsStart.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parmsStart.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        ProcessAcceptQueueResultDTO result = null;
        try {
            result = client.postProcessAcceptQueue(parmsStart, null);
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortStartCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
        if (result.isCancelled() && (noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        CurrentPatchDTO currentPort = result.getCurrentPatch();
        if (cli.hasOption((IOptionKey)OPT_CURRENT)) {
            out.println((CharSequence)Messages.PortStartCmd_MARKED_CURRENT_GUIDANCE);
        } else if (cli.hasOption((IOptionKey)OPT_SINGLE)) {
            out.println((CharSequence)Messages.PortStartCmd_PROCESSED_CURRENT_GUIDANCE);
        } else if (currentPort == null && result.getAcceptQueueSize() == 0L) {
            out.println((CharSequence)Messages.PortCmd_NO_PENDING_PORTS_GUIDANCE);
        } else {
            out.println((CharSequence)Messages.PortStartCmd_SUCCESS);
        }
        if (cli.hasOption((IOptionKey)OPT_INPLACE_CONFLICT_HANDLER)) {
            this.markInPlaceConflicts(this.config, targetWs, result, client, this.hasVerboseOption(cli));
            out.println((CharSequence)Messages.Conflicts_InPlaceMarkers_Help);
        }
        if (currentPort != null) {
            if (this.hasUnresolvedChanges(currentPort)) {
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, PortResolveCmd.class);
                out.println((CharSequence)NLS.bind((String)Messages.PortCmd_RESOLVE_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString()}));
            } else {
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, CurrentPortCmd.class);
                out.println((CharSequence)NLS.bind((String)Messages.PortCmd_COMPLETE_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), CurrentPortCmd.OPT_COMPLETE.getName()}));
            }
        }
        if (this.hasVerboseOption(cli)) {
            PortStartCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.Common_FORCE_OVERWRITE_UNCOMMITTED);
        options.addOption((INamedOptionDefinition)OPT_INPLACE_CONFLICT_HANDLER, Messages.AcceptCmdOptions_1);
        options.addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_CURRENT, Messages.PortCmdOption_CREATE_CURRENT_PORT, false).addOption((INamedOptionDefinition)OPT_SINGLE, Messages.PortCmdOption_PROCESS_SINGLE_PORT, false));
        options.addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE);
        options.addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }

    private void markInPlaceConflicts(IScmClientConfiguration config, ParmsWorkspace ws, ProcessAcceptQueueResultDTO updateResult, IFilesystemRestClient client, boolean verbose) throws FileSystemException {
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        if (cfaRootPath != null) {
            Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
            CurrentPatchDTO currentPort = updateResult.getCurrentPatch();
            if (currentPort != null) {
                GapInPlaceConflictHandler handler = new GapInPlaceConflictHandler();
                handler.handleConflicts((IPath)cfaRoot, ws, currentPort, client, config);
            }
        }
    }

    private boolean hasUnresolvedChanges(CurrentPatchDTO currentPort) {
        boolean hasUnresolved = false;
        for (VersionableChangeDTO changeDTO : currentPort.getChanges()) {
            if (changeDTO.isResolved()) continue;
            hasUnresolved = true;
            break;
        }
        return hasUnresolved;
    }
}

