/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.GapInPlaceConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.client.internal.portcommand.CurrentPortCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ContentChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.UpdateCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.VersionableChangeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.subcommands.HelpCmd;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.ProducesOrphansInConfigurationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class PortResolveCmd
extends AbstractPortSubcommand {
    protected static final PositionalOptionDefinition OPT_COMPONENT = new PositionalOptionDefinition("component", 1, 1);
    public static final NamedOptionDefinition OPT_CHANGES = new NamedOptionDefinition("c", "changes", -1, "@");
    public static final NamedOptionDefinition OPT_RESOLVE_WITH_MINE = new NamedOptionDefinition("m", "mine", 0);
    public static final NamedOptionDefinition OPT_RESOLVE_WITH_PROPOSED = new NamedOptionDefinition("p", "proposed", 0);
    public static final NamedOptionDefinition OPT_INPLACE_CONFLICT_HANDLER = new NamedOptionDefinition("i", "in-place-markers", 0);
    public static final NamedOptionDefinition OPT_PARENT = new NamedOptionDefinition(null, "parent", 1);

    public void run() throws FileSystemException {
        boolean automergeDisabled;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        boolean bl = automergeDisabled = cli.hasOption((IOptionKey)OPT_RESOLVE_WITH_MINE) || cli.hasOption((IOptionKey)OPT_RESOLVE_WITH_PROPOSED);
        if (automergeDisabled && cli.hasOption((IOptionKey)OPT_INPLACE_CONFLICT_HANDLER)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.PortResolveCmd_INVALID_INPLACE_MARKER_REQUEST, (Object[])new String[]{OPT_INPLACE_CONFLICT_HANDLER.getName(), OPT_RESOLVE_WITH_MINE.getName(), OPT_RESOLVE_WITH_PROPOSED.getName()}));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashSet<String> changesToResolve = new HashSet<String>();
        if (cli.hasOption((IOptionKey)OPT_CHANGES)) {
            List argChanges = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_CHANGES), (IScmClientConfiguration)this.config);
            List selChanges = RepoUtil.getSelectors((List)argChanges);
            int i = 0;
            while (i < selChanges.size()) {
                UUID uuid = RepoUtil.lookupUuid((String)((String)selChanges.get(i)));
                if (uuid == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.UndoCmd_0, selChanges.get(i)));
                }
                changesToResolve.add(uuid.getUuidValue());
                ++i;
            }
        }
        if (changesToResolve.isEmpty()) {
            throw StatusHelper.argSyntax((String)Messages.PortResolveCmd_InvalidOptionMissingChanges);
        }
        ParmsUpdateCurrentPatch parms = new ParmsUpdateCurrentPatch();
        String action = "autoresolve";
        if (cli.hasOption((IOptionKey)OPT_RESOLVE_WITH_MINE)) {
            action = "mark_as_resolved";
        } else if (cli.hasOption((IOptionKey)OPT_RESOLVE_WITH_PROPOSED)) {
            action = "resolve_with_proposed";
        } else if (cli.hasOption((IOptionKey)OPT_PARENT)) {
            action = "reparent";
            ScmCommandLineArgument argParent = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PARENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)argParent, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            String selParent = argParent.getItemSelector();
            ILocation locParent = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)selParent);
            try {
                ResourcePropertiesDTO propsParent = RepoUtil.getResourceProperties((String)locParent.toOSString(), (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)false);
                parms.newParenId = propsParent.getItemId();
            }
            catch (Exception e) {
                UUID uuid = RepoUtil.lookupUuid((String)selParent);
                if (uuid == null) {
                    throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.UndoCmd_0, (Object)selParent));
                }
                parms.newParenId = uuid.getUuidValue();
            }
        }
        parms.workspace = targetWs;
        parms.componentItemId = componentDto.getItemId();
        parms.changeIds = changesToResolve.toArray(new String[changesToResolve.size()]);
        parms.bestEffort = true;
        parms.force = true;
        parms.action = action;
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        UpdateCurrentPatchResultDTO resultDto = null;
        try {
            resultDto = client.postUpdateCurrentPatch(parms, null);
        }
        catch (TeamRepositoryException tre) {
            ProducesOrphansInConfigurationException poe = (ProducesOrphansInConfigurationException)SubcommandUtil.findExceptionByType(ProducesOrphansInConfigurationException.class, (TeamRepositoryException)tre);
            if (poe != null) {
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, PortResolveCmd.class);
                throw StatusHelper.orphan((String)NLS.bind((String)Messages.PortResolveCmd_PRODUCES_ORPHANS, (Object[])new String[]{OPT_PARENT.getName(), this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()}), null);
            }
            throw StatusHelper.wrap((String)Messages.PortResolveCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
        String autoResolution = null;
        if (action == "autoresolve") {
            if (cli.hasOption((IOptionKey)OPT_INPLACE_CONFLICT_HANDLER)) {
                List<VersionableChangeDTO> unresolveChanges = this.getUnresolvedChanges(changesToResolve, resultDto);
                this.markInPlaceConflicts(this.config, targetWs, resultDto, unresolveChanges, client, this.hasVerboseOption(cli));
                autoResolution = Messages.Conflicts_InPlaceMarkers_Help;
            } else {
                for (String change : changesToResolve) {
                    if (resultDto.getResolvedVersionableIds().contains(change) || resultDto.getResolvedChangeDetailIds().contains(change)) continue;
                    autoResolution = Messages.PortResolveCmd_CANNOT_AUTORESOLVE;
                    break;
                }
            }
        }
        this.printResult(resultDto, autoResolution, out);
        if (!this.hasUnresolvedChanges(resultDto.getCurrentPatch())) {
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, CurrentPortCmd.class);
            out.println((CharSequence)NLS.bind((String)Messages.PortCmd_COMPLETE_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), CurrentPortCmd.OPT_COMPLETE.getName()}));
        }
        if (this.hasVerboseOption(cli)) {
            PortResolveCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.Common_FORCE_OVERWRITE_UNCOMMITTED);
        options.addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE);
        options.addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_RESOLVE_WITH_MINE, Messages.PortResolveCmdOption_RESOLVE_WITH_MINE, false).addOption((INamedOptionDefinition)OPT_RESOLVE_WITH_PROPOSED, Messages.PortResolveCmdOption_RESOLVE_WITH_PROPOSED, false).addOption((INamedOptionDefinition)OPT_INPLACE_CONFLICT_HANDLER, Messages.AcceptCmdOptions_1, false).addOption((INamedOptionDefinition)OPT_PARENT, Messages.PortResolveCmdOption_PARENT, false));
        options.addOption((INamedOptionDefinition)OPT_CHANGES, Messages.PortResolveCmdOption_CHANGES_TO_RESOLVE, true);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PortResolveCmdOption_SEPARATOR, (Object)OPT_CHANGES.getName()));
        options.addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }

    @Override
    protected void validateCommonArguments(ICommandLine cli) throws FileSystemException {
        int countChanges;
        ScmCommandLineArgument workspace = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)workspace, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument component = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)component, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        boolean hasChanges = cli.hasOption((IOptionKey)OPT_CHANGES);
        if (!hasChanges) {
            throw StatusHelper.argSyntax((String)Messages.PortResolveCmd_InvalidOptionMissingChanges);
        }
        List argChanges = cli.getOptionValues((IOptionKey)OPT_CHANGES);
        int n = countChanges = hasChanges ? argChanges.size() : 0;
        if (hasChanges && countChanges <= 0) {
            throw StatusHelper.argSyntax((String)Messages.PortCmd_UnexpectedArguments);
        }
        List changes = ScmCommandLineArgument.createList((List)argChanges, (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)changes, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.VERSIONABLE, RepoUtil.ItemType.CHANGE});
    }

    private void printResult(UpdateCurrentPatchResultDTO result, String autoResolution, IndentingPrintStream out) throws CLIFileSystemClientException {
        int noOfUncheckedInChanges;
        if (result.isCancelled() && (noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        if (result.isSetUpdateDilemma()) {
            out.println((CharSequence)Messages.PortResolveCmd_FAILURE);
        } else if (autoResolution == null) {
            out.println((CharSequence)Messages.PortResolveCmd_SUCCESS);
        } else {
            out.println((CharSequence)autoResolution);
        }
    }

    private void markInPlaceConflicts(IScmClientConfiguration config, ParmsWorkspace ws, UpdateCurrentPatchResultDTO updateResult, List<VersionableChangeDTO> unresolvedChanges, IFilesystemRestClient client, boolean verbose) throws FileSystemException {
        File cfaRootPath = SubcommandUtil.findAncestorCFARoot((String)config.getContext().getCurrentWorkingDirectory());
        if (cfaRootPath != null) {
            Path cfaRoot = new Path(cfaRootPath.getAbsolutePath());
            CurrentPatchDTO currentPort = updateResult.getCurrentPatch();
            if (currentPort != null) {
                GapInPlaceConflictHandler handler = new GapInPlaceConflictHandler();
                handler.handleConflicts((IPath)cfaRoot, ws, currentPort, unresolvedChanges, client, config);
            }
        }
    }

    private boolean hasUnresolvedChanges(CurrentPatchDTO currentPort) {
        boolean hasUnresolved = false;
        for (VersionableChangeDTO changeDTO : currentPort.getChanges()) {
            if (changeDTO.isResolved()) continue;
            hasUnresolved = true;
            break;
        }
        return hasUnresolved;
    }

    private List<VersionableChangeDTO> getUnresolvedChanges(Set<String> changesToResolve, UpdateCurrentPatchResultDTO resultDto) {
        HashSet<String> unresolvedChangeIds = new HashSet<String>();
        for (String idString : changesToResolve) {
            if (resultDto.getResolvedVersionableIds().contains(idString) || resultDto.getResolvedChangeDetailIds().contains(idString)) continue;
            unresolvedChangeIds.add(idString);
        }
        ArrayList<VersionableChangeDTO> unresolvedChanges = new ArrayList<VersionableChangeDTO>();
        CurrentPatchDTO currentPort = resultDto.getCurrentPatch();
        block1: for (VersionableChangeDTO changeDTO : currentPort.getChanges()) {
            if (unresolvedChangeIds.contains(changeDTO.getVersionableItemId())) {
                unresolvedChanges.add(changeDTO);
                continue;
            }
            for (ChangeDetailDTO detailDTO : changeDTO.getChangeDetails()) {
                if (!unresolvedChangeIds.contains(detailDTO.getId()) || !(detailDTO instanceof ContentChangeDetailDTO)) continue;
                unresolvedChanges.add(changeDTO);
                continue block1;
            }
        }
        return unresolvedChanges;
    }
}

