/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAddToAcceptQueue;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReorderAcceptQueue;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class PortReorderCmd
extends AbstractPortSubcommand {
    protected static final PositionalOptionDefinition OPT_COMPONENT = new PositionalOptionDefinition("component", 1, 1);
    public static final NamedOptionDefinition OPT_ORDER = new NamedOptionDefinition("o", "order", -1);
    public static final NamedOptionDefinition OPT_AFTER = new NamedOptionDefinition("a", "after", 1);
    public static final NamedOptionDefinition OPT_ADD = new NamedOptionDefinition(null, "add", -1);

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (!cli.hasOption((IOptionKey)OPT_ORDER) && !cli.hasOption((IOptionKey)OPT_ADD)) {
            throw StatusHelper.argSyntax((String)Messages.PortReorderCmd_MissingOption);
        }
        if (cli.hasOption((IOptionKey)OPT_ORDER) && cli.hasOption((IOptionKey)OPT_ADD)) {
            throw StatusHelper.argSyntax((String)Messages.PortReorderCmd_0);
        }
        String afterId = null;
        if (cli.hasOption((IOptionKey)OPT_AFTER)) {
            ScmCommandLineArgument argAfter = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_AFTER), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)argAfter, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            String valAfter = argAfter.getItemSelector();
            UUID uuid = RepoUtil.lookupUuid((String)valAfter);
            String string = afterId = uuid != null ? uuid.getUuidValue() : valAfter;
        }
        if (cli.hasOption((IOptionKey)OPT_ORDER)) {
            this.performReorderAcceptQueue(cli, client, targetWs, repo, componentDto, afterId);
        } else {
            this.performAddToAcceptQueue(cli, client, targetWs, repo, componentDto, afterId);
        }
    }

    private void performReorderAcceptQueue(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspace targetWs, ITeamRepository repo, WorkspaceComponentDTO componentDto, String afterId) throws FileSystemException, CLIFileSystemClientException {
        List argSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_ORDER), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        List portsToReorder = RepoUtil.getSelectors((List)argSelectors);
        String[] portsArray = new String[portsToReorder.size()];
        int i = 0;
        while (i < portsToReorder.size()) {
            UUID uuid = RepoUtil.lookupUuid((String)((String)portsToReorder.get(i)));
            portsArray[i] = uuid != null ? uuid.getUuidValue() : (String)portsToReorder.get(i);
            ++i;
        }
        ParmsReorderAcceptQueue parmsReorder = new ParmsReorderAcceptQueue();
        parmsReorder.workspace = targetWs;
        parmsReorder.componentItemId = componentDto.getItemId();
        parmsReorder.ids = portsArray;
        parmsReorder.afterId = afterId;
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        try {
            client.postReorderAcceptQueue(parmsReorder, null);
            out.println((CharSequence)Messages.PortReorderCmd_SUCCESS);
            if (this.hasVerboseOption(cli)) {
                PortReorderCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
            }
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortReorderCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
    }

    private void performAddToAcceptQueue(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspace targetWs, ITeamRepository repo, WorkspaceComponentDTO componentDto, String afterId) throws FileSystemException, CLIFileSystemClientException {
        List argSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_ADD), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        List changeSetsToAdd = RepoUtil.getSelectors((List)argSelectors);
        String[] changeSets = new String[changeSetsToAdd.size()];
        int i = 0;
        while (i < changeSetsToAdd.size()) {
            UUID uuid = RepoUtil.lookupUuid((String)((String)changeSetsToAdd.get(i)));
            changeSets[i] = uuid != null ? uuid.getUuidValue() : (String)changeSetsToAdd.get(i);
            ++i;
        }
        ParmsAddToAcceptQueue parmsReorder = new ParmsAddToAcceptQueue();
        parmsReorder.workspace = targetWs;
        parmsReorder.componentItemId = componentDto.getItemId();
        parmsReorder.ids = changeSets;
        parmsReorder.afterId = afterId;
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        try {
            client.postAddToAcceptQueue(parmsReorder, null);
            out.println((CharSequence)Messages.PortReorderCmd_1);
            if (this.hasVerboseOption(cli)) {
                PortReorderCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
            }
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortReorderCmd_2, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE).addOption((INamedOptionDefinition)OPT_AFTER, Messages.PortReorderCmdOption_AFTER).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_ADD, Messages.PortReorderCmd_3, true).addOption((INamedOptionDefinition)OPT_ORDER, Messages.PortReorderCmdOption_Ports, true)).addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PortReorderCmdOption_SEPARATOR, (Object)OPT_ORDER.getName())).addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }

    @Override
    protected void validateCommonArguments(ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument workspace = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)workspace, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument component = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)component, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
    }
}

