/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAbortCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveFromAcceptQueue;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.AbortCurrentPatchResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class PortRemoveCmd
extends AbstractPortSubcommand {
    public static final NamedOptionDefinition OPT_REMOVE_CURRENT = new NamedOptionDefinition("c", "current", 0);
    public static final NamedOptionDefinition OPT_REMOVE_ALL = new NamedOptionDefinition("a", "all", 0);
    public static final NamedOptionDefinition OPT_REMOVE_SELECTOR = new NamedOptionDefinition("q", "queue", -1);

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (!(cli.hasOption((IOptionKey)OPT_REMOVE_CURRENT) || cli.hasOption((IOptionKey)OPT_REMOVE_ALL) || cli.hasOption((IOptionKey)OPT_REMOVE_SELECTOR))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.PortRemoveCmd_MissingOption, (Object[])new String[]{OPT_REMOVE_CURRENT.getName(), OPT_REMOVE_ALL.getName(), OPT_REMOVE_SELECTOR.getName()}));
        }
        int actionCount = 0;
        if (cli.hasOption((IOptionKey)OPT_REMOVE_CURRENT)) {
            ++actionCount;
        }
        if (cli.hasOption((IOptionKey)OPT_REMOVE_ALL)) {
            ++actionCount;
        }
        if (cli.hasOption((IOptionKey)OPT_REMOVE_SELECTOR)) {
            ++actionCount;
        }
        if (actionCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_3_ARGUMENTS, (Object[])new String[]{OPT_REMOVE_CURRENT.getName(), OPT_REMOVE_ALL.getName(), OPT_REMOVE_SELECTOR.getName()}));
        }
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (cli.hasOption((IOptionKey)OPT_REMOVE_ALL) || cli.hasOption((IOptionKey)OPT_REMOVE_CURRENT)) {
            int noOfUncheckedInChanges;
            ParmsAbortCurrentPatch parmsAbort = new ParmsAbortCurrentPatch();
            parmsAbort.workspace = targetWs;
            parmsAbort.componentItemIds = new String[]{componentDto.getItemId()};
            parmsAbort.action = cli.hasOption((IOptionKey)OPT_REMOVE_ALL) ? "discard_all" : "discard_current";
            parmsAbort.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
            parmsAbort.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            parmsAbort.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
            AbortCurrentPatchResultDTO result = null;
            try {
                result = client.postAbortCurrentPatch(parmsAbort, null);
            }
            catch (TeamRepositoryException tre) {
                throw StatusHelper.failure((String)Messages.PortRemoveCmd_FAILURE, (Throwable)tre);
            }
            if (result.isCancelled() && (noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            out.println((CharSequence)(cli.hasOption((IOptionKey)OPT_REMOVE_ALL) ? Messages.PortRemoveCmd_All_SUCCESS : Messages.PortRemoveCmd_Current_SUCCESS));
            if (this.hasVerboseOption(cli)) {
                PortRemoveCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
            }
        } else if (cli.hasOption((IOptionKey)OPT_REMOVE_SELECTOR)) {
            List argSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_REMOVE_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            if (argSelectors.size() <= 0) {
                throw StatusHelper.argSyntax((String)Messages.PortCmd_UnexpectedArguments);
            }
            List ports = RepoUtil.getSelectors((List)argSelectors);
            String[] toRemove = new String[ports.size()];
            int i = 0;
            while (i < ports.size()) {
                UUID uuid = RepoUtil.lookupUuid((String)((String)ports.get(i)));
                toRemove[i] = uuid != null ? uuid.getUuidValue() : (String)ports.get(i);
                ++i;
            }
            ParmsRemoveFromAcceptQueue parmsRemove = new ParmsRemoveFromAcceptQueue();
            parmsRemove.workspace = targetWs;
            parmsRemove.componentItemId = componentDto.getItemId();
            parmsRemove.ids = toRemove;
            try {
                client.postRemoveFromAcceptQueue(parmsRemove, null);
                out.println((CharSequence)Messages.PortRemoveCmd_Selector_SUCCESS);
                if (this.hasVerboseOption(cli)) {
                    PortRemoveCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
                }
            }
            catch (TeamRepositoryException tre) {
                throw StatusHelper.wrap((String)Messages.PortRemoveCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
            }
        }
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS).addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.Common_FORCE_OVERWRITE_UNCOMMITTED).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_REMOVE_ALL, Messages.PortRemoveCmdOption_All, true).addOption((INamedOptionDefinition)OPT_REMOVE_CURRENT, Messages.PortRemoveCmdOption_Current, true).addOption((INamedOptionDefinition)OPT_REMOVE_SELECTOR, Messages.PortRemoveCmdOption_Selector, true)).addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PortRemoveCmdOption_SEPARATOR, (Object)OPT_REMOVE_SELECTOR.getName())).addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }

    @Override
    protected void validateCommonArguments(ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument workspace = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)workspace, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument component = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)component, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
    }
}

