/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.portcommand.AbstractPortSubcommand;
import com.ibm.team.filesystem.cli.client.internal.portcommand.PortReorderCmd;
import com.ibm.team.filesystem.cli.client.internal.portcommand.PortStartCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAbortCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteCurrentPortDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.AbortCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CompleteCurrentPatchResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CurrentPortCmd
extends AbstractPortSubcommand {
    public static final NamedOptionDefinition OPT_COMPLETE = new NamedOptionDefinition(null, "complete", 0);
    public static final NamedOptionDefinition OPT_NO_LINK = new NamedOptionDefinition(null, "no-link", 0);
    public static final NamedOptionDefinition OPT_IGNORE_UNRESOLVED = new NamedOptionDefinition("i", "ignore-unresolved", 0);
    public static final NamedOptionDefinition OPT_ABORT = new NamedOptionDefinition(null, "abort", 0);

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateCommonArguments(cli);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument workspaceSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (workspaceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)workspaceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)workspaceSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        WorkspaceComponentDTO componentDto = RepoUtil.getComponent((ParmsWorkspace)targetWs, (String)componentSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (!cli.hasOption((IOptionKey)OPT_COMPLETE) && !cli.hasOption((IOptionKey)OPT_ABORT)) {
            throw StatusHelper.argSyntax((String)Messages.CurrentPortCmd_MissingOption);
        }
        if (cli.hasOption((IOptionKey)OPT_COMPLETE)) {
            this.portComplete(cli, client, targetWs, componentDto);
        }
        if (cli.hasOption((IOptionKey)OPT_ABORT)) {
            this.portAbort(cli, client, targetWs, componentDto);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.hasVerboseOption(cli)) {
            CurrentPortCmd.printPorts(repo, targetWs, componentDto.getItemId(), client, out, this.config);
        }
    }

    private void portComplete(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspace targetWs, WorkspaceComponentDTO componentDto) throws FileSystemException {
        ParmsCompleteCurrentPatch parmsResolve = new ParmsCompleteCurrentPatch();
        parmsResolve.workspace = targetWs;
        parmsResolve.componentItemId = componentDto.getItemId();
        parmsResolve.createLink = !cli.hasOption((IOptionKey)OPT_NO_LINK);
        parmsResolve.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parmsResolve.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parmsResolve.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        parmsResolve.completeCurrentPortDilemmaHandler = new ParmsCompleteCurrentPortDilemmaHandler();
        parmsResolve.completeCurrentPortDilemmaHandler.unresolvedChangesInstruction = cli.hasOption((IOptionKey)OPT_IGNORE_UNRESOLVED) ? "continue" : "cancel";
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        CompleteCurrentPatchResultDTO result = null;
        try {
            result = client.postCompleteCurrentPatch(parmsResolve, null);
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortCompleteCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
        if (result.isCancelled()) {
            int noOfUnresolvedChanges;
            int noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges());
            if (noOfUncheckedInChanges > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            List unresolvedChanges = result.getUnresolvedChanges();
            if (unresolvedChanges != null && (noOfUnresolvedChanges = unresolvedChanges.size()) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.PortCmd_UNRESOLVED_ITEMS_PRESENT, (Object)noOfUnresolvedChanges, (Object)OPT_IGNORE_UNRESOLVED.getName()));
            }
        }
        if (result.getAcceptQueueSize() == 0L) {
            out.println((CharSequence)Messages.PortCmd_NO_PENDING_PORTS_GUIDANCE);
        } else {
            out.println((CharSequence)Messages.PortCompleteCmd_SUCCESS);
            ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, PortStartCmd.class);
            ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, PortReorderCmd.class);
            out.println((CharSequence)NLS.bind((String)Messages.PortCmd_RESUME_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()}));
        }
    }

    private void portAbort(ICommandLine cli, IFilesystemRestClient client, ParmsWorkspace targetWs, WorkspaceComponentDTO componentDto) throws FileSystemException {
        int noOfUncheckedInChanges;
        ParmsAbortCurrentPatch parmsAbort = new ParmsAbortCurrentPatch();
        parmsAbort.workspace = targetWs;
        parmsAbort.componentItemIds = new String[]{componentDto.getItemId()};
        parmsAbort.action = "make_pending";
        parmsAbort.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parmsAbort.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parmsAbort.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        AbortCurrentPatchResultDTO result = null;
        try {
            result = client.postAbortCurrentPatch(parmsAbort, null);
        }
        catch (TeamRepositoryException tre) {
            throw StatusHelper.wrap((String)Messages.PortAbortCmd_FAILURE, (TeamRepositoryException)tre, (IndentingPrintStream)out);
        }
        if (result.isCancelled() && (noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        out.println((CharSequence)Messages.PortAbortCmd_SUCCESS);
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        this.addVerboseToOptions(options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_ROOT_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.Common_FORCE_OVERWRITE_UNCOMMITTED);
        options.addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE);
        options.addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_COMPLETE, Messages.CurrentPortCmd_COMPLETE, true).addOption((INamedOptionDefinition)OPT_IGNORE_UNRESOLVED, Messages.PortCmdOption_FORCE_IGNORE_UNRESOLVED, false).addOption((INamedOptionDefinition)OPT_NO_LINK, Messages.PortCompleteCmd_NO_LINK, false)).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_ABORT, Messages.CurrentPortCmd_ABORT, true));
        options.addOption((IPositionalOptionDefinition)OPT_COMPONENT, Messages.PortCmdOption_COMPONENT);
        return options;
    }
}

