/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.portcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListPortsCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.PortsUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIndexedPageDescriptor;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractPortSubcommand
extends AbstractSubcommand
implements IOptionSource {
    protected static final IOptionKey OPT_WORKSPACE = ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId();
    protected static final PositionalOptionDefinition OPT_COMPONENT = new PositionalOptionDefinition("component", 1, 1);

    protected void validateCommonArguments(ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument workspace = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)workspace, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument component = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)component, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
    }

    public static void printPorts(ITeamRepository repo, ParmsWorkspace workspace, String componentId, IFilesystemRestClient client, IndentingPrintStream out, IScmClientConfiguration config) throws FileSystemException {
        AbstractPortSubcommand.printPorts(workspace, componentId, client, out, config);
    }

    public static void printPorts(ParmsWorkspace workspace, String componentId, IFilesystemRestClient client, IndentingPrintStream out, IScmClientConfiguration config) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        options.enablePrinter(22);
        options.enablePrinter(30);
        options.enablePrinter(32);
        out.println();
        ICommandLine cli = config.getSubcommandCommandLine();
        ParmsIndexedPageDescriptor parmsPageDescriptor = PortsUtil.printPorts((ParmsWorkspace)workspace, (String)componentId, (int)RepoUtil.getMaxResultsOption((ICommandLine)cli), (IFilesystemRestClient)client, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, (IScmClientConfiguration)config);
        if (parmsPageDescriptor != null && parmsPageDescriptor.hasNextPage() && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && !config.isJSONEnabled()) {
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ListPortsCmd.class);
            config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.AbstractPortSubCmd_MORE_ITEMS_AVAILABLE, (Object[])new String[]{Long.toString(parmsPageDescriptor.totalSize), config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), CommonOptions.OPT_MAXRESULTS.getName()}));
        }
    }

    protected void addVerboseToOptions(Options options) throws ConflictingOptionException {
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.PortCmdOption_VERBOSE);
    }

    protected boolean hasVerboseOption(ICommandLine cli) {
        return cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
    }
}

