/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.lock.LockAcquireCmd;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUnlockResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.LockEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.UnlockResourcesResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionable;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LockReleaseCmd
extends LockAcquireCmd
implements IOptionSource {
    private static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition("f", "force", 0);

    @Override
    protected void addNamedOptions(Options options) throws ConflictingOptionException {
        super.addNamedOptions(options);
        CommonOptions.OPT_WIDE.hideOption();
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_WIDE, CommonOptions.OPT_WIDE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.LockReleaseCmd_OPT_FORCE_HELP);
    }

    public LockReleaseCmd() {
        super(Messages.LockReleaseCmd_OPT_FILES_TO_UNLOCK_HELP, Messages.Common_INVALID_NON_FILE_UNLOCK);
    }

    @Override
    protected void lock(ParmsWorkspace ws, WorkspaceComponentDTO comp, boolean includeComponentHierarchy, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws CLIFileSystemClientException, FileSystemException {
        try {
            ParmsUnlock lock = new ParmsUnlock();
            lock.workspace = ws;
            lock.componentItemId = comp.getItemId();
            lock.unlockComponentHierarchy = includeComponentHierarchy;
            ParmsUnlockResources parms = new ParmsUnlockResources();
            parms.locks = new ParmsUnlock[]{lock};
            client.postUnlockResources(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockReleaseCmd_LOCKS_SUCCESSFULLY_RELEASED);
    }

    @Override
    protected void lock(ParmsWorkspace ws, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws CLIFileSystemClientException, FileSystemException {
        try {
            ParmsUnlock lock = new ParmsUnlock();
            lock.workspace = ws;
            ParmsUnlockResources parms = new ParmsUnlockResources();
            parms.locks = new ParmsUnlock[]{lock};
            client.postUnlockResources(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap(null, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockReleaseCmd_LOCKS_SUCCESSFULLY_RELEASED);
    }

    @Override
    protected void lock(Map<ParmsWorkspace, List<LockAcquireCmd.LockItem>> streamToLockItems, Map<ParmsWorkspace, ParmsWorkspace> streamToWorkspace, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws FileSystemException {
        HashMap<String, ITeamRepository> repoIdToObject = new HashMap<String, ITeamRepository>();
        HashMap<String, String> repoUriToId = new HashMap<String, String>();
        for (ParmsWorkspace parmsWorkspace : streamToLockItems.keySet()) {
            String repoUri = (String)repoUriToId.get(parmsWorkspace.repositoryUrl);
            if (repoUri != null) continue;
            ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parmsWorkspace.repositoryUrl, 0);
            repoUriToId.put(parmsWorkspace.repositoryUrl, repo.getId().getUuidValue());
            repoIdToObject.put(repo.getId().getUuidValue(), repo);
        }
        for (Map.Entry entry : streamToLockItems.entrySet()) {
            ParmsWorkspace ws = (ParmsWorkspace)entry.getKey();
            ArrayList<ParmsUnlock> locks = new ArrayList<ParmsUnlock>();
            for (LockAcquireCmd.LockItem lockItem : (List)entry.getValue()) {
                ParmsUnlock lock = new ParmsUnlock();
                lock.workspace = new ParmsWorkspace();
                lock.workspace.repositoryUrl = ws.repositoryUrl;
                lock.workspace.workspaceItemId = ws.workspaceItemId;
                lock.componentItemId = lockItem.getComponent();
                lock.versionable = new ParmsVersionable();
                lock.versionable.versionableItemType = lockItem.getVersionableType();
                lock.versionable.itemId = lockItem.getVersionable();
                for (Map.Entry<ParmsWorkspace, ParmsWorkspace> sourcews : streamToWorkspace.entrySet()) {
                    if (!sourcews.getKey().workspaceItemId.equals(ws.workspaceItemId)) continue;
                    lock.sourceWorkspace = sourcews.getValue();
                }
                locks.add(lock);
            }
            ParmsUnlockResources parms = new ParmsUnlockResources();
            parms.locks = locks.toArray(new ParmsUnlock[locks.size()]);
            (parms.lockDilemmaHandler = new ParmsLockDilemmaHandler()).currentUserDoesntOwnLock = cli.hasOption((IOptionKey)OPT_FORCE) ? "continue" : "no";
            UnlockResourcesResultDTO result = null;
            try {
                result = client.postUnlockResources(parms, null);
            }
            catch (FileSystemStatusException e) {
                config.getWrappedErrorStream().print((CharSequence)e.getStatus().getMessage());
                throw StatusHelper.inappropriateArgument((String)Messages.LockReleaseCmd_FAILURE);
            }
            catch (LockOperationFailureException e) {
                config.getWrappedErrorStream().print((CharSequence)e.getLocalizedMessage());
                throw StatusHelper.inappropriateArgument((String)Messages.LockReleaseCmd_FAILURE);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.LockReleaseCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), null);
            }
            if (!result.isCancelled()) continue;
            JSONArray jEntries = new JSONArray();
            List currentUserDoesntOwnLocks = result.getCurrentUserDoesntOwnLocks();
            for (LockEntryDTO lockEntry : currentUserDoesntOwnLocks) {
                ITeamRepository repo = (ITeamRepository)repoIdToObject.get(lockEntry.getRepositoryItemId());
                if (repo == null) continue;
                JSONObject jEntry = this.jsonizeEntry(repo, lockEntry, config);
                jEntries.add((Object)jEntry);
            }
            boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
            boolean wide = cli.hasOption((IOptionKey)CommonOptions.OPT_WIDE);
            int width = SubcommandUtil.getTerminalWidth((IClientConfiguration)config);
            if (jEntries.size() <= 0) continue;
            this.printEntries(jEntries, verbose, wide, width, config);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockReleaseCmd_LOCKS_SUCCESSFULLY_RELEASED);
    }

    private JSONObject jsonizeEntry(ITeamRepository repo, LockEntryDTO lockEntry, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        JSONObject jEntry = new JSONObject();
        ScmVersionable verDTO = this.getVersionableById(scmService, lockEntry.getWorkspaceItemId(), lockEntry.getComponentItemId(), lockEntry.getVersionableItemId(), config);
        String verPath = Messages.LockListCmd_Unknown;
        if (verDTO != null) {
            verPath = verDTO.getPath();
        }
        JSONObject jVer = JSONPrintUtil.jsonize((String)verPath, (String)lockEntry.getVersionableItemId(), (String)repo.getRepositoryURI());
        jEntry.put((Object)"versionable", (Object)jVer);
        return jEntry;
    }

    private void printEntries(JSONArray jEntries, boolean verbose, boolean wide, int width, IScmClientConfiguration config) throws FileSystemException {
        JSONObject jNotOwnerLocks = new JSONObject();
        jNotOwnerLocks.put((Object)"locks-not-owned", (Object)jEntries);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jNotOwnerLocks.toString());
        } else {
            IndentingPrintStream ps = config.getWrappedOutputStream();
            for (Object obj : jEntries) {
                JSONObject entry = (JSONObject)obj;
                JSONObject ver = (JSONObject)entry.get((Object)"versionable");
                ps.println((CharSequence)AliasUtil.selector((String)((String)ver.get((Object)"name")), (UUID)UUID.valueOf((String)((String)ver.get((Object)"uuid"))), (String)((String)ver.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE));
            }
        }
        throw StatusHelper.inappropriateArgument((String)Messages.LockReleaseCmd_SOME_FILES_COULD_NOT_BE_UNLOCKED);
    }
}

