/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rest.IScmRestService;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentLocks;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmContributorLocks;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePathList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceLocks;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceLocksResult;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceLocksResult2;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class LockListCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client = null;
    private static final String LOCAL = "L";
    private static final String REMOTE = "R";
    private static final String UNKNOWN = "U";
    private static final NamedOptionDefinition OPT_OWNER = new NamedOptionDefinition("o", "owner", 1);
    private static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("c", "component", 1);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        CommonOptions.OPT_WIDE.hideOption();
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_WIDE, CommonOptions.OPT_WIDE_HELP);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10));
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_STREAM_SELECTOR, CommonOptions.OPT_STREAM_SELECTOR_HELP);
        options.addOption((INamedOptionDefinition)OPT_COMPONENT, CommonOptions.OPT_COMPONENT_SELECTOR_HELP);
        options.addOption((INamedOptionDefinition)OPT_OWNER, Messages.LockListCmd_OptOwnerUserIdHelp);
        return options;
    }

    public void run() throws FileSystemException {
        Map<String, WorkspaceDetailsDTO> streamIdToDetails;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        Map<ParmsWorkspace, ParmsWorkspace> wsToStream = this.findSandboxWorkspaceToStreamMappings(cli);
        IScmCommandLineArgument componentSelector = this.getComponentSelector(cli);
        HashSet<String> componentIds = new HashSet<String>();
        HashSet<String> streamIds = new HashSet<String>();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) {
            ScmCommandLineArgument streamSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR), (IScmClientConfiguration)this.config);
            ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)streamSelector);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)streamSelector, (RepoUtil.ItemType)RepoUtil.ItemType.STREAM);
            IWorkspace stream = RepoUtil.getWorkspace((String)streamSelector.getItemSelector(), (boolean)false, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            streamIdToDetails = this.fetchStreamDetails(Collections.singletonList(new ParmsWorkspace(repo.getRepositoryURI(), stream.getItemId().getUuidValue())));
            streamIds.add(stream.getItemId().getUuidValue());
            if (componentSelector != null) {
                Iterator<Object> compAlias = RepoUtil.lookupUuidAndAlias((String)componentSelector.getItemSelector());
                WorkspaceDetailsDTO streamDetails = streamIdToDetails.get(stream.getItemId().getUuidValue());
                for (Iterator wsCompDTO : streamDetails.getComponents()) {
                    WorkspaceComponentDTO component = (WorkspaceComponentDTO)wsCompDTO;
                    if (!this.aliasMatchesId((IUuidAliasRegistry.IUuidAlias)compAlias, component) && !componentSelector.getItemSelector().equals(component.getName())) continue;
                    componentIds.add(component.getItemId());
                    break;
                }
            }
        } else {
            if (wsToStream.isEmpty()) {
                throw StatusHelper.argSyntax((String)Messages.LockAcquireCmd_UNMATCHED_STREAM);
            }
            List<ParmsWorkspace> uniqueStreams = this.getUniqueStreams(wsToStream.values());
            streamIdToDetails = this.fetchStreamDetails(uniqueStreams);
            if (componentSelector == null) {
                List shareDTOList = RepoUtil.getSharesInSandbox(null, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
                for (ShareDTO shareDTO : shareDTOList) {
                    componentIds.add(shareDTO.getComponentItemId());
                }
                streamIds.addAll(streamIdToDetails.keySet());
            } else {
                IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)componentSelector.getItemSelector());
                block2: for (WorkspaceDetailsDTO streamDetails : streamIdToDetails.values()) {
                    for (Object wsCompDTO : streamDetails.getComponents()) {
                        WorkspaceComponentDTO component = (WorkspaceComponentDTO)wsCompDTO;
                        if (!this.aliasMatchesId(compAlias, component) && !componentSelector.getItemSelector().equals(component.getName())) continue;
                        componentIds.add(component.getItemId());
                        streamIds.add(streamDetails.getItemId());
                        continue block2;
                    }
                }
            }
        }
        if (componentIds.isEmpty() && cli.hasOption((IOptionKey)OPT_COMPONENT) && componentSelector != null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockListCmd_UNMATCHED_COMP, (Object)componentSelector.getItemSelector()));
        }
        Map<String, ListLockForRepositoryRequest> repoUriToRequest = this.createListLockRequests(streamIdToDetails, streamIds, componentIds);
        String ownerSelector = null;
        if (cli.hasOption((IOptionKey)OPT_OWNER)) {
            ScmCommandLineArgument ownerId = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_OWNER), (IScmClientConfiguration)this.config);
            ownerSelector = ownerId.getItemSelector();
        }
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean wide = cli.hasOption((IOptionKey)CommonOptions.OPT_WIDE);
        int width = SubcommandUtil.getTerminalWidth((IClientConfiguration)this.config);
        int maxResult = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        int lockEntries = 0;
        for (Map.Entry<String, ListLockForRepositoryRequest> entry : repoUriToRequest.entrySet()) {
            lockEntries += entry.getValue().listLocks(ownerSelector, maxResult, verbose, wide, width, streamIdToDetails, wsToStream);
        }
        if (lockEntries == 0) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.LockListCmd_NO_LOCKS_TO_LIST);
        }
    }

    private IScmCommandLineArgument getComponentSelector(ICommandLine cli) throws FileSystemException {
        ScmCommandLineArgument componentSelector = null;
        if (cli.hasOption((IOptionKey)OPT_COMPONENT)) {
            componentSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)componentSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
        return componentSelector;
    }

    private Map<String, ListLockForRepositoryRequest> createListLockRequests(Map<String, WorkspaceDetailsDTO> streamIdToDetails, Set<String> streamIds, Set<String> componentIds) {
        HashMap<String, ListLockForRepositoryRequest> repoUriToRequest = new HashMap<String, ListLockForRepositoryRequest>();
        for (String streamId : streamIds) {
            WorkspaceDetailsDTO stream = streamIdToDetails.get(streamId);
            ListLockForRepositoryRequest request = (ListLockForRepositoryRequest)repoUriToRequest.get(stream.getRepositoryURL());
            if (request == null) {
                request = new ListLockForRepositoryRequest(stream.getRepositoryURL());
                repoUriToRequest.put(stream.getRepositoryURL(), request);
            }
            request.addStream(streamId);
            for (Object o : stream.getComponents()) {
                WorkspaceComponentDTO wc = (WorkspaceComponentDTO)o;
                if (!componentIds.contains(wc.getItemId())) continue;
                request.addComponent(wc.getItemId());
            }
        }
        return repoUriToRequest;
    }

    private boolean aliasMatchesId(IUuidAliasRegistry.IUuidAlias alias, WorkspaceComponentDTO component) {
        if (alias == null) {
            return false;
        }
        return alias.getUuid().getUuidValue().equals(component.getItemId());
    }

    private List<ParmsWorkspace> getUniqueStreams(Collection<ParmsWorkspace> streams) {
        return new ArrayList<ParmsWorkspace>(new HashSet<ParmsWorkspace>(streams));
    }

    private Map<String, WorkspaceDetailsDTO> fetchStreamDetails(List<ParmsWorkspace> streams) throws FileSystemException {
        HashMap<String, WorkspaceDetailsDTO> streamIdToDetails = new HashMap<String, WorkspaceDetailsDTO>();
        for (ParmsWorkspace stream : streams) {
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(stream.repositoryUrl));
        }
        List streamDetailsList = RepoUtil.getWorkspaceDetails(streams, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        for (WorkspaceDetailsDTO streamDetails : streamDetailsList) {
            streamIdToDetails.put(streamDetails.getItemId(), streamDetails);
        }
        return streamIdToDetails;
    }

    private Map<ParmsWorkspace, ParmsWorkspace> findSandboxWorkspaceToStreamMappings(ICommandLine cli) throws FileSystemException, CLIFileSystemClientException {
        HashMap<ParmsWorkspace, ParmsWorkspace> wsToStream = new HashMap<ParmsWorkspace, ParmsWorkspace>();
        List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        if (wsInSandboxList.isEmpty() && !cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.LockListCmd_NO_SANDBOX);
        }
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(wsInSandboxList.size());
        for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
            try {
                String uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
                ITeamRepository repoTeam = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(uri));
                IWorkspace workspace = RepoUtil.getWorkspace((String)wsInSandbox.getWorkspaceItemId(), (boolean)true, (boolean)false, (ITeamRepository)repoTeam, (IScmClientConfiguration)this.config);
                if (workspace == null) continue;
                wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
            }
            catch (FileSystemException e) {
                if (cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) continue;
                throw e;
            }
        }
        if (wsList.size() > 0) {
            List wsDetailsList = RepoUtil.getWorkspaceDetails(wsList, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            for (WorkspaceDetailsDTO wsDetails : wsDetailsList) {
                ParmsWorkspace stream = this.getFlowStream(wsDetails);
                if (stream == null) continue;
                wsToStream.put(new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId()), stream);
            }
        }
        return wsToStream;
    }

    private ParmsWorkspace getFlowStream(WorkspaceDetailsDTO wsDetails) throws FileSystemException {
        ParmsWorkspace ws = RepoUtil.getFlowTarget((WorkspaceDetailsDTO)wsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.OUTGOING, (boolean)false);
        WorkspaceDetailsDTO wsFlowDetails = null;
        if (ws != null) {
            wsFlowDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        }
        if (wsFlowDetails != null && wsFlowDetails.isStream()) {
            return ws;
        }
        return null;
    }

    private void jsonizeLockEntries(JSONArray jEntries, ScmWorkspaceLocks wsLocks, IContributor owner, int width, Map<String, WorkspaceDetailsDTO> streamIdToDetails, Map<ParmsWorkspace, ParmsWorkspace> wsToStream) throws FileSystemException {
        WorkspaceDetailsDTO streamDetails = streamIdToDetails.get(wsLocks.getWorkspace().getItemId().getUuidValue());
        HashMap<String, WorkspaceComponentDTO> componentDetails = new HashMap<String, WorkspaceComponentDTO>();
        for (WorkspaceComponentDTO componentDTO : streamDetails.getComponents()) {
            componentDetails.put(componentDTO.getItemId(), componentDTO);
        }
        ITeamRepository repo = RepoUtil.getSharedRepository((String)streamDetails.getRepositoryURL(), (boolean)true);
        HashMap<String, IContributor> contribIdToObject = new HashMap<String, IContributor>();
        if (owner != null) {
            contribIdToObject.put(owner.getItemId().getUuidValue(), owner);
        }
        if (wsLocks.isStreamLock()) {
            boolean jsonizeStream;
            boolean bl = jsonizeStream = owner != null ? owner.getItemId().getUuidValue().equals(streamDetails.getLockedBy().getContributorItemId()) : true;
            if (jsonizeStream) {
                JSONObject jEntry = new JSONObject();
                jEntry.put((Object)"owner", (Object)streamDetails.getLockedBy().getUserId());
                JSONObject stream = JSONPrintUtil.jsonize((String)streamDetails.getName(), (String)streamDetails.getItemId(), (String)streamDetails.getRepositoryURL(), (boolean)streamDetails.isStream());
                jEntry.put((Object)"stream", (Object)stream);
                jEntries.add((Object)jEntry);
            }
            return;
        }
        for (ScmComponentLocks scmCompLocks : wsLocks.getComponentLocks()) {
            String compId = scmCompLocks.getComponent().getItemId().getUuidValue();
            ArrayList<ScmContributorLocks> scmContribLockList = new ArrayList<ScmContributorLocks>();
            if (owner != null) {
                ScmContributorLocks contributorLocks = scmCompLocks.getContributorLock((IContributorHandle)owner);
                if (contributorLocks != null) {
                    scmContribLockList.add(contributorLocks);
                }
            } else {
                scmContribLockList.addAll(scmCompLocks.getContributorLocks());
            }
            WorkspaceComponentDTO componentDTO = (WorkspaceComponentDTO)componentDetails.get(compId);
            if (scmContribLockList.isEmpty() && componentDTO != null && componentDTO.getLockedBy() != null) {
                boolean jsonizeComp;
                boolean bl = jsonizeComp = owner != null ? owner.getItemId().getUuidValue().equals(componentDTO.getLockedBy().getContributorItemId()) : true;
                if (!jsonizeComp) continue;
                JSONObject jEntry = new JSONObject();
                jEntry.put((Object)"owner", (Object)componentDTO.getLockedBy().getUserId());
                JSONObject comp = JSONPrintUtil.jsonize((String)componentDTO.getName(), (String)componentDTO.getItemId(), (String)streamDetails.getRepositoryURL());
                jEntry.put((Object)"component", (Object)comp);
                JSONObject stream = JSONPrintUtil.jsonize((String)streamDetails.getName(), (String)streamDetails.getItemId(), (String)streamDetails.getRepositoryURL(), (boolean)streamDetails.isStream());
                jEntry.put((Object)"stream", (Object)stream);
                jEntries.add((Object)jEntry);
                continue;
            }
            for (ScmContributorLocks contribLocks : scmContribLockList) {
                Map<UUID, VersionablePathData> versionablePaths = this.findVersionablePaths(streamDetails, wsToStream, compId, contribLocks.getVersionables());
                for (IVersionableHandle verHandle : contribLocks.getVersionables()) {
                    VersionablePathData data = versionablePaths.get(verHandle.getItemId());
                    JSONObject jEntry = new JSONObject();
                    jEntry.put((Object)"nameSource", (Object)data.source);
                    JSONObject jVer = JSONPrintUtil.jsonize((String)data.path, (String)verHandle.getItemId().getUuidValue(), (String)streamDetails.getRepositoryURL());
                    jEntry.put((Object)"versionable", (Object)jVer);
                    String contrib = null;
                    IContributor contributor = (IContributor)contribIdToObject.get(contribLocks.getContributor().getItemId().getUuidValue());
                    if (contributor == null) {
                        try {
                            contributor = (IContributor)RepoUtil.getItem((IItemType)IContributor.ITEM_TYPE, (UUID)contribLocks.getContributor().getItemId(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                            contribIdToObject.put(contributor.getItemHandle().getItemId().getUuidValue(), contributor);
                            contrib = contributor.getUserId();
                        }
                        catch (Exception e) {
                            contrib = Messages.LockListCmd_Unknown;
                        }
                    } else {
                        contrib = contributor.getUserId();
                    }
                    jEntry.put((Object)"owner", (Object)contrib);
                    WorkspaceComponentDTO compMatched = (WorkspaceComponentDTO)componentDetails.get(compId);
                    JSONObject comp = null;
                    comp = compMatched != null ? JSONPrintUtil.jsonize((String)compMatched.getName(), (String)compMatched.getItemId(), (String)streamDetails.getRepositoryURL()) : JSONPrintUtil.jsonize((String)Messages.LockListCmd_Unknown, (String)compId, (String)streamDetails.getRepositoryURL());
                    jEntry.put((Object)"component", (Object)comp);
                    JSONObject stream = JSONPrintUtil.jsonize((String)streamDetails.getName(), (String)streamDetails.getItemId(), (String)streamDetails.getRepositoryURL(), (boolean)streamDetails.isStream());
                    jEntry.put((Object)"stream", (Object)stream);
                    jEntries.add((Object)jEntry);
                }
            }
        }
    }

    private Map<UUID, VersionablePathData> findVersionablePaths(WorkspaceDetailsDTO streamDetails, Map<ParmsWorkspace, ParmsWorkspace> wsToStream, String compId, List<IVersionableHandle> versionables) throws FileSystemException {
        HashMap<UUID, VersionablePathData> results = new HashMap<UUID, VersionablePathData>();
        ArrayList<IVersionableHandle> toQuery = new ArrayList<IVersionableHandle>();
        for (IVersionableHandle handle : versionables) {
            ShareableDTO shareable = this.findLocalVersionable(streamDetails, wsToStream, compId, handle);
            if (shareable != null) {
                results.put(handle.getItemId(), new VersionablePathData(LOCAL, StringUtil.createPathString((List)shareable.getRelativePath().getSegments())));
                continue;
            }
            results.put(handle.getItemId(), new VersionablePathData(UNKNOWN, Messages.LockListCmd_Unknown));
            toQuery.add(handle);
        }
        if (toQuery.size() > 0) {
            ITeamRepository repo = RepoUtil.getSharedRepository((String)streamDetails.getRepositoryURL(), (boolean)true);
            IScmRichClientRestService restService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            int batchStart = 0;
            while (batchStart < toQuery.size()) {
                int batchSize = Math.min(2048, toQuery.size() - batchStart);
                List batch = toQuery.subList(batchStart, batchStart + batchSize);
                ScmVersionablePathList pathList = RepoUtil.getVersionablePaths((IScmRichClientRestService)restService, (String)streamDetails.getItemId(), (String)compId, batch, (IScmClientConfiguration)this.config);
                for (ScmVersionablePath path : pathList.getPaths()) {
                    if (path == null || path.getVersionable() == null) continue;
                    results.put(path.getVersionable().getItemId(), new VersionablePathData(REMOTE, StringUtil.createPathString((List)path.getSegments())));
                }
                batchStart += 2048;
            }
        }
        return results;
    }

    private ShareableDTO findLocalVersionable(WorkspaceDetailsDTO streamDetails, Map<ParmsWorkspace, ParmsWorkspace> wsToStream, String compId, IVersionableHandle verHandle) {
        ShareableDTO shareable = null;
        for (Map.Entry<ParmsWorkspace, ParmsWorkspace> entry : wsToStream.entrySet()) {
            if (!entry.getValue().workspaceItemId.equals(streamDetails.getItemId()) || (shareable = this.findLocalVersionable(entry.getKey(), compId, verHandle)) == null) continue;
            Path sandboxPath = new Path(shareable.getSandboxPath());
            if (sandboxPath.isPrefixOf((IPath)new Path(this.config.getCurrentWorkingDirectory().getAbsolutePath()))) break;
            shareable = null;
        }
        return shareable;
    }

    private ShareableDTO findLocalVersionable(ParmsWorkspace ws, String compId, IVersionableHandle verHandle) {
        ShareableDTO shareableDTO = null;
        try {
            shareableDTO = RepoUtil.findLocalVersionable((ParmsWorkspace)ws, (String)compId, (String)verHandle.getItemId().getUuidValue(), (String)SubcommandUtil.getVersionableItemType((IItemType)verHandle.getItemType()), (IFilesystemRestClient)this.client, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        return shareableDTO;
    }

    public static void printLockEntries(JSONArray jEntries, IndentingPrintStream out, boolean wide, int width, IScmClientConfiguration config) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jEntries.toString());
            return;
        }
        ArrayList<String> versionableLocks = new ArrayList<String>();
        ArrayList<String> streamLocks = new ArrayList<String>();
        ArrayList<String> componentLocks = new ArrayList<String>();
        for (Object obj : jEntries) {
            JSONObject component;
            JSONObject entry = (JSONObject)obj;
            String sourceString = "";
            String versionableString = "";
            String ownerString = "";
            String componentString = "";
            String streamString = "";
            sourceString = (String)entry.get((Object)"nameSource");
            ownerString = (String)entry.get((Object)"owner");
            JSONObject stream = (JSONObject)entry.get((Object)"stream");
            RepoUtil.ItemType itemType = PendingChangesUtil.getWorkspaceType((String)((String)stream.get((Object)"type")));
            streamString = AliasUtil.selector((String)((String)stream.get((Object)"name")), (UUID)UUID.valueOf((String)((String)stream.get((Object)"uuid"))), (String)((String)stream.get((Object)"url")), (RepoUtil.ItemType)itemType);
            JSONObject versionable = (JSONObject)entry.get((Object)"versionable");
            if (versionable != null) {
                versionableString = AliasUtil.selector((String)((String)versionable.get((Object)"name")), (UUID)UUID.valueOf((String)((String)versionable.get((Object)"uuid"))), (String)((String)versionable.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            }
            if ((component = (JSONObject)entry.get((Object)"component")) != null) {
                componentString = AliasUtil.selector((String)((String)component.get((Object)"name")), (UUID)UUID.valueOf((String)((String)component.get((Object)"uuid"))), (String)((String)component.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            }
            if (versionable == null && component == null) {
                streamLocks.add(streamString);
                streamLocks.add(ownerString);
                continue;
            }
            if (versionable == null && component != null) {
                componentLocks.add(componentString);
                componentLocks.add(ownerString);
                componentLocks.add(streamString);
                continue;
            }
            versionableLocks.add(sourceString);
            versionableLocks.add(versionableString);
            versionableLocks.add(ownerString);
            versionableLocks.add(componentString);
            versionableLocks.add(streamString);
        }
        if (!streamLocks.isEmpty()) {
            out.println((CharSequence)Messages.LockListCmd_STREAM_LOCKS);
            StringUtil.printTable((IndentingPrintStream)out.indent(), (int)2, (boolean)true, (CharSequence[])streamLocks.toArray(new String[streamLocks.size()]));
            out.println();
        }
        if (!componentLocks.isEmpty()) {
            out.println((CharSequence)Messages.LockListCmd_COMPONENT_LOCKS);
            StringUtil.printTable((IndentingPrintStream)out.indent(), (int)3, (boolean)true, (CharSequence[])componentLocks.toArray(new String[componentLocks.size()]));
            out.println();
        }
        if (!versionableLocks.isEmpty()) {
            out.println((CharSequence)Messages.LockListCmd_FILE_LOCKS);
            StringUtil.printTable((IndentingPrintStream)out.indent(), (int)5, (boolean)true, (CharSequence[])versionableLocks.toArray(new String[versionableLocks.size()]));
        }
    }

    private class ListLockForRepositoryRequest {
        private final String repoUri;
        private final Set<String> streams = new HashSet<String>();
        private final Set<String> componentIds = new HashSet<String>();

        public ListLockForRepositoryRequest(String repositoryURL) {
            this.repoUri = repositoryURL;
        }

        public int listLocks(String ownerSelector, int maxResult, boolean verbose, boolean wide, int width, Map<String, WorkspaceDetailsDTO> streamIdToDetails, Map<ParmsWorkspace, ParmsWorkspace> wsToStream) throws FileSystemException {
            ITeamRepository repo = RepoUtil.getSharedRepository((String)this.repoUri, (boolean)true);
            IContributor owner = null;
            if (ownerSelector != null) {
                block11: {
                    try {
                        owner = RepoUtil.fetchContributor((String)ownerSelector, (ITeamRepository)repo, (IScmClientConfiguration)LockListCmd.this.config);
                    }
                    catch (FileSystemException e) {
                        if (e instanceof CLIFileSystemClientException && ((CLIFileSystemClientException)((Object)e)).getStatus().getCode() == 25) break block11;
                        throw e;
                    }
                }
                if (owner == null) {
                    return 0;
                }
            }
            IScmRestService.ParmsLockSearchCriteria lockCriteria = new IScmRestService.ParmsLockSearchCriteria();
            lockCriteria.streamItemIds = this.streams.toArray(new String[this.streams.size()]);
            lockCriteria.includeStreamAndComponentLocks = Boolean.TRUE;
            lockCriteria.length = maxResult;
            if (owner != null) {
                lockCriteria.lockedByContributorId = owner.getItemId().getUuidValue();
            }
            JSONArray jEntries = new JSONArray();
            ArrayList<String> componentList = new ArrayList<String>(this.componentIds);
            int pageStart = 0;
            while (pageStart == 0 || pageStart < componentList.size()) {
                if (componentList.size() > 0) {
                    int pageSize = Math.min(componentList.size() - pageStart, 512);
                    List page = componentList.subList(pageStart, pageStart + pageSize);
                    lockCriteria.componentItemIds = page.toArray(new String[page.size()]);
                }
                String pageDescriptor = "first";
                while (pageDescriptor != null && jEntries.size() < maxResult) {
                    ScmWorkspaceLocksResult result = null;
                    try {
                        lockCriteria.pageDescriptor = pageDescriptor;
                        IScmRichClientRestService scmRichService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
                        result = scmRichService.postFindLocks(lockCriteria);
                        pageDescriptor = result instanceof ScmWorkspaceLocksResult2 ? ((ScmWorkspaceLocksResult2)result).getPageDescriptor() : null;
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.LockListCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)LockListCmd.this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                    }
                    List workspaceLockList = result.getWorkspaceLocksList();
                    for (ScmWorkspaceLocks locks : workspaceLockList) {
                        LockListCmd.this.jsonizeLockEntries(jEntries, locks, owner, width, streamIdToDetails, wsToStream);
                    }
                }
                if (jEntries.size() >= maxResult) break;
                pageStart += 512;
            }
            LockListCmd.printLockEntries(jEntries, LockListCmd.this.config.getWrappedOutputStream(), wide, width, LockListCmd.this.config);
            return jEntries.size();
        }

        public void addStream(String streamId) {
            this.streams.add(streamId);
        }

        public void addComponent(String itemId) {
            this.componentIds.add(itemId);
        }
    }

    private static class VersionablePathData {
        public String source;
        public String path;

        public VersionablePathData(String source, String path) {
            this.source = source;
            this.path = path;
        }
    }
}

