/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.lock;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLock;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLockResources;
import com.ibm.team.filesystem.client.rest.parameters.ParmsVersionable;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.internal.ScmPackage;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionable;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePathList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class LockAcquireCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final PositionalOptionDefinition OPT_FILES = new PositionalOptionDefinition("files", 0, -1);
    private static final NamedOptionDefinition OPT_COMPONENT = new NamedOptionDefinition("c", "component", 1);
    private static final NamedOptionDefinition OPT_REMOTE_PATH = new NamedOptionDefinition("R", "remotePath", 0);
    private static final NamedOptionDefinition OPT_IGNORE_INCOMING = new NamedOptionDefinition("I", "ignore-incoming", 0);
    private String filesHelpMsg;
    private String unsupportedVersionableMsg;

    public LockAcquireCmd() {
        this(NLS.bind((String)Messages.LockAcquireCmd_OPT_FILES_HELP, (Object[])new Object[]{OPT_COMPONENT.getName(), CommonOptions.OPT_STREAM_SELECTOR.getName(), OPT_REMOTE_PATH.getName()}), Messages.Common_INVALID_NON_FILE_LOCK);
    }

    protected LockAcquireCmd(String filesHelpMsg, String UnsupportedVersionableMsg) {
        this.filesHelpMsg = filesHelpMsg;
        this.unsupportedVersionableMsg = UnsupportedVersionableMsg;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        this.addNamedOptions(options);
        this.addPositionalOptions(options);
        return options;
    }

    protected void addNamedOptions(Options options) throws ConflictingOptionException {
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS);
        options.addOption((INamedOptionDefinition)OPT_IGNORE_INCOMING, Messages.LockAcquireCmd_OPT_IGNORE_INCOMING_HELP);
        options.addOption((IOptionGroup)new SimpleGroup(false).addOption((INamedOptionDefinition)OPT_REMOTE_PATH, Messages.LockAcquireCmd_OPT_REMOTEPATH_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_STREAM_SELECTOR, NLS.bind((String)Messages.LockAcquireCmd_OPT_STREAM_HELP, (Object)OPT_REMOTE_PATH.getName()), true).addOption((INamedOptionDefinition)OPT_COMPONENT, NLS.bind((String)Messages.LockAcquireCmd_OPT_COMPONENT_HELP, (Object)OPT_REMOTE_PATH.getName()), false));
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_COMPONENT_HIERARCHY, Messages.LockAcquireCmd_OPT_COMPONENT_HIERARCHY_HELP);
    }

    protected void addPositionalOptions(Options options) throws ConflictingOptionException {
        options.addOption((IPositionalOptionDefinition)OPT_FILES, this.filesHelpMsg);
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!(!cli.hasOption((IOptionKey)OPT_REMOTE_PATH) || cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR) && cli.hasOption((IOptionKey)OPT_COMPONENT) && cli.hasOption((IOptionKey)OPT_FILES))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_SPECIFY_STREAM_AND_COMPONENT, (Object[])new Object[]{CommonOptions.OPT_STREAM_SELECTOR.getName(), OPT_COMPONENT.getName(), OPT_FILES.getName(), OPT_REMOTE_PATH.getName()}));
        }
        if (cli.hasOption((IOptionKey)OPT_FILES) && !cli.hasOption((IOptionKey)OPT_REMOTE_PATH) && (cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR) || cli.hasOption((IOptionKey)OPT_COMPONENT))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_1, (Object[])new Object[]{OPT_FILES.getName(), CommonOptions.OPT_STREAM_SELECTOR.getName(), OPT_COMPONENT.getName(), OPT_REMOTE_PATH.getName()}));
        }
        if (!cli.hasOption((IOptionKey)OPT_FILES) && !cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_2, (Object[])new Object[]{CommonOptions.OPT_STREAM_SELECTOR.getName(), OPT_FILES.getName()}));
        }
        boolean isStreamLock = !cli.hasOption((IOptionKey)OPT_FILES) && !cli.hasOption((IOptionKey)OPT_COMPONENT);
        boolean isComponentLock = !isStreamLock && !cli.hasOption((IOptionKey)OPT_FILES);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        List strPaths = null;
        if (cli.hasOption((IOptionKey)OPT_FILES)) {
            List paths = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_FILES), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)paths, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            strPaths = RepoUtil.getSelectors((List)paths);
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR)) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.STREAM);
            ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace workspace = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)false, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), workspace.getItemId().getUuidValue());
            if (isStreamLock) {
                this.lock(ws, client, this.config, cli);
            } else {
                ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                WorkspaceComponentDTO comp = RepoUtil.getComponent((ParmsWorkspace)ws, (String)compSelector.getItemSelector(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                if (isComponentLock) {
                    this.lock(ws, comp, cli.hasOption((IOptionKey)CommonOptions.OPT_COMPONENT_HIERARCHY), client, this.config, cli);
                } else {
                    List<LockItem> lockItems = this.getRemoteLockItems(workspace, comp, strPaths, repo, this.config);
                    HashMap<ParmsWorkspace, List<LockItem>> streamToLockItems = new HashMap<ParmsWorkspace, List<LockItem>>();
                    HashMap<ParmsWorkspace, ParmsWorkspace> streamToWorkspace = new HashMap<ParmsWorkspace, ParmsWorkspace>();
                    streamToLockItems.put(ws, lockItems);
                    this.lock(streamToLockItems, streamToWorkspace, client, this.config, cli);
                }
            }
        } else {
            List absolutePaths = SubcommandUtil.makeAbsolutePaths((IScmClientConfiguration)this.config, strPaths);
            for (ILocation path : absolutePaths) {
                if (SubcommandUtil.exists((ILocation)path, null)) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)path.toOSString()));
            }
            List resProps = RepoUtil.getResourceProperties((List)strPaths, (boolean)SubcommandUtil.shouldRefreshFileSystem((IScmClientConfiguration)this.config), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, (boolean)true);
            Map<ParmsWorkspace, List<LockItem>> streamToLockItems = this.getLocalLockItems(resProps, client, this.config);
            Map<ParmsWorkspace, ParmsWorkspace> streamToWorkspace = this.getStreamToWorkspace(resProps, client, this.config);
            this.lock(streamToLockItems, streamToWorkspace, client, this.config, cli);
        }
    }

    protected void lock(ParmsWorkspace ws, WorkspaceComponentDTO comp, boolean lockComponentHierarchy, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws CLIFileSystemClientException, FileSystemException {
        try {
            ParmsLock lock = new ParmsLock();
            lock.workspace = ws;
            lock.componentItemId = comp.getItemId();
            lock.lockComponentHierarchy = lockComponentHierarchy;
            ParmsLockResources parms = new ParmsLockResources();
            parms.locks = new ParmsLock[]{lock};
            client.postLockResources(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)e.getMessage(), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockAcquireCmd_LOCKS_SUCCESSFULLY_ACQUIRED);
    }

    protected void lock(ParmsWorkspace ws, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws CLIFileSystemClientException, FileSystemException {
        try {
            ParmsLock lock = new ParmsLock();
            lock.workspace = ws;
            ParmsLockResources parms = new ParmsLockResources();
            parms.locks = new ParmsLock[]{lock};
            client.postLockResources(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)e.getMessage(), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockAcquireCmd_LOCKS_SUCCESSFULLY_ACQUIRED);
    }

    private List<LockItem> getRemoteLockItems(IWorkspace workspace, WorkspaceComponentDTO comp, List<String> strPaths, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        ArrayList<LockItem> lockItems = new ArrayList<LockItem>();
        ArrayList allVerionables = new ArrayList();
        ArrayList<String> versionableItemPaths = new ArrayList<String>();
        IScmRichClientRestService.ParmsGetPaths parmsByIds = new IScmRichClientRestService.ParmsGetPaths();
        parmsByIds.contextItemNamespace = workspace.getItemType().getNamespaceURI();
        parmsByIds.contextItemId = workspace.getItemId().getUuidValue();
        parmsByIds.contextItemType = workspace.getItemType().getName();
        parmsByIds.componentItemId = comp.getItemId();
        ArrayList<String> versionableItemIds = new ArrayList<String>();
        ArrayList<String> versionableItemTypes = new ArrayList<String>();
        ArrayList<String> versionableItemNamespaces = new ArrayList<String>();
        for (String strPath : strPaths) {
            IUuidAliasRegistry.IUuidAlias lockAlias = RepoUtil.lookupUuidAndAlias((String)strPath, (String)repo.getRepositoryURI());
            if (lockAlias != null) {
                versionableItemIds.add(lockAlias.getUuid().getUuidValue());
                versionableItemNamespaces.add(ScmPackage.eINSTANCE.getNsURI());
                versionableItemTypes.add(ScmPackage.eINSTANCE.getVersionable().getName());
                continue;
            }
            List<String> pathSeg = Arrays.asList(StringUtil.splitEscapedPath((String)strPath));
            ArrayList<String> encodedPathSeg = new ArrayList<String>();
            try {
                Iterator<String> i = pathSeg.iterator();
                while (i.hasNext()) {
                    encodedPathSeg.add(LocationUtil.encode((String)i.next()));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new FileSystemException((Throwable)e);
            }
            versionableItemPaths.add(StringUtil.createPathString((String[])encodedPathSeg.toArray(new String[0])));
        }
        if (!versionableItemIds.isEmpty()) {
            parmsByIds.versionableItemIds = versionableItemIds.toArray(new String[versionableItemIds.size()]);
            parmsByIds.versionableItemNamespaces = versionableItemNamespaces.toArray(new String[versionableItemNamespaces.size()]);
            parmsByIds.versionableItemTypes = versionableItemTypes.toArray(new String[versionableItemTypes.size()]);
            ScmVersionablePathList versionablesByIds = null;
            try {
                versionablesByIds = scmService.postGetVersionablePaths(parmsByIds);
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException((Throwable)e);
            }
            this.validateVersionables(versionablesByIds.getPaths(), parmsByIds.versionableItemIds);
            if (versionablesByIds.isSetPaths()) {
                allVerionables.addAll(versionablesByIds.getPaths());
            }
        }
        IScmRichClientRestService.ParmsGetVersionables parmsByPath = new IScmRichClientRestService.ParmsGetVersionables();
        if (!versionableItemPaths.isEmpty()) {
            parmsByPath.componentItemId = comp.getItemId();
            parmsByPath.contextItemId = workspace.getItemId().getUuidValue();
            parmsByPath.contextItemNamespace = workspace.getItemType().getNamespaceURI();
            parmsByPath.contextItemType = workspace.getItemType().getName();
            parmsByPath.paths = versionableItemPaths.toArray(new String[versionableItemPaths.size()]);
            ScmVersionablePathList versionablesByPaths = null;
            try {
                versionablesByPaths = scmService.postGetVersionables(parmsByPath);
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException((Throwable)e);
            }
            this.validateVersionables(versionablesByPaths.getPaths(), parmsByPath.paths);
            if (versionablesByPaths.isSetPaths()) {
                allVerionables.addAll(versionablesByPaths.getPaths());
            }
        }
        for (ScmVersionablePath verpath : allVerionables) {
            String verType = SubcommandUtil.getVersionableItemType((IItemType)verpath.getVersionable().getItemType());
            LockItem lockItem = new LockItem(comp.getItemId(), verpath.getVersionable().getItemId().getUuidValue(), verType);
            lockItems.add(lockItem);
        }
        return lockItems;
    }

    private void validateVersionables(List<ScmVersionablePath> versionables, String[] aliases) throws FileSystemException {
        ArrayList<String> invalidAliases = new ArrayList<String>();
        ArrayList<String> unsupportedVersionables = new ArrayList<String>();
        int index = 0;
        for (ScmVersionablePath verPath : versionables) {
            if (verPath.getVersionable() == null) {
                invalidAliases.add(aliases[index]);
            } else {
                String verType = SubcommandUtil.getVersionableItemType((IItemType)verPath.getVersionable().getItemType());
                if (!verType.equals("file") && !verType.equals("symbolic_link")) {
                    unsupportedVersionables.add(aliases[index]);
                }
            }
            ++index;
        }
        if (invalidAliases.size() > 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_INVALID_ALIAS_UUID_PATH, (Object)invalidAliases.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))));
        }
        if (unsupportedVersionables.size() > 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)this.unsupportedVersionableMsg, (Object)unsupportedVersionables.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "))));
        }
    }

    protected ScmVersionable getVersionableById(IScmRichClientRestService scmService, String wsId, String compId, String verId, IScmClientConfiguration config) throws FileSystemException {
        ScmVersionable verDTO = null;
        String itemType = String.valueOf(ScmPackage.eINSTANCE.getNsURI()) + "." + ScmPackage.eINSTANCE.getVersionable().getName();
        try {
            verDTO = RepoUtil.getVersionableById((IScmRichClientRestService)scmService, (String)wsId, (String)compId, (String)verId, null, (String)itemType, (IScmClientConfiguration)config);
            return verDTO;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Map<ParmsWorkspace, List<LockItem>> getLocalLockItems(List<ResourcePropertiesDTO> resProps, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ParmsWorkspace, List<LockItem>> streamToLockItems = new HashMap<ParmsWorkspace, List<LockItem>>();
        HashMap<String, ParmsWorkspace> wsToStream = new HashMap<String, ParmsWorkspace>();
        for (ResourcePropertiesDTO resProp : resProps) {
            ArrayList<LockItem> lockItems;
            if (resProp.getVersionableItemType().equals("folder")) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)this.unsupportedVersionableMsg, (Object)resProp.getFullPath()));
            }
            if (resProp.getItemId() == null) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)resProp.getFullPath()));
            }
            ParmsWorkspace targetStream = (ParmsWorkspace)wsToStream.get(resProp.getShare().getContextItemId());
            if (targetStream == null) {
                ParmsWorkspace ws = new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ShareDTO)resProp.getShare()), resProp.getShare().getContextItemId());
                WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
                ITeamRepository targetRepo = null;
                IWorkspace targetWs = null;
                ParmsWorkspace flowTarget = RepoUtil.getFlowTarget((WorkspaceDetailsDTO)wsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.OUTGOING, (boolean)true);
                if (flowTarget == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_NO_FLOWTARGET, (Object)AliasUtil.selector((String)wsDetails.getName(), (UUID)UUID.valueOf((String)wsDetails.getItemId()), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
                }
                targetRepo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(flowTarget.repositoryUrl));
                targetWs = RepoUtil.getWorkspaceById((String)flowTarget.workspaceItemId, (ITeamRepository)targetRepo, (IScmClientConfiguration)config);
                if (targetWs != null && targetWs.isStream()) {
                    targetStream = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
                    wsToStream.put(resProp.getShare().getContextItemId(), targetStream);
                } else {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_NO_FLOWTARGET, (Object)AliasUtil.selector((String)wsDetails.getName(), (UUID)UUID.valueOf((String)wsDetails.getItemId()), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
                }
            }
            if ((lockItems = (ArrayList<LockItem>)streamToLockItems.get(targetStream)) == null) {
                lockItems = new ArrayList<LockItem>();
                streamToLockItems.put(targetStream, lockItems);
            }
            LockItem lockItem = new LockItem(resProp.getShare().getComponentItemId(), resProp.getItemId(), resProp.getVersionableItemType());
            lockItems.add(lockItem);
        }
        return streamToLockItems;
    }

    /*
     * Unable to fully structure code
     */
    protected void lock(Map<ParmsWorkspace, List<LockItem>> streamToLockItems, Map<ParmsWorkspace, ParmsWorkspace> streamToWorkspace, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws FileSystemException {
        for (Map.Entry<ParmsWorkspace, List<LockItem>> entry : streamToLockItems.entrySet()) {
            ws = entry.getKey();
            try {
                block8: {
                    locks = new ArrayList<ParmsLock>();
                    for (LockItem lockItem : entry.getValue()) {
                        lock = new ParmsLock();
                        lock.workspace = new ParmsWorkspace();
                        lock.workspace.repositoryUrl = ws.repositoryUrl;
                        lock.workspace.workspaceItemId = ws.workspaceItemId;
                        lock.componentItemId = lockItem.getComponent();
                        lock.versionable = new ParmsVersionable();
                        lock.versionable.versionableItemType = lockItem.getVersionableType();
                        lock.versionable.itemId = lockItem.getVersionable();
                        for (Map.Entry<ParmsWorkspace, ParmsWorkspace> sourcews : streamToWorkspace.entrySet()) {
                            if (!sourcews.getKey().workspaceItemId.equals(ws.workspaceItemId)) continue;
                            lock.sourceWorkspace = sourcews.getValue();
                        }
                        locks.add(lock);
                    }
                    parms = new ParmsLockResources();
                    parms.locks = locks.toArray(new ParmsLock[locks.size()]);
                    (parms.lockDilemmaHandler = new ParmsLockDilemmaHandler()).incomingChangeAffectsFileToLock = cli.hasOption((IOptionKey)LockAcquireCmd.OPT_IGNORE_INCOMING) != false ? "continue" : "cancel";
                    result = null;
                    try {
                        result = client.postLockResources(parms, null);
                        break block8;
                    }
                    catch (LockOperationFailureException e) {
                        var17_17 = strings = e.getMessage().split("\r\n|\r|\n");
                        var16_18 = strings.length;
                        var15_19 = 0;
                        ** while (var15_19 < var16_18)
                    }
lbl-1000:
                    // 1 sources

                    {
                        s = var17_17[var15_19];
                        config.getWrappedErrorStream().println((CharSequence)s);
                        ++var15_19;
                        continue;
                    }
lbl37:
                    // 1 sources

                    throw StatusHelper.inappropriateArgument((String)Messages.LockAcquireCmd_ALREADY_LOCKED);
                }
                if (!result.isCancelled() || result.getIncomingChangesToLockedFiles().size() == 0) continue;
                throw StatusHelper.createException((String)NLS.bind((String)Messages.LockAcquireCmd_CONFLICT_WITH_INCOMING_CHANGE, (Object)LockAcquireCmd.OPT_IGNORE_INCOMING.getName()), (int)63, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)e.getMessage(), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
            }
        }
        config.getWrappedOutputStream().println((CharSequence)Messages.LockAcquireCmd_LOCKS_SUCCESSFULLY_ACQUIRED);
    }

    private Map<ParmsWorkspace, ParmsWorkspace> getStreamToWorkspace(List<ResourcePropertiesDTO> resProps, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ParmsWorkspace, ParmsWorkspace> streamToWorkspace = new HashMap<ParmsWorkspace, ParmsWorkspace>();
        HashMap<String, ParmsWorkspace> wsToStream = new HashMap<String, ParmsWorkspace>();
        for (ResourcePropertiesDTO resProp : resProps) {
            if (resProp.getItemId() == null) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)resProp.getFullPath()));
            }
            ParmsWorkspace targetStream = (ParmsWorkspace)wsToStream.get(resProp.getShare().getContextItemId());
            if (targetStream != null) continue;
            ParmsWorkspace ws = new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ShareDTO)resProp.getShare()), resProp.getShare().getContextItemId());
            WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
            ITeamRepository targetRepo = null;
            IWorkspace targetWs = null;
            ParmsWorkspace flowTarget = RepoUtil.getFlowTarget((WorkspaceDetailsDTO)wsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.OUTGOING, (boolean)true);
            if (flowTarget == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_NO_FLOWTARGET, (Object)AliasUtil.selector((String)wsDetails.getName(), (UUID)UUID.valueOf((String)wsDetails.getItemId()), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
            }
            targetRepo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)config.getConnectionInfo(flowTarget.repositoryUrl));
            targetWs = RepoUtil.getWorkspaceById((String)flowTarget.workspaceItemId, (ITeamRepository)targetRepo, (IScmClientConfiguration)config);
            if (targetWs != null && targetWs.isStream()) {
                targetStream = new ParmsWorkspace(targetRepo.getRepositoryURI(), targetWs.getItemId().getUuidValue());
                wsToStream.put(resProp.getShare().getContextItemId(), targetStream);
                streamToWorkspace.put(targetStream, ws);
                continue;
            }
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.LockAcquireCmd_NO_FLOWTARGET, (Object)AliasUtil.selector((String)wsDetails.getName(), (UUID)UUID.valueOf((String)wsDetails.getItemId()), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE)));
        }
        return streamToWorkspace;
    }

    public static class LockItem {
        String componentId;
        String versionableId;
        String versionableType;

        public LockItem(String componentId, String versionableId, String versionableType) {
            this.componentId = componentId;
            this.versionableId = versionableId;
            this.versionableType = versionableType;
        }

        public String getComponent() {
            return this.componentId;
        }

        public String getVersionable() {
            return this.versionableId;
        }

        public String getVersionableType() {
            return this.versionableType;
        }
    }
}

