/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class WorkspacePrinter
extends AbstractItemPrinter {
    private boolean workspacesOnly;
    private boolean streamsOnly;
    private boolean verbose;

    public WorkspacePrinter(IScmClientConfiguration config, ITeamRepository repo, boolean verbose) {
        super(config, repo);
        this.verbose = verbose;
    }

    public void printWorkspaces(List<ScmWorkspace> workspaces, ITeamRepository repo, boolean hasMoreItems) throws FileSystemException {
        JSONArray jWrkspcs = this.jsonizeWorkspaces(workspaces, this.verbose);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jWrkspcs.toString());
            return;
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (jWrkspcs.size() == 0) {
            if (this.workspacesOnly) {
                out.println((CharSequence)Messages.ListCmd_NO_WORKSPACES_FOUND);
            } else if (this.streamsOnly) {
                out.println((CharSequence)Messages.ListCmd_NO_STREAMS_FOUND);
            } else {
                out.println((CharSequence)Messages.WorkspacePrinter_0);
            }
            return;
        }
        this.printWorkspaces(jWrkspcs, out, this.verbose);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!this.config.isJSONEnabled() && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && hasMoreItems) {
            this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    public void setWorspacesOnly(boolean workspacesOnly) {
        this.workspacesOnly = workspacesOnly;
    }

    public void setStreamsOnly(boolean streamsOnly) {
        this.streamsOnly = streamsOnly;
    }

    @Override
    public void printResult(List<Object> result, boolean hasMoreItems) throws FileSystemException {
        this.printWorkspaces(this.convertToWorkspaceList(result), this.repo, hasMoreItems);
    }

    private List<ScmWorkspace> convertToWorkspaceList(List<Object> result) {
        ArrayList<ScmWorkspace> newList = new ArrayList<ScmWorkspace>(result.size());
        for (Object o : result) {
            newList.add((ScmWorkspace)o);
        }
        return newList;
    }
}

