/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmSnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class SnapshotItemPrinter
extends AbstractItemPrinter {
    public SnapshotItemPrinter(IScmClientConfiguration config, ITeamRepository repo) {
        super(config, repo);
    }

    @Override
    public void printResult(List<Object> result, boolean hasMoreItems) throws FileSystemException {
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        if (result.isEmpty() && !this.config.isJSONEnabled()) {
            printStream.println((CharSequence)Messages.SnapshotItemPrinter_NO_SNAPSHOTS);
            return;
        }
        if (!this.config.isJSONEnabled()) {
            printStream.println((CharSequence)Messages.SnapshotItemPrinter_HEADER);
        }
        JSONArray jItems = this.jsonizeItems(result);
        this.printItemFromJson(jItems);
        if (!this.config.isJSONEnabled() && hasMoreItems) {
            printStream.println((CharSequence)NLS.bind((String)Messages.ListQueryItemsCmd_2, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private JSONArray jsonizeItems(List<Object> items) throws FileSystemException {
        List<ScmSnapshot> sortedItems = this.sortItems(items);
        return this.jsonizeSnapshots(sortedItems);
    }

    private List<ScmSnapshot> sortItems(List<Object> items) {
        ArrayList<ScmSnapshot> sortedList = new ArrayList<ScmSnapshot>();
        for (Object o : items) {
            sortedList.add((ScmSnapshot)o);
        }
        Collections.sort(sortedList, new Comparator<ScmSnapshot>(){

            @Override
            public int compare(ScmSnapshot o1, ScmSnapshot o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return SnapshotItemPrinter.this.compareImpl(name1, name2);
            }
        });
        return sortedList;
    }

    private void printItemFromJson(JSONArray jItems) {
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.config.isJSONEnabled()) {
            JSONObject root = new JSONObject();
            root.put((Object)"snapshots", (Object)jItems);
            this.config.getOutputStream().print((CharSequence)root.toString());
            return;
        }
        for (Object obj : jItems) {
            JSONObject item = (JSONObject)obj;
            this.printSnapshot(out, item);
        }
    }
}

