/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.AbstractItemPrinter;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmQueryItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class QueryItemPrinter
extends AbstractItemPrinter {
    public QueryItemPrinter(IScmClientConfiguration config, ITeamRepository repo) {
        super(config, repo);
    }

    @Override
    public void printResult(List<Object> result, boolean hasMoreItems) throws FileSystemException {
        boolean isJsonEnabled = this.config.isJSONEnabled();
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        if (result.isEmpty() && !isJsonEnabled) {
            printStream.println((CharSequence)Messages.ListQueryItemsCmd_1);
            return;
        }
        JSONArray jQueryItems = this.jsonizeQueryItems(result, this.repo);
        this.printQueryItemJson(jQueryItems);
        if (!isJsonEnabled && hasMoreItems) {
            printStream.println((CharSequence)NLS.bind((String)Messages.ListQueryItemsCmd_2, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private void printQueryItemJson(JSONArray jQueryItems) {
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.config.isJSONEnabled()) {
            JSONObject root = new JSONObject();
            root.put((Object)"query-items", (Object)jQueryItems);
            this.config.getOutputStream().print((CharSequence)root.toString());
            return;
        }
        for (Object obj : jQueryItems) {
            JSONObject queryItem = (JSONObject)obj;
            String selector = AliasUtil.selector((String)((String)queryItem.get((Object)"name")), (UUID)UUID.valueOf((String)((String)queryItem.get((Object)"uuid"))), (String)((String)queryItem.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.QUERY_ITEM);
            out.println((CharSequence)NLS.bind((String)Messages.ListQueryItemsCmd_10, (Object)selector, (Object)queryItem.get((Object)"result-type")));
        }
    }

    private JSONArray jsonizeQueryItems(List<Object> queryItems, ITeamRepository repository) {
        JSONArray jQueryItems = new JSONArray();
        List<ScmQueryItem> sortedQueryItems = this.sortQueryItems(queryItems);
        for (ScmQueryItem queryItem : sortedQueryItems) {
            JSONObject json = this.jsonizeQueryItem(queryItem, repository);
            jQueryItems.add((Object)json);
        }
        return jQueryItems;
    }

    private List<ScmQueryItem> sortQueryItems(List<Object> queryItems) {
        ArrayList<ScmQueryItem> sortedList = new ArrayList<ScmQueryItem>();
        for (Object o : queryItems) {
            sortedList.add((ScmQueryItem)o);
        }
        Collections.sort(sortedList, new Comparator<ScmQueryItem>(){

            @Override
            public int compare(ScmQueryItem o1, ScmQueryItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return sortedList;
    }

    private JSONObject jsonizeQueryItem(ScmQueryItem queryItem, ITeamRepository repository) {
        JSONObject json = JSONPrintUtil.jsonize((String)queryItem.getName(), (String)queryItem.getItemId(), (String)repository.getRepositoryURI());
        String resultType = queryItem.getResultType();
        String jsonResultType = resultType.equals(this.getResultType(IWorkspace.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_3 : (resultType.equals(this.getResultType(IComponent.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_4 : (resultType.equals(this.getResultType(IBaselineSet.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_5 : (resultType.equals(this.getResultType(IBaseline.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_6 : (resultType.equals(this.getResultType(IQueryItem.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_7 : (resultType.equals(this.getResultType(IChangeSet.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_8 : Messages.ListQueryItemsCmd_9)))));
        json.put((Object)"result-type", (Object)jsonResultType);
        return json;
    }

    private String getResultType(IItemType itemType) {
        return String.valueOf(itemType.getNamespaceURI()) + "." + itemType.getName();
    }
}

