/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.rest.IFilesystemRichClientRestService;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rich.rest.dto.ContentStatusDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IVersionedContentService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmIntermediateChangeNode;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmIntermediateHistory;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ListStatesCmd
extends AbstractSubcommand
implements IOptionSource {
    IFilesystemRestClient client = null;
    public static final IOptionKey OPT_CHANGES = new OptionKey("changes");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption(OPT_CHANGES, "c", "changes", Messages.ListStatesCmdOption_CHANGES, -1).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.ChangesetCompleteCmdOptions_0).addOption(ChangesetCommonOptions.OPT_CHANGESET, ChangesetCommonOptions.OPT_CHANGESET_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)this.config);
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(csSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)csSelector);
        }
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        List changeSelectors = null;
        if (cli.hasOption(OPT_CHANGES)) {
            changeSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_CHANGES), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)changeSelectors, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.VERSIONABLE});
        }
        ChangeSetSyncDTO csDTO = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (boolean)true, (String)(ws != null ? ws.workspaceItemId : null), (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        List<ChangeSyncDTO> changes = this.getChanges(csDTO, changeSelectors, repo);
        this.listStates(ws, csDTO, changes, repo);
    }

    private List<ChangeSyncDTO> getChanges(ChangeSetSyncDTO csDTO, List<IScmCommandLineArgument> changeSelectors, ITeamRepository repo) throws FileSystemException {
        List<ChangeSyncDTO> changes = null;
        if (changeSelectors == null || changeSelectors.size() == 0) {
            changes = new ArrayList<ChangeSyncDTO>();
            for (ChangeFolderSyncDTO changeFolderSyncDTO : csDTO.getChanges()) {
                for (ChangeSyncDTO changeSyncDTO : changeFolderSyncDTO.getChanges()) {
                    changes.add(changeSyncDTO);
                }
            }
        } else {
            List selectors = RepoUtil.getSelectors(changeSelectors);
            changes = this.getChanges(csDTO, selectors, repo.getRepositoryURI(), this.config);
        }
        return changes;
    }

    private List<ChangeSyncDTO> getChanges(ChangeSetSyncDTO csDTO, List<String> changeSelectors, String repoUri, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<ChangeSyncDTO> changes = new ArrayList<ChangeSyncDTO>();
        for (String changeSelector : changeSelectors) {
            IUuidAliasRegistry.IUuidAlias changeAlias = RepoUtil.lookupUuidAndAlias((String)changeSelector, (String)repoUri);
            ArrayList<ChangeSyncDTO> matchedChanges = new ArrayList<ChangeSyncDTO>();
            for (ChangeFolderSyncDTO changeFolderSyncDTO : csDTO.getChanges()) {
                for (ChangeSyncDTO changeSyncDTO : changeFolderSyncDTO.getChanges()) {
                    if (changeAlias != null && changeAlias.getUuid().getUuidValue().equals(changeSyncDTO.getVersionableItemId())) {
                        matchedChanges.add(changeSyncDTO);
                        continue;
                    }
                    if (changeAlias != null) continue;
                    IPath changeSelectorPath = new Path(changeSelector).makeAbsolute().removeTrailingSeparator();
                    if (changeSelectorPath.segmentCount() > 1) {
                        IPath changePath = new Path(changeSyncDTO.getPathHint()).makeAbsolute().removeTrailingSeparator();
                        if (!changePath.toOSString().endsWith(changeSelectorPath.toOSString())) continue;
                        matchedChanges.add(changeSyncDTO);
                        continue;
                    }
                    if (!changeSyncDTO.getVersionableName().equals(changeSelectorPath.lastSegment())) continue;
                    matchedChanges.add(changeSyncDTO);
                }
            }
            if (matchedChanges.size() == 0) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListStatesCmd_CHANGE_NOT_FOUND, (Object)changeSelector));
            }
            if (matchedChanges.size() > 1) {
                IndentingPrintStream err = config.getWrappedErrorStream();
                err.println((CharSequence)Messages.ListStatesCmd_MULTIPLE_CHANGE_MATCHED);
                for (ChangeSyncDTO change : matchedChanges) {
                    err.indent().println((CharSequence)AliasUtil.selector((String)change.getPathHint(), (UUID)UUID.valueOf((String)change.getVersionableItemId()), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE));
                }
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.Common_AMBIGUOUS_CHANGE, (Object)changeSelector));
            }
            changes.add((ChangeSyncDTO)matchedChanges.get(0));
        }
        return changes;
    }

    private void listStates(ParmsWorkspace ws, ChangeSetSyncDTO csDTO, List<ChangeSyncDTO> changes, ITeamRepository repo) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IScmRichClientRestService.ParmsGetIntermediateHistory parms = new IScmRichClientRestService.ParmsGetIntermediateHistory();
        parms.changeSetItemId = csDTO.getChangeSetItemId();
        HashMap<ChangeSyncDTO, List<ScmIntermediateChangeNode>> changeToStates = new HashMap<ChangeSyncDTO, List<ScmIntermediateChangeNode>>();
        for (ChangeSyncDTO change : changes) {
            ScmIntermediateHistory result = null;
            if (change.getVersionableItemType().equals("file")) {
                parms.versionableItemId = change.getVersionableItemId();
                parms.versionableItemNamespace = IFileItem.ITEM_TYPE.getNamespaceURI();
                parms.versionableItemType = IFileItem.ITEM_TYPE.getName();
                try {
                    result = scmService.getChangeSetHistory(parms);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.ListStatesCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
                }
            }
            changeToStates.put(change, result != null ? result.getHistory() : null);
        }
        JSONObject changesObj = new JSONObject();
        JSONArray changeArray = this.jsonizeStates(changeToStates, csDTO.isIsActive(), repo, this.config);
        changesObj.put((Object)"changes", (Object)changeArray);
        if (this.config.isJSONEnabled()) {
            if (changeArray.size() > 0) {
                this.config.getOutputStream().print((CharSequence)changesObj.toString());
            }
        } else {
            IndentingPrintStream out = this.config.getWrappedOutputStream();
            this.printStates(changeArray, (IClientConfiguration)this.config, out);
        }
    }

    private JSONArray jsonizeStates(Map<ChangeSyncDTO, List<ScmIntermediateChangeNode>> changeToStates, boolean isCsActive, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        JSONArray changeArray = new JSONArray();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
        for (Map.Entry<ChangeSyncDTO, List<ScmIntermediateChangeNode>> entry : changeToStates.entrySet()) {
            ChangeSyncDTO change = entry.getKey();
            String changePath = new StringBuffer("/").append(change.getPathHint()).toString();
            JSONObject changeObj = new JSONObject();
            changeObj.put((Object)"uuid", (Object)change.getVersionableItemId());
            changeObj.put((Object)"url", (Object)repo.getRepositoryURI());
            changeObj.put((Object)"path", (Object)changePath);
            JSONArray statesArray = new JSONArray();
            changeObj.put((Object)"states", (Object)statesArray);
            if (entry.getValue() != null) {
                Map<String, ContentStatusDTO> stateToStatusMap = this.getStateStatus(entry.getKey().getVersionableItemId(), entry.getValue(), repo, config);
                for (ScmIntermediateChangeNode intermediateChange : entry.getValue()) {
                    boolean isLastChange = false;
                    if (!intermediateChange.isSetSuccessors() || intermediateChange.getSuccessors().size() == 0) {
                        isLastChange = true;
                    }
                    JSONObject chgStateObj = this.jsonizeState(intermediateChange.getType(), isCsActive, isLastChange, stateToStatusMap.get(intermediateChange.getStateId()), repo);
                    String date = sdf.format(intermediateChange.getDate());
                    JSONObject stateObj = new JSONObject();
                    stateObj.put((Object)"uuid", (Object)intermediateChange.getStateId());
                    stateObj.put((Object)"url", (Object)repo.getRepositoryURI());
                    stateObj.put((Object)"state", (Object)chgStateObj);
                    stateObj.put((Object)"date", (Object)date);
                    statesArray.add((Object)stateObj);
                }
            }
            changeArray.add((Object)changeObj);
        }
        return changeArray;
    }

    private Map<String, ContentStatusDTO> getStateStatus(String itemId, List<ScmIntermediateChangeNode> stateNodes, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ContentStatusDTO[] result;
        ArrayList<String> fileItemIdList = new ArrayList<String>();
        ArrayList<String> fileStateIdList = new ArrayList<String>();
        for (ScmIntermediateChangeNode stateNode : stateNodes) {
            if (stateNode.getStateId() == null) continue;
            fileItemIdList.add(itemId);
            fileStateIdList.add(stateNode.getStateId());
        }
        IFilesystemRichClientRestService.ParmsContentStatus parms = new IFilesystemRichClientRestService.ParmsContentStatus();
        parms.fileItemId = fileItemIdList.toArray(new String[fileItemIdList.size()]);
        parms.fileItemStateId = fileStateIdList.toArray(new String[fileStateIdList.size()]);
        IFilesystemRichClientRestService service = (IFilesystemRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IFilesystemRichClientRestService.class);
        try {
            result = service.getContentStatus(parms);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListStatesCmd_FAILURE_FETCHING_STATUS, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        HashMap<String, ContentStatusDTO> stateToDeletedMap = new HashMap<String, ContentStatusDTO>();
        int count = 0;
        for (String stateId : fileStateIdList) {
            stateToDeletedMap.put(stateId, result[count++]);
        }
        return stateToDeletedMap;
    }

    private void printStates(JSONArray changeArray, IClientConfiguration config, IndentingPrintStream out) {
        if (changeArray.size() == 0) {
            out.println((CharSequence)Messages.ListStatesCmd_NO_CHANGES_FOUND);
            return;
        }
        for (Object changeObj : changeArray) {
            JSONObject change = (JSONObject)changeObj;
            String changeAlias = AliasUtil.alias((String)((String)change.get((Object)"uuid")), (String)((String)change.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)changeAlias, (Object)change.get((Object)"path")));
            JSONArray stateArray = (JSONArray)change.get((Object)"states");
            for (Object stateObj : stateArray) {
                JSONObject state = (JSONObject)stateObj;
                String stateAlias = "(----)";
                if (state.get((Object)"uuid") != null) {
                    stateAlias = AliasUtil.alias((String)((String)state.get((Object)"uuid")), (String)((String)state.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
                }
                String stateString = this.getStateString((JSONObject)state.get((Object)"state"));
                out.indent().println((CharSequence)NLS.bind((String)Messages.Common_PRINT_3_ITEMS, (Object[])new Object[]{stateAlias, stateString, (String)state.get((Object)"date")}));
            }
        }
    }

    private JSONObject jsonizeState(int type, boolean isActive, boolean isLastChange, ContentStatusDTO status, ITeamRepository repo) throws FileSystemException {
        JSONObject chgStateObj = new JSONObject();
        if (type == ScmIntermediateChangeNode.TYPE_BEFORE) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_INITIAL);
        } else if (type == ScmIntermediateChangeNode.TYPE_AFTER) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_MODIFIED);
        } else if (type == ScmIntermediateChangeNode.TYPE_MERGE) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_PROPOSED);
        } else if (type == ScmIntermediateChangeNode.TYPE_ADDITION) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_ADDED);
        } else if (type == ScmIntermediateChangeNode.TYPE_DELETE) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_DELETED);
        } else if (type == ScmIntermediateChangeNode.TYPE_MOVE) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_MOVED);
        } else if (type == ScmIntermediateChangeNode.TYPE_RENAME) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_RENAMED);
        } else if (type == ScmIntermediateChangeNode.TYPE_UNDO) {
            chgStateObj.put((Object)"type", (Object)Messages.ListStatesCmd_STATE_UNDO);
        }
        if (isLastChange) {
            if (isActive) {
                chgStateObj.put((Object)"status", (Object)Messages.ListStatesCmd_STATE_CURRENT);
            } else {
                chgStateObj.put((Object)"status", (Object)Messages.ListStatesCmd_STATE_FINAL);
            }
        }
        if (status != null && status.isSetStatus()) {
            chgStateObj.put((Object)"state-content", (Object)status.getStatus());
            String contrib = "";
            if (status.getDeletedByContributorId() != null) {
                IContributor contributor = (IContributor)RepoUtil.getItem((IItemType)IContributor.ITEM_TYPE, (UUID)UUID.valueOf((String)status.getDeletedByContributorId()), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                contrib = contributor.getUserId();
            }
            chgStateObj.put((Object)"deletedby-contributor", (Object)contrib);
            String date = "";
            if (status.getDeletedOn() != 0L) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
                date = sdf.format(new Date(status.getDeletedOn()));
            }
            chgStateObj.put((Object)"deleted-on", (Object)date);
        }
        return chgStateObj;
    }

    private String getStateString(JSONObject stateObj) {
        String contentStatus;
        String stateString = "";
        stateString = (String)stateObj.get((Object)"type");
        if (stateObj.get((Object)"status") != null) {
            stateString = NLS.bind((String)Messages.PropertyListCmd_KeyValue, (Object)stateObj.get((Object)"status"), (Object)stateString);
        }
        if ((contentStatus = (String)stateObj.get((Object)"state-content")) != null && !contentStatus.equalsIgnoreCase(IVersionedContentService.ContentStatus.PRESENT.name())) {
            String statusMsg = contentStatus;
            if (contentStatus.equalsIgnoreCase(IVersionedContentService.ContentStatus.DELETED.name())) {
                String contrib = Messages.LockListCmd_Unknown;
                if (stateObj.get((Object)"deletedby-contributor") != null) {
                    contrib = (String)stateObj.get((Object)"deletedby-contributor");
                }
                String date = Messages.LockListCmd_Unknown;
                if (stateObj.get((Object)"deleted-on") != null) {
                    date = (String)stateObj.get((Object)"deleted-on");
                }
                statusMsg = NLS.bind((String)Messages.ListStatesCmd_DELETED, (Object)contrib, (Object)date);
            }
            stateString = NLS.bind((String)Messages.ListStatesCmd_STATUS, (Object)stateString, (Object)statusMsg);
        }
        return stateString;
    }
}

