/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ListSnapshotsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_SELECTOR = new PositionalOptionDefinition("selector", 0, 1, "@");
    public static final NamedOptionDefinition OPT_PROJECTAREA = new NamedOptionDefinition(null, "projectarea", 1, "@");
    public static final NamedOptionDefinition OPT_TEAMAREA = new NamedOptionDefinition(null, "teamarea", 1, "@");
    public static final IOptionKey OPT_NAME_FILTER = new OptionKey("name");

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SELECTOR, null), (IScmClientConfiguration)this.config);
        boolean isSnapshotName = cli.hasOption(OPT_NAME_FILTER);
        if (isSnapshotName && selector == null) {
            throw StatusHelper.argSyntax((String)Messages.ListSnapshotsCmd_SNAPSHOT_NAME_NOT_SPECIFIED);
        }
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA) && cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)OPT_PROJECTAREA.getName(), (Object)OPT_TEAMAREA.getName()));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        IWorkspace ws = null;
        String ssPrefix = null;
        if (!isSnapshotName && selector != null && selector.getItemSelector().length() > 0) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
            ws = RepoUtil.getWorkspace((String)selector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
            ssPrefix = selector != null ? selector.getItemSelector() : null;
        }
        IProjectArea processArea = null;
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA)) {
            String projectAreaName = cli.getOption((IOptionKey)OPT_PROJECTAREA);
            processArea = RepoUtil.getProjectArea((ITeamRepository)repo, (String)projectAreaName, (IScmClientConfiguration)this.config);
        } else if (cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            String teamAreaName = cli.getOption((IOptionKey)OPT_TEAMAREA);
            processArea = RepoUtil.getTeamArea((String)teamAreaName, null, (IScmClientConfiguration)this.config, (ITeamRepository)repo);
        }
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        List baselineSets = RepoUtil.getSnapshotByName((String)(ws != null ? ws.getItemId().getUuidValue() : null), (String)ssPrefix, (IProcessAreaHandle)processArea, (boolean)false, (int)(maxResults == Integer.MAX_VALUE ? maxResults : maxResults + 1), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        Collections.sort(baselineSets, new Comparator<IBaselineSet>(){

            @Override
            public int compare(IBaselineSet b1, IBaselineSet b2) {
                return b1.getCreationDate().after(b2.getCreationDate()) ? -1 : 1;
            }
        });
        JSONArray snapshots = new JSONArray();
        int ssCount = this.jsonize(this.config, snapshots, baselineSets, cli, repo, maxResults);
        JSONObject jResult = new JSONObject();
        if (snapshots.size() > 0) {
            jResult.put((Object)"snapshots", (Object)snapshots);
        }
        this.printResults(jResult, this.config, ssCount, maxResults);
    }

    void printResults(JSONObject jResult, IScmClientConfiguration config, int ssCount, int maxResults) {
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jResult.toString());
        } else {
            IndentingPrintStream printStream = config.getWrappedOutputStream();
            if (ssCount == 0) {
                printStream.println((CharSequence)Messages.ListSnapshotsCmd_NO_SNAPSHOTS);
                return;
            }
            ICommandLine cli = config.getSubcommandCommandLine();
            boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
            JSONArray jSnpShots = (JSONArray)jResult.get((Object)"snapshots");
            for (Object obj : jSnpShots) {
                JSONObject jSnapshot = (JSONObject)obj;
                String message = Messages.ListSnapshotsCmd_1;
                String snapshotSelector = AliasUtil.selector((String)((String)jSnapshot.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jSnapshot.get((Object)"uuid"))), (String)((String)jSnapshot.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
                String creationDate = (String)jSnapshot.get((Object)"creationDate");
                String comment = (String)jSnapshot.get((Object)"comment");
                if (verbose) {
                    message = Messages.ListSnapshotsCmd_3;
                }
                String ownerSelector = null;
                JSONObject owner = (JSONObject)jSnapshot.get((Object)"ownedby");
                if (owner.get((Object)"uuid") != null) {
                    RepoUtil.ItemType type = ((String)owner.get((Object)"type")).equals("workspace") ? RepoUtil.ItemType.WORKSPACE : RepoUtil.ItemType.STREAM;
                    ownerSelector = AliasUtil.selector((String)((String)owner.get((Object)"name")), (UUID)UUID.valueOf((String)((String)owner.get((Object)"uuid"))), (String)((String)owner.get((Object)"url")), (RepoUtil.ItemType)type);
                } else {
                    ownerSelector = NLS.bind((String)Messages.ListSnapshotsCmd_5, (Object)Messages.ListSnapshotsCmd_OWNER_INACCESSIBLE);
                }
                String ownedBy = NLS.bind((String)Messages.ListSnapshotsCmd_OWNED_BY, (Object)ownerSelector);
                printStream.println((CharSequence)NLS.bind((String)message, (Object[])new String[]{snapshotSelector, creationDate, comment, ownedBy}));
            }
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && ssCount >= maxResults) {
                config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
        }
    }

    int jsonize(IScmClientConfiguration config, JSONArray jSnapshots, List<IBaselineSet> snapshots, ICommandLine cli, ITeamRepository repo, int maxResults) throws FileSystemException {
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
        format = SubcommandUtil.getDateFormat((String)format.toPattern(), (IScmClientConfiguration)config);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        int ssCount = 0;
        ArrayList<IWorkspaceHandle> snapshotOwnerHandles = new ArrayList<IWorkspaceHandle>(snapshots.size());
        for (IBaselineSet snapshot : snapshots) {
            snapshotOwnerHandles.add(snapshot.getOwner());
        }
        Map ownerIdToObject = RepoUtil.getJsonizedWorkspace(snapshotOwnerHandles, (ITeamRepository)repo, (IScmClientConfiguration)config);
        for (IBaselineSet snapshot : snapshots) {
            if (ssCount >= maxResults) break;
            JSONObject jsonizedSnapshot = JSONPrintUtil.jsonize((String)snapshot.getName(), (String)snapshot.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
            if (verbose || config.isJSONEnabled()) {
                String comment = snapshot.getComment();
                if (comment.length() == 0) {
                    comment = Messages.ListSnapshotsCmd_NO_COMMENT;
                }
                jsonizedSnapshot.put((Object)"comment", (Object)comment);
            }
            jsonizedSnapshot.put((Object)"creationDate", (Object)format.format(snapshot.getCreationDate()));
            if (ownerIdToObject != null) {
                JSONObject owner = (JSONObject)ownerIdToObject.get(snapshot.getOwner().getItemId().getUuidValue());
                if (owner == null) {
                    owner = JSONPrintUtil.jsonize((String)Messages.ListSnapshotsCmd_OWNER_INACCESSIBLE, null, (String)repo.getRepositoryURI());
                    owner.put((Object)"type", (Object)RepoUtil.ItemType.UNKNOWN.toString());
                }
                jsonizedSnapshot.put((Object)"ownedby", (Object)owner);
            }
            jSnapshots.add((Object)jsonizedSnapshot);
            ++ssCount;
        }
        return ssCount;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListSnapshotsCmd_2).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10)).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_PROJECTAREA, Messages.ListCmdOptions_PROJECTAREA, false).addOption((INamedOptionDefinition)OPT_TEAMAREA, Messages.ListCmdOptions_TEAMAREA, false)).addOption(OPT_NAME_FILTER, "n", "name", Messages.ListSnapShotCmdOptions_NAME_FILTER, 0).addOption((IPositionalOptionDefinition)OPT_SELECTOR, NLS.bind((String)Messages.ListSnapshotsCmd_4, (Object)((OptionKey)OPT_NAME_FILTER).getName()));
        return options;
    }
}

