/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.repository.client.login.SmartCardLoginInfo;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.List;

public class ListSmartCardAliasesCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP);
        return opts;
    }

    public void run() throws FileSystemException {
        if (!Constants.ON_WINDOWS) {
            throw StatusHelper.disallowed((String)Messages.ListSmartCardAliases_NOT_SUPPORTED);
        }
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        SmartCardLoginInfo loginInfo = new SmartCardLoginInfo();
        List aliases = loginInfo.getAliases();
        JSONArray jAliases = this.jsonizeAliases(aliases);
        if (this.config.isJSONEnabled()) {
            JSONObject jResult = new JSONObject();
            jResult.put((Object)"aliases", (Object)jAliases);
            this.config.getOutputStream().print((CharSequence)jResult.toString());
            return;
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (aliases.size() == 0) {
            out.println((CharSequence)Messages.ListSmartCardAliases_NOT_FOUND);
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                out.println((CharSequence)Messages.ListSmartCardAliases_NOT_FOUND_HINT);
            }
            return;
        }
        for (String alias : aliases) {
            out.println((CharSequence)alias);
        }
    }

    private JSONArray jsonizeAliases(List<String> aliases) {
        JSONArray jAliases = new JSONArray();
        for (String alias : aliases) {
            JSONObject jAlias = new JSONObject();
            jAlias.put((Object)"alias", (Object)alias);
        }
        return jAliases;
    }
}

