/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListRemoteFilesOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2List;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmFolderEntryReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmFolderEntryReportList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifier;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifierList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePermissionsResult;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;

public class ListRemoteFilesCmd
extends AbstractSubcommand {
    static final int DEPTH_INFINITE = -1;
    private static final String READ_ACCESS_TYPE = "type";
    private static final String READ_ACCESS_NAME = "name";
    private static final String READ_ACCESS_UUID = "uuid";
    private Map<String, String> readContextCache = new HashMap<String, String>();
    private static final int MAX_BATCH_SIZE = 50;
    private static final Comparator<String> PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String object1, String object2) {
            int l2;
            int l1 = object1.length();
            int end = l1 < (l2 = object2.length()) ? l1 : l2;
            int i = 0;
            while (i < end) {
                char c1 = object1.charAt(i);
                char c2 = object2.charAt(i);
                if (c1 == '/' && c2 != '/') {
                    return -1;
                }
                if (c2 == '/' && c1 != '/') {
                    return 1;
                }
                int compare = c1 - c2;
                if (compare != 0) {
                    return compare;
                }
                ++i;
            }
            return l1 - l2;
        }
    };

    public void run() throws FileSystemException {
        Map<String, JSONObject> versionablePermissions;
        JSONObject permissions;
        String stateId;
        Map<String, ScmVersionableIdentifier> identifiers;
        String[] path;
        String compId;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        int depth = -1;
        String depthString = cli.getOption(ListRemoteFilesOptions.OPT_DEPTH, null);
        if (depthString != null) {
            if (!"-".equals(depthString)) {
                try {
                    depth = Integer.parseInt(depthString);
                }
                catch (NumberFormatException e) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListRemoteFilesCmd_5, (Object)depthString));
                }
            }
        } else {
            depth = 1;
        }
        VersionMode vMode = VersionMode.HIDE;
        if (cli.hasOption(ListRemoteFilesOptions.OPT_SHOW_SHORT_VERSION_ID) && cli.hasOption(ListRemoteFilesOptions.OPT_SHOW_FULL_VERSION_ID)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption(ListRemoteFilesOptions.OPT_SHOW_SHORT_VERSION_ID).getName(), (Object)cli.getDefinition().getOption(ListRemoteFilesOptions.OPT_SHOW_FULL_VERSION_ID).getName()));
        }
        if (cli.hasOption(ListRemoteFilesOptions.OPT_SHOW_SHORT_VERSION_ID)) {
            vMode = VersionMode.SHORT_VERSION;
        } else if (cli.hasOption(ListRemoteFilesOptions.OPT_SHOW_FULL_VERSION_ID)) {
            vMode = VersionMode.LONG_VERSION;
        }
        boolean showAccess = this.config.getSubcommandCommandLine().hasOption((IOptionKey)ListRemoteFilesOptions.OPT_SHOW_ACCESS);
        Mode mode = Mode.WORKSPACE;
        int modeCount = 0;
        if (cli.hasOption((IOptionKey)ListRemoteFilesOptions.OPT_WORKSPACE)) {
            mode = Mode.WORKSPACE;
            ++modeCount;
        }
        if (cli.hasOption((IOptionKey)ListRemoteFilesOptions.OPT_SNAPSHOT)) {
            mode = Mode.SNAPSHOT;
            ++modeCount;
        }
        if (cli.hasOption((IOptionKey)ListRemoteFilesOptions.OPT_BASELINE)) {
            mode = Mode.BASELINE;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_3_ARGUMENTS, (Object[])new String[]{ListRemoteFilesOptions.OPT_WORKSPACE.getName(), ListRemoteFilesOptions.OPT_SNAPSHOT.getName(), ListRemoteFilesOptions.OPT_BASELINE.getName()}));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListRemoteFilesOptions.OPT_SELECTOR), (IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
        ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListRemoteFilesOptions.OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)this.config);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        IItemHandle contextItem = null;
        if (mode == Mode.WORKSPACE) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            IWorkspace wsFound = RepoUtil.getWorkspace((String)selector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            contextItem = wsFound.getItemHandle();
            WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
            ArrayList<WorkspaceComponentDTO> matches = new ArrayList<WorkspaceComponentDTO>();
            for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                if (!this.matches((IScmCommandLineArgument)compSelector, compDTO)) continue;
                matches.add(compDTO);
            }
            if (matches.isEmpty()) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
            if (matches.size() > 1) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.ListRemoteFilesCmd_MULTI_MATCH);
                this.showAmbiguousWorkspaceComponents(matches, repo, err.indent());
                throw StatusHelper.ambiguousSelector((String)Messages.ListRemoteFilesCmd_SPECIFY_SINGLE);
            }
            compId = ((WorkspaceComponentDTO)matches.get(0)).getItemId();
        } else if (mode == Mode.SNAPSHOT) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)selector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            contextItem = snapshot.getItemHandle();
            List bls = RepoUtil.getItems((IItemType)IBaseline.ITEM_TYPE, (List)snapshot.getBaselines(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ArrayList<IComponentHandle> compHandles = new ArrayList<IComponentHandle>(bls.size());
            for (IBaseline blHandle : bls) {
                compHandles.add(blHandle.getComponent());
            }
            List comps = RepoUtil.getItems((IItemType)IComponent.ITEM_TYPE, compHandles, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ArrayList<IComponent> matches = new ArrayList<IComponent>(comps.size());
            for (IComponent comp : comps) {
                if (!this.matches((IScmCommandLineArgument)compSelector, comp)) continue;
                matches.add(comp);
            }
            if (matches.isEmpty()) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
            if (matches.size() > 1) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.ListRemoteFilesCmd_MULTI_MATCH);
                this.showAmbiguousIComponents(matches, repo, err.indent());
                throw StatusHelper.ambiguousSelector((String)Messages.ListRemoteFilesCmd_SPECIFY_SINGLE);
            }
            compId = ((IComponent)matches.get(0)).getItemId().getUuidValue();
        } else {
            IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            IBaseline bl = RepoUtil.getBaseline((String)selector.getItemSelector(), (String)comp.getItemId().getUuidValue(), null, (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            contextItem = bl.getItemHandle();
            compId = bl.getComponent().getItemId().getUuidValue();
        }
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        String remotePath = null;
        remotePath = cli.hasOption(ListRemoteFilesOptions.OPT_REMOTE_PATH) ? ((path = StringUtil.splitEscapedPath((String)(remotePath = cli.getOption(ListRemoteFilesOptions.OPT_REMOTE_PATH)))).length == 0 ? Character.toString('/') : this.toPath(path, false)) : Character.toString('/');
        ScmVersionablePath scmPath = RepoUtil.getVersionable2((IScmRichClientRestService)scmService, (IItemHandle)contextItem, (String)compId, (String)remotePath, (IScmClientConfiguration)this.config);
        if (scmPath == null || scmPath.getVersionable() == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListRemoteFilesCmd_3, (Object)remotePath));
        }
        String[] pathSegs = scmPath.getSegments().toArray(new String[scmPath.getSegments().size()]);
        String path2 = this.toPath(pathSegs, scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE));
        JSONObject jPath = new JSONObject();
        jPath.put((Object)"path", (Object)path2);
        jPath.put((Object)READ_ACCESS_UUID, (Object)scmPath.getVersionable().getItemId().getUuidValue());
        jPath.put((Object)"state-id", (Object)scmPath.getVersionable().getStateId().getUuidValue());
        if (!VersionMode.HIDE.equals((Object)vMode) && !scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE) && (identifiers = this.fetchVersionIdentifiers(scmService, Collections.singletonList(stateId = scmPath.getVersionable().getStateId().getUuidValue()), repo, this.config)).containsKey(stateId)) {
            jPath.put((Object)"version", (Object)JSONPrintUtil.jsonizeVersionId((ScmVersionableIdentifier)identifiers.get(stateId)));
        }
        if (showAccess && (permissions = (versionablePermissions = this.fetchVersionablePermissions(scmService, compId, Collections.singletonList(scmPath.getVersionable()), repo, this.config)).get(scmPath.getVersionable().getItemId().getUuidValue())) != null) {
            jPath.put((Object)"jazz.read-access", (Object)permissions);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (!scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE) || depth == 0) {
            this.printFiles(Collections.singletonList(jPath), out, repo.getRepositoryURI(), this.config, vMode);
            return;
        }
        this.jsonizeFiles(path2, jPath, contextItem, compId, scmPath.getVersionable(), depth, repo, this.config, vMode);
    }

    private void showAmbiguousIComponents(ArrayList<IComponent> matches, ITeamRepository repo, IndentingPrintStream err) throws CLIFileSystemClientException, FileSystemException {
        IScmRichClientRestService.ParmsGetComponents parmsGetComps = new IScmRichClientRestService.ParmsGetComponents();
        parmsGetComps.componentItemIds = new String[matches.size()];
        int i = 0;
        while (i < parmsGetComps.componentItemIds.length) {
            parmsGetComps.componentItemIds[i] = matches.get(i).getItemId().getUuidValue();
            ++i;
        }
        this.showAmbiguousComponents(parmsGetComps, repo, err);
    }

    private void showAmbiguousWorkspaceComponents(ArrayList<WorkspaceComponentDTO> matches, ITeamRepository repo, IndentingPrintStream err) throws CLIFileSystemClientException, FileSystemException {
        IScmRichClientRestService.ParmsGetComponents parmsGetComps = new IScmRichClientRestService.ParmsGetComponents();
        parmsGetComps.componentItemIds = new String[matches.size()];
        int i = 0;
        while (i < parmsGetComps.componentItemIds.length) {
            parmsGetComps.componentItemIds[i] = matches.get(i).getItemId();
            ++i;
        }
        this.showAmbiguousComponents(parmsGetComps, repo, err);
    }

    public void showAmbiguousComponents(IScmRichClientRestService.ParmsGetComponents parmsGetComps, ITeamRepository repo, IndentingPrintStream out) throws CLIFileSystemClientException, FileSystemException {
        ScmComponent2List componentList = null;
        try {
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            componentList = scmService.postGetComponents2(parmsGetComps);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)"Failed to fetch components", (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        for (ScmComponent2 compInfo : componentList.getComponents()) {
            String ownerName = RepoUtil.getOwnerName((String)compInfo.getOwner().getItemId(), (String)compInfo.getOwner().getItemType(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            out.println((CharSequence)NLS.bind((String)"{0} owned by {1}", (Object)AliasUtil.selector((String)compInfo.getName(), (UUID)UUID.valueOf((String)compInfo.getItemId()), (String)repo.publicUriRoot(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object)ownerName));
        }
    }

    private boolean matches(IScmCommandLineArgument sel, IComponent comp) {
        IUuidAliasRegistry.IUuidAlias alias = sel.getUuidAlias();
        if (alias == null) {
            return sel.getValuePrefix().equals(comp.getName());
        }
        return alias.getUuid().equals((Object)comp.getItemId());
    }

    private boolean matches(IScmCommandLineArgument sel, WorkspaceComponentDTO dto) {
        IUuidAliasRegistry.IUuidAlias alias = sel.getUuidAlias();
        if (alias == null) {
            return sel.getValuePrefix().equals(dto.getName());
        }
        return alias.getUuid().getUuidValue().equals(dto.getItemId());
    }

    private String getPrintableAccessType(String internalAccessType) {
        if (internalAccessType == null) {
            return Messages.Common_UNKNOWN;
        }
        if (internalAccessType.equals(IAccessGroup.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_ACCESS_GROUP;
        }
        if (internalAccessType.equals(IProjectArea.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_PROJECT_AREA;
        }
        if (internalAccessType.equals(ITeamArea.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_TEAM_AREA;
        }
        if (internalAccessType.equals(IComponent.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_COMPONENT_SCOPED;
        }
        if (internalAccessType.equals(IContributor.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_CONTRIBUTOR;
        }
        return internalAccessType;
    }

    private void printFiles(Collection paths, IndentingPrintStream out, String repoUri, IScmClientConfiguration config, VersionMode vMode) throws FileSystemException {
        boolean showVersionId;
        boolean bl = showVersionId = vMode == VersionMode.LONG_VERSION || vMode == VersionMode.SHORT_VERSION;
        if (config.isJSONEnabled()) {
            JSONObject jResult = new JSONObject();
            JSONArray array = new JSONArray();
            array.addAll(paths);
            jResult.put((Object)"remote-files", (Object)array);
            config.getOutputStream().print((CharSequence)jResult.toString());
            return;
        }
        for (Object obj : paths) {
            JSONObject jPath = (JSONObject)obj;
            String versionId = null;
            JSONObject version = (JSONObject)jPath.get((Object)"version");
            if (version != null) {
                switch (vMode) {
                    case LONG_VERSION: {
                        versionId = JSONPrintUtil.jsonizeGetLongVersionId((JSONObject)version);
                        break;
                    }
                    case SHORT_VERSION: {
                        versionId = JSONPrintUtil.jsonizeGetShortVersionId((JSONObject)version);
                    }
                }
            }
            JSONObject access = (JSONObject)jPath.get((Object)"jazz.read-access");
            String output = null;
            output = config.getAliasConfig().showUuid() ? (showVersionId && versionId != null ? NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_UUID_VERSION_ID, (Object[])new String[]{(String)jPath.get((Object)READ_ACCESS_UUID), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"path"), versionId}) : NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT, (Object[])new String[]{(String)jPath.get((Object)READ_ACCESS_UUID), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"path")})) : (showVersionId && versionId != null ? NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_VERSION_ID, (Object[])new String[]{(String)jPath.get((Object)"path"), versionId}) : (String)jPath.get((Object)"path"));
            if (access != null) {
                String printableAccessType = this.getPrintableAccessType((String)access.get((Object)READ_ACCESS_TYPE));
                output = String.valueOf(output) + ' ';
                if (access.get((Object)READ_ACCESS_NAME) != null) {
                    output = config.getAliasConfig().showUuid() && access.get((Object)READ_ACCESS_UUID) != null ? String.valueOf(output) + NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_ACCESS_UUID, (Object[])new Object[]{printableAccessType, access.get((Object)READ_ACCESS_UUID), access.get((Object)READ_ACCESS_NAME)}) : String.valueOf(output) + NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_ACCESS, (Object)printableAccessType, (Object)access.get((Object)READ_ACCESS_NAME));
                }
            }
            out.println((CharSequence)output);
        }
    }

    private IScmRichClientRestService.ParmsGetVersionableChildren createVersionableChildrenParms(IItemHandle contextItem, String componentId, List<Map.Entry<String, IVersionableHandle>> batch) {
        IScmRichClientRestService.ParmsGetVersionableChildren parmsVerChild = new IScmRichClientRestService.ParmsGetVersionableChildren();
        parmsVerChild.contextItemId = contextItem.getItemId().getUuidValue();
        parmsVerChild.contextItemType = contextItem.getItemType().getName();
        parmsVerChild.contextItemNamespace = contextItem.getItemType().getNamespaceURI();
        parmsVerChild.componentItemId = componentId;
        parmsVerChild.versionableItemIds = new String[batch.size()];
        parmsVerChild.versionableItemTypes = new String[batch.size()];
        parmsVerChild.versionableItemNamespaces = new String[batch.size()];
        int idx = 0;
        for (Map.Entry<String, IVersionableHandle> entry : batch) {
            parmsVerChild.versionableItemIds[idx] = entry.getValue().getItemId().getUuidValue();
            parmsVerChild.versionableItemTypes[idx] = entry.getValue().getItemType().getName();
            parmsVerChild.versionableItemNamespaces[idx] = entry.getValue().getItemType().getNamespaceURI();
            ++idx;
        }
        return parmsVerChild;
    }

    private int calculateDepth(String path) {
        int depth = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                ++depth;
            }
            ++i;
        }
        return depth;
    }

    private void jsonizeFiles(String path, JSONObject root, IItemHandle contextItem, String compId, IVersionableHandle versionable, int maxDepth, ITeamRepository repo, IScmClientConfiguration config, VersionMode vMode) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IndentingPrintStream out = config.getWrappedOutputStream();
        boolean showAccess = config.getSubcommandCommandLine().hasOption((IOptionKey)ListRemoteFilesOptions.OPT_SHOW_ACCESS);
        int initialDepth = this.calculateDepth(path);
        TreeMap<String, IVersionableHandle> pathQueue = new TreeMap<String, IVersionableHandle>(PATH_COMPARATOR);
        TreeMap<String, JSONObject> results = new TreeMap<String, JSONObject>(PATH_COMPARATOR);
        results.put(path, root);
        pathQueue.put(path, versionable);
        while (!pathQueue.isEmpty()) {
            SortedMap toPrint;
            if (!config.isJSONEnabled() && !(toPrint = results.headMap(pathQueue.firstKey())).isEmpty()) {
                this.printFiles(toPrint.values(), out, repo.getRepositoryURI(), config, vMode);
                toPrint.clear();
            }
            int batchSize = pathQueue.size() > 50 ? 50 : pathQueue.size();
            ArrayList<Map.Entry<String, IVersionableHandle>> batch = new ArrayList<Map.Entry<String, IVersionableHandle>>(batchSize);
            while (batch.size() < batchSize) {
                batch.add(pathQueue.pollFirstEntry());
            }
            ScmFolderEntryReportList folderReportList = null;
            try {
                IScmRichClientRestService.ParmsGetVersionableChildren parms = this.createVersionableChildrenParms(contextItem, compId, batch);
                folderReportList = scmService.postGetVersionableChildren(parms);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListRemoteFilesCmd_FAILED_TO_GET_VER_CHILDREN, (Object)path));
            }
            Map<Object, Object> versionablePermissions = Collections.emptyMap();
            if (showAccess) {
                versionablePermissions = this.fetchVersionablePermissions(scmService, compId, folderReportList, repo, config);
            }
            Map<Object, Object> versionIds = Collections.emptyMap();
            if (!VersionMode.HIDE.equals((Object)vMode)) {
                versionIds = this.fetchVersionIdentifiers(scmService, folderReportList, repo, config);
            }
            int batchIdx = 0;
            for (ScmFolderEntryReport childReport : folderReportList.getFolderEntryReports()) {
                Map.Entry parentEntry = (Map.Entry)batch.get(batchIdx++);
                for (Map.Entry entry : childReport.getEntries().entrySet()) {
                    ScmVersionableIdentifier vid;
                    IVersionableHandle verHandle = (IVersionableHandle)entry.getValue();
                    String childRemotePath = this.appendPathSegment((String)parentEntry.getKey(), (String)entry.getKey(), verHandle instanceof IFolderHandle);
                    JSONObject jPath = new JSONObject();
                    results.put(childRemotePath, jPath);
                    jPath.put((Object)"path", (Object)childRemotePath);
                    jPath.put((Object)READ_ACCESS_UUID, (Object)verHandle.getItemId().getUuidValue());
                    jPath.put((Object)"state-id", (Object)verHandle.getStateId().getUuidValue());
                    JSONObject permissions = (JSONObject)versionablePermissions.get(verHandle.getItemId().getUuidValue());
                    if (permissions != null) {
                        jPath.put((Object)"jazz.read-access", (Object)permissions);
                    }
                    if ((vid = (ScmVersionableIdentifier)versionIds.get(verHandle.getStateId().getUuidValue())) != null) {
                        jPath.put((Object)"version", (Object)JSONPrintUtil.jsonizeVersionId((ScmVersionableIdentifier)vid));
                    }
                    int currDepth = this.calculateDepth(childRemotePath) - initialDepth;
                    if (!(verHandle instanceof IFolderHandle) || maxDepth != -1 && currDepth >= maxDepth) continue;
                    pathQueue.put(childRemotePath, verHandle);
                }
            }
        }
        JSONArray jArray = null;
        if (config.isJSONEnabled()) {
            jArray = new JSONArray(results.size());
            jArray.addAll(results.values());
        }
        this.printFiles((Collection)(jArray != null ? jArray : results.values()), out, repo.getRepositoryURI(), config, vMode);
    }

    private Map<String, ScmVersionableIdentifier> fetchVersionIdentifiers(IScmRichClientRestService scmService, ScmFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> versionableStates = new ArrayList<String>(2048);
        for (ScmFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            for (IVersionableHandle versionable : folderEntry.getEntries().values()) {
                if (versionable instanceof IFolderHandle) continue;
                versionableStates.add(versionable.getStateId().getUuidValue());
            }
        }
        return this.fetchVersionIdentifiers(scmService, versionableStates, repo, config);
    }

    private Map<String, ScmVersionableIdentifier> fetchVersionIdentifiers(IScmRichClientRestService scmService, List<String> versionableStates, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService.ParmsGetVersionableIdentifiers parms = new IScmRichClientRestService.ParmsGetVersionableIdentifiers();
        HashMap<String, ScmVersionableIdentifier> results = new HashMap<String, ScmVersionableIdentifier>();
        int batchStart = 0;
        int batchSize = versionableStates.size() > 2048 ? 2048 : versionableStates.size();
        while (batchStart < versionableStates.size()) {
            parms.versionableStateIds = versionableStates.subList(batchStart, batchStart + batchSize).toArray(new String[batchSize]);
            ScmVersionableIdentifierList versionIdentifiers = null;
            try {
                versionIdentifiers = scmService.postGetVersionableIdentifiers(parms);
                for (ScmVersionableIdentifier identifier : versionIdentifiers.getVersionableIdentifiers()) {
                    results.put(identifier.getStateId(), identifier);
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)com.ibm.team.filesystem.cli.core.internal.Messages.RepoUtil_CANNOT_DETERMINE_VERSION_IDS, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            int n = batchSize = (batchStart += batchSize) + 2048 > versionableStates.size() ? versionableStates.size() - batchStart : 2048;
        }
        return results;
    }

    private Map<String, JSONObject> fetchVersionablePermissions(IScmRichClientRestService scmService, String componentId, ScmFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>(2048);
        for (ScmFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            Map entries = folderEntry.getEntries();
            versionables.addAll(entries.values());
        }
        return this.fetchVersionablePermissions(scmService, componentId, versionables, repo, config);
    }

    private Map<String, JSONObject> fetchVersionablePermissions(IScmRichClientRestService scmService, String componentId, List<IVersionableHandle> versionables, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService.ParmsGetVersionablePermissions parms = new IScmRichClientRestService.ParmsGetVersionablePermissions();
        parms.componentId = componentId;
        HashMap<String, JSONObject> results = new HashMap<String, JSONObject>();
        int batchStart = 0;
        int batchSize = versionables.size() > 50 ? 50 : versionables.size();
        while (batchStart < versionables.size()) {
            parms.versionableItemId = new String[batchSize];
            parms.versionableItemType = new String[batchSize];
            parms.versionableItemTypeNamespace = new String[batchSize];
            int idx = 0;
            for (IVersionableHandle handle : versionables.subList(batchStart, batchStart + batchSize)) {
                parms.versionableItemId[idx] = handle.getItemId().getUuidValue();
                parms.versionableItemType[idx] = handle.getItemType().getName();
                parms.versionableItemTypeNamespace[idx] = handle.getItemType().getNamespaceURI();
                ++idx;
            }
            try {
                ScmVersionablePermissionsResult result = scmService.postGetVersionablePermissions(parms);
                for (ScmVersionablePermissionsReport report : result.getReports()) {
                    JSONObject access = null;
                    if (Boolean.valueOf(report.getIsReportOfInaccessible()).booleanValue()) {
                        access = new JSONObject();
                        access.put((Object)READ_ACCESS_TYPE, (Object)Messages.Common_UNKNOWN);
                    } else {
                        access = this.getReadAccess(report.getReadContext(), repo, config);
                    }
                    if (access == null) continue;
                    for (String item : report.getItems()) {
                        results.put(item, access);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"error", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            int n = batchSize = (batchStart += batchSize) + 50 > versionables.size() ? versionables.size() - batchStart : 50;
        }
        return results;
    }

    private JSONObject getReadAccess(ScmHandle readContext, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        if (readContext == null) {
            return null;
        }
        String name = this.readContextCache.get(readContext.getItemId());
        if (name == null) {
            IItemType itemType = IItemType.IRegistry.INSTANCE.getItemType(readContext.getItemType(), readContext.getItemNamespace());
            IAuditableHandle handle = (IAuditableHandle)itemType.createItemHandle(UUID.valueOf((String)readContext.getItemId()), null);
            name = RepoUtil.getReadAccessContextName((IAuditableHandle)handle, (ITeamRepository)repo, (IScmClientConfiguration)config);
            this.readContextCache.put(readContext.getItemId(), name);
        }
        JSONObject access = new JSONObject();
        access.put((Object)READ_ACCESS_TYPE, (Object)readContext.getItemType());
        access.put((Object)READ_ACCESS_UUID, (Object)readContext.getItemId());
        access.put((Object)READ_ACCESS_NAME, (Object)name);
        return access;
    }

    private String toPath(String[] path, boolean isFolder) {
        return String.valueOf(StringUtil.createPathString((String[])path)) + (isFolder ? Character.valueOf('/') : "");
    }

    private String appendPathSegment(String parent, String child, boolean isFolder) {
        StringBuilder builder = new StringBuilder(parent);
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append(child);
        if (isFolder) {
            builder.append('/');
        }
        return builder.toString();
    }

    static enum Mode {
        WORKSPACE,
        SNAPSHOT,
        BASELINE;

    }

    static enum VersionMode {
        HIDE,
        SHORT_VERSION,
        LONG_VERSION;

    }
}

