/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.workitem.common.model.IDeliverable;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListReleaseCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_SNAPSHOT = new PositionalOptionDefinition("snapshot", 1, 1, "@");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IPositionalOptionDefinition)OPT_SNAPSHOT, Messages.ListReleaseCmd_SNAPSHOT_OPTION_DESCRIPTION);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT, null), (IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
        IBaselineSet ss = RepoUtil.getSnapshot(null, (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        JSONObject jSs = new JSONObject();
        jSs.put((Object)"name", (Object)ss.getName());
        jSs.put((Object)"uuid", (Object)ss.getItemId().getUuidValue());
        jSs.put((Object)"url", (Object)repo.getRepositoryURI());
        JSONArray jRel = ListReleaseCmd.getReleases(ss, repo, this.config);
        jSs.put((Object)"release", (Object)jRel);
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jSs.toString());
        } else {
            ListReleaseCmd.printProperties(jSs, this.config);
        }
    }

    private static JSONArray getReleases(IBaselineSet ss, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        List fetched = RepoUtil.getBaselineSetReleases((IBaselineSet)ss, (ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONArray array = new JSONArray();
        for (IDeliverable iteration : fetched) {
            if (iteration == null) continue;
            JSONObject properties = new JSONObject();
            properties.put((Object)"uuid", (Object)iteration.getItemId().getUuidValue());
            properties.put((Object)"name", (Object)iteration.getName());
            properties.put((Object)"archived", (Object)iteration.isArchived());
            array.add((Object)properties);
        }
        if (array.size() > 0) {
            return array;
        }
        return null;
    }

    private static void printProperties(JSONObject jSs, IScmClientConfiguration config) throws FileSystemException {
        JSONArray jRelease;
        IndentingPrintStream out = config.getWrappedOutputStream();
        String itemId = (String)jSs.get((Object)"uuid");
        String repoUri = (String)jSs.get((Object)"url");
        String name = (String)jSs.get((Object)"name");
        if (name != null) {
            name = AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            out.println((CharSequence)NLS.bind((String)Messages.WorkspacePropertiesCmd_NAME, (Object)name));
        }
        if ((jRelease = (JSONArray)jSs.get((Object)"release")) != null) {
            out.println((CharSequence)Messages.SnapshotPropertiesCmd_RELEASES);
            for (Object entry : jRelease) {
                JSONObject prop = (JSONObject)entry;
                String release = (String)prop.get((Object)"name");
                Boolean archived = (Boolean)prop.get((Object)"archived");
                String output = release;
                if (archived.booleanValue()) {
                    output = String.valueOf(output) + Messages.ListReleaseCmd_ARCHIVED_DECORATOR_LABEL;
                }
                out.indent().println((CharSequence)output);
            }
        }
    }
}

