/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListQueryItemsOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IQueryItem;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryResult;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmQueryItem;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListQueryItemsCmd
extends AbstractSubcommand {
    public static int DEFAULT_MAX_RESULT_SIZE = 25;

    public void run() throws FileSystemException {
        String nameFilter;
        ITeamRepository repository;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption(ListQueryItemsOptions.OPT_PROJECTAREA) && cli.hasOption(ListQueryItemsOptions.OPT_CONTRIB)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption(ListQueryItemsOptions.OPT_PROJECTAREA).getName(), (Object)cli.getDefinition().getOption(ListQueryItemsOptions.OPT_CONTRIB).getName()));
        }
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListQueryItemsOptions.OPT_SELECTOR, null), (IScmClientConfiguration)this.config);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (selector == null) {
            repository = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
            nameFilter = null;
        } else {
            repository = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
            nameFilter = selector.getItemSelector();
        }
        IAuditableHandle ownerFilter = this.getOwnerFilter(cli, repository);
        List<ScmQueryItem> queryItems = this.fetchQueryItems(repository, nameFilter, ownerFilter);
        this.printQueryItems(repository, queryItems);
    }

    private void printQueryItems(ITeamRepository repository, List<ScmQueryItem> queryItems) {
        boolean isJsonEnabled = this.config.isJSONEnabled();
        IndentingPrintStream printStream = this.config.getWrappedOutputStream();
        if (queryItems.isEmpty() && !isJsonEnabled) {
            printStream.println((CharSequence)Messages.ListQueryItemsCmd_1);
            return;
        }
        JSONArray jQueryItems = this.jsonizeQueryItems(queryItems, repository);
        this.printQueryItemJson(jQueryItems);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (!isJsonEnabled && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && queryItems.size() >= DEFAULT_MAX_RESULT_SIZE) {
            printStream.println((CharSequence)NLS.bind((String)Messages.ListQueryItemsCmd_2, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private JSONArray jsonizeQueryItems(List<ScmQueryItem> queryItems, ITeamRepository repository) {
        JSONArray jQueryItems = new JSONArray();
        queryItems = this.sortQueryItems(queryItems);
        for (ScmQueryItem queryItem : queryItems) {
            JSONObject json = this.jsonizeQueryItem(queryItem, repository);
            jQueryItems.add((Object)json);
        }
        return jQueryItems;
    }

    private List<ScmQueryItem> sortQueryItems(List<ScmQueryItem> queryItems) {
        ArrayList<ScmQueryItem> sortedCompList = new ArrayList<ScmQueryItem>(queryItems);
        Collections.sort(sortedCompList, new Comparator<ScmQueryItem>(){

            @Override
            public int compare(ScmQueryItem o1, ScmQueryItem o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return sortedCompList;
    }

    private JSONObject jsonizeQueryItem(ScmQueryItem queryItem, ITeamRepository repository) {
        JSONObject json = JSONPrintUtil.jsonize((String)queryItem.getName(), (String)queryItem.getItemId(), (String)repository.getRepositoryURI());
        String resultType = queryItem.getResultType();
        String jsonResultType = resultType.equals(this.getResultType(IWorkspace.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_3 : (resultType.equals(this.getResultType(IComponent.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_4 : (resultType.equals(this.getResultType(IBaselineSet.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_5 : (resultType.equals(this.getResultType(IBaseline.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_6 : (resultType.equals(this.getResultType(IQueryItem.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_7 : (resultType.equals(this.getResultType(IChangeSet.ITEM_TYPE)) ? Messages.ListQueryItemsCmd_8 : Messages.ListQueryItemsCmd_9)))));
        json.put((Object)"result-type", (Object)jsonResultType);
        return json;
    }

    private String getResultType(IItemType itemType) {
        return String.valueOf(itemType.getNamespaceURI()) + "." + itemType.getName();
    }

    private void printQueryItemJson(JSONArray jQueryItems) {
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.config.isJSONEnabled()) {
            JSONObject root = new JSONObject();
            root.put((Object)"query-items", (Object)jQueryItems);
            this.config.getOutputStream().print((CharSequence)root.toString());
            return;
        }
        for (Object obj : jQueryItems) {
            JSONObject queryItem = (JSONObject)obj;
            String selector = AliasUtil.selector((String)((String)queryItem.get((Object)"name")), (UUID)UUID.valueOf((String)((String)queryItem.get((Object)"uuid"))), (String)((String)queryItem.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.QUERY_ITEM);
            out.println((CharSequence)NLS.bind((String)Messages.ListQueryItemsCmd_10, (Object)selector, (Object)queryItem.get((Object)"result-type")));
        }
    }

    private List<ScmQueryItem> fetchQueryItems(ITeamRepository repository, String nameFilter, IAuditableHandle ownerFilter) throws FileSystemException {
        int maxResults = this.getMaximumResultSize();
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repository).getServiceInterface(IScmRichClientRestService.class);
        int toFetch = maxResults;
        ArrayList<String> criteria = new ArrayList<String>();
        if (nameFilter != null && nameFilter.length() > 0) {
            criteria.add("Name:partial ignorecase\n" + nameFilter);
        }
        if (ownerFilter != null) {
            String type = ownerFilter instanceof IContributorHandle ? "contributor" : "projectarea";
            criteria.add("Owner:" + type + "\n" + ownerFilter.getItemId().getUuidValue());
        }
        IScmRichClientRestService.ParmsRunQuery queryParms = new IScmRichClientRestService.ParmsRunQuery();
        queryParms.resultType = String.valueOf(IQueryItem.ITEM_TYPE.getNamespaceURI()) + '.' + IQueryItem.ITEM_TYPE.getName();
        queryParms.criteria = criteria.toArray(new String[criteria.size()]);
        ArrayList<ScmQueryItem> result = new ArrayList<ScmQueryItem>();
        try {
            boolean hasMore = true;
            while (hasMore) {
                queryParms.maxResultSize = toFetch;
                ScmItemQueryResult dto = scmService.postRunQuery(queryParms);
                for (Object element : dto.getItems()) {
                    if (!(element instanceof ScmQueryItem)) continue;
                    ScmQueryItem queryItem = (ScmQueryItem)element;
                    result.add(queryItem);
                }
                if (dto.getNextPage() == null || result.size() >= maxResults) {
                    hasMore = false;
                    continue;
                }
                queryParms.pageTimestamp = dto.getNextPage().getLastTimestamp().getTime();
                toFetch = maxResults - result.size();
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListQueryItemsCmd_0, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repository.getRepositoryURI());
        }
        return result;
    }

    private int getMaximumResultSize() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int maxResults = cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) ? Integer.MAX_VALUE : RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)DEFAULT_MAX_RESULT_SIZE);
        return maxResults;
    }

    private IAuditableHandle getOwnerFilter(ICommandLine cli, ITeamRepository repository) throws FileSystemException {
        String projectAreaSelector = cli.getOption(ListQueryItemsOptions.OPT_PROJECTAREA, null);
        String contribName = cli.getOption(ListQueryItemsOptions.OPT_CONTRIB, null);
        IProjectArea projectArea = null;
        if (projectAreaSelector != null && projectAreaSelector.length() != 0) {
            projectArea = RepoUtil.getProjectArea((ITeamRepository)repository, (String)projectAreaSelector, (IScmClientConfiguration)this.config);
            if (projectArea == null) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projectAreaSelector), null);
            }
            return projectArea;
        }
        if (contribName != null && contribName.length() > 0) {
            IContributor contributor = RepoUtil.fetchContributor((String)contribName, (ITeamRepository)repository, (IScmClientConfiguration)this.config);
            if (contributor == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contribName, (Object)repository.getRepositoryURI()));
            }
            return contributor;
        }
        return null;
    }
}

