/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.PortsUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsIndexedPageDescriptor;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListPortsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_COMPONENT_SELECTOR = new PositionalOptionDefinition("component", 1, 1);
    public static final NamedOptionDefinition OPT_CURRENT = new NamedOptionDefinition("c", "current", 0);
    public static final NamedOptionDefinition OPT_UNRESOLVED = new NamedOptionDefinition("U", "unresolved", 0);
    public static final NamedOptionDefinition OPT_WIDE = new NamedOptionDefinition("W", "wide", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)OPT_WIDE, CommonOptions.OPT_WIDE_HELP).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10)).addOption((INamedOptionDefinition)OPT_CURRENT, NLS.bind((String)Messages.ListPortsCmdOption_Current, (Object)OPT_UNRESOLVED.getName())).addOption((INamedOptionDefinition)OPT_UNRESOLVED, Messages.ListPortsCmdOption_Unresolved).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.PortCmdOption_WORKSPACE).addOption((IPositionalOptionDefinition)OPT_COMPONENT_SELECTOR, Messages.ListPortsCmd_Component);
        return options;
    }

    public void run() throws FileSystemException {
        ParmsIndexedPageDescriptor parmsPageDescriptor;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ParmsWorkspace targetWs = new ParmsWorkspace();
        ITeamRepository repo = null;
        if (wsSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.PortCmdOption_AmbiguousWorkspace, (Object)cli.getDefinition().getOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId()).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        IComponent comp = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        if (comp == null) {
            throw StatusHelper.argSyntax((String)Messages.Common_UNIQUE_LOADED_COMP);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        options.enablePrinter(22);
        if (cli.hasOption((IOptionKey)OPT_CURRENT)) {
            options.enablePrinter(29);
        }
        options.enablePrinter(30);
        options.enablePrinter(32);
        if (cli.hasOption((IOptionKey)OPT_UNRESOLVED)) {
            options.enablePrinter(33);
        }
        if ((parmsPageDescriptor = PortsUtil.printPorts((ParmsWorkspace)targetWs, (String)comp.getItemId().getUuidValue(), (int)RepoUtil.getMaxResultsOption((ICommandLine)cli), (IFilesystemRestClient)client, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, (IScmClientConfiguration)this.config)) != null && parmsPageDescriptor.hasNextPage() && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && !this.config.isJSONEnabled()) {
            out.println((CharSequence)NLS.bind((String)Messages.ListPortsCmd_MORE_ITEMS_AVAILABLE, (Object)parmsPageDescriptor.totalSize, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_MAXRESULTS).getName()));
        }
    }
}

