/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSet;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmGapFillingChangeSetsReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmGapFillingChangeSetsReportList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ListMissingChangeSetsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_FILE_ONLY = new OptionKey("summarize-changes");
    public static final PositionalOptionDefinition OPT_SELECTORS = new PositionalOptionDefinition("selectors", 1, -1, "@");
    public static final IOptionKey OPT_WORKSPACE = new OptionKey("workspace");

    public static ChangeSetSyncDTO[] getOriginalChangeSets(IScmRichClientRestService scmService, IScmRichClientRestService.ParmsFillGapChangeSets parms, String repoUri, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        return RepoUtil.findChangeSets(Arrays.asList(parms.changeSetItemIds), (boolean)true, (String)parms.workspaceItemId, (String)"workspace", (String)repoUri, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
    }

    public static ChangeSetSyncDTO[] getChangeSets(IScmRichClientRestService scmService, IScmRichClientRestService.ParmsFillGapChangeSets parms, Set<String> originalChangeSetsUUIDs, List<String> csIds, String repoUri, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ScmGapFillingChangeSetsReportList reports = null;
        try {
            reports = scmService.postGetChangeSetsFillingGap(parms);
        }
        catch (TeamRepositoryException e) {
            if (e instanceof ChangeSetAlreadyInHistoryException) {
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)e.getData();
                String message = NLS.bind((String)Messages.ListMissingChangeSets_CHANGE_SETS_ALREADY_IN_HISTORY, (Object)AliasUtil.alias((UUID)changeSetHandle.getItemId(), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET), (Object[])new Object[0]);
                ChangeSetAlreadyInHistoryException exception = new ChangeSetAlreadyInHistoryException(message);
                exception.setData((Object)changeSetHandle);
                throw StatusHelper.wrap((String)Messages.ListMissingChangeSets_UNABLE_TO_RETRIEVE_FILLING_CHANGE_SETS, (TeamRepositoryException)exception, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repoUri);
            }
            throw StatusHelper.wrap((String)Messages.ListMissingChangeSets_UNABLE_TO_RETRIEVE_FILLING_CHANGE_SETS, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repoUri);
        }
        List reports2 = reports.getReports();
        for (ScmGapFillingChangeSetsReport report : reports2) {
            List changeSets = report.getChanges().getChangeSets();
            for (ScmChangeSet changeSet : changeSets) {
                String itemId = changeSet.getItemId();
                if (originalChangeSetsUUIDs.contains(itemId)) continue;
                csIds.add(itemId);
            }
        }
        ChangeSetSyncDTO[] csDTOs = RepoUtil.findChangeSets(csIds, (boolean)true, (String)parms.workspaceItemId, (String)"workspace", (String)repoUri, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        HashMap<String, ChangeSetSyncDTO> allDtos = new HashMap<String, ChangeSetSyncDTO>(csDTOs.length);
        int index = 0;
        boolean needSorting = false;
        ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOs;
        int n = csDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO dto = changeSetSyncDTOArray[n2];
            String changeSetItemId = dto.getChangeSetItemId();
            if (!changeSetItemId.equals(csIds.get(index))) {
                needSorting = true;
            }
            ++index;
            allDtos.put(changeSetItemId, dto);
            ++n2;
        }
        if (needSorting) {
            index = 0;
            for (String changeSetItemId : csIds) {
                csDTOs[index] = (ChangeSetSyncDTO)allDtos.get(changeSetItemId);
                ++index;
            }
        }
        return csDTOs;
    }

    private static JSONObject getFileInfosFromChangeSets(ChangeSetSyncDTO[] changeSets, ChangeSetSyncDTO[] originalChangeSets) {
        HashSet<String> originalPaths = new HashSet<String>();
        ChangeSetSyncDTO[] changeSetSyncDTOArray = originalChangeSets;
        int n = originalChangeSets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO dto = changeSetSyncDTOArray[n2];
            List changes = dto.getChanges();
            for (ChangeFolderSyncDTO dto2 : changes) {
                List changes2 = dto2.getChanges();
                for (ChangeSyncDTO dto3 : changes2) {
                    originalPaths.add(ListMissingChangeSetsCmd.standardizeDisplayPath(dto3.getPathHint(), dto3.getVersionableItemType().equals("folder")));
                }
            }
            ++n2;
        }
        HashMap<String, JSONObject> infos = new HashMap<String, JSONObject>();
        ChangeSetSyncDTO[] changeSetSyncDTOArray2 = changeSets;
        int n3 = changeSets.length;
        n = 0;
        while (n < n3) {
            ChangeSetSyncDTO dto = changeSetSyncDTOArray2[n];
            List changes = dto.getChanges();
            for (ChangeFolderSyncDTO dto2 : changes) {
                List changes2 = dto2.getChanges();
                for (ChangeSyncDTO dto3 : changes2) {
                    String path = ListMissingChangeSetsCmd.standardizeDisplayPath(dto3.getPathHint(), dto3.getVersionableItemType().equals("folder"));
                    if (originalPaths.contains(path)) continue;
                    JSONObject fileInfo = (JSONObject)infos.get(path);
                    if (fileInfo == null) {
                        fileInfo = ListMissingChangeSetsCmd.newFileInfo(path, dto3.getVersionableItemId());
                        infos.put(path, fileInfo);
                    }
                    ListMissingChangeSetsCmd.addChangeSetId(fileInfo, dto.getChangeSetItemId());
                }
            }
            ++n;
        }
        JSONArray result = new JSONArray();
        result.addAll(infos.values());
        JSONObject files = new JSONObject();
        files.put((Object)"files", (Object)result);
        return files;
    }

    private static void addChangeSetId(JSONObject fileInfo, String changesetId) {
        ((JSONArray)fileInfo.get((Object)"ids")).add((Object)changesetId);
    }

    private static JSONObject newFileInfo(String fullPath, String fileItemId) {
        JSONObject fileInfo = new JSONObject();
        fileInfo.put((Object)"id", (Object)fileItemId);
        fileInfo.put((Object)"path", (Object)fullPath);
        fileInfo.put((Object)"ids", (Object)new JSONArray());
        return fileInfo;
    }

    private static String standardizeDisplayPath(String path, boolean isFolder) {
        Path newpath = new Path(path);
        if (!newpath.isAbsolute()) {
            newpath = new Path(File.separator).append((IPath)newpath);
        }
        if (isFolder && !newpath.hasTrailingSeparator()) {
            newpath = newpath.addTrailingSeparator();
        }
        path = newpath.toOSString();
        return path;
    }

    private ITeamRepository generateParms(IScmRichClientRestService.ParmsFillGapChangeSets parms, ICommandLine cli, IFilesystemRestClient client, IScmClientConfiguration config, Set<String> originalChangeSetsIds) throws FileSystemException {
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)config);
        ParmsWorkspace ws = null;
        ITeamRepository repo = null;
        if (wsSelector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, null);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        parms.workspaceItemId = ws.workspaceItemId;
        List argSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SELECTORS), (IScmClientConfiguration)config);
        List selectors = RepoUtil.getSelectors((List)argSelectors);
        SubcommandUtil.validateArgument((List)argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, (List)argSelectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
        for (String selector : selectors) {
            IUuidAliasRegistry.IUuidAlias uuid = RepoUtil.lookupUuidAndAlias((String)selector);
            String uuid2 = uuid.getUuid().getUuidValue();
            originalChangeSetsIds.add(uuid2);
        }
        parms.changeSetItemIds = originalChangeSetsIds.toArray(new String[selectors.size()]);
        return repo;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListMissingChangeSetsCmd_VERBOSE_HELP).addOption((IOptionGroup)new ContinuousGroup().addOption(OPT_WORKSPACE, "w", "workspace", Messages.ListMissingChangeSetsCmd_Option_WORKSPACE, 1, false).addOption(OPT_FILE_ONLY, "s", "summarize-changes", Messages.ListMissingChangeSetsCmd_SHOW_FILES_ONLY_OUTPUT, 0, false)).addOption((IPositionalOptionDefinition)OPT_SELECTORS, Messages.ListMissingChangeSetsCmd_OPT_SELECTOR_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        IScmRichClientRestService.ParmsFillGapChangeSets parms = new IScmRichClientRestService.ParmsFillGapChangeSets();
        HashSet<String> originalChangeSetsIds = new HashSet<String>();
        ITeamRepository repo = this.generateParms(parms, cli, client, this.config, originalChangeSetsIds);
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        ArrayList<String> csIds = new ArrayList<String>();
        String repositoryURI = repo.getRepositoryURI();
        ChangeSetSyncDTO[] changeSets = ListMissingChangeSetsCmd.getChangeSets(scmService, parms, originalChangeSetsIds, csIds, repositoryURI, client, this.config);
        if (changeSets == null) {
            return;
        }
        if (csIds.size() == 0 && !this.config.isJSONEnabled()) {
            out.println((CharSequence)Messages.ListMissingChangeSetsCmd_NO_CS_FOUND);
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            options.enablePrinter(6);
            options.enablePrinter(14);
            options.enablePrinter(26);
        }
        if (!cli.hasOption(OPT_FILE_ONLY)) {
            if (!this.config.isJSONEnabled()) {
                out.println((CharSequence)Messages.ListMissingChangeSetsCmd_FillingChangesets);
            }
            Arrays.sort(changeSets, new Comparator<ChangeSetSyncDTO>(){

                @Override
                public int compare(ChangeSetSyncDTO dto1, ChangeSetSyncDTO dto2) {
                    return dto1.getComponentItemId().compareTo(dto2.getComponentItemId());
                }
            });
            PendingChangesUtil.printChangeSets(null, Arrays.asList(changeSets), (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        } else {
            ChangeSetSyncDTO[] originalChangeSets = ListMissingChangeSetsCmd.getOriginalChangeSets(scmService, parms, repositoryURI, client, this.config);
            JSONObject fileInfo = ListMissingChangeSetsCmd.getFileInfosFromChangeSets(changeSets, originalChangeSets);
            JSONArray fileInfos = (JSONArray)fileInfo.get((Object)"files");
            if (fileInfos.size() == 0) {
                if (!this.config.isJSONEnabled()) {
                    out.println((CharSequence)Messages.ListMissingChangeSetsCmd_NoOtherModifiedFiles);
                } else {
                    this.config.getOutputStream().println((CharSequence)fileInfo.toString());
                }
            } else if (this.config.isJSONEnabled()) {
                this.config.getOutputStream().println((CharSequence)fileInfo.toString());
            } else {
                out.println((CharSequence)Messages.ListMissingChangeSetsCmd_ModifiedFiles);
                int i = 0;
                int max = fileInfos.size();
                while (i < max) {
                    JSONObject info = (JSONObject)fileInfos.get(i);
                    StringBuilder builder = new StringBuilder();
                    builder.append(AliasUtil.alias((String)((String)info.get((Object)"id")), (String)repositoryURI, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE)).append(' ').append(info.get((Object)"path")).append("  (").append(Messages.ListMissingChangeSetsCmd_ChangeSetsHeader);
                    JSONArray allChangeSetIds = (JSONArray)info.get((Object)"ids");
                    int index = 0;
                    int max2 = allChangeSetIds.size();
                    while (index < max2) {
                        if (index > 0) {
                            builder.append(' ');
                        }
                        String changeSetId = (String)allChangeSetIds.get(index);
                        builder.append(AliasUtil.aliasNoParen((AliasUtil.IAliasOptions)((ScmClientConfiguration)CommandLineCore.getConfig()).getAliasConfig(), (UUID)UUID.valueOf((String)changeSetId), (String)repositoryURI, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET));
                        ++index;
                    }
                    builder.append(')');
                    out.indent().println((CharSequence)builder.toString());
                    ++i;
                }
            }
        }
    }
}

