/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ListFlowTargetsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_SHOW_SCOPED_COMPONENTS = new NamedOptionDefinition("S", "show-scoped-components", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((INamedOptionDefinition)OPT_SHOW_SCOPED_COMPONENTS, Messages.ListFlowTargetsCmd_SHOW_SCOPED_COMPONENTS).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.ListFlowTargetsCmdOptions_WORKSPACE_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument srcSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)srcSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)srcSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)srcSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        JSONArray jFlowTargetArray = new JSONArray();
        List wsFlowList = wsDetails.getFlowEntries();
        for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
            JSONObject jFlowTarget = new JSONObject();
            ITeamRepository flowRepo = null;
            try {
                flowRepo = RepoUtil.getSharedRepository((String)wsFlow.getRepositoryURL(), (boolean)true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (flowRepo == null) {
                try {
                    flowRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(wsFlow.getRepositoryURL(), null, false, true, false));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            jFlowTarget.put((Object)"uuid", (Object)wsFlow.getWorkspaceItemId());
            jFlowTarget.put((Object)"url", (Object)wsFlow.getRepositoryURL());
            String flowName = wsFlow.getWorkspaceItemId();
            IWorkspace flowWs = null;
            if (flowRepo != null) {
                try {
                    flowWs = RepoUtil.getWorkspace((String)wsFlow.getWorkspaceItemId(), (boolean)true, (boolean)true, (ITeamRepository)flowRepo, (IScmClientConfiguration)this.config);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (flowWs != null) {
                flowName = flowWs.getName();
                jFlowTarget.put((Object)"type", (Object)(flowWs.isStream() ? RepoUtil.ItemType.STREAM.toString() : RepoUtil.ItemType.WORKSPACE.toString()));
                if (cli.hasOption((IOptionKey)OPT_SHOW_SCOPED_COMPONENTS)) {
                    JSONArray jCompArray = new JSONArray();
                    if (!wsFlow.getScopedComponentItemIds().isEmpty()) {
                        HashMap<String, String> compIdToName = new HashMap<String, String>();
                        WorkspaceDetailsDTO flowTargetDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId())), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
                        for (WorkspaceComponentDTO compDTO : flowTargetDetails.getComponents()) {
                            compIdToName.put(compDTO.getItemId(), compDTO.getName());
                        }
                        for (String compId : wsFlow.getScopedComponentItemIds()) {
                            JSONObject jComp = new JSONObject();
                            jComp.put((Object)"uuid", (Object)compId);
                            if (compIdToName.containsKey(compId)) {
                                jComp.put((Object)"name", compIdToName.get(compId));
                            } else {
                                jComp.put((Object)"name", (Object)compId);
                            }
                            jCompArray.add((Object)jComp);
                        }
                    }
                    jFlowTarget.put((Object)"components", (Object)jCompArray);
                }
            } else {
                jFlowTarget.put((Object)"type", (Object)RepoUtil.ItemType.UNKNOWN.toString());
            }
            jFlowTarget.put((Object)"name", (Object)flowName);
            jFlowTarget.put((Object)"incoming-flow", (Object)(wsFlow.isIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"outgoing-flow", (Object)(wsFlow.isOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"default-incoming", (Object)(wsFlow.isDefaultIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"default-outgoing", (Object)(wsFlow.isDefaultOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"current-incoming", (Object)(wsFlow.isCurrentIncomingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"current-outgoing", (Object)(wsFlow.isCurrentOutgoingFlow() ? Boolean.TRUE : Boolean.FALSE));
            jFlowTarget.put((Object)"scoped", (Object)(wsFlow.getScopedComponentItemIds().isEmpty() ? Boolean.FALSE : Boolean.TRUE));
            jFlowTargetArray.add((Object)jFlowTarget);
        }
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)jFlowTargetArray.toString());
            return;
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        for (Object obj : jFlowTargetArray) {
            JSONObject jFlowTarget = (JSONObject)obj;
            ListFlowTargetsCmd.printFlowTarget(jFlowTarget, out);
        }
        if (jFlowTargetArray.isEmpty()) {
            out.println((CharSequence)Messages.ListFlowTargetsCmd_NO_TARGETS);
        }
    }

    public static void printFlowTarget(JSONObject jFlowTarget, IndentingPrintStream out) {
        String name = (String)jFlowTarget.get((Object)"name");
        String itemId = (String)jFlowTarget.get((Object)"uuid");
        String repoUri = (String)jFlowTarget.get((Object)"url");
        RepoUtil.ItemType itemType = RepoUtil.ItemType.valueOf((String)((String)jFlowTarget.get((Object)"type")));
        StringBuilder flowInfo = new StringBuilder(AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)itemType));
        if (((Boolean)jFlowTarget.get((Object)"scoped")).booleanValue()) {
            flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_SCOPED);
        }
        boolean incomingFlow = (Boolean)jFlowTarget.get((Object)"incoming-flow");
        boolean outgoingFlow = (Boolean)jFlowTarget.get((Object)"outgoing-flow");
        if (incomingFlow && outgoingFlow) {
            flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_INCOMING_OUTGOING);
        } else {
            if (incomingFlow) {
                flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_INCOMING);
            }
            if (outgoingFlow) {
                flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_OUTGOING);
            }
        }
        boolean defaultIncomingFlow = (Boolean)jFlowTarget.get((Object)"default-incoming");
        boolean defaultOutgoingFlow = (Boolean)jFlowTarget.get((Object)"default-outgoing");
        if (defaultIncomingFlow && defaultOutgoingFlow) {
            flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_DEFAULT);
        } else {
            if (defaultIncomingFlow) {
                if (incomingFlow && !outgoingFlow) {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_DEFAULT);
                } else {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_DEFAULT_INCOMING);
                }
            }
            if (defaultOutgoingFlow) {
                if (outgoingFlow && !incomingFlow) {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_DEFAULT);
                } else {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_DEFAULT_OUTGOING);
                }
            }
        }
        boolean currentIncomingFlow = (Boolean)jFlowTarget.get((Object)"current-incoming");
        boolean currentOutgoingFlow = (Boolean)jFlowTarget.get((Object)"current-outgoing");
        if (currentIncomingFlow && currentOutgoingFlow) {
            flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_CURRENT);
        } else {
            if (currentIncomingFlow) {
                if (incomingFlow && !outgoingFlow) {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_CURRENT);
                } else {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_CURRENT_INCOMING);
                }
            }
            if (currentOutgoingFlow) {
                if (outgoingFlow && !incomingFlow) {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_CURRENT);
                } else {
                    flowInfo.append(" ").append(Messages.WorkspacePropertiesCmd_CURRENT_OUTGOING);
                }
            }
        }
        out.println((CharSequence)flowInfo.toString());
        JSONArray jCompArray = (JSONArray)jFlowTarget.get((Object)"components");
        if (jCompArray != null) {
            if (!jCompArray.isEmpty()) {
                out.println((CharSequence)Messages.FlowTargetCmd_FLOWS_TO_COMPONENTS);
                for (Object compObj : jCompArray) {
                    JSONObject jComp = (JSONObject)compObj;
                    name = (String)jComp.get((Object)"name");
                    itemId = (String)jComp.get((Object)"uuid");
                    out.indent().println((CharSequence)AliasUtil.selector((String)name, (UUID)UUID.valueOf((String)itemId), (String)repoUri, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
                }
            } else {
                out.println((CharSequence)Messages.FlowTargetCmd_FLOWS_ALL_COMPONENTS);
            }
        }
    }
}

