/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListFilesOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentFolderEntryReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponentFolderEntryReportList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmFolderEntryReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmFolderEntryReportList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifier;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionableIdentifierList;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePath;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePermissionsReport;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionablePermissionsResult;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;

public class ListFilesCmd
extends AbstractSubcommand {
    private int fileCount;
    private int max;
    private int depth;
    final int DEFAULT_VALUE = 10;
    static final int DEPTH_INFINITE = -1;
    private static final int MAX_BATCH_SIZE = 50;
    private static final String READ_ACCESS_TYPE = "type";
    private static final String READ_ACCESS_NAME = "name";
    private static final String READ_ACCESS_UUID = "uuid";
    private final String NL = System.getProperty("line.separator");
    private Map<String, String> readContextCache = new HashMap<String, String>();
    private Map<String, String> compMap = new HashMap<String, String>();
    private boolean showAccess;
    private boolean isNameCaseSensitive;
    private boolean isModeBaseline;
    private String selectorId;
    private String selectorName;
    private String remotePath;
    private String workspaceOrStreamMsg;
    private String nameOrPatternToBeFetched;
    private JSONArray jComponentArray;
    private JSONObject selectorObject;
    private JSONObject jComponentObject;
    private Mode mode;
    private VersionMode vMode;
    private RepoUtil.ItemType itemType;
    private IItemHandle contextItem = null;
    private List<IScmCommandLineArgument> componentSelectors;
    private IScmCommandLineArgument workspaceOrSnapshotOrBaselineSelector;
    private ITeamRepository repo;
    private IndentingPrintStream out;
    private IFilesystemRestClient client;
    private IScmRichClientRestService scmService;
    private static final Comparator<String> PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String object1, String object2) {
            int l2;
            int l1 = object1.length();
            int end = l1 < (l2 = object2.length()) ? l1 : l2;
            int i = 0;
            while (i < end) {
                char c1 = object1.charAt(i);
                char c2 = object2.charAt(i);
                if (c1 == '/' && c2 != '/') {
                    return -1;
                }
                if (c2 == '/' && c1 != '/') {
                    return 1;
                }
                int compare = c1 - c2;
                if (compare != 0) {
                    return compare;
                }
                ++i;
            }
            return l1 - l2;
        }
    };
    private static final Comparator<String> FILE_AND_PATH_COMPARATOR = new Comparator<String>(){
        private Collator fCollator = Collator.getInstance();

        @Override
        public int compare(String s1, String s2) {
            String fileName2;
            String fileName1 = s1.substring(s1.lastIndexOf("/") + 1);
            if (fileName1.compareTo(fileName2 = s2.substring(s2.lastIndexOf("/") + 1)) == 0) {
                return this.fCollator.compare(s1, s2);
            }
            return this.fCollator.compare(fileName1, fileName2);
        }
    };

    private IndentingPrintStream getPrintStream() {
        return this.config.getWrappedOutputStream();
    }

    private IScmRichClientRestService getService() {
        return (IScmRichClientRestService)((IClientLibraryContext)this.repo).getServiceInterface(IScmRichClientRestService.class);
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && !cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER)) {
            StringBuffer message = new StringBuffer(NLS.bind((String)Messages.ListFilesOptions_HELP_1, (Object)CommonOptions.OPT_MAXRESULTS.getName(), (Object)ListFilesOptions.OPT_NAME_FILTER.getName()));
            if (!cli.hasOption((IOptionKey)ListFilesOptions.OPT_DEPTH)) {
                message.append(" ").append(NLS.bind((String)Messages.ListFilesCmd_DEPTH_USAGE_HELP, (Object)ListFilesOptions.OPT_DEPTH.getName(), (Object)ListFilesOptions.OPT_REMOTE_PATH.getName()));
            }
            throw StatusHelper.argSyntax((String)message.toString());
        }
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_DEPTH) && cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER)) {
            StringBuffer message = new StringBuffer(NLS.bind((String)Messages.ListFilesCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)ListFilesOptions.OPT_DEPTH.getName(), (Object)ListFilesOptions.OPT_NAME_FILTER.getName()));
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) {
                message.append(" ").append(NLS.bind((String)Messages.ListFilesCmd_MAXRESULTS_USAGE_HELP, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
            throw StatusHelper.argSyntax((String)message.toString());
        }
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_CASE_SENSITIVE) && !cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListFilesOptions_HELP_1, (Object)ListFilesOptions.OPT_CASE_SENSITIVE.getName(), (Object)ListFilesOptions.OPT_NAME_FILTER.getName()));
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER) && !RepoUtil.isAllowedMaxValue((ICommandLine)cli, (int)10, (int)2048)) {
            StringBuffer message = new StringBuffer();
            message.append(NLS.bind((String)Messages.ListFilesCmd_MAXRESULTS_ALLOWED_VALUE_HELP, (Object[])new String[]{CommonOptions.OPT_MAXRESULTS.getName(), ListFilesOptions.OPT_NAME_FILTER.getName(), "2048"}));
            throw StatusHelper.disallowed((String)message.toString());
        }
        String selectorMessage = null;
        RepoUtil.ItemType selectorItemType = null;
        this.assembleInputOptions();
        if (this.mode == Mode.WORKSPACE) {
            this.setCompMapForWorkspace();
            selectorItemType = this.itemType;
            selectorMessage = this.workspaceOrStreamMsg;
        } else if (this.mode == Mode.SNAPSHOT) {
            this.setCompMapForSnapshot();
            selectorItemType = RepoUtil.ItemType.SNAPSHOT;
            selectorMessage = Messages.ListComponentsCmd_Snapshot;
        } else {
            this.isModeBaseline = true;
            this.setCompMapForBaseline();
            selectorItemType = RepoUtil.ItemType.BASELINE;
            selectorMessage = Messages.ListComponentsCmd_Baseline;
        }
        this.scmService = this.getService();
        this.out = this.getPrintStream();
        if (!this.config.isJSONEnabled() && !this.isModeBaseline) {
            this.printText(selectorItemType, selectorMessage, this.selectorName, this.selectorId);
        }
        this.selectorObject = JSONPrintUtil.jsonize((String)this.selectorName, (String)this.selectorId, (String)this.repo.getRepositoryURI());
        if (!this.isModeBaseline) {
            this.jComponentArray = new JSONArray();
            this.selectorObject.put((Object)"components", (Object)this.jComponentArray);
        }
        if (this.compMap == null || this.compMap.isEmpty()) {
            throw StatusHelper.itemNotFound((String)Messages.ListFilesCmd_NO_COMPONENTS);
        }
        int filesDisplayed = 0;
        boolean displayAllComponents = cli.hasOption((IOptionKey)ListFilesOptions.OPT_SHOW_COMPONENTS);
        if (this.mode == Mode.WORKSPACE && this.nameOrPatternToBeFetched != null && !cli.hasOption((IOptionKey)ListFilesOptions.OPT_REMOTE_PATH)) {
            IScmRichClientRestService.ParmsGetWorkspaceFindVersionablesByNamePattern parmsGetWorkspaceFindVersionablesByNamePattern = this.createGetWorkspaceFindVersionablesByNamePattern();
            ScmComponentFolderEntryReportList versionableList = null;
            try {
                versionableList = RepoUtil.searchFilesByNamePattern((IScmRichClientRestService)this.scmService, (IScmRichClientRestService.ParmsGetWorkspaceFindVersionablesByNamePattern)parmsGetWorkspaceFindVersionablesByNamePattern);
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException((Throwable)e);
            }
            ArrayList<String> filesNotFoundInComp = new ArrayList<String>(this.compMap.keySet());
            for (Map.Entry entry : this.compMap.entrySet()) {
                String compId = (String)entry.getKey();
                for (ScmComponentFolderEntryReport childReport : versionableList.getFolderEntryReports()) {
                    if (!compId.equals(childReport.getComponentItemId())) continue;
                    this.jComponentObject = JSONPrintUtil.jsonize((String)this.compMap.get(childReport.getComponentItemId()), (String)childReport.getComponentItemId(), (String)this.repo.getRepositoryURI());
                    this.jComponentArray.add((Object)this.jComponentObject);
                    JSONArray files = new JSONArray();
                    if (!childReport.getEntries().isEmpty()) {
                        Map<String, JSONObject> versionablePermissions = this.getPermissions2(childReport.getComponentItemId(), this.repo, this.config, versionableList);
                        Map<String, ScmVersionableIdentifier> versionIds = this.getVersionIds2(this.repo, this.config, this.vMode, versionableList);
                        TreeMap sortedChildMap = new TreeMap(childReport.getEntries());
                        for (Map.Entry entry2 : sortedChildMap.entrySet()) {
                            if (entry2 == null) continue;
                            JSONObject jPath = new JSONObject();
                            String path = (String)entry2.getKey();
                            IVersionableHandle verHandle = (IVersionableHandle)entry2.getValue();
                            this.addJpath(versionablePermissions, versionIds, verHandle, path, jPath);
                            files.add((Object)jPath);
                        }
                    }
                    if (files.size() <= 0) continue;
                    filesNotFoundInComp.remove(childReport.getComponentItemId());
                    if (this.config.isJSONEnabled()) {
                        filesDisplayed += this.populateFilesIntoJSON((Collection)files);
                        continue;
                    }
                    this.printText(RepoUtil.ItemType.COMPONENT, "  " + Messages.ListComponentsCmd_Component, this.compMap.get(childReport.getComponentItemId()), childReport.getComponentItemId());
                    filesDisplayed += this.printFiles((Collection)files, this.out, this.repo.getRepositoryURI(), this.config);
                }
            }
            if (displayAllComponents) {
                for (String string : filesNotFoundInComp) {
                    if (this.config.isJSONEnabled()) {
                        this.jComponentObject = JSONPrintUtil.jsonize((String)this.compMap.get(string), (String)string, (String)this.repo.getRepositoryURI());
                        this.jComponentArray.add((Object)this.jComponentObject);
                        JSONArray files = new JSONArray();
                        this.populateFilesIntoJSON((Collection)files);
                        continue;
                    }
                    this.printHeaderOutput(this.compMap.get(string), string, selectorItemType, selectorMessage);
                    this.printText(null, "    " + Messages.ListFilesCmd_NO_MATCHING_FILES_FOUND_2);
                }
            }
        } else {
            for (Map.Entry entry : this.compMap.entrySet()) {
                String compName = (String)entry.getValue();
                String string = (String)entry.getKey();
                if (this.nameOrPatternToBeFetched != null && this.fileCount > this.max) {
                    this.printCompWhenRemotePathNotFoundOrMaxResultIsReached(selectorMessage, selectorItemType, compName, string, displayAllComponents, Messages.ListFilesCmd_NO_MATCHING_FILES_FOUND_2);
                    continue;
                }
                ScmVersionablePath scmPath = RepoUtil.getVersionable2((IScmRichClientRestService)this.scmService, (IItemHandle)this.contextItem, (String)string, (String)this.remotePath, (IScmClientConfiguration)this.config);
                if (scmPath == null || scmPath.getVersionable() == null) {
                    this.printCompWhenRemotePathNotFoundOrMaxResultIsReached(selectorMessage, selectorItemType, compName, string, displayAllComponents, Messages.ListRemoteFilesCmd_3);
                    continue;
                }
                String[] pathSegs = scmPath.getSegments().toArray(new String[scmPath.getSegments().size()]);
                String path = this.toPath(pathSegs, scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE));
                JSONObject jPath = new JSONObject();
                if (this.nameOrPatternToBeFetched == null) {
                    this.buildJPathObj(string, scmPath, path, jPath);
                    if (!scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE) || this.depth == 0) {
                        if (!this.config.isJSONEnabled()) {
                            this.printHeaderOutput(compName, string, selectorItemType, selectorMessage);
                            filesDisplayed += this.printFiles(Collections.singletonList(jPath), this.out, this.repo.getRepositoryURI(), this.config);
                            continue;
                        }
                        filesDisplayed += this.populateFilesIntoJSON(Collections.singletonList(jPath));
                        continue;
                    }
                }
                filesDisplayed += this.jsonizeFiles(path, jPath, this.contextItem, compName, string, scmPath.getVersionable(), this.depth, this.repo, this.config, this.getHeaderOutput(compName, string, selectorItemType, selectorMessage), displayAllComponents);
            }
        }
        if (this.config.isJSONEnabled()) {
            if (this.isModeBaseline) {
                this.config.getOutputStream().print((CharSequence)this.jComponentObject.toString());
            } else {
                this.config.getOutputStream().print((CharSequence)this.selectorObject.toString());
            }
        }
        if (filesDisplayed == 0) {
            if (!(this.config.isJSONEnabled() || displayAllComponents || this.isModeBaseline)) {
                if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_REMOTE_PATH) || cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER)) {
                    void var6_16;
                    Object var6_12 = null;
                    if (!cli.hasOption((IOptionKey)ListFilesOptions.OPT_REMOTE_PATH)) {
                        String string = Messages.ListFilesCmd_NO_MATCHING_FILES_FOUND_2;
                    } else if (!cli.hasOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER)) {
                        String string = NLS.bind((String)Messages.ListRemoteFilesCmd_3, (Object)this.remotePath);
                    } else {
                        String string = NLS.bind((String)Messages.ListFilesCmd_NO_MATCHING_FILES_FOUND_1, (Object[])new String[]{this.remotePath, ListFilesOptions.OPT_SHOW_COMPONENTS.getShortOpt().toString(), ListFilesOptions.OPT_SHOW_COMPONENTS.getName()});
                    }
                    this.printText(null, "  " + (String)var6_16);
                } else {
                    this.printText(null, "  " + Messages.ListFilesCmd_NO_FILES_FOUND);
                }
            }
            throw StatusHelper.returnValue((int)25);
        }
    }

    private void printCompWhenRemotePathNotFoundOrMaxResultIsReached(String selectorMessage, RepoUtil.ItemType selectorItemType, String compName, String compId, boolean displayAllComponents, String message) throws FileSystemException {
        if (this.isModeBaseline || displayAllComponents) {
            if (this.config.isJSONEnabled()) {
                this.jComponentObject = JSONPrintUtil.jsonize((String)compName, (String)compId, (String)this.repo.getRepositoryURI());
                this.populateFilesIntoJSON((Collection)new JSONArray());
                if (!this.isModeBaseline) {
                    this.jComponentArray.add((Object)this.jComponentObject);
                }
            } else {
                this.printHeaderOutput(compName, compId, selectorItemType, selectorMessage);
                this.printText(null, "    " + message, this.remotePath);
            }
        }
    }

    private void printHeaderOutput(String compName, String compId, RepoUtil.ItemType selectorItemType, String selectorMessage) {
        this.out.println((CharSequence)this.getHeaderOutput(compName, compId, selectorItemType, selectorMessage));
    }

    private String getHeaderOutput(String compName, String compId, RepoUtil.ItemType selectorItemType, String selectorMessage) {
        if (!this.isModeBaseline) {
            return this.getText(RepoUtil.ItemType.COMPONENT, "  " + Messages.ListComponentsCmd_Component, compName, compId);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getText(RepoUtil.ItemType.COMPONENT, Messages.ListComponentsCmd_Component, compName, compId));
        buffer.append(this.NL);
        buffer.append(this.getText(selectorItemType, "  " + selectorMessage, this.selectorName, this.selectorId));
        return buffer.toString();
    }

    private void buildJPathObj(String compId, ScmVersionablePath scmPath, String path, JSONObject jPath) throws FileSystemException {
        Map<String, JSONObject> versionablePermissions;
        JSONObject permissions;
        String stateId;
        Map<String, ScmVersionableIdentifier> identifiers;
        jPath.put((Object)"path", (Object)path);
        jPath.put((Object)READ_ACCESS_UUID, (Object)scmPath.getVersionable().getItemId().getUuidValue());
        jPath.put((Object)"state-id", (Object)scmPath.getVersionable().getStateId().getUuidValue());
        if (!VersionMode.HIDE.equals((Object)this.vMode) && !scmPath.getVersionable().getItemType().equals(IFolder.ITEM_TYPE) && (identifiers = this.fetchVersionIdentifiers(this.scmService, Collections.singletonList(stateId = scmPath.getVersionable().getStateId().getUuidValue()), this.repo, this.config)).containsKey(stateId)) {
            jPath.put((Object)"version", (Object)JSONPrintUtil.jsonizeVersionId((ScmVersionableIdentifier)identifiers.get(stateId)));
        }
        if (this.showAccess && (permissions = (versionablePermissions = this.fetchVersionablePermissions(this.scmService, compId, Collections.singletonList(scmPath.getVersionable()), this.repo, this.config)).get(scmPath.getVersionable().getItemId().getUuidValue())) != null) {
            jPath.put((Object)"jazz.read-access", (Object)permissions);
        }
    }

    private void printText(RepoUtil.ItemType selectorItemType, String ... arguments) {
        this.out.println((CharSequence)this.getText(selectorItemType, arguments));
    }

    private String getText(RepoUtil.ItemType selectorItemType, String ... arguments) {
        if (selectorItemType != null) {
            return NLS.bind((String)arguments[0], (Object)AliasUtil.selector((String)arguments[1], (UUID)UUID.valueOf((String)arguments[2]), (String)this.repo.getRepositoryURI(), (RepoUtil.ItemType)selectorItemType));
        }
        if (arguments.length == 2) {
            return NLS.bind((String)arguments[0], (Object)arguments[1]);
        }
        return arguments[0];
    }

    private void setCompMapForBaseline() throws FileSystemException, CLIFileSystemClientException {
        SubcommandUtil.validateArgument((IScmCommandLineArgument)this.workspaceOrSnapshotOrBaselineSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        if (this.componentSelectors != null) {
            this.checkForSingleComp();
            IComponent comp = RepoUtil.getComponent((String)this.componentSelectors.get(0).getItemSelector(), (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
            IBaseline bl = RepoUtil.getBaseline((String)this.workspaceOrSnapshotOrBaselineSelector.getItemSelector(), (String)comp.getItemId().getUuidValue(), null, (ITeamRepository)this.repo, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            this.contextItem = bl.getItemHandle();
            this.selectorName = bl.getName();
            this.selectorId = bl.getItemId().getUuidValue();
            this.compMap.put(comp.getItemId().getUuidValue(), comp.getName());
        } else {
            String blUUID = null;
            IUuidAliasRegistry.IUuidAlias uuidAlias = RepoUtil.lookupUuidAndAlias((String)this.workspaceOrSnapshotOrBaselineSelector.getItemSelector());
            if (uuidAlias != null) {
                blUUID = uuidAlias.getUuid().getUuidValue();
                BaselineDTO baselineDTO = RepoUtil.getBaselineById((String)blUUID, (String)this.repo.getRepositoryURI(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
                IBaseline bl = RepoUtil.getBaseline((String)this.workspaceOrSnapshotOrBaselineSelector.getItemSelector(), (String)baselineDTO.getComponentItemId(), null, (ITeamRepository)this.repo, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
                this.contextItem = bl.getItemHandle();
                this.selectorName = bl.getName();
                this.selectorId = bl.getItemId().getUuidValue();
                this.compMap.put(baselineDTO.getComponentItemId(), baselineDTO.getComponentName());
            } else {
                throw StatusHelper.itemNotFound((String)Messages.ListFilesCmd_BASELINE_NOT_FOUND);
            }
        }
    }

    private void checkForSingleComp() throws CLIFileSystemClientException {
        if (this.componentSelectors.size() > 1) {
            throw StatusHelper.disallowed((String)Messages.ListFilesCmd_SPECIFY_SINGLE_COMP_FOR_BASELINE_SELECTOR);
        }
    }

    private void setCompMapForSnapshot() throws FileSystemException, CLIFileSystemClientException {
        SubcommandUtil.validateArgument((IScmCommandLineArgument)this.workspaceOrSnapshotOrBaselineSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        IBaselineSet snapshot = RepoUtil.getSnapshot(null, (String)this.workspaceOrSnapshotOrBaselineSelector.getItemSelector(), (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
        this.contextItem = snapshot.getItemHandle();
        this.selectorName = snapshot.getName();
        this.selectorId = snapshot.getItemId().getUuidValue();
        this.buildComponentMap(snapshot);
    }

    private void buildComponentMap(IBaselineSet snapshot) throws FileSystemException, CLIFileSystemClientException {
        List baselines = RepoUtil.getItems((IItemType)IBaseline.ITEM_TYPE, (List)snapshot.getBaselines(), (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
        ArrayList<IComponentHandle> compHandles = new ArrayList<IComponentHandle>(baselines.size());
        for (IBaseline baseline : baselines) {
            compHandles.add(baseline.getComponent());
        }
        List comps = RepoUtil.getItems((IItemType)IComponent.ITEM_TYPE, compHandles, (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
        if (this.componentSelectors != null) {
            for (IScmCommandLineArgument compSelector : this.componentSelectors) {
                boolean compFound = false;
                for (IComponent comp : comps) {
                    if (!this.matches(compSelector, comp)) continue;
                    IAlias compAlias = compSelector.getAlias();
                    if (compAlias == null && this.compMap.containsValue(compSelector)) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListFilesCmd_DUPLICATE_COMPONENT, (Object)compSelector.getItemSelector()));
                    }
                    this.compMap.put(comp.getItemId().getUuidValue(), comp.getName());
                    compFound = true;
                }
                if (compFound) continue;
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
        } else {
            for (IComponent comp : comps) {
                this.compMap.put(comp.getItemId().getUuidValue(), comp.getName());
            }
        }
        if (this.compMap.size() > 1) {
            this.sortComponentMap();
        }
    }

    private void setCompMapForWorkspace() throws FileSystemException, CLIFileSystemClientException {
        SubcommandUtil.validateArgument((IScmCommandLineArgument)this.workspaceOrSnapshotOrBaselineSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IWorkspace wsFound = RepoUtil.getWorkspace((String)this.workspaceOrSnapshotOrBaselineSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(this.repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        this.decideWorkspaceOrStream(wsFound);
        this.contextItem = wsFound.getItemHandle();
        this.selectorName = wsFound.getName();
        this.selectorId = wsFound.getItemId().getUuidValue();
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        this.buildComponentMap(wsDetails);
    }

    private void decideWorkspaceOrStream(IWorkspace wsFound) {
        if (wsFound.isStream()) {
            this.itemType = RepoUtil.ItemType.STREAM;
            this.workspaceOrStreamMsg = Messages.ListFilesCmd_Stream;
        } else {
            this.itemType = RepoUtil.ItemType.WORKSPACE;
            this.workspaceOrStreamMsg = Messages.ListFilesCmd_Workspace;
        }
    }

    private void buildComponentMap(WorkspaceDetailsDTO wsDetails) throws CLIFileSystemClientException {
        if (this.componentSelectors != null) {
            for (IScmCommandLineArgument compSelector : this.componentSelectors) {
                boolean compFound = false;
                for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                    if (!this.matches(compSelector, compDTO)) continue;
                    IAlias compAlias = compSelector.getAlias();
                    if (compAlias == null && this.compMap.containsValue(compSelector)) {
                        throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ListFilesCmd_DUPLICATE_COMPONENT, (Object)compSelector.getItemSelector()));
                    }
                    this.compMap.put(compDTO.getItemId(), compDTO.getName());
                    compFound = true;
                }
                if (compFound) continue;
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
        } else {
            for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                this.compMap.put(compDTO.getItemId(), compDTO.getName());
            }
        }
        if (this.compMap.size() > 1) {
            this.sortComponentMap();
        }
    }

    private void assembleInputOptions() throws CLIFileSystemClientException, FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        this.setDepth(cli);
        this.setVersionMode(cli);
        this.setShowAccess(cli);
        this.decideMode(cli);
        this.setNameFilter(cli);
        this.setRemotePath(cli);
        this.setSelector(cli);
        this.setComponentsSelector(cli);
    }

    private void setShowAccess(ICommandLine cli) {
        this.showAccess = cli.hasOption((IOptionKey)ListFilesOptions.OPT_SHOW_ACCESS);
    }

    private void setComponentsSelector(ICommandLine cli) throws CLIFileSystemClientException, FileSystemException {
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_COMPONENTS_SELECTOR)) {
            this.componentSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ListFilesOptions.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, this.componentSelectors, (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument(this.componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        }
    }

    private void setSelector(ICommandLine cli) throws FileSystemException {
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.workspaceOrSnapshotOrBaselineSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListFilesOptions.OPT_SELECTOR), (IScmClientConfiguration)this.config);
        this.repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)this.workspaceOrSnapshotOrBaselineSelector);
    }

    private void setRemotePath(ICommandLine cli) {
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_REMOTE_PATH)) {
            this.remotePath = cli.getOption((IOptionKey)ListFilesOptions.OPT_REMOTE_PATH);
            String[] path = StringUtil.splitEscapedPath((String)this.remotePath);
            this.remotePath = path.length == 0 ? Character.toString('/') : this.toPath(path, false);
        } else {
            this.remotePath = Character.toString('/');
        }
    }

    private void setNameFilter(ICommandLine cli) throws FileSystemException {
        this.nameOrPatternToBeFetched = cli.getOption((IOptionKey)ListFilesOptions.OPT_NAME_FILTER, null);
        if (this.nameOrPatternToBeFetched != null && !this.nameOrPatternToBeFetched.isEmpty()) {
            this.depth = -1;
            this.max = RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)10);
            if (this.max == Integer.MAX_VALUE) {
                this.max = 2048;
            }
            this.isNameCaseSensitive = cli.hasOption((IOptionKey)ListFilesOptions.OPT_CASE_SENSITIVE);
        }
    }

    private void decideMode(ICommandLine cli) throws CLIFileSystemClientException {
        int modeCount = 0;
        this.mode = Mode.WORKSPACE;
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_WORKSPACE)) {
            ++modeCount;
        }
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_SNAPSHOT)) {
            this.mode = Mode.SNAPSHOT;
            ++modeCount;
        }
        if (cli.hasOption((IOptionKey)ListFilesOptions.OPT_BASELINE)) {
            this.mode = Mode.BASELINE;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_3_ARGUMENTS, (Object[])new String[]{ListFilesOptions.OPT_WORKSPACE.getName(), ListFilesOptions.OPT_SNAPSHOT.getName(), ListFilesOptions.OPT_BASELINE.getName()}));
        }
    }

    private void setVersionMode(ICommandLine cli) throws CLIFileSystemClientException {
        this.vMode = VersionMode.HIDE;
        if (cli.hasOption(ListFilesOptions.OPT_SHOW_SHORT_VERSION_ID) && cli.hasOption(ListFilesOptions.OPT_SHOW_FULL_VERSION_ID)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption(ListFilesOptions.OPT_SHOW_SHORT_VERSION_ID).getName(), (Object)cli.getDefinition().getOption(ListFilesOptions.OPT_SHOW_FULL_VERSION_ID).getName()));
        }
        if (cli.hasOption(ListFilesOptions.OPT_SHOW_SHORT_VERSION_ID)) {
            this.vMode = VersionMode.SHORT_VERSION;
        } else if (cli.hasOption(ListFilesOptions.OPT_SHOW_FULL_VERSION_ID)) {
            this.vMode = VersionMode.LONG_VERSION;
        }
    }

    private void setDepth(ICommandLine cli) throws CLIFileSystemClientException {
        String depthString = cli.getOption((IOptionKey)ListFilesOptions.OPT_DEPTH, null);
        if (depthString != null) {
            if (depthString.equals("all") || depthString.equals("-")) {
                this.depth = -1;
            } else {
                try {
                    this.depth = Integer.parseInt(depthString);
                }
                catch (NumberFormatException e) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListRemoteFilesCmd_5, (Object)depthString));
                }
            }
        } else {
            this.depth = 1;
        }
    }

    private boolean matches(IScmCommandLineArgument sel, IComponent comp) {
        IAlias alias = sel.getAlias();
        if (alias == null) {
            return sel.getValuePrefix().equals(comp.getName());
        }
        return alias.getId().equals(comp.getItemId().getUuidValue());
    }

    private boolean matches(IScmCommandLineArgument sel, WorkspaceComponentDTO dto) {
        IAlias alias = sel.getAlias();
        if (alias == null) {
            return sel.getValuePrefix().equals(dto.getName());
        }
        return alias.getId().equals(dto.getItemId());
    }

    private int populateFilesIntoJSON(Collection paths) throws FileSystemException {
        if (this.config.isJSONEnabled()) {
            JSONArray array = this.removeNull(paths);
            this.populateJsonOutput(array);
            return array.size();
        }
        return 0;
    }

    private JSONArray removeNull(Collection paths) {
        JSONArray array = new JSONArray();
        for (JSONObject result : paths) {
            if (result == null || result.isEmpty()) continue;
            array.add((Object)result);
        }
        return array;
    }

    private void populateJsonOutput(JSONArray array) throws FileSystemException {
        if (!this.isModeBaseline) {
            this.jComponentObject.put((Object)"remote-files", (Object)array);
        } else {
            this.jComponentObject.put((Object)"baseline", (Object)this.selectorObject);
            this.selectorObject.put((Object)"remote-files", (Object)array);
        }
    }

    private int printFiles(Collection paths, IndentingPrintStream out, String repoUri, IScmClientConfiguration config) throws FileSystemException {
        return this.printFiles(paths, out, repoUri, config, null);
    }

    private int printFiles(Collection paths, IndentingPrintStream out, String repoUri, IScmClientConfiguration config, String header) throws FileSystemException {
        int filesDisplayed = 0;
        boolean showVersionId = this.vMode == VersionMode.LONG_VERSION || this.vMode == VersionMode.SHORT_VERSION;
        for (Object obj : paths) {
            String output = this.extractOutput(config, showVersionId, obj);
            if (output == null) continue;
            if (filesDisplayed == 0 && header != null) {
                out.println((CharSequence)header);
            }
            out.println((CharSequence)("    " + output));
            ++filesDisplayed;
        }
        return filesDisplayed;
    }

    private String extractOutput(IScmClientConfiguration config, boolean showVersionId, Object obj) {
        String output = null;
        JSONObject jPath = (JSONObject)obj;
        String versionId = this.getVersionId(jPath);
        output = this.extractUuidPathStateId(config, showVersionId, jPath, versionId);
        output = this.extractReadAccess(config, output, jPath);
        return output;
    }

    private String getVersionId(JSONObject jPath) {
        String versionId = null;
        JSONObject version = (JSONObject)jPath.get((Object)"version");
        if (version != null) {
            switch (this.vMode) {
                case LONG_VERSION: {
                    versionId = JSONPrintUtil.jsonizeGetLongVersionId((JSONObject)version);
                    break;
                }
                case SHORT_VERSION: {
                    versionId = JSONPrintUtil.jsonizeGetShortVersionId((JSONObject)version);
                }
            }
        }
        return versionId;
    }

    private String extractUuidPathStateId(IScmClientConfiguration config, boolean showVersionId, JSONObject jPath, String versionId) {
        String output = config.getAliasConfig().showUuid() ? (showVersionId && versionId != null ? NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_UUID_VERSION_ID, (Object[])new String[]{(String)jPath.get((Object)READ_ACCESS_UUID), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"path"), versionId}) : NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT, (Object[])new String[]{(String)jPath.get((Object)READ_ACCESS_UUID), (String)jPath.get((Object)"state-id"), (String)jPath.get((Object)"path")})) : (showVersionId && versionId != null ? NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_VERSION_ID, (Object[])new String[]{(String)jPath.get((Object)"path"), versionId}) : (String)jPath.get((Object)"path"));
        return output;
    }

    private String extractReadAccess(IScmClientConfiguration config, String output, JSONObject jPath) {
        JSONObject access = (JSONObject)jPath.get((Object)"jazz.read-access");
        if (access != null) {
            String printableAccessType = this.getPrintableAccessType((String)access.get((Object)READ_ACCESS_TYPE));
            output = String.valueOf(output) + ' ';
            if (access.get((Object)READ_ACCESS_NAME) != null) {
                output = config.getAliasConfig().showUuid() && access.get((Object)READ_ACCESS_UUID) != null ? String.valueOf(output) + NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_ACCESS_UUID, (Object[])new Object[]{printableAccessType, access.get((Object)READ_ACCESS_UUID), access.get((Object)READ_ACCESS_NAME)}) : String.valueOf(output) + NLS.bind((String)Messages.ListRemoteFilesCmd_PRINT_ACCESS, (Object)printableAccessType, (Object)access.get((Object)READ_ACCESS_NAME));
            }
        }
        return output;
    }

    private IScmRichClientRestService.ParmsGetWorkspaceFindVersionablesByNamePattern createGetWorkspaceFindVersionablesByNamePattern() {
        IScmRichClientRestService.ParmsGetWorkspaceFindVersionablesByNamePattern parms = new IScmRichClientRestService.ParmsGetWorkspaceFindVersionablesByNamePattern();
        parms.contextItemId = this.contextItem.getItemId().getUuidValue();
        parms.contextItemType = this.contextItem.getItemType().getName();
        parms.contextItemNamespace = this.contextItem.getItemType().getNamespaceURI();
        parms.componentItemIds = new String[this.compMap.size()];
        int idx = 0;
        Iterator<String> iterator = this.compMap.keySet().iterator();
        while (iterator.hasNext()) {
            String compId;
            parms.componentItemIds[idx] = compId = iterator.next();
            ++idx;
        }
        parms.namePattern = this.nameOrPatternToBeFetched;
        parms.maxResult = this.max;
        parms.isNamePatternCaseSensitive = this.isNameCaseSensitive;
        return parms;
    }

    private String getPrintableAccessType(String internalAccessType) {
        if (internalAccessType == null) {
            return Messages.Common_UNKNOWN;
        }
        if (internalAccessType.equals(IAccessGroup.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_ACCESS_GROUP;
        }
        if (internalAccessType.equals(IProjectArea.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_PROJECT_AREA;
        }
        if (internalAccessType.equals(ITeamArea.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_TEAM_AREA;
        }
        if (internalAccessType.equals(IComponent.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_COMPONENT_SCOPED;
        }
        if (internalAccessType.equals(IContributor.ITEM_TYPE.getName())) {
            return Messages.ListRemoteFilesCmd_CONTRIBUTOR;
        }
        return internalAccessType;
    }

    private int calculateDepth(String path) {
        int depth = -1;
        int i = 0;
        while (i < path.length()) {
            if (path.charAt(i) == '/') {
                ++depth;
            }
            ++i;
        }
        return depth;
    }

    private int jsonizeFiles(String path, JSONObject root, IItemHandle contextItem, String compName, String compId, IVersionableHandle versionable, int maxDepth, ITeamRepository repo, IScmClientConfiguration config, String header, boolean displayAllComponents) throws FileSystemException {
        boolean hasFiles;
        int filesDisplayed = 0;
        int initialDepth = this.calculateDepth(path);
        TreeMap<String, IVersionableHandle> pathQueue = null;
        TreeMap<String, JSONObject> results = null;
        if (this.nameOrPatternToBeFetched != null) {
            pathQueue = new TreeMap<String, IVersionableHandle>(FILE_AND_PATH_COMPARATOR);
            results = new TreeMap<String, JSONObject>(FILE_AND_PATH_COMPARATOR);
        } else {
            pathQueue = new TreeMap(PATH_COMPARATOR);
            results = new TreeMap(PATH_COMPARATOR);
        }
        results.put(path, root);
        pathQueue.put(path, versionable);
        while (!pathQueue.isEmpty()) {
            int batchSize = pathQueue.size() > 50 ? 50 : pathQueue.size();
            ArrayList<Map.Entry<String, IVersionableHandle>> batch = new ArrayList<Map.Entry<String, IVersionableHandle>>(batchSize);
            while (batch.size() < batchSize) {
                batch.add(pathQueue.pollFirstEntry());
            }
            ScmFolderEntryReportList folderReportList = null;
            try {
                IScmRichClientRestService.ParmsGetVersionableChildren parms = this.createVersionableChildrenParms(contextItem, compId, batch);
                folderReportList = this.scmService.postGetVersionableChildren(parms);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListRemoteFilesCmd_FAILED_TO_GET_VER_CHILDREN, (Object)path));
            }
            Map<String, JSONObject> versionablePermissions = this.getPermissions(compId, repo, config, folderReportList);
            Map<String, ScmVersionableIdentifier> versionIds = this.getVersionIds(repo, config, this.vMode, folderReportList);
            int batchIdx = 0;
            for (ScmFolderEntryReport childReport : folderReportList.getFolderEntryReports()) {
                Map.Entry parentEntry = (Map.Entry)batch.get(batchIdx++);
                for (Map.Entry entry : childReport.getEntries().entrySet()) {
                    IVersionableHandle verHandle = (IVersionableHandle)entry.getValue();
                    String childRemotePath = this.appendPathSegment((String)parentEntry.getKey(), (String)entry.getKey(), verHandle instanceof IFolderHandle);
                    JSONObject jPath = new JSONObject();
                    if (this.nameOrPatternToBeFetched != null) {
                        if (!(verHandle instanceof IFolderHandle)) {
                            results.put(childRemotePath, jPath);
                            this.addJpath(versionablePermissions, versionIds, verHandle, childRemotePath, jPath);
                        }
                    } else {
                        results.put(childRemotePath, jPath);
                        this.addJpath(versionablePermissions, versionIds, verHandle, childRemotePath, jPath);
                    }
                    int currDepth = this.calculateDepth(childRemotePath) - initialDepth;
                    if (!(verHandle instanceof IFolderHandle) || maxDepth != -1 && currDepth >= maxDepth) continue;
                    pathQueue.put(childRemotePath, verHandle);
                }
            }
        }
        if (this.nameOrPatternToBeFetched != null) {
            results = this.getSlicedResult(results);
        }
        JSONArray jArray = null;
        if (config.isJSONEnabled()) {
            jArray = new JSONArray(results.size());
            jArray.addAll(results.values());
        }
        boolean bl = hasFiles = results.values().size() > 1 || results.values().size() == 1 && !results.values().iterator().next().isEmpty();
        if (hasFiles || displayAllComponents || this.isModeBaseline) {
            if (config.isJSONEnabled()) {
                this.jComponentObject = JSONPrintUtil.jsonize((String)compName, (String)compId, (String)repo.getRepositoryURI());
                if (!this.isModeBaseline) {
                    this.jComponentArray.add((Object)this.jComponentObject);
                }
                filesDisplayed += this.populateFilesIntoJSON((Collection)jArray);
            } else {
                if (filesDisplayed == 0) {
                    this.out.println((CharSequence)header);
                }
                filesDisplayed += this.printFiles(results.values(), this.out, repo.getRepositoryURI(), config);
                if (!hasFiles) {
                    this.printText(null, "    " + Messages.ListFilesCmd_NO_MATCHING_FILES_FOUND_2);
                }
            }
        }
        return filesDisplayed;
    }

    private TreeMap<String, JSONObject> getSlicedResult(TreeMap<String, JSONObject> results) {
        results.remove("/");
        TreeMap<String, JSONObject> slicedResult = new TreeMap<String, JSONObject>();
        for (Map.Entry<String, JSONObject> sortedEntry : results.entrySet()) {
            ++this.fileCount;
            if (this.fileCount > this.max) break;
            slicedResult.put(sortedEntry.getKey(), results.get(sortedEntry.getKey()));
        }
        return slicedResult;
    }

    private IScmRichClientRestService.ParmsGetVersionableChildren createVersionableChildrenParms(IItemHandle contextItem, String componentId, List<Map.Entry<String, IVersionableHandle>> batch) {
        IScmRichClientRestService.ParmsGetVersionableChildren parmsVerChild = new IScmRichClientRestService.ParmsGetVersionableChildren();
        parmsVerChild.contextItemId = contextItem.getItemId().getUuidValue();
        parmsVerChild.contextItemType = contextItem.getItemType().getName();
        parmsVerChild.contextItemNamespace = contextItem.getItemType().getNamespaceURI();
        parmsVerChild.componentItemId = componentId;
        parmsVerChild.versionableItemIds = new String[batch.size()];
        parmsVerChild.versionableItemTypes = new String[batch.size()];
        parmsVerChild.versionableItemNamespaces = new String[batch.size()];
        parmsVerChild.fileNameOrPattern = this.nameOrPatternToBeFetched;
        parmsVerChild.isNameCaseSensitive = this.isNameCaseSensitive;
        int idx = 0;
        for (Map.Entry<String, IVersionableHandle> entry : batch) {
            parmsVerChild.versionableItemIds[idx] = entry.getValue().getItemId().getUuidValue();
            parmsVerChild.versionableItemTypes[idx] = entry.getValue().getItemType().getName();
            parmsVerChild.versionableItemNamespaces[idx] = entry.getValue().getItemType().getNamespaceURI();
            ++idx;
        }
        return parmsVerChild;
    }

    private void addJpath(Map<String, JSONObject> versionablePermissions, Map<String, ScmVersionableIdentifier> versionIds, IVersionableHandle verHandle, String childRemotePath, JSONObject jPath) {
        this.addToJpath1(verHandle, childRemotePath, jPath);
        this.addToJpath2(versionablePermissions, verHandle, jPath);
        this.addToJpath3(versionIds, verHandle, jPath);
    }

    private Map<String, ScmVersionableIdentifier> getVersionIds(ITeamRepository repo, IScmClientConfiguration config, VersionMode vMode, ScmFolderEntryReportList folderReportList) throws FileSystemException {
        Map<String, ScmVersionableIdentifier> versionIds = Collections.emptyMap();
        if (!VersionMode.HIDE.equals((Object)vMode)) {
            versionIds = this.fetchVersionIdentifiers(this.scmService, folderReportList, repo, config);
        }
        return versionIds;
    }

    private Map<String, ScmVersionableIdentifier> getVersionIds2(ITeamRepository repo, IScmClientConfiguration config, VersionMode vMode, ScmComponentFolderEntryReportList folderReportList) throws FileSystemException {
        Map<String, ScmVersionableIdentifier> versionIds = Collections.emptyMap();
        if (!VersionMode.HIDE.equals((Object)vMode)) {
            versionIds = this.fetchVersionIdentifiers2(this.scmService, folderReportList, repo, config);
        }
        return versionIds;
    }

    private Map<String, JSONObject> getPermissions(String compId, ITeamRepository repo, IScmClientConfiguration config, ScmFolderEntryReportList folderReportList) throws FileSystemException {
        Map<String, JSONObject> versionablePermissions = Collections.emptyMap();
        if (this.showAccess) {
            versionablePermissions = this.fetchVersionablePermissions(this.scmService, compId, folderReportList, repo, config);
        }
        return versionablePermissions;
    }

    private Map<String, JSONObject> getPermissions2(String compId, ITeamRepository repo, IScmClientConfiguration config, ScmComponentFolderEntryReportList folderReportList) throws FileSystemException {
        Map<String, JSONObject> versionablePermissions = Collections.emptyMap();
        if (this.showAccess) {
            versionablePermissions = this.fetchVersionablePermissions2(this.scmService, compId, folderReportList, repo, config);
        }
        return versionablePermissions;
    }

    private void addToJpath3(Map<String, ScmVersionableIdentifier> versionIds, IVersionableHandle verHandle, JSONObject jPath) {
        ScmVersionableIdentifier vid = versionIds.get(verHandle.getStateId().getUuidValue());
        if (vid != null) {
            jPath.put((Object)"version", (Object)JSONPrintUtil.jsonizeVersionId((ScmVersionableIdentifier)vid));
        }
    }

    private void addToJpath2(Map<String, JSONObject> versionablePermissions, IVersionableHandle verHandle, JSONObject jPath) {
        JSONObject permissions = versionablePermissions.get(verHandle.getItemId().getUuidValue());
        if (permissions != null) {
            jPath.put((Object)"jazz.read-access", (Object)permissions);
        }
    }

    private void addToJpath1(IVersionableHandle verHandle, String childRemotePath, JSONObject jPath) {
        jPath.put((Object)"path", (Object)childRemotePath);
        jPath.put((Object)READ_ACCESS_UUID, (Object)verHandle.getItemId().getUuidValue());
        jPath.put((Object)"state-id", (Object)verHandle.getStateId().getUuidValue());
    }

    private Map<String, ScmVersionableIdentifier> fetchVersionIdentifiers(IScmRichClientRestService scmService, ScmFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> versionableStates = new ArrayList<String>(2048);
        for (ScmFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            for (IVersionableHandle versionable : folderEntry.getEntries().values()) {
                if (versionable instanceof IFolderHandle) continue;
                versionableStates.add(versionable.getStateId().getUuidValue());
            }
        }
        return this.fetchVersionIdentifiers(scmService, versionableStates, repo, config);
    }

    private Map<String, ScmVersionableIdentifier> fetchVersionIdentifiers2(IScmRichClientRestService scmService, ScmComponentFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> versionableStates = new ArrayList<String>(2048);
        for (ScmComponentFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            for (IVersionableHandle versionable : folderEntry.getEntries().values()) {
                if (versionable instanceof IFolderHandle) continue;
                versionableStates.add(versionable.getStateId().getUuidValue());
            }
        }
        return this.fetchVersionIdentifiers(scmService, versionableStates, repo, config);
    }

    private Map<String, ScmVersionableIdentifier> fetchVersionIdentifiers(IScmRichClientRestService scmService, List<String> versionableStates, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService.ParmsGetVersionableIdentifiers parms = new IScmRichClientRestService.ParmsGetVersionableIdentifiers();
        HashMap<String, ScmVersionableIdentifier> results = new HashMap<String, ScmVersionableIdentifier>();
        int batchStart = 0;
        int batchSize = versionableStates.size() > 2048 ? 2048 : versionableStates.size();
        while (batchStart < versionableStates.size()) {
            parms.versionableStateIds = versionableStates.subList(batchStart, batchStart + batchSize).toArray(new String[batchSize]);
            ScmVersionableIdentifierList versionIdentifiers = null;
            try {
                versionIdentifiers = scmService.postGetVersionableIdentifiers(parms);
                for (ScmVersionableIdentifier identifier : versionIdentifiers.getVersionableIdentifiers()) {
                    results.put(identifier.getStateId(), identifier);
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)com.ibm.team.filesystem.cli.core.internal.Messages.RepoUtil_CANNOT_DETERMINE_VERSION_IDS, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            int n = batchSize = (batchStart += batchSize) + 2048 > versionableStates.size() ? versionableStates.size() - batchStart : 2048;
        }
        return results;
    }

    private Map<String, JSONObject> fetchVersionablePermissions(IScmRichClientRestService scmService, String componentId, ScmFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>(2048);
        for (ScmFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            Map entries = folderEntry.getEntries();
            versionables.addAll(entries.values());
        }
        return this.fetchVersionablePermissions(scmService, componentId, versionables, repo, config);
    }

    private Map<String, JSONObject> fetchVersionablePermissions2(IScmRichClientRestService scmService, String componentId, ScmComponentFolderEntryReportList folderReport, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>(2048);
        for (ScmComponentFolderEntryReport folderEntry : folderReport.getFolderEntryReports()) {
            Map entries = folderEntry.getEntries();
            versionables.addAll(entries.values());
        }
        return this.fetchVersionablePermissions(scmService, componentId, versionables, repo, config);
    }

    private Map<String, JSONObject> fetchVersionablePermissions(IScmRichClientRestService scmService, String componentId, List<IVersionableHandle> versionables, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService.ParmsGetVersionablePermissions parms = new IScmRichClientRestService.ParmsGetVersionablePermissions();
        parms.componentId = componentId;
        HashMap<String, JSONObject> results = new HashMap<String, JSONObject>();
        int batchStart = 0;
        int batchSize = versionables.size() > 50 ? 50 : versionables.size();
        while (batchStart < versionables.size()) {
            parms.versionableItemId = new String[batchSize];
            parms.versionableItemType = new String[batchSize];
            parms.versionableItemTypeNamespace = new String[batchSize];
            int idx = 0;
            for (IVersionableHandle handle : versionables.subList(batchStart, batchStart + batchSize)) {
                parms.versionableItemId[idx] = handle.getItemId().getUuidValue();
                parms.versionableItemType[idx] = handle.getItemType().getName();
                parms.versionableItemTypeNamespace[idx] = handle.getItemType().getNamespaceURI();
                ++idx;
            }
            try {
                ScmVersionablePermissionsResult result = scmService.postGetVersionablePermissions(parms);
                for (ScmVersionablePermissionsReport report : result.getReports()) {
                    JSONObject access = null;
                    if (Boolean.valueOf(report.getIsReportOfInaccessible()).booleanValue()) {
                        access = new JSONObject();
                        access.put((Object)READ_ACCESS_TYPE, (Object)Messages.Common_UNKNOWN);
                    } else {
                        access = this.getReadAccess(report.getReadContext(), repo, config);
                    }
                    if (access == null) continue;
                    for (String item : report.getItems()) {
                        results.put(item, access);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)"error", (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            int n = batchSize = (batchStart += batchSize) + 50 > versionables.size() ? versionables.size() - batchStart : 50;
        }
        return results;
    }

    private JSONObject getReadAccess(ScmHandle readContext, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        if (readContext == null) {
            return null;
        }
        String name = this.readContextCache.get(readContext.getItemId());
        if (name == null) {
            IItemType iItemType = IItemType.IRegistry.INSTANCE.getItemType(readContext.getItemType(), readContext.getItemNamespace());
            IAuditableHandle handle = (IAuditableHandle)iItemType.createItemHandle(UUID.valueOf((String)readContext.getItemId()), null);
            name = RepoUtil.getReadAccessContextName((IAuditableHandle)handle, (ITeamRepository)repo, (IScmClientConfiguration)config);
            this.readContextCache.put(readContext.getItemId(), name);
        }
        JSONObject access = new JSONObject();
        access.put((Object)READ_ACCESS_TYPE, (Object)readContext.getItemType());
        access.put((Object)READ_ACCESS_UUID, (Object)readContext.getItemId());
        access.put((Object)READ_ACCESS_NAME, (Object)name);
        return access;
    }

    private String toPath(String[] path, boolean isFolder) {
        return String.valueOf(StringUtil.createPathString((String[])path)) + (isFolder ? Character.valueOf('/') : "");
    }

    private String appendPathSegment(String parent, String child, boolean isFolder) {
        StringBuilder builder = new StringBuilder(parent);
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append(child);
        if (isFolder) {
            builder.append('/');
        }
        return builder.toString();
    }

    private void sortComponentMap() {
        LinkedList<Map.Entry<String, String>> compList = new LinkedList<Map.Entry<String, String>>(this.compMap.entrySet());
        Collections.sort(compList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> c1, Map.Entry<String, String> c2) {
                return c1.getValue().compareTo(c2.getValue());
            }
        });
        LinkedHashMap<String, String> sortedCompMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : compList) {
            sortedCompMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.compMap = sortedCompMap;
    }

    static enum Mode {
        WORKSPACE,
        SNAPSHOT,
        BASELINE;

    }

    static enum VersionMode {
        HIDE,
        SHORT_VERSION,
        LONG_VERSION;

    }
}

