/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.util.IRepositoryRecord;
import com.ibm.team.filesystem.client.util.IRepositoryRegistry;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import org.eclipse.osgi.util.NLS;

public class ListCredentialsCmd
extends AbstractSubcommand
implements IOptionSource {
    public void run() throws FileSystemException {
        IRepositoryRegistry repoReg = this.config.getRepositoryRegistry();
        JSONArray creds = this.jsonizeCreds(repoReg);
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().print((CharSequence)creds.toString());
            return;
        }
        if (creds.size() == 0) {
            return;
        }
        if (this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.ListRepositoriesCmd_0);
        }
        for (Object obj : creds) {
            JSONObject rec = (JSONObject)obj;
            String userName = (String)rec.get((Object)"userName");
            String nick = (String)rec.get((Object)"repoNickName");
            String password = (String)rec.get((Object)"password");
            String certLoc = (String)rec.get((Object)"certLoc");
            String smartCard = (String)rec.get((Object)"smartCard");
            String kerberos = (String)rec.get((Object)"kerberos");
            String integratedWindows = (String)rec.get((Object)"integratedWindows");
            this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListRepositoriesCmd_5, (Object[])new Object[]{rec.get((Object)"url"), userName, nick, certLoc, smartCard, kerberos, integratedWindows, password}));
        }
    }

    JSONArray jsonizeCreds(IRepositoryRegistry repoReg) {
        JSONArray creds = new JSONArray();
        for (IRepositoryRecord rec : repoReg) {
            JSONObject cred = new JSONObject();
            String userName = rec.getUsername();
            if (userName == null) {
                userName = Messages.ListRepositoriesCmd_1;
            }
            cred.put((Object)"userName", (Object)userName);
            String nick = rec.getNickname();
            if (nick == null) {
                nick = Messages.ListRepositoriesCmd_2;
            }
            cred.put((Object)"repoNickName", (Object)nick);
            String password = Messages.ListRepositoriesCmd_3;
            if (rec.getPassword() == null && rec.getPasswordFileLocation() == null) {
                password = Messages.ListRepositoriesCmd_4;
            }
            cred.put((Object)"password", (Object)password);
            String certLoc = rec.getCertficiateLocation();
            if (certLoc == null) {
                certLoc = Messages.ListRepositoriesCmd_NoCertificate;
            }
            cred.put((Object)"certLoc", (Object)certLoc);
            String smartCard = Messages.ListRepositoriesCmd_UseSmartCard;
            if (!rec.isSmartCard()) {
                smartCard = Messages.ListRepositoriesCmd_NoSmartCard;
            }
            cred.put((Object)"smartCard", (Object)smartCard);
            String kerberos = rec.isKerberos() ? Messages.ListCredentialsCmd_0 : Messages.ListCredentialsCmd_1;
            cred.put((Object)"kerberos", (Object)kerberos);
            String integratedWindows = rec.isIntegratedWindows() ? Messages.ListCredentialsCmd_INTEGRATED_WINDOWS : Messages.ListCredentialsCmd_NO_INTEGRATED_WINDOWS;
            cred.put((Object)"integratedWindows", (Object)integratedWindows);
            cred.put((Object)"url", (Object)rec.getUrl());
            if (rec.getUserId() != null) {
                cred.put((Object)"user-id", (Object)rec.getUserId().getUuidValue());
            }
            creds.add((Object)cred);
        }
        return creds;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListRepositoriesCmd_6);
        return opts;
    }
}

