/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListComponentsOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.BatchingPrinter;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentHierarchyDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2List;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryPageDescriptor2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryResult;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.osgi.util.NLS;

public class ListComponentsCmd
extends AbstractSubcommand {
    public static int DEFAULT_MAX_COMPONENTS = 25;

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListComponentsOptions.OPT_SELECTOR, null), (IScmClientConfiguration)this.config);
        boolean isSnapshot = cli.hasOption(CommonOptions.OPT_ISSNAPSHOT);
        boolean isCompName = cli.hasOption(ListComponentsOptions.OPT_NAME_FILTER);
        if (isCompName && selector == null) {
            throw StatusHelper.argSyntax((String)Messages.ListComponentsCmd_SPECIFY_COMP_NAME_NOT_SPECIFIED);
        }
        if (isSnapshot && selector == null) {
            throw StatusHelper.argSyntax((String)Messages.ListComponentsCmd_SNAPSHOT_NOT_SPECIFIED);
        }
        if (isCompName && isSnapshot) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_MUTUALLYEXCLUSIVE_COMPNAME_SNAPSHOT, (Object)cli.getDefinition().getOption(ListComponentsOptions.OPT_NAME_FILTER).getName(), (Object)cli.getDefinition().getOption(CommonOptions.OPT_ISSNAPSHOT).getName()));
        }
        if (cli.hasOption(ListComponentsOptions.OPT_CONTRIB) && (cli.hasOption(ListComponentsOptions.OPT_PROJECTAREA) || cli.hasOption(ListComponentsOptions.OPT_TEAMAREA))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_MUTUALLYEXCLUSIVE_CONTRIB_TEAMAREA_PROJECTAREA, (Object[])new Object[]{cli.getDefinition().getOption(ListComponentsOptions.OPT_CONTRIB).getName(), cli.getDefinition().getOption(ListComponentsOptions.OPT_PROJECTAREA).getName(), cli.getDefinition().getOption(ListComponentsOptions.OPT_TEAMAREA).getName()}));
        }
        if (cli.hasOption(ListComponentsOptions.OPT_PROJECTAREA) && cli.hasOption(ListComponentsOptions.OPT_TEAMAREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption(ListComponentsOptions.OPT_PROJECTAREA).getName(), (Object)cli.getDefinition().getOption(ListComponentsOptions.OPT_TEAMAREA).getName()));
        }
        if ((cli.hasOption(ListComponentsOptions.OPT_CONTRIB) || cli.hasOption(ListComponentsOptions.OPT_PROJECTAREA) || cli.hasOption(ListComponentsOptions.OPT_TEAMAREA)) && selector != null && !isCompName) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_MUTUALLYEXCLUSIVE_SELECTOR_CONTRIB_TEAMAREA_PROJECTAREA, (Object[])new Object[]{cli.getDefinition().getOption(ListComponentsOptions.OPT_CONTRIB).getName(), cli.getDefinition().getOption(ListComponentsOptions.OPT_PROJECTAREA).getName(), cli.getDefinition().getOption(ListComponentsOptions.OPT_TEAMAREA).getName()}));
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        repo = selector == null || isCompName ? RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client) : RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        if (isSnapshot) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            this.listComponentsForSnapshot(repo, client, cli, (IScmCommandLineArgument)selector, this.config, verbose);
        } else if (isCompName && selector != null) {
            this.listComponentsInRepo(selector.getItemSelector(), repo, cli, client, this.config, verbose);
        } else if (selector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            ListComponentsCmd.listComponentsForWorkspace(repo, client, cli, (IScmCommandLineArgument)selector, this.config, verbose);
        } else {
            this.listComponentsInRepo("", repo, cli, client, this.config, verbose);
        }
    }

    private void listComponentsForSnapshot(ITeamRepository repo, IFilesystemRestClient client, ICommandLine cli, IScmCommandLineArgument selector, IScmClientConfiguration config, boolean verbose) throws FileSystemException {
        IBaselineSet baselineSet = RepoUtil.getSnapshot(null, (String)selector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        int maxResults = cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) ? Integer.MAX_VALUE : RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)DEFAULT_MAX_COMPONENTS);
        ArrayList<String> blIdList = new ArrayList<String>(baselineSet.getBaselines().size());
        boolean hasMore = false;
        for (IBaselineHandle baselineHandle : baselineSet.getBaselines()) {
            if (blIdList.size() >= maxResults) {
                hasMore = true;
                break;
            }
            blIdList.add(baselineHandle.getItemId().getUuidValue());
        }
        List blDTOList = RepoUtil.getBaselinesById(blIdList, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        HashMap<String, BaselineDTO> componentToBaseline = new HashMap<String, BaselineDTO>();
        for (BaselineDTO baselineDTO : blDTOList) {
            componentToBaseline.put(baselineDTO.getComponentItemId(), baselineDTO);
        }
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IScmRichClientRestService.ParmsGetComponents parmsGetComps = new IScmRichClientRestService.ParmsGetComponents();
        int numComponents = componentToBaseline.keySet().size();
        String[] componentIdArray = componentToBaseline.keySet().toArray(new String[numComponents]);
        ArrayList components = new ArrayList(numComponents);
        try {
            int index = 0;
            while (index < numComponents) {
                parmsGetComps.componentItemIds = Arrays.copyOfRange(componentIdArray, index, index + 512);
                ScmComponent2List componentList = scmService.postGetComponents2(parmsGetComps);
                components.addAll(componentList.getComponents());
                index += 512;
            }
            Collections.sort(components, (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.Common_COMPS_NOT_FOUND, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        BatchingPrinter.BatchProvider provider = BatchingPrinter.BatchProvider.fromList(components);
        IndentingPrintStream indented = config.getWrappedOutputStream().indent();
        BatchingPrinter printer = new BatchingPrinter(config, json -> this.printComponent((JSONObject)json, indented));
        if (numComponents == 0 && !config.isJSONEnabled()) {
            printer.printMessage(Messages.ListComponentsCmd_NO_COMPONENTS_FOUND);
            return;
        }
        JSONObject snapshot = JSONPrintUtil.jsonize((String)baselineSet.getName(), (String)baselineSet.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
        printer.beginObject(NLS.bind((String)Messages.ListComponentsCmd_Snapshot, (Object)this.getAlias(snapshot, RepoUtil.ItemType.SNAPSHOT)));
        printer.printJSONEntries(snapshot);
        printer.printList("components", provider.map(this.jsonizer(componentToBaseline, repo)));
        printer.end();
        if (hasMore && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) {
            printer.printMessage(NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
        }
    }

    private String getAlias(JSONObject json, RepoUtil.ItemType type) {
        return AliasUtil.selector((String)((String)json.get((Object)"name")), (UUID)UUID.valueOf((String)((String)json.get((Object)"uuid"))), (String)((String)json.get((Object)"url")), (RepoUtil.ItemType)type);
    }

    private Function<ScmComponent2, JSONObject> jsonizer(Map<String, BaselineDTO> componentToBaseline, ITeamRepository repo) {
        return component -> {
            JSONObject comp = JSONPrintUtil.jsonize((String)component.getName(), (String)component.getItemId(), (String)repo.getRepositoryURI());
            if (componentToBaseline != null && componentToBaseline.containsKey(component.getItemId())) {
                BaselineDTO baseline = (BaselineDTO)componentToBaseline.get(component.getItemId());
                JSONObject bl = JSONPrintUtil.jsonize((int)baseline.getId(), (String)baseline.getName(), (String)baseline.getItemId(), (String)repo.getRepositoryURI());
                comp.put((Object)"baseline", (Object)bl);
            }
            return comp;
        };
    }

    private void printComponent(JSONObject comp, IndentingPrintStream componentPS) {
        IndentingPrintStream baselinePS = componentPS.indent();
        componentPS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_Component, (Object)this.getAlias(comp, RepoUtil.ItemType.COMPONENT)));
        JSONObject bl = (JSONObject)comp.get((Object)"baseline");
        if (bl != null) {
            baselinePS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_Baseline, (Object)this.getAlias(bl, RepoUtil.ItemType.BASELINE)));
        }
    }

    private static void listComponentsForWorkspace(ITeamRepository repo, IFilesystemRestClient client, ICommandLine cli, IScmCommandLineArgument wsSelector, IScmClientConfiguration config, boolean verbose) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(38);
        options.enablePrinter(24);
        options.enablePrinter(25);
        options.setShowOutTargetLockedContributor(true);
        if (verbose) {
            options.enablePrinter(11);
        }
        int maxResults = cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) ? Integer.MAX_VALUE : RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)DEFAULT_MAX_COMPONENTS);
        options.setMaxComponents(maxResults);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
        options.isInFilter(wsFound.getItemId(), 0);
        WorkspaceDetailsDTO wsDetails = ListComponentsCmd.getWorkspaceDetails(repo, wsFound, client, config);
        IndentingPrintStream printStream = config.getWrappedOutputStream();
        if (wsDetails.getComponents().size() == 0 && !config.isJSONEnabled()) {
            printStream.println((CharSequence)Messages.ListComponentsCmd_NO_COMPONENTS_FOUND);
            return;
        }
        WorkspaceDetailsDTO wsIncomingFlowDetails = RepoUtil.getFlowTargetDetails((WorkspaceDetailsDTO)wsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.INCOMING, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        WorkspaceDetailsDTO wsOutgoingFlowDetails = RepoUtil.getFlowTargetDetails((WorkspaceDetailsDTO)wsDetails, (RepoUtil.FlowType)RepoUtil.FlowType.OUTGOING, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        JSONObject workspaceJson = JSONPrintUtil.jsonizeWorkspace((WorkspaceDetailsDTO)wsDetails, (WorkspaceDetailsDTO)wsIncomingFlowDetails, (WorkspaceDetailsDTO)wsOutgoingFlowDetails, (ITeamRepository)repo, (PendingChangesUtil.PendingChangesOptions)options);
        JSONArray wses = new JSONArray();
        if (workspaceJson.size() > 0) {
            wses.add((Object)workspaceJson);
        }
        if (config.isJSONEnabled()) {
            JSONObject root = new JSONObject();
            root.put((Object)"workspaces", (Object)wses);
            config.getOutputStream().print((CharSequence)root.toString());
        } else {
            PendingChangesUtil.printWorkspaces((JSONArray)wses, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)printStream);
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && ListComponentsCmd.hasMoreComponents(wsDetails, maxResults, options)) {
                printStream.println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
            }
        }
    }

    private static boolean hasMoreComponents(WorkspaceDetailsDTO workspace, int max, PendingChangesUtil.PendingChangesOptions options) {
        int sum = 0;
        List componentDtos = workspace.getComponents();
        if (componentDtos.size() >= max) {
            return true;
        }
        ArrayList componentHierarchyDtos = workspace.getComponentHierarchies();
        if (options.isPrinterEnabled(38)) {
            componentHierarchyDtos = new ArrayList(componentHierarchyDtos);
            for (ComponentHierarchyDTO componentHieararchyDto : componentHierarchyDtos) {
                if (!options.isInFilter(UUID.valueOf((String)componentHieararchyDto.getComponentItemId()), 1) || !componentHieararchyDto.isRoot()) continue;
                if (sum >= max) {
                    return true;
                }
                ++sum;
            }
        } else {
            for (WorkspaceComponentDTO componentDto : componentDtos) {
                if (!options.isInFilter(UUID.valueOf((String)componentDto.getItemId()), 1)) continue;
                if (sum >= max) {
                    return true;
                }
                ++sum;
            }
        }
        return sum >= max;
    }

    private static WorkspaceDetailsDTO getWorkspaceDetails(ITeamRepository repo, IWorkspace wsFound, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsGetWorkspace parms = new ParmsGetWorkspace();
        parms.includeComponents = true;
        parms.includeComponentHierarchy = true;
        parms.includeFlowTargets = true;
        parms.refresh = true;
        parms.workspace = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        ParmsGetWorkspace[] workspaces = new ParmsGetWorkspace[]{parms};
        List workspaceDetailsDtos = RepoUtil.getWorkspaceDetails((ParmsGetWorkspace[])workspaces, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)workspaceDetailsDtos.get(0);
        return wsDetails;
    }

    private void listComponentsInRepo(String compName, ITeamRepository repo, ICommandLine cli, IFilesystemRestClient client, IScmClientConfiguration config, boolean verbose) throws FileSystemException {
        String projectAreaSelector = cli.getOption(ListComponentsOptions.OPT_PROJECTAREA, null);
        String teamAreaSelector = cli.getOption(ListComponentsOptions.OPT_TEAMAREA, null);
        String contribName = cli.getOption(ListComponentsOptions.OPT_CONTRIB, null);
        IProjectArea projectArea = null;
        if (projectAreaSelector != null && projectAreaSelector.length() != 0 && (projectArea = RepoUtil.getProjectArea((ITeamRepository)repo, (String)projectAreaSelector, (IScmClientConfiguration)config)) == null) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projectAreaSelector), null);
        }
        IContributor contributor = null;
        if (contribName != null && contribName.length() > 0 && (contributor = RepoUtil.fetchContributor((String)contribName, (ITeamRepository)repo, (IScmClientConfiguration)config)) == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contribName, (Object)repo.getRepositoryURI()));
        }
        ITeamArea teamArea = RepoUtil.getTeamArea((String)teamAreaSelector, (IProjectArea)projectArea, (IScmClientConfiguration)config, (ITeamRepository)repo);
        if (teamArea == null && teamAreaSelector != null) {
            config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.ListCmd_TeamAreaNotFound, (Object)teamAreaSelector));
            return;
        }
        this.listComponentsByName(compName, projectArea, teamArea, contributor, client, repo, config, verbose, cli);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void listComponentsByName(String compName, IProjectArea projectArea, ITeamArea teamArea, IContributor contributor, IFilesystemRestClient client, final ITeamRepository repo, final IScmClientConfiguration config, boolean verbose, ICommandLine cli) throws FileSystemException {
        void var13_17;
        final int maxResults = cli.hasOption((IOptionKey)CommonOptions.OPT_ALL) ? Integer.MAX_VALUE : RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)DEFAULT_MAX_COMPONENTS);
        final IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        ArrayList<String> criteria = new ArrayList<String>();
        Object var13_13 = null;
        if (teamArea != null) {
            ITeamArea iTeamArea = teamArea;
        } else if (contributor != null) {
            IContributor iContributor = contributor;
        } else {
            IProjectArea iProjectArea = projectArea;
        }
        if (var13_17 != null) {
            criteria.add("Owner:" + var13_17.getItemType().getNamespaceURI() + "\n" + var13_17.getItemType().getName() + "\n" + var13_17.getItemId().getUuidValue());
        }
        if (cli.hasOption((IOptionKey)ListComponentsOptions.OPT_VISIBILITY)) {
            ScmCommandLineArgument value;
            ICommandLineArgument visibility = cli.getOptionValue((IOptionKey)ListComponentsOptions.OPT_VISIBILITY);
            if (visibility.getValue().equalsIgnoreCase("public")) {
                criteria.add("ReadScope:public_scope");
            } else if (visibility.getValue().equalsIgnoreCase("private")) {
                criteria.add("ReadScope:private_scope");
            } else if (visibility.getValue().equalsIgnoreCase("archived")) {
                criteria.add("ReadScope:archived_scope");
            } else if (visibility.getValue().equalsIgnoreCase("teamarea")) {
                if (cli.hasOption((IOptionKey)ListComponentsOptions.OPT_PROCESSAREA)) {
                    value = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListComponentsOptions.OPT_PROCESSAREA), (IScmClientConfiguration)config);
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)value, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
                    ITeamArea context = RepoUtil.getTeamArea((String)value.getItemSelector(), null, (IScmClientConfiguration)config, (ITeamRepository)repo);
                    if (context == null) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.QueryBuilder_NoSuchTeamArea, (Object)value.getItemSelector()));
                    criteria.add("ReadScope:team_area_private_scope\n" + context.getItemId().getUuidValue() + "\n" + context.getItemType().getNamespaceURI() + "\n" + context.getItemType().getName());
                } else {
                    criteria.add("ReadScope:team_area_private_scope");
                }
            } else if (visibility.getValue().equalsIgnoreCase("projectarea")) {
                IProjectArea context = null;
                if (cli.hasOption((IOptionKey)ListComponentsOptions.OPT_PROCESSAREA)) {
                    ScmCommandLineArgument value2 = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListComponentsOptions.OPT_PROCESSAREA), (IScmClientConfiguration)config);
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)value2, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                    context = (IProjectArea)RepoUtil.getProcessArea((IScmCommandLineArgument)value2, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    criteria.add("ReadScope:deferring_project\n" + context.getItemId().getUuidValue() + "\n" + context.getItemType().getNamespaceURI() + "\n" + context.getItemType().getName());
                } else {
                    criteria.add("ReadScope:deferring_project");
                }
            } else if (visibility.getValue().equalsIgnoreCase("accessgroup")) {
                if (cli.hasOption((IOptionKey)ListComponentsOptions.OPT_ACCESSGROUP)) {
                    value = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListComponentsOptions.OPT_ACCESSGROUP), (IScmClientConfiguration)config);
                    SubcommandUtil.validateArgument((IScmCommandLineArgument)value, (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP);
                    IAccessGroup accessGroup = RepoUtil.getAccessGroup((IScmCommandLineArgument)value, (ITeamRepository)repo, (IScmClientConfiguration)config);
                    if (accessGroup == null) throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.WorkspacePropertiesCmd_INVALID_ACCESS_GROUP, (Object)value.getItemSelector()));
                    criteria.add("ReadScope:access_group_scope\n" + accessGroup.getGroupContextId().getUuidValue());
                } else {
                    criteria.add("ReadScope:access_group_scope");
                }
            }
        }
        if (compName != null && !compName.isEmpty()) {
            criteria.add("Name:partial\n" + compName);
        }
        final IScmRichClientRestService.ParmsRunQuery parms = new IScmRichClientRestService.ParmsRunQuery();
        parms.resultType = String.valueOf(IComponent.ITEM_TYPE.getNamespaceURI()) + "." + IComponent.ITEM_TYPE.getName();
        parms.criteria = criteria.toArray(new String[criteria.size()]);
        parms.pageToken = "";
        parms.handlesOnly = false;
        parms.alphabetical = true;
        BatchingPrinter.BatchProvider<ScmComponent2> provider = new BatchingPrinter.BatchProvider<ScmComponent2>(){
            int count = 0;

            public List<ScmComponent2> nextBatch() throws FileSystemException {
                if (parms.pageToken == null || this.count >= maxResults) {
                    return Collections.emptyList();
                }
                try {
                    parms.maxResultSize = Math.min(512, maxResults - this.count);
                    ScmItemQueryResult result = scmService.postRunQuery(parms);
                    ScmItemQueryPageDescriptor2 nextPage = (ScmItemQueryPageDescriptor2)result.getNextPage();
                    parms.pageToken = nextPage != null ? nextPage.getPageToken() : null;
                    this.count += result.getItems().size();
                    return result.getItems();
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)Messages.Common_COMPS_NOT_FOUND, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                }
            }

            public boolean hasMore() {
                return parms.pageToken != null;
            }
        };
        IndentingPrintStream printStream = config.getWrappedOutputStream();
        BatchingPrinter printer = new BatchingPrinter(config, json -> this.printAllComponents((JSONObject)json, printStream));
        try {
            printer.setNotFoundMessage(Messages.ListComponentsCmd_NO_COMPONENTS_FOUND);
            printer.beginObject();
            printer.printList("components", provider.map(this.jsonizerAllComponent(repo)));
        }
        finally {
            printer.end();
        }
        if (!provider.hasMore() || config.isJSONEnabled() || cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) return;
        printer.printMessage(NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)CommonOptions.OPT_MAXRESULTS.getName()));
    }

    private Function<ScmComponent2, JSONObject> jsonizerAllComponent(ITeamRepository repo) {
        return component -> {
            JSONObject comp = null;
            try {
                comp = JSONPrintUtil.jsonizeComponent((String)component.getName(), (String)component.getItemId(), (String)repo.getRepositoryURI(), (String)RepoUtil.getOwnerName((String)component.getOwner().getItemId(), (String)component.getOwner().getItemType(), (ITeamRepository)repo, (IScmClientConfiguration)this.config));
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            return comp;
        };
    }

    private void printAllComponents(JSONObject comp, IndentingPrintStream componentPS) {
        componentPS.println((CharSequence)NLS.bind((String)Messages.ListComponentsCmd_AllComponent, (Object)AliasUtil.selector((String)((String)comp.get((Object)"name")), (UUID)UUID.valueOf((String)((String)comp.get((Object)"uuid"))), (String)((String)comp.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object)((String)comp.get((Object)"owner"))));
    }
}

