/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListCmdContribOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListDeletedOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListStreamsOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListWorkspacesOptions;
import com.ibm.team.filesystem.cli.client.internal.listcommand.WorkspacePrinter;
import com.ibm.team.filesystem.cli.client.internal.subcommands.OperationsCmdLabelGenerator;
import com.ibm.team.filesystem.cli.core.CommandLineCore;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistory;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistoryEntry;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceList;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListCmd
extends AbstractSubcommand {
    private static final String LIST_PROJECT_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-projectareas";
    private static final String LIST_TEAM_AREAS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-teamareas";
    private static final String LIST_STREAMS_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-streams";
    private static final String LIST_WORKSPACES_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-workspaces";
    private static final String LIST_DELETED_ID = "com.ibm.team.filesystem.cli.client.list/com.ibm.team.filesystem.cli.client.list-deleted";

    public void run() throws FileSystemException {
        String id;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        ConnectionInfo connection = this.config.getConnectionInfo();
        if (subargs.hasOption((IOptionKey)ListCmdOptions.OPT_PROJECTAREA) && subargs.hasOption(ListStreamsOptions.OPT_TEAMAREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)subargs.getDefinition().getOption((IOptionKey)ListCmdOptions.OPT_PROJECTAREA).getName(), (Object)subargs.getDefinition().getOption(ListStreamsOptions.OPT_TEAMAREA).getName()));
        }
        boolean verbose = subargs.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        String contribName = null;
        if (subargs.hasOption(ListCmdContribOptions.OPT_CONTRIB)) {
            ScmCommandLineArgument contributorSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(ListCmdContribOptions.OPT_CONTRIB), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)contributorSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR);
            contribName = contributorSelector.getItemSelector();
        }
        if (LIST_PROJECT_AREAS_ID.equals(id = this.config.getSubcommandDefinition().getId())) {
            this.listProjectAreas(this.config, client, connection, verbose);
        } else if (LIST_TEAM_AREAS_ID.equals(id)) {
            this.listTeamAreas(this.config, client, connection, contribName, verbose, subargs);
        } else if (LIST_STREAMS_ID.equals(id) || LIST_WORKSPACES_ID.equals(id)) {
            this.listWorkspaces(this.config, client, connection, contribName, LIST_WORKSPACES_ID.equals(id), verbose, subargs);
        } else if (LIST_DELETED_ID.equals(id)) {
            this.listDeleted(this.config, client, connection, verbose, subargs);
        } else {
            throw StatusHelper.configurationFailure((String)NLS.bind((String)Messages.ListCmd_1, (Object)id));
        }
    }

    private void listProjectAreas(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, boolean verbose) throws FileSystemException {
        JSONArray jProjAreas = this.jsonizeProjectAreas(config, client, connection, verbose);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jProjAreas.toString());
            return;
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (jProjAreas.size() == 0) {
            out.println((CharSequence)Messages.ListCmd_NO_PROJECT_AREAS_FOUND);
            return;
        }
        for (Object obj : jProjAreas) {
            JSONObject jProjArea = (JSONObject)obj;
            out.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jProjArea.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jProjArea.get((Object)"uuid"))), (String)((String)jProjArea.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA));
            JSONArray jTeamAreas = (JSONArray)jProjArea.get((Object)"team-areas");
            if (jTeamAreas == null) continue;
            for (Object jobj : jTeamAreas) {
                JSONObject jTeamArea = (JSONObject)jobj;
                out.indent().println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jTeamArea.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jTeamArea.get((Object)"uuid"))), (String)((String)jTeamArea.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA));
            }
        }
    }

    private JSONArray jsonizeProjectAreas(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, boolean verbose) throws FileSystemException {
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        List projectAreas = RepoUtil.findProjectAreas((ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONArray jProjAreas = new JSONArray();
        for (IProjectArea projectArea : projectAreas) {
            JSONObject jProjArea = JSONPrintUtil.jsonize((String)projectArea.getName(), (String)projectArea.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
            if (verbose) {
                List teamAreas;
                try {
                    teamAreas = repo.itemManager().fetchPartialItems(projectArea.getTeamAreas(), 0, Collections.singletonList("name"), null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListCmd_4, (Object)projectArea.getName()), (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                }
                JSONArray jTeamAreas = new JSONArray();
                for (ITeamArea teamArea : teamAreas) {
                    JSONObject jTeamArea = JSONPrintUtil.jsonize((String)teamArea.getName(), (String)teamArea.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
                    jTeamAreas.add((Object)jTeamArea);
                }
                if (jTeamAreas.size() > 0) {
                    jProjArea.put((Object)"team-areas", (Object)jTeamAreas);
                }
            }
            jProjAreas.add((Object)jProjArea);
        }
        return jProjAreas;
    }

    private void listTeamAreas(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, String contribId, boolean verbose, ICommandLine subargs) throws FileSystemException {
        JSONArray jTeamAreas = this.jsonizeTeamAreas(config, client, connection, contribId, verbose, subargs);
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jTeamAreas.toString());
            return;
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        if (jTeamAreas.size() == 0) {
            out.println((CharSequence)Messages.ListCmd_NO_TEAM_AREAS_FOUND);
            return;
        }
        for (Object obj : jTeamAreas) {
            JSONObject jTeamArea = (JSONObject)obj;
            String teamArea = AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jTeamArea.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jTeamArea.get((Object)"uuid"))), (String)((String)jTeamArea.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
            if (verbose) {
                JSONObject jProjArea = (JSONObject)jTeamArea.get((Object)"project-area");
                String projectArea = AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jProjArea.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jProjArea.get((Object)"uuid"))), (String)((String)jProjArea.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                out.println((CharSequence)NLS.bind((String)Messages.PreferenceListCmd_Value_Units, (Object)teamArea, (Object)projectArea));
                continue;
            }
            out.println((CharSequence)teamArea);
        }
    }

    private JSONArray jsonizeTeamAreas(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, String contribId, boolean verbose, ICommandLine subargs) throws FileSystemException {
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        IProjectArea projectAreaInput = this.getProjectArea(subargs, repo);
        List projectAreas = projectAreaInput != null ? Collections.singletonList(projectAreaInput) : RepoUtil.findProjectAreas((ITeamRepository)repo, (IScmClientConfiguration)config);
        JSONArray jTeamAreas = new JSONArray();
        IContributor currentContributor = null;
        JSONObject jProjArea = null;
        int maxResults = 0;
        int teamAreaCount = 0;
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) {
            maxResults = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
        }
        block0: for (IProjectArea projectArea : projectAreas) {
            if (verbose) {
                jProjArea = JSONPrintUtil.jsonize((String)projectArea.getName(), (String)projectArea.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
            }
            List teamAreas = new ArrayList();
            if (subargs.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && teamAreaCount >= maxResults) break;
            if (contribId == null) {
                teamAreas = RepoUtil.findTeamAreas((IScmClientConfiguration)config, (IProjectArea)projectArea, (ITeamRepository)repo);
            } else {
                if (currentContributor == null && (currentContributor = RepoUtil.fetchContributor((String)contribId, (ITeamRepository)repo, (IScmClientConfiguration)config)) == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contribId, (Object)repo.getRepositoryURI()));
                }
                teamAreas = RepoUtil.findTeamAreas((IScmClientConfiguration)config, (IProjectArea)projectArea, (IContributor)currentContributor, (ITeamRepository)repo);
            }
            for (ITeamArea teamArea : teamAreas) {
                if (subargs.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS)) {
                    if (teamAreaCount >= maxResults) continue block0;
                    ++teamAreaCount;
                }
                JSONObject jTeamArea = JSONPrintUtil.jsonize((String)teamArea.getName(), (String)teamArea.getItemId().getUuidValue(), (String)repo.getRepositoryURI());
                if (verbose) {
                    jTeamArea.put((Object)"project-area", (Object)jProjArea);
                }
                jTeamAreas.add((Object)jTeamArea);
            }
        }
        return jTeamAreas;
    }

    private void listWorkspaces(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, String contribName, boolean fetchWorkspace, boolean verbose, ICommandLine subargs) throws FileSystemException {
        if (subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP) && subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmd_MUTUALLYEXCLUSIVE_CONTRIB_TEAMAREA, (Object)subargs.getDefinition().getOption((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP).getName(), (Object)subargs.getDefinition().getOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA).getName()));
        }
        if ((subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP) || subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA)) && !subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_VISIBILITY)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmd_DEPENDENT_OPTIONS, (Object[])new String[]{subargs.getDefinition().getOption((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP).getName(), subargs.getDefinition().getOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA).getName(), subargs.getDefinition().getOption((IOptionKey)ListStreamsOptions.OPT_VISIBILITY).getName()}));
        }
        String teamAreaName = null;
        if (subargs.hasOption(ListStreamsOptions.OPT_TEAMAREA)) {
            if (subargs.hasOption(ListCmdContribOptions.OPT_CONTRIB)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmd_MUTUALLYEXCLUSIVE_CONTRIB_TEAMAREA, (Object)subargs.getDefinition().getOption(ListCmdContribOptions.OPT_CONTRIB).getName(), (Object)subargs.getDefinition().getOption(ListStreamsOptions.OPT_TEAMAREA).getName()));
            }
            ScmCommandLineArgument taSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(ListStreamsOptions.OPT_TEAMAREA), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)taSelector, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
            teamAreaName = taSelector.getItemSelector();
        }
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        IProjectArea projectArea = this.getProjectArea(subargs, repo);
        IContributor contributor = null;
        if (contribName != null && contribName.length() > 0 && (contributor = RepoUtil.fetchContributor((String)contribName, (ITeamRepository)repo, (IScmClientConfiguration)config)) == null) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contribName, (Object)repo.getRepositoryURI()));
        }
        ITeamArea teamArea = RepoUtil.getTeamArea((String)teamAreaName, (IProjectArea)projectArea, (IScmClientConfiguration)config, (ITeamRepository)repo);
        if (teamArea == null && teamAreaName != null) {
            config.getWrappedErrorStream().println((CharSequence)NLS.bind((String)Messages.ListCmd_TeamAreaNotFound, (Object)teamAreaName));
            return;
        }
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        boolean hasMoreItems = false;
        ArrayList<ScmWorkspace> workspaces = new ArrayList<ScmWorkspace>();
        hasMoreItems = this.getWorkspaces(projectArea, teamArea, contributor, scmService, fetchWorkspace, workspaces, subargs, repo, config);
        WorkspacePrinter workspacePrinter = new WorkspacePrinter(config, repo, verbose);
        workspacePrinter.setWorspacesOnly(fetchWorkspace);
        workspacePrinter.setStreamsOnly(!fetchWorkspace);
        workspacePrinter.printWorkspaces(workspaces, repo, hasMoreItems);
    }

    private void listDeleted(IScmClientConfiguration config, IFilesystemRestClient client, ConnectionInfo connection, boolean verbose, ICommandLine subargs) throws FileSystemException {
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        IContributor contributor = null;
        if (subargs.hasOption((IOptionKey)ListDeletedOptions.OPT_DELETED_BY)) {
            ScmCommandLineArgument contributorSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ListDeletedOptions.OPT_DELETED_BY), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)contributorSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR);
            contributor = RepoUtil.fetchContributor((String)contributorSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (contributor == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)contributorSelector.getItemSelector(), (Object)repo.getRepositoryURI()));
            }
        }
        IComponent component = null;
        if (subargs.hasOption((IOptionKey)ListDeletedOptions.OPT_COMPONENT_SELECTOR)) {
            ScmCommandLineArgument selector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ListDeletedOptions.OPT_COMPONENT_SELECTOR), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)selector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            component = RepoUtil.getComponent((String)selector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (component == null) {
                throw StatusHelper.argSyntax((String)Messages.Common_UNIQUE_LOADED_COMP);
            }
        }
        IScmRichClientRestService.ParmsDeletedWorkspaces parms = new IScmRichClientRestService.ParmsDeletedWorkspaces();
        parms.deletedAfter = SubcommandUtil.getTimeArgument((ICommandLine)subargs, (IOptionKey)ListDeletedOptions.OPT_AFTER, (boolean)false, (IScmClientConfiguration)config);
        parms.deletedBefore = SubcommandUtil.getTimeArgument((ICommandLine)subargs, (IOptionKey)ListDeletedOptions.OPT_BEFORE, (boolean)true, (IScmClientConfiguration)config);
        parms.contributorId = contributor != null ? contributor.getItemId().getUuidValue() : null;
        parms.componentItemId = component != null ? component.getItemId().getUuidValue() : null;
        try {
            ScmWorkspaceHistory workspaceHistory;
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            int MAX_PAGE_SIZE = 512;
            int entriesToFetch = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
            String nextPage = null;
            ArrayList<ScmWorkspaceHistoryEntry> historyEntries = new ArrayList<ScmWorkspaceHistoryEntry>();
            do {
                parms.pageSize = Math.min(entriesToFetch, 512);
                parms.pageToken = nextPage;
                workspaceHistory = scmService.postFindDeletedWorkspaces(parms);
                historyEntries.addAll(workspaceHistory.getHistoryEntries());
            } while ((nextPage = workspaceHistory.getNextPage()) != null && (entriesToFetch -= 512) > 0);
            IndentingPrintStream printStream = config.getWrappedOutputStream();
            this.printDeletedWorkspaces(historyEntries, nextPage, printStream.indent(), repo);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        parms.pageSize = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
    }

    private void printDeletedWorkspaces(List<ScmWorkspaceHistoryEntry> historyEntries, String nextPage, IndentingPrintStream printStream, ITeamRepository repo) {
        PendingChangesUtil.PendingChangesOptions printOptions = new PendingChangesUtil.PendingChangesOptions();
        printOptions.setDateFormat(new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss a"));
        if (this.config.isJSONEnabled()) {
            JSONObject workspaceHistoryJson = JSONPrintUtil.jsonizeWorkspaceHistory(historyEntries, null, (String)nextPage, (PendingChangesUtil.PendingChangesOptions)printOptions, (ITeamRepository)repo);
            JSONObject root = new JSONObject();
            root.put((Object)"workspace_history", (Object)workspaceHistoryJson);
            this.config.getOutputStream().print((CharSequence)root.toString());
        } else {
            for (ScmWorkspaceHistoryEntry historyEntry : historyEntries) {
                String operation = OperationsCmdLabelGenerator.getLabel(historyEntry.getOperation(), historyEntry.getDetails(), historyEntry.getAffectedComponentCount(), printOptions);
                String date = printOptions.getDateFormat().format(new Date(historyEntry.getDate()));
                String operationAlias = AliasUtil.alias((AliasUtil.IAliasOptions)((ScmClientConfiguration)CommandLineCore.getConfig()), (String)historyEntry.getWorkspaceComponentStateId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE_COMPONENT_STATE);
                String message = NLS.bind((String)Messages.OperationsCmd_OPERATION_LABEL, (Object[])new String[]{operationAlias, operation, historyEntry.getContributor().getName(), date});
                printStream.println((CharSequence)message);
            }
        }
    }

    private IProjectArea getProjectArea(ICommandLine subargs, ITeamRepository repo) throws FileSystemException {
        IProjectArea projectArea = null;
        if (subargs.hasOption((IOptionKey)ListCmdOptions.OPT_PROJECTAREA)) {
            ScmCommandLineArgument paSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(ListCmdOptions.OPT_PROJECTAREA.getId()), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)paSelector, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
            String projectAreaInput = paSelector.getItemSelector();
            projectArea = RepoUtil.getProjectArea((ITeamRepository)repo, (String)projectAreaInput, (IScmClientConfiguration)this.config);
            if (projectArea == null) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projectAreaInput), null);
            }
        }
        return projectArea;
    }

    private boolean getWorkspaces(IProjectArea projectArea, ITeamArea teamArea, IContributor contributor, IScmRichClientRestService scmService, boolean fetchWorkspace, List<ScmWorkspace> workspaces, ICommandLine subargs, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        String nameSelector;
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)subargs);
        if (maxResults == Integer.MAX_VALUE) {
            --maxResults;
        }
        IScmRichClientRestService.ParmsSearchWorkspaces parms = new IScmRichClientRestService.ParmsSearchWorkspaces();
        parms.workspaceKind = fetchWorkspace ? "workspaces" : "streams";
        parms.maxResultSize = maxResults;
        parms.includeLockOwner = true;
        if (subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_COMPONENT)) {
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue((IOptionKey)ListStreamsOptions.OPT_COMPONENT), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            IComponent component = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            parms.componentItemId = component.getItemId().getUuidValue();
        }
        ArrayList<Object> owners = new ArrayList<Object>();
        if (projectArea != null) {
            owners.add(projectArea);
            owners.addAll(projectArea.getTeamAreas());
        }
        if (teamArea != null) {
            owners.add(teamArea);
        }
        if (contributor != null) {
            owners.add(contributor);
        }
        if (!owners.isEmpty()) {
            parms.ownerItemId = new String[owners.size()];
            parms.ownerType = new String[owners.size()];
            int i = 0;
            while (i < owners.size()) {
                IAuditableHandle handle = (IAuditableHandle)owners.get(i);
                parms.ownerItemId[i] = handle.getItemId().getUuidValue();
                parms.ownerType[i] = IProjectArea.ITEM_TYPE.equals(handle.getItemType()) ? "projectarea" : (ITeamArea.ITEM_TYPE.equals(handle.getItemType()) ? "teamarea" : "contributor");
                ++i;
            }
        }
        if (subargs.hasOption(ListWorkspacesOptions.OPT_NAME_FILTER) && (nameSelector = subargs.getOption(ListWorkspacesOptions.OPT_NAME_FILTER, null)) != null && nameSelector.length() > 0) {
            parms.workspaceName = nameSelector;
            parms.workspaceNameKind = "partial ignorecase";
        }
        if (subargs.hasOption((IOptionKey)ListStreamsOptions.OPT_VISIBILITY)) {
            this.setVisibilityOptions(parms, subargs, fetchWorkspace, repo);
        }
        int MAX_PAGE_SIZE = 512;
        long pageTime = System.currentTimeMillis() + 3600000L;
        while (pageTime > 0L) {
            int pageSize;
            parms.maxResultSize = pageSize = Math.min(maxResults - workspaces.size() + 1, 512);
            parms.modifiedBefore = pageTime;
            List batchResults = null;
            try {
                ScmWorkspaceList result = scmService.postSearchWorkspaces(parms);
                batchResults = result.getWorkspaces();
                workspaces.addAll(batchResults);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.ListCmd_10, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (workspaces.size() >= maxResults || batchResults.size() < pageSize) {
                if (workspaces.size() > maxResults) {
                    workspaces.remove(workspaces.size() - 1);
                    return true;
                }
                return false;
            }
            ScmWorkspace lastWorkspace = (ScmWorkspace)batchResults.get(batchResults.size() - 1);
            long newPageTime = lastWorkspace.getDateModified().getTime();
            if (newPageTime >= pageTime) {
                config.getWrappedErrorStream().println((CharSequence)Messages.ListCmd_UnexpectedPagingError);
                return false;
            }
            pageTime = newPageTime;
        }
        return false;
    }

    private void setVisibilityOptions(IScmRichClientRestService.ParmsSearchWorkspaces parms, ICommandLine cli, boolean isWorkspace, ITeamRepository repo) throws FileSystemException {
        ScmCommandLineArgument value;
        ICommandLineArgument visibility = cli.getOptionValue((IOptionKey)ListStreamsOptions.OPT_VISIBILITY);
        if (visibility.getValue().equalsIgnoreCase("public")) {
            parms.readScopeType = new String[]{"public_scope"};
        } else if (visibility.getValue().equalsIgnoreCase("private")) {
            parms.readScopeType = new String[]{"private_scope"};
        } else if (visibility.getValue().equalsIgnoreCase("archived")) {
            parms.readScopeType = new String[]{"archived_scope"};
        } else if (visibility.getValue().equalsIgnoreCase("teamarea")) {
            parms.readScopeType = new String[]{"team_area_private_scope"};
            if (cli.hasOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA)) {
                value = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)value, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
                ITeamArea context = RepoUtil.getTeamArea((String)value.getItemSelector(), null, (IScmClientConfiguration)this.config, (ITeamRepository)repo);
                if (context != null) {
                    parms.readScopeContextId = new String[]{context.getItemId().getUuidValue()};
                }
            }
        } else if (visibility.getValue().equalsIgnoreCase("projectarea")) {
            IProjectArea context = null;
            if (cli.hasOption((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA)) {
                ScmCommandLineArgument value2 = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListStreamsOptions.OPT_PROCESSAREA), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)value2, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
                context = (IProjectArea)RepoUtil.getProcessArea((IScmCommandLineArgument)value2, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            }
            if (isWorkspace) {
                parms.readScopeType = new String[]{"process_area_scope", "contributor_deferring_scope"};
                if (context != null) {
                    parms.readScopeContextId = new String[]{context.getItemId().getUuidValue(), context.getItemId().getUuidValue()};
                }
            } else {
                parms.readScopeType = new String[]{"process_area_scope"};
                if (context != null) {
                    parms.readScopeContextId = new String[]{context.getItemId().getUuidValue()};
                }
            }
        } else if (visibility.getValue().equalsIgnoreCase("accessgroup")) {
            parms.readScopeType = new String[]{"access_group_scope"};
            if (cli.hasOption((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP)) {
                value = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListStreamsOptions.OPT_ACCESSGROUP), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)value, (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP);
                IAccessGroup accessGroup = RepoUtil.getAccessGroup((IScmCommandLineArgument)value, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                if (accessGroup != null) {
                    parms.readScopeContextId = new String[]{accessGroup.getGroupContextId().getUuidValue()};
                }
            }
        } else {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListCmdOptions_INVALIDVISIBILITY, (Object)visibility.getValue()));
        }
        if (parms.readScopeContextId == null) {
            parms.readScopeContextId = new String[parms.readScopeType.length];
            int i = 0;
            while (i < parms.readScopeContextId.length) {
                parms.readScopeContextId[i] = "";
                ++i;
            }
        }
    }

    static enum ListableThing {
        PROJECT_AREAS,
        TEAM_AREAS,
        STREAMS,
        WORKSPACES,
        CONTRIBUTORS;

    }
}

