/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.BatchingPrinter;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyNodeDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryPageDescriptor2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryResult;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmVersionable;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;

public class ListChangesetsCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_WORKSPACE = new OptionKey("workspace");
    public static final IOptionKey OPT_COMPONENT = new OptionKey("component");
    public static final IOptionKey OPT_BASELINE = new OptionKey("baseline");
    public static final IOptionKey OPT_SUSPENDEDBY = new OptionKey("suspendedby");
    public static final IOptionKey OPT_CREATOR = new OptionKey("creator");
    public static final IOptionKey OPT_CREATED_AFTER = new OptionKey("created-after");
    public static final IOptionKey OPT_CREATED_BEFORE = new OptionKey("created-before");
    public static final IOptionKey OPT_CHANGE_PATH = new OptionKey("path");
    public static final IOptionKey OPT_CHANGE_NAME = new OptionKey("name");
    public static final IOptionKey OPT_CHANGE_TYPE = new OptionKey("type");
    public static final NamedOptionDefinition OPT_WORKITEMS = new NamedOptionDefinition("W", "workitems", 1, -1, "@");
    public static final NamedOptionDefinition OPT_WORKITEMS_ALL = new NamedOptionDefinition(null, "include-child-workitems", 0);
    private static final int MAX_FIND_CHANGESETS_LENGTH = 512;
    protected ChangeSetUtil csUtil = new ChangeSetUtil();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10), false).addOption(OPT_SUSPENDEDBY, null, "suspendedby", Messages.ListChangesetsCmdOption_SUSPENDEDBY, 1, false).addOption(OPT_CREATOR, null, "creator", Messages.ListChangesetsCmdOption_CREATOR, 1, false).addOption(OPT_CREATED_AFTER, null, "created-after", Messages.ListChangesetsCmdOption_CREATED_AFTER, 1, false).addOption(OPT_CREATED_BEFORE, null, "created-before", Messages.ListChangesetsCmdOption_CREATED_BEFORE, 1, false).addOption(OPT_CHANGE_PATH, "p", "path", Messages.ListChangesetsCmdOption_CHANGE_PATH, 1, false).addOption(OPT_CHANGE_NAME, "n", "name", Messages.ListChangesetsCmdOption_CHANGE_NAME, 1, false).addOption(OPT_CHANGE_TYPE, "t", "type", Messages.ListChangesetsCmdOption_CHANGE_TYPE, 1, false).addOption(OPT_WORKSPACE, "w", "workspace", Messages.ListChangesetsCmdOption_WORKSPACE, 1, false).addOption(new SimpleGroup(false).addOption((INamedOptionDefinition)new NamedOptionDefinition(OPT_COMPONENT, "C", "component", 1), CommonOptions.OPT_COMPONENT_SELECTOR_HELP, true).addOption((INamedOptionDefinition)new NamedOptionDefinition(OPT_BASELINE, "b", "baseline", 1), Messages.ListChangesetsCmdOption_BASELINE, false))).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_WORKITEMS, Messages.ListChangesetsCmdOption_WORKITEMS, true).addOption((INamedOptionDefinition)OPT_WORKITEMS_ALL, NLS.bind((String)Messages.ListChangesetsCmdOption_WORKITEMS_ALL, (Object)OPT_WORKITEMS.getName()), false));
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.validateArguments(cli);
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            ITeamRepository repo = null;
            try {
                repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)this.config, (IFilesystemRestClient)client);
                this.csUtil.repoStrToRepo.put(repo.getRepositoryURI(), repo);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
            List selectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_WORKITEMS), (IScmClientConfiguration)this.config, (boolean)false);
            this.csUtil.validateRepoAndLogin(selectors, client, this.config, cli, repo == null);
            ArrayList<WorkItemHierarchyNodeDTO> wiHierarchyList = new ArrayList<WorkItemHierarchyNodeDTO>();
            Map<String, ChangeSetSyncDTO> csList = this.csUtil.getChangeSetsFromWorkitem(selectors, repo, client, this.config, cli.hasOption((IOptionKey)OPT_WORKITEMS_ALL), wiHierarchyList);
            if (csList == null || csList.size() == 0) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetLocateCmd_CS_NOT_FOUND_FOR_WI);
                return;
            }
            PendingChangesUtil.printWorkItemHierarchyList(wiHierarchyList, csList, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        } else {
            ListChangeSetParms csParms = this.generateParms(cli, client, this.config);
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)csParms.repo).getServiceInterface(IScmRichClientRestService.class);
            BatchingPrinter.BatchProvider<String> provider = ListChangesetsCmd.getChangeSetsProvider(scmService, csParms, RepoUtil.getMaxResultsOption((ICommandLine)cli), this.config, client, cli);
            ChangeSetStateFactory stateFactory = ChangeSetStateFactory.createChangeSetstateFactory((IFilesystemRestClient)client, (ITeamRepository)csParms.repo, (String)csParms.workspaceId, (String)csParms.componentId);
            String repoUrl = csParms.repo.getRepositoryURI();
            IndentingPrintStream indent = this.config.getOutputStream().indent();
            options.enablePrinter(22);
            BatchingPrinter printer = new BatchingPrinter(csParms.repo, client, options, this.config, json -> PendingChangesUtil.printChangeSet((JSONObject)json, (String)repoUrl, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)indent, null));
            printer.setNotFoundMessage(Messages.ListChangesetsCmd_NO_CS_FOUND);
            printer.printChangeSets(provider, stateFactory);
            if (provider.hasMore() && !cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS) && !this.config.isJSONEnabled()) {
                this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ListCmd_MORE_ITEMS_AVAILABLE, (Object)cli.getDefinition().getOption((IOptionKey)CommonOptions.OPT_MAXRESULTS).getName()));
            }
        }
    }

    public static BatchingPrinter.BatchProvider<String> getChangeSetsProvider(final IScmRichClientRestService scmService, final ListChangeSetParms csParms, final int maxResults, final IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine cli) throws FileSystemException {
        final IScmRichClientRestService.ParmsRunQuery parms = new IScmRichClientRestService.ParmsRunQuery();
        parms.resultType = String.valueOf(IChangeSet.ITEM_TYPE.getNamespaceURI()) + "." + IChangeSet.ITEM_TYPE.getName();
        parms.criteria = csParms.searchCriteria;
        parms.handlesOnly = true;
        parms.pageToken = "";
        return new BatchingPrinter.BatchProvider<String>(){
            private int idsSize = 0;

            public List<String> nextBatch() throws FileSystemException {
                ArrayList<String> csIds = new ArrayList<String>();
                if (parms.pageToken != null && this.idsSize < maxResults) {
                    try {
                        ScmItemQueryPageDescriptor2 nextPage;
                        parms.maxResultSize = Math.min(512, maxResults - this.idsSize);
                        ScmItemQueryResult queryResult = scmService.postRunQuery(parms);
                        if (!queryResult.getItems().isEmpty()) {
                            Stream handles = queryResult.getItems().stream();
                            handles.map(ScmHandle::getItemId).forEach(csIds::add);
                        }
                        parms.pageToken = (nextPage = (ScmItemQueryPageDescriptor2)queryResult.getNextPage()) != null ? nextPage.getPageToken() : null;
                    }
                    catch (TeamRepositoryException e) {
                        throw StatusHelper.wrap((String)Messages.ListChangesetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)csParms.repo.getRepositoryURI());
                    }
                }
                this.idsSize += csIds.size();
                return csIds;
            }

            public boolean hasMore() {
                return parms.pageToken != null;
            }
        };
    }

    private ListChangeSetParms generateParms(ICommandLine cli, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        String changeName;
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_WORKSPACE, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ArrayList<String> csCriteria = new ArrayList<String>();
        ListChangeSetParms result = new ListChangeSetParms();
        ITeamRepository repo = null;
        if (cli.hasOption(OPT_SUSPENDEDBY)) {
            wsSelector = null;
        }
        String csPrefix = "ChangeSetFilter:";
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            result.workspaceId = ws.workspaceItemId;
            csCriteria.add(String.valueOf(csPrefix) + "Workspace" + "\n" + ws.workspaceItemId);
        }
        ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_COMPONENT, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        IComponent comp = null;
        if (compSelector != null) {
            if (ws == null) {
                repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            } else {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)config);
            }
            comp = this.getComponent((IScmCommandLineArgument)compSelector, ws, repo, client, config);
            result.componentId = comp.getItemId().getUuidValue();
            csCriteria.add("Component:" + comp.getItemId().getUuidValue());
        }
        ScmCommandLineArgument blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_BASELINE, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
        if (blSelector != null) {
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.BASELINE, Collections.singletonList(blSelector), (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (comp == null) {
                throw StatusHelper.argSyntax((String)Messages.ListChangesetsCmd_MUST_SPECIFY_COMPONENT);
            }
            IBaseline blId = RepoUtil.getBaseline((String)blSelector.getItemSelector(), (String)comp.getItemId().getUuidValue(), (String)comp.getName(), (ITeamRepository)repo, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            csCriteria.add(String.valueOf(csPrefix) + "Baseline" + "\n" + blId.getItemId().getUuidValue());
        }
        if (repo == null) {
            repo = RepoUtil.loginUrlArgAnc((IScmClientConfiguration)config, (IFilesystemRestClient)client);
        }
        ScmCommandLineArgument suspBySelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_SUSPENDEDBY, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)suspBySelector, (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR);
        IContributor suspByContrib = null;
        if (suspBySelector != null) {
            suspByContrib = RepoUtil.getContributor((String)suspBySelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            csCriteria.add(String.valueOf(csPrefix) + "SuspendedBy" + "\n" + suspByContrib.getItemId().getUuidValue());
        }
        ScmCommandLineArgument creatorSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_CREATOR, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)creatorSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR);
        if (creatorSelector != null) {
            IContributor creatorContributor = RepoUtil.fetchContributor((String)creatorSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (creatorContributor != null) {
                csCriteria.add("Creator:" + creatorContributor.getItemId().getUuidValue());
            } else {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)creatorSelector.getItemSelector(), (Object)repo.getRepositoryURI()));
            }
        }
        Date dateAfter = null;
        String afterSelector = cli.getOption(OPT_CREATED_AFTER, null);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String afterTime = "";
        if (afterSelector != null) {
            dateAfter = SubcommandUtil.parseDate((SimpleDateFormat)sdf, (String)afterSelector, (IScmClientConfiguration)config);
            afterTime = String.valueOf(dateAfter.getTime());
        }
        Date dateBefore = null;
        String beforeSelector = cli.getOption(OPT_CREATED_BEFORE, null);
        String beforeTime = "";
        if (beforeSelector != null) {
            dateBefore = SubcommandUtil.parseDate((SimpleDateFormat)sdf, (String)beforeSelector, (IScmClientConfiguration)config);
            beforeTime = String.valueOf(dateBefore.getTime());
        }
        if (!afterTime.isEmpty() || !beforeTime.isEmpty()) {
            csCriteria.add("DateRange:" + afterTime + "\n" + beforeTime);
        }
        ScmCommandLineArgument changePathSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_CHANGE_PATH, null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)changePathSelector, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
        ScmVersionable versionable = null;
        if (changePathSelector != null) {
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
            String remotePath = changePathSelector.getItemSelector();
            String[] path = StringUtil.splitEscapedPath((String)remotePath);
            remotePath = StringUtil.createPathString((String[])path);
            if (ws == null || comp == null) {
                throw StatusHelper.argSyntax((String)Messages.ListChangesetsCmd_MUST_SPECIFY_WORKSPACE_COMPONENT);
            }
            versionable = RepoUtil.getVersionableByPath((IScmRichClientRestService)scmService, (String)ws.workspaceItemId, (String)comp.getItemId().getUuidValue(), (String)remotePath, (IScmClientConfiguration)config);
            csCriteria.add(String.valueOf(csPrefix) + "Versionable" + "\n" + versionable.getVersionable().getItemType().getNamespaceURI() + "\n" + versionable.getVersionable().getItemType().getName() + "\n" + versionable.getVersionable().getItemId().getUuidValue());
        }
        if ((changeName = cli.getOption(OPT_CHANGE_NAME, null)) != null && !changeName.isEmpty()) {
            csCriteria.add("Name:" + changeName);
        }
        if (cli.hasOption(OPT_CHANGE_TYPE)) {
            int changeType = this.getChangeType(cli.getOption(OPT_CHANGE_TYPE));
            csCriteria.add(String.valueOf(csPrefix) + "ChangeType" + "\n" + String.valueOf(changeType));
        }
        result.repo = repo;
        result.searchCriteria = csCriteria.toArray(new String[csCriteria.size()]);
        return result;
    }

    private void validateArguments(ICommandLine cli) throws FileSystemException {
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS) && (cli.hasOption(OPT_WORKSPACE) || cli.hasOption(OPT_COMPONENT) || cli.hasOption(OPT_BASELINE) || cli.hasOption(OPT_SUSPENDEDBY) || cli.hasOption(OPT_CREATOR) || cli.hasOption(OPT_CREATED_AFTER) || cli.hasOption(OPT_CREATED_BEFORE) || cli.hasOption(OPT_CHANGE_PATH) || cli.hasOption(OPT_CHANGE_NAME) || cli.hasOption(OPT_CHANGE_TYPE) || cli.hasOption((IOptionKey)CommonOptions.OPT_MAXRESULTS))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetLocateCmd_WI_ALL_ONLY_FOR_WORKITEMS, (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS).getName(), (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS_ALL).getName()));
        }
        if (cli.hasOption(OPT_BASELINE) && !cli.hasOption(OPT_COMPONENT)) {
            throw StatusHelper.argSyntax((String)Messages.ListChangesetsCmd_MUST_SPECIFY_COMPONENT);
        }
        if (cli.hasOption(OPT_BASELINE) && cli.hasOption(OPT_WORKSPACE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_WS_AND_BASELINE, (Object)cli.getDefinition().getOption(OPT_BASELINE).getName(), (Object)cli.getDefinition().getOption(OPT_WORKSPACE).getName()));
        }
        String changeType = cli.getOption(OPT_CHANGE_TYPE, null);
        if (changeType != null) {
            char[] cArray = changeType.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                Character item = Character.valueOf(c);
                if (item.charValue() != 'a' && item.charValue() != 'd' && item.charValue() != 'c' && item.charValue() != 'r' && item.charValue() != 'm') {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListChangesetsCmd_INVALID_CHANGE_TYPE, (Object)changeType));
                }
                ++n2;
            }
        }
        if (!(!cli.hasOption(OPT_CHANGE_PATH) || cli.hasOption(OPT_WORKSPACE) && cli.hasOption(OPT_COMPONENT))) {
            throw StatusHelper.argSyntax((String)Messages.ListChangesetsCmd_MUST_SPECIFY_WORKSPACE_COMPONENT);
        }
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS_ALL) && !cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetLocateCmd_WI_ALL_ONLY_FOR_WORKITEMS, (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS_ALL).getName(), (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS).getName()));
        }
    }

    private WorkspaceComponentDTO matchComponent(ITeamRepository repo, ParmsWorkspace ws, IScmCommandLineArgument compSelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)config).get(0);
        IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
        ArrayList<WorkspaceComponentDTO> matchedComps = new ArrayList<WorkspaceComponentDTO>();
        for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
            if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !compSelector.getItemSelector().equals(compDTO.getName())) continue;
            matchedComps.add(compDTO);
        }
        if (matchedComps.size() == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
        }
        if (matchedComps.size() > 1) {
            int NoOfRepos = 1;
            HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>> repoToMatchedComps = new HashMap<ITeamRepository, ArrayList<WorkspaceComponentDTO>>(NoOfRepos);
            repoToMatchedComps.put(repo, matchedComps);
            RepoUtil.displayAmbiguousComponents((String)compSelector.getItemSelector(), repoToMatchedComps, (IScmClientConfiguration)config);
        }
        return (WorkspaceComponentDTO)matchedComps.get(0);
    }

    private IComponent getComponent(IScmCommandLineArgument compSelector, ParmsWorkspace ws, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        IComponent component = null;
        if (ws != null) {
            WorkspaceComponentDTO comp = this.matchComponent(repo, ws, compSelector, client, config);
            component = (IComponent)RepoUtil.getItem((IItemType)IComponent.ITEM_TYPE, (UUID)UUID.valueOf((String)comp.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)config);
        } else {
            component = RepoUtil.getComponent((String)compSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        }
        return component;
    }

    public int getChangeType(String changeTypeSelector) {
        int changeType = 0;
        if (changeTypeSelector.indexOf(97) != -1) {
            changeType |= 1;
        }
        if (changeTypeSelector.indexOf(100) != -1) {
            changeType |= 0x10;
        }
        if (changeTypeSelector.indexOf(99) != -1) {
            changeType |= 2;
        }
        if (changeTypeSelector.indexOf(114) != -1) {
            changeType |= 4;
        }
        if (changeTypeSelector.indexOf(109) != -1) {
            changeType |= 8;
        }
        return changeType;
    }

    public static class ListChangeSetParms {
        public ITeamRepository repo;
        public String workspaceId;
        public String componentId;
        public String[] searchCriteria;
    }
}

