/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListChangesCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ListChangesCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ScmCommandLineArgument blSelector;
        ScmCommandLineArgument ssSelector;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        if (cli.hasOption((IOptionKey)ListChangesCmdOptions.OPT_SNAPSHOT) && cli.hasOption((IOptionKey)ListChangesCmdOptions.OPT_BASELINE)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object[])new String[]{ListChangesCmdOptions.OPT_SNAPSHOT.getName(), ListChangesCmdOptions.OPT_BASELINE.getName()}));
        }
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        String itemID = null;
        String contextType = null;
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListChangesCmdOptions.OPT_WORKSPACE, null), (IScmClientConfiguration)this.config);
        if (wsSelector != null) {
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            itemID = ws.workspaceItemId;
            contextType = "workspace";
        }
        if ((ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListChangesCmdOptions.OPT_SNAPSHOT, null), (IScmClientConfiguration)this.config)) != null) {
            if (repo != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT, Collections.singletonList(ssSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            } else {
                repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
            }
            SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            IBaselineSet snapshot = RepoUtil.getSnapshot((String)(ws != null ? ws.workspaceItemId : null), (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            itemID = snapshot.getItemId().getUuidValue();
            contextType = "baselineset";
        }
        if ((blSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)ListChangesCmdOptions.OPT_BASELINE, null), (IScmClientConfiguration)this.config)) != null) {
            if (!cli.hasOption((IOptionKey)ListChangesCmdOptions.OPT_WORKSPACE)) {
                if (blSelector.getRepositorySelector() != null) {
                    repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(blSelector.getRepositorySelector()));
                }
                ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)(repo != null ? repo.getId() : null), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                if (repo == null) {
                    repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(ws.repositoryUrl));
                }
            }
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.BASELINE, Collections.singletonList(blSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)blSelector, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            itemID = this.getBaselineItemID(ws.workspaceItemId, (IScmCommandLineArgument)blSelector, client, this.config);
            contextType = "baseline";
        }
        List csSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)ListChangesCmdOptions.OPT_CHANGESET), (IScmClientConfiguration)this.config);
        this.listChanges(csSelectors, itemID, contextType, repo, client, this.config, cli);
    }

    String getBaselineItemID(String wsId, IScmCommandLineArgument selector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        List result;
        String itemID = null;
        String blSelector = selector.getItemSelector();
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)selector);
        String blUUID = null;
        UUID uuid = RepoUtil.lookupUuid((String)blSelector);
        if (uuid != null) {
            blUUID = uuid.getUuidValue();
        }
        if ((result = RepoUtil.getWorkspaceDetails(Collections.singletonList(new ParmsWorkspace(repo.getRepositoryURI(), wsId)), (IFilesystemRestClient)client, (IScmClientConfiguration)config)).size() != 1) {
            throw StatusHelper.failure((String)Messages.FlowTargetUnsetCmd_WORKSPACE_NOT_FOUND, null);
        }
        WorkspaceDetailsDTO workspaceDetails = (WorkspaceDetailsDTO)result.get(0);
        List comps = workspaceDetails.getComponents();
        ArrayList<BaselineDTO> matchedBaselines = new ArrayList<BaselineDTO>();
        for (WorkspaceComponentDTO comp : comps) {
            BaselineDTO baseline = comp.getBaseline();
            if (blUUID != null && baseline.getItemId().equals(blUUID)) {
                itemID = blUUID;
                matchedBaselines.add(baseline);
                break;
            }
            if (!baseline.getName().equals(blSelector)) continue;
            itemID = baseline.getItemId();
            matchedBaselines.add(baseline);
        }
        if (matchedBaselines.size() == 0) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.DiffCmd_12, (Object)blSelector));
        }
        if (matchedBaselines.size() > 1) {
            ArrayList<SubcommandUtil.ItemInfo> blMatched = new ArrayList<SubcommandUtil.ItemInfo>();
            for (BaselineDTO bl : matchedBaselines) {
                blMatched.add(new SubcommandUtil.ItemInfo(bl.getName(), bl.getItemId(), bl.getRepositoryURL(), RepoUtil.ItemType.BASELINE));
            }
            SubcommandUtil.displayAmbiguousSelectorException((String)blSelector, blMatched, (IScmClientConfiguration)config);
            throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DiffCmd_15, (Object)blSelector));
        }
        return itemID;
    }

    private void listChanges(List<IScmCommandLineArgument> csSelectors, String itemId, String contextType, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine cli) throws FileSystemException {
        HashMap repoUuids = new HashMap();
        for (IScmCommandLineArgument csSelector : csSelectors) {
            ITeamRepository repoCs = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            if (repo != null && !repo.getId().getUuidValue().equals(repoCs.getId().getUuidValue())) {
                ICommandLineArgument ctxtSelector = cli.hasOption((IOptionKey)ListChangesCmdOptions.OPT_WORKSPACE) ? cli.getOptionValue((IOptionKey)ListChangesCmdOptions.OPT_WORKSPACE) : cli.getOptionValue((IOptionKey)ListChangesCmdOptions.OPT_SNAPSHOT);
                ScmCommandLineArgument contextSelector = ScmCommandLineArgument.create((ICommandLineArgument)ctxtSelector, (IScmClientConfiguration)config);
                StatusHelper.repoIncorrectlySpecified((String)NLS.bind((String)Messages.ListChangesCmd_AMBIGUOUS_REPOS, (Object)contextSelector.getItemSelector()));
            }
            SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            IUuidAliasRegistry.IUuidAlias csItem = RepoUtil.lookupUuidAndAlias((String)csSelector.getItemSelector());
            if (csItem == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)"Unable to find change set ''{0}''", (Object)csSelector));
            }
            String csUuid = csItem.getUuid().getUuidValue();
            if (repoUuids.get(repoCs) == null) {
                ArrayList<String> selectors = new ArrayList<String>();
                selectors.add(csUuid);
                repoUuids.put(repoCs, selectors);
                continue;
            }
            ((List)repoUuids.get(repoCs)).add(csUuid);
        }
        for (ITeamRepository repoItem : repoUuids.keySet()) {
            List csIds = (List)repoUuids.get(repoItem);
            PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
            options.setVerbose(true);
            options.enablePrinter(20);
            options.enablePrinter(4);
            options.enablePrinter(6);
            options.enablePrinter(7);
            options.enablePrinter(31);
            options.enablePrinter(14);
            options.enablePrinter(19);
            options.enablePrinter(37);
            if (cli.hasOption(ListChangesCmdOptions.OPT_SHOW_FULL_VERSION_ID)) {
                options.enablePrinter(36);
            }
            if (cli.hasOption(ListChangesCmdOptions.OPT_SHOW_SHORT_VERSION_ID)) {
                options.enablePrinter(35);
            }
            if (cli.hasOption((IOptionKey)ListChangesCmdOptions.OPT_INCLUDE_UNCHANGED_FILES)) {
                options.enablePrinter(41);
            }
            for (String csId : csIds) {
                options.addFilter(UUID.valueOf((String)csId), 4);
            }
            ChangeSetStateFactory stateFactory = ChangeSetStateFactory.createChangeSetstateFactory((IFilesystemRestClient)client, (ITeamRepository)repo, null, null);
            PendingChangesUtil.printChangeSets2((ITeamRepository)repoItem, (String)itemId, (String)contextType, (List)csIds, (ChangeSetStateFactory)stateFactory, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)config.getWrappedOutputStream(), (IFilesystemRestClient)client, (IScmClientConfiguration)config, null, null);
        }
    }
}

