/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.BatchingPrinter;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineHistoryEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmBaseline;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryPageDescriptor2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmItemQueryResult;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class ListBaselineCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_WORKSPACE = new NamedOptionDefinition("w", "workspace", 1, "@");
    public static final NamedOptionDefinition OPT_COMPONENTS_SELECTOR = new NamedOptionDefinition("C", "components", -1, "@");
    public static final NamedOptionDefinition OPT_SNAPSHOT = new NamedOptionDefinition("s", "snapshot", 1, "@");
    private String baseLineNameFilter;
    private Date dateAfter;
    private Date dateBefore;
    private Map<String, String> repoIdToContributorId = new HashMap<String, String>();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_SNAPSHOT, Messages.ListBaselineCmd_SS_HELP, true).addOption((INamedOptionDefinition)OPT_COMPONENTS_SELECTOR, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP, false)).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_WORKSPACE, Messages.ListBaselineCmd_WS_HELP, true).addOption((INamedOptionDefinition)OPT_COMPONENTS_SELECTOR, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP, false)).addOption((IOptionGroup)new ContinuousGroup().addOption((INamedOptionDefinition)OPT_COMPONENTS_SELECTOR, CommonOptions.OPT_COMPONENTS_SELECTOR_HELP, true));
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, Messages.ListBaselineCmd_OPT_MAX).addOption((INamedOptionDefinition)CommonOptions.OPT_NAME_FILTER, Messages.ListBaselineCmd_NAME_FILTER).addOption((INamedOptionDefinition)CommonOptions.OPT_CREATED_AFTER, Messages.ListBaselineCmdOption_CREATED_AFTER).addOption((INamedOptionDefinition)CommonOptions.OPT_CREATED_BEFORE, Messages.ListBaselineCmdOption_CREATED_BEFORE).addOption((INamedOptionDefinition)CommonOptions.OPT_CREATOR, Messages.ListBaselineCmdOption_CREATOR);
        return options;
    }

    public void run() throws FileSystemException {
        String beforeSelector;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (!(cli.hasOption((IOptionKey)OPT_WORKSPACE) || cli.hasOption((IOptionKey)OPT_SNAPSHOT) || cli.hasOption((IOptionKey)OPT_COMPONENTS_SELECTOR))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListBaselineCmd_SPECIFY_ONE_OPT, (Object[])new String[]{OPT_WORKSPACE.getName(), OPT_SNAPSHOT.getName(), OPT_COMPONENTS_SELECTOR.getName()}));
        }
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE) && cli.hasOption((IOptionKey)OPT_SNAPSHOT)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)OPT_WORKSPACE.getName(), (Object)OPT_SNAPSHOT.getName()));
        }
        this.baseLineNameFilter = cli.getOption((IOptionKey)CommonOptions.OPT_NAME_FILTER, null);
        String afterSelector = cli.getOption((IOptionKey)CommonOptions.OPT_CREATED_AFTER, null);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        if (afterSelector != null) {
            this.dateAfter = SubcommandUtil.parseDate((SimpleDateFormat)sdf, (String)afterSelector, (IScmClientConfiguration)this.config);
        }
        if ((beforeSelector = cli.getOption((IOptionKey)CommonOptions.OPT_CREATED_BEFORE, null)) != null) {
            this.dateBefore = SubcommandUtil.parseDate((SimpleDateFormat)sdf, (String)beforeSelector, (IScmClientConfiguration)this.config);
        }
        int DEFAULT_VALUE = 10;
        int max = RepoUtil.getMaxResultsOption((ICommandLine)cli, (int)10);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        WorkspaceDetailsDTO wsDetails = null;
        IBaselineSet ss = null;
        List<BaselineDTO> baselineDTOList = null;
        ArrayList repoList = null;
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE)) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_WORKSPACE), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
            wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        } else if (cli.hasOption((IOptionKey)OPT_SNAPSHOT)) {
            ScmCommandLineArgument ssSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_SNAPSHOT), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)ssSelector, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)ssSelector);
            ss = RepoUtil.getSnapshot(null, (String)ssSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        }
        List componentSelectors = null;
        HashMap<SubcommandUtil.ItemInfo, ITeamRepository> componentToRepoMap = new HashMap<SubcommandUtil.ItemInfo, ITeamRepository>();
        if (cli.hasOption((IOptionKey)OPT_COMPONENTS_SELECTOR)) {
            componentSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)componentSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            HashMap<ITeamRepository, ArrayList<String>> repoToCompSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
            if (ws != null && wsDetails != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)componentSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                for (IScmCommandLineArgument iScmCommandLineArgument : componentSelectors) {
                    boolean compFound = false;
                    IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)iScmCommandLineArgument.getItemSelector());
                    for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                        if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !iScmCommandLineArgument.getItemSelector().equals(compDTO.getName())) continue;
                        SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(compDTO.getName(), compDTO.getItemId(), ws.repositoryUrl, RepoUtil.ItemType.COMPONENT);
                        componentToRepoMap.put(itemInfo, repo);
                        compFound = true;
                        break;
                    }
                    if (compFound) continue;
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)iScmCommandLineArgument.getItemSelector()));
                }
            } else if (ss != null && repo != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (List)componentSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                baselineDTOList = this.getBaselinesInSnapshot(ss, repo, client);
                List<IComponent> list = this.getComponentsInSnapshot(baselineDTOList, repo, client);
                for (Iterator<Object> compSelector : componentSelectors) {
                    boolean compFound = false;
                    IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
                    for (IComponent comp : list) {
                        if ((compAlias == null || !compAlias.getUuid().equals((Object)comp.getItemId())) && !compSelector.getItemSelector().equals(comp.getName())) continue;
                        SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(comp.getName(), comp.getItemId().getUuidValue(), repo.getRepositoryURI(), RepoUtil.ItemType.COMPONENT);
                        componentToRepoMap.put(itemInfo, repo);
                        compFound = true;
                        break;
                    }
                    if (compFound) continue;
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
                }
            } else {
                for (IScmCommandLineArgument iScmCommandLineArgument : componentSelectors) {
                    ITeamRepository compRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)iScmCommandLineArgument);
                    ArrayList<String> compSelectors = (ArrayList<String>)repoToCompSelectors.get(compRepo);
                    if (compSelectors == null) {
                        compSelectors = new ArrayList<String>();
                        repoToCompSelectors.put(compRepo, compSelectors);
                    }
                    compSelectors.add(iScmCommandLineArgument.getItemSelector());
                }
                repoList = new ArrayList(repoToCompSelectors.keySet());
                for (Map.Entry entry : repoToCompSelectors.entrySet()) {
                    List comps = RepoUtil.getComponents((List)((List)entry.getValue()), (ITeamRepository)((ITeamRepository)entry.getKey()), (IScmClientConfiguration)this.config);
                    for (IComponent comp : comps) {
                        SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(comp.getName(), comp.getItemId().getUuidValue(), ((ITeamRepository)entry.getKey()).getRepositoryURI(), RepoUtil.ItemType.COMPONENT);
                        componentToRepoMap.put(itemInfo, (ITeamRepository)entry.getKey());
                    }
                }
            }
        } else if (ws != null && wsDetails != null) {
            for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
                SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(compDTO.getName(), compDTO.getItemId(), ws.repositoryUrl, RepoUtil.ItemType.COMPONENT);
                componentToRepoMap.put(itemInfo, repo);
            }
        } else if (ss != null && repo != null) {
            baselineDTOList = this.getBaselinesInSnapshot(ss, repo, client);
            List<IComponent> comps = this.getComponentsInSnapshot(baselineDTOList, repo, client);
            for (IComponent iComponent : comps) {
                SubcommandUtil.ItemInfo itemInfo = new SubcommandUtil.ItemInfo(iComponent.getName(), iComponent.getItemId().getUuidValue(), repo.getRepositoryURI(), RepoUtil.ItemType.COMPONENT);
                componentToRepoMap.put(itemInfo, repo);
            }
        }
        ScmCommandLineArgument creatorSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)CommonOptions.OPT_CREATOR, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)creatorSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CONTRIBUTOR);
        if (creatorSelector != null) {
            if (repoList != null && repoList.size() > 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (ITeamRepository compRepo : repoList) {
                    IContributor creatorContrib = RepoUtil.fetchContributor((String)creatorSelector.getItemSelector(), (ITeamRepository)compRepo, (IScmClientConfiguration)this.config);
                    if (creatorContrib != null) {
                        this.repoIdToContributorId.put(compRepo.getId().getUuidValue(), creatorContrib.getItemId().getUuidValue());
                        continue;
                    }
                    arrayList.add(compRepo.getRepositoryURI());
                }
                if (!arrayList.isEmpty()) {
                    if (arrayList.size() > 1) {
                        StringBuffer repos = new StringBuffer();
                        for (String repoUri : arrayList) {
                            repos.append(String.valueOf(System.lineSeparator()) + repoUri);
                        }
                        repos.append(System.lineSeparator());
                        throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_INVALID_CONTRIBUTOR_IN_REPOS, (Object)creatorSelector.getItemSelector(), (Object)repos.toString()));
                    }
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)creatorSelector.getItemSelector(), arrayList.get(0)));
                }
            } else if (repo != null) {
                IContributor iContributor = RepoUtil.fetchContributor((String)creatorSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                if (iContributor != null) {
                    this.repoIdToContributorId.put(repo.getId().getUuidValue(), iContributor.getItemId().getUuidValue());
                } else {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ListComponentsCmd_INVALID_CONTRIBUTOR_IN_REPO, (Object)creatorSelector.getItemSelector(), (Object)repo.getRepositoryURI()));
                }
            }
        }
        BatchingPrinter batchingPrinter = new BatchingPrinter(this.config, json -> this.printBaseline((JSONObject)json, this.config.getWrappedOutputStream()));
        batchingPrinter.setNotFoundMessage(Messages.ListBaselineCmd_NO_MATCHING_BASELINES_FOUND);
        try {
            List<SubcommandUtil.ItemInfo> compList = this.sort(new ArrayList<SubcommandUtil.ItemInfo>(componentToRepoMap.keySet()));
            batchingPrinter.beginList(null, null);
            for (SubcommandUtil.ItemInfo comp : compList) {
                ITeamRepository componentRepo = (ITeamRepository)componentToRepoMap.get(comp);
                this.beginComponent(comp, componentRepo, batchingPrinter);
                Object provider = ws != null ? this.getBaselinesInWorkspace(ws, comp, componentRepo, max, client) : (ss != null ? this.getBaselinesInSnapshot(baselineDTOList, comp) : this.getBaselines(comp, componentRepo, max));
                batchingPrinter.printList("baselines", provider.map(this.jsonizer(componentRepo, this.config)));
                this.endComponent(batchingPrinter);
            }
        }
        finally {
            batchingPrinter.end();
        }
    }

    private void beginComponent(SubcommandUtil.ItemInfo comp, ITeamRepository componentRepo, BatchingPrinter printer) {
        String selector = AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getId()), (String)componentRepo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        printer.setHeader(NLS.bind((String)Messages.ListComponentsCmd_Component, (Object)selector));
        printer.setRepository(componentRepo);
        printer.beginObject();
        printer.printJSON("name", (Object)comp.getName());
        printer.printJSON("uuid", (Object)comp.getId());
        printer.printJSON("url", (Object)componentRepo.getRepositoryURI());
    }

    private <T> Function<T, JSONObject> jsonizer(ITeamRepository repo, IScmClientConfiguration config) {
        return dto -> {
            if (dto instanceof BaselineHistoryEntryDTO) {
                BaselineDTO baselineDTO = ((BaselineHistoryEntryDTO)dto).getBaseline();
                return JSONPrintUtil.jsonizeBaseline((BaselineDTO)baselineDTO, (BaselineHistoryEntryDTO)((BaselineHistoryEntryDTO)dto), (ITeamRepository)repo, null, (IScmClientConfiguration)config);
            }
            if (dto instanceof BaselineDTO) {
                return JSONPrintUtil.jsonizeBaseline((BaselineDTO)((BaselineDTO)dto), null, (ITeamRepository)repo, null, (IScmClientConfiguration)config);
            }
            return null;
        };
    }

    private void endComponent(BatchingPrinter printer) {
        printer.endObject();
    }

    private List<BaselineDTO> getBaselinesInSnapshot(IBaselineSet ss, ITeamRepository repo, IFilesystemRestClient client) throws FileSystemException {
        ArrayList<String> baselineIds = new ArrayList<String>();
        for (IBaselineHandle blHandle : ss.getBaselines()) {
            baselineIds.add(blHandle.getItemId().getUuidValue());
        }
        return RepoUtil.getBaselinesById(baselineIds, (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
    }

    private List<IComponent> getComponentsInSnapshot(List<BaselineDTO> baselineDTOList, ITeamRepository repo, IFilesystemRestClient client) throws FileSystemException {
        ArrayList<String> compIds = new ArrayList<String>();
        for (BaselineDTO blDTO : baselineDTOList) {
            compIds.add(blDTO.getComponentItemId());
        }
        return RepoUtil.getComponents(compIds, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
    }

    private void printBaseline(JSONObject baseline, IndentingPrintStream printStream) {
        String message = Messages.ListBaselineCmd_BASELINE_1;
        String repoUrl = (String)baseline.get((Object)"url");
        String blSelector = baseline.get((Object)"id") != null ? AliasUtil.selector((int)((Integer)baseline.get((Object)"id")), (String)((String)baseline.get((Object)"name")), (UUID)UUID.valueOf((String)((String)baseline.get((Object)"uuid"))), (String)repoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE) : AliasUtil.selectorWithNoIdAndName();
        String comment = (String)baseline.get((Object)"comment");
        if (comment == null || comment.isEmpty() || comment.equals(JSONPrintUtil.getBaselineCommentForJson((String)""))) {
            comment = Messages.ListBaselineCmd_NO_COMMENT;
        }
        String creationBy = NLS.bind((String)Messages.ListBaselineCmd_CREATED_BY, (Object)baseline.get((Object)"contributor"), (Object)baseline.get((Object)"creationDate"));
        String addedBy = null;
        String deliveredBy = (String)baseline.get((Object)"added-by");
        if (deliveredBy != null) {
            message = Messages.ListBaselineCmd_BASELINE_2;
            String deliveryDate = (String)baseline.get((Object)"date-added");
            addedBy = NLS.bind((String)Messages.ListBaselineCmd_ADDED_BY, (Object)deliveredBy, (Object)deliveryDate);
        }
        IndentingPrintStream indented = printStream.indent();
        indented.printIndent();
        indented.println((CharSequence)NLS.bind((String)message, (Object[])new String[]{blSelector, comment, creationBy, addedBy}));
    }

    List<SubcommandUtil.ItemInfo> sort(List<SubcommandUtil.ItemInfo> list) {
        Collections.sort(list, new Comparator<SubcommandUtil.ItemInfo>(){

            @Override
            public int compare(SubcommandUtil.ItemInfo comp1, SubcommandUtil.ItemInfo comp2) {
                return comp1.getName().compareTo(comp2.getName());
            }
        });
        return list;
    }

    private BatchingPrinter.BatchProvider<BaselineHistoryEntryDTO> getBaselinesInWorkspace(ParmsWorkspace ws, SubcommandUtil.ItemInfo component, ITeamRepository repo, int max, IFilesystemRestClient client) throws FileSystemException {
        try {
            ParmsGetBaselines parms = this.createGetBaselineParms(ws, component, repo, max);
            GetBaselinesDTO result = client.postGetBaselines(parms, null);
            ArrayList batch = new ArrayList(result.getBaselineHistoryEntriesInWorkspace());
            Collections.reverse(batch);
            return BatchingPrinter.BatchProvider.fromList(batch);
        }
        catch (TeamRepositoryException e) {
            String selector = AliasUtil.selector((String)component.getName(), (UUID)UUID.valueOf((String)component.getId()), (String)component.getRepoUri(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListBaselineCmd_GET_BASELINES_FAILURE, (Object)selector), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    private BatchingPrinter.BatchProvider<BaselineDTO> getBaselines(final SubcommandUtil.ItemInfo component, final ITeamRepository repo, final int max) throws FileSystemException {
        final IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        final IScmRichClientRestService.ParmsRunQuery parms = new IScmRichClientRestService.ParmsRunQuery();
        parms.resultType = String.valueOf(IBaseline.ITEM_TYPE.getNamespaceURI()) + "." + IBaseline.ITEM_TYPE.getName();
        parms.pageToken = "";
        parms.criteria = new String[]{"Component:" + component.getId()};
        return new BatchingPrinter.BatchProvider<BaselineDTO>(){
            private int numFound = 0;

            public List<BaselineDTO> nextBatch() throws FileSystemException {
                if (parms.pageToken == null || this.numFound >= max) {
                    return Collections.emptyList();
                }
                try {
                    parms.maxResultSize = Math.min(512, max - this.numFound);
                    ScmItemQueryResult queryResult = scmService.postRunQuery(parms);
                    ScmItemQueryPageDescriptor2 nextPage = (ScmItemQueryPageDescriptor2)queryResult.getNextPage();
                    parms.pageToken = nextPage != null ? nextPage.getPageToken() : null;
                    this.numFound += queryResult.getItems().size();
                    return ListBaselineCmd.this.convert(queryResult.getItems());
                }
                catch (TeamRepositoryException e) {
                    String selector = AliasUtil.selector((String)component.getName(), (UUID)UUID.valueOf((String)component.getId()), (String)component.getRepoUri(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                    throw StatusHelper.wrap((String)NLS.bind((String)Messages.ListBaselineCmd_GET_BASELINES_FAILURE, (Object)selector), (TeamRepositoryException)e, (IndentingPrintStream)ListBaselineCmd.this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
                }
            }

            public boolean hasMore() {
                return parms.pageToken != null;
            }
        };
    }

    private List<BaselineDTO> convert(List<ScmBaseline> list) {
        return list.stream().map(b -> {
            BaselineDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createBaselineDTO();
            dto.setItemId(b.getItemId());
            dto.setId(Integer.valueOf(b.getId()).intValue());
            dto.setName(b.getName());
            dto.setComment(b.getComment());
            dto.setComponentItemId(b.getComponent().getItemId());
            dto.setComponentName(b.getComponent().getName());
            dto.setCreatorContributorItemId(b.getCreator().getItemId());
            dto.setCreatorContributorName(b.getCreator().getName());
            dto.setCreationDate(b.getCreationDate());
            return dto;
        }).collect(Collectors.toList());
    }

    private ParmsGetBaselines createGetBaselineParms(ParmsWorkspace ws, SubcommandUtil.ItemInfo component, ITeamRepository repo, int max) {
        ParmsGetBaselines parms = new ParmsGetBaselines();
        parms.workspaceItemId = ws.workspaceItemId;
        parms.componentItemId = component.getId();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.authorContributorItemId = this.repoIdToContributorId.get(repo.getId().getUuidValue());
        parms.max = max;
        if (this.baseLineNameFilter != null) {
            parms.baselineNameFilter = this.baseLineNameFilter;
        }
        if (this.dateAfter != null) {
            parms.createdAfterTimestamp = this.dateAfter.getTime();
        }
        if (this.dateBefore != null) {
            parms.createdBeforeTimestamp = this.dateBefore.getTime();
        }
        return parms;
    }

    private BatchingPrinter.BatchProvider<BaselineDTO> getBaselinesInSnapshot(List<BaselineDTO> baselineDTOList, SubcommandUtil.ItemInfo component) throws FileSystemException {
        for (BaselineDTO blDTO : baselineDTOList) {
            if (!blDTO.getComponentItemId().equals(component.getId())) continue;
            List<Object> batch = !this.isFilteringApplied() || this.filterBaselines(blDTO) ? Collections.singletonList(blDTO) : Collections.emptyList();
            return BatchingPrinter.BatchProvider.fromList(batch);
        }
        return null;
    }

    private boolean isFilteringApplied() {
        return this.baseLineNameFilter != null || !this.repoIdToContributorId.isEmpty() || this.dateAfter != null || this.dateBefore != null;
    }

    private boolean filterBaselines(BaselineDTO blDTO) {
        Long createdBeforeTimestamp;
        Timestamp t2;
        Long createdAfterTimestamp;
        Timestamp t1;
        if (this.baseLineNameFilter != null && !this.checkName(blDTO.getName(), this.baseLineNameFilter)) {
            return false;
        }
        if (!this.repoIdToContributorId.isEmpty() && !this.checkUser(this.repoIdToContributorId.get(blDTO.getRepositoryId()), blDTO.getCreatorContributorItemId())) {
            return false;
        }
        if (this.dateAfter != null && !this.checkCreatedAfterDate(t1 = new Timestamp(createdAfterTimestamp = Long.valueOf(this.dateAfter.getTime())), t2 = new Timestamp(blDTO.getCreationDate()))) {
            return false;
        }
        return this.dateBefore == null || this.checkCreatedBeforeDate(t1 = new Timestamp(createdBeforeTimestamp = Long.valueOf(this.dateBefore.getTime())), t2 = new Timestamp(blDTO.getCreationDate()));
    }

    private boolean checkCreatedBeforeDate(Timestamp t1, Timestamp t2) {
        return t1.compareTo(t2) >= 0;
    }

    private boolean checkCreatedAfterDate(Timestamp t1, Timestamp t2) {
        return t1.compareTo(t2) <= 0;
    }

    private boolean checkUser(String authorContributorItemId, String p_authorContributorItemId) {
        return authorContributorItemId.equals(p_authorContributorItemId);
    }

    private boolean checkName(String name, String namePreffix) {
        return name.toLowerCase().startsWith(namePreffix.toLowerCase());
    }
}

