/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.listcommand.ListWorkspacesOptions;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.process.client.IAccessGroupClientService;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.Arrays;
import org.eclipse.osgi.util.NLS;

public class ListAccessGroupsCmd
extends AbstractSubcommand
implements IOptionSource {
    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP).addOption(ListWorkspacesOptions.OPT_NAME_FILTER, "n", "name", Messages.ListCmdOptions_NAME_FILTER, 1).addOption((INamedOptionDefinition)CommonOptions.OPT_MAXRESULTS, NLS.bind((String)CommonOptions.OPT_MAXRESULTS_HELP, (Object)10));
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ConnectionInfo connection = this.config.getConnectionInfo();
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)connection);
        String nameSelector = cli.getOption(ListWorkspacesOptions.OPT_NAME_FILTER, null);
        int maxResults = RepoUtil.getMaxResultsOption((ICommandLine)cli);
        boolean verbose = cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        IAccessGroupClientService accessGroupService = (IAccessGroupClientService)repo.getClientLibrary(IAccessGroupClientService.class);
        try {
            IAccessGroup[] accessGroups = accessGroupService.getAccessGroups(nameSelector, null);
            if (accessGroups.length > maxResults) {
                accessGroups = Arrays.copyOfRange(accessGroups, 0, maxResults);
            }
            this.printAccessGroups(accessGroups, repo, client, this.config, verbose);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private void printAccessGroups(IAccessGroup[] accessGroups, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, boolean verbose) {
        JSONArray jAccessGroups = new JSONArray();
        IAccessGroup[] iAccessGroupArray = accessGroups;
        int n = accessGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IAccessGroup accessGroup = iAccessGroupArray[n2];
            JSONObject jAccessGroup = JSONPrintUtil.jsonize((String)accessGroup.getName(), (String)accessGroup.getGroupContextId().getUuidValue(), (String)repo.getRepositoryURI());
            jAccessGroup.put((Object)"desc", (Object)accessGroup.getDescription());
            jAccessGroups.add((Object)jAccessGroup);
            ++n2;
        }
        if (config.isJSONEnabled()) {
            config.getOutputStream().print((CharSequence)jAccessGroups.toString());
            return;
        }
        if (jAccessGroups.size() == 0) {
            return;
        }
        IndentingPrintStream out = config.getWrappedOutputStream();
        for (Object obj : jAccessGroups) {
            JSONObject jAccessGroup = (JSONObject)obj;
            out.println((CharSequence)AliasUtil.selector((AliasUtil.IAliasOptions)config.getAliasConfig(), (String)((String)jAccessGroup.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jAccessGroup.get((Object)"uuid"))), (String)((String)jAccessGroup.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.ACCESSGROUP));
            if (!verbose) continue;
            String desc = (String)jAccessGroup.get((Object)"desc");
            if (desc != null && !desc.trim().isEmpty()) {
                String[] lines = desc.split("\n");
                int i = 0;
                while (i < lines.length && i < 5) {
                    String line = lines[i].trim();
                    if (!line.isEmpty()) {
                        out.indent().println((CharSequence)SubcommandUtil.sanitizeText((String)lines[i].trim(), (int)80, (boolean)true));
                    }
                    ++i;
                }
                continue;
            }
            out.indent().println((CharSequence)Messages.ListAccessGroups_NO_DESCRIPTION);
        }
    }
}

