/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.listcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.locks.ContributorNameDTO;
import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmBaseline;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmHandle;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmSnapshot;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspace2;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractItemPrinter {
    private IFilesystemRestClient client;
    protected IScmClientConfiguration config;
    protected ITeamRepository repo;
    private Map<UUID, JSONObject> ownerIdToInfo = new HashMap<UUID, JSONObject>();

    public AbstractItemPrinter(IScmClientConfiguration config, ITeamRepository repo) {
        this.config = config;
        this.repo = repo;
    }

    protected IFilesystemRestClient getClient() throws FileSystemException {
        if (this.client == null) {
            this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        }
        return this.client;
    }

    public abstract void printResult(List<Object> var1, boolean var2) throws FileSystemException;

    private JSONObject getOwnerDetails(IItem owner) {
        JSONObject ownerObj = new JSONObject();
        ownerObj.put((Object)"type", (Object)owner.getItemType().getName());
        ownerObj.put((Object)"itemId", (Object)owner.getItemId().getUuidValue());
        if (owner instanceof IContributor) {
            IContributor contributor = (IContributor)owner;
            ownerObj.put((Object)"name", (Object)contributor.getName());
            ownerObj.put((Object)"id", (Object)contributor.getUserId());
        } else if (owner instanceof ITeamArea) {
            ITeamArea ta = (ITeamArea)owner;
            ownerObj.put((Object)"name", (Object)ta.getName());
        } else if (owner instanceof IProjectArea) {
            IProjectArea pa = (IProjectArea)owner;
            ownerObj.put((Object)"name", (Object)pa.getName());
        } else if (owner instanceof IAccessGroup) {
            IAccessGroup ag = (IAccessGroup)owner;
            ownerObj.put((Object)"name", (Object)ag.getName());
        }
        return ownerObj;
    }

    private JSONObject fetchOwnerInfo(Object ownerHandle) throws FileSystemException {
        JSONObject ownerObj = null;
        IItem ownerItem = null;
        if (ownerHandle instanceof IAuditableHandle) {
            IAuditableHandle iAuditableHndl = (IAuditableHandle)ownerHandle;
            ownerObj = this.ownerIdToInfo.get(iAuditableHndl.getItemId());
            if (ownerObj == null) {
                try {
                    ownerItem = this.repo.itemManager().fetchCompleteItem((IItemHandle)iAuditableHndl, 0, null);
                }
                catch (TeamRepositoryException e) {
                    throw StatusHelper.wrap((String)com.ibm.team.filesystem.cli.core.internal.Messages.RepoUtil_CANNOT_FETCH_OWNER, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)this.repo.getRepositoryURI());
                }
            }
        } else if (ownerHandle instanceof ScmHandle) {
            ScmHandle scmHndl = (ScmHandle)ownerHandle;
            ownerObj = this.ownerIdToInfo.get(UUID.valueOf((String)scmHndl.getItemId()));
            if (ownerObj == null) {
                IItemType itemType = SubcommandUtil.getOwnerType((String)scmHndl.getItemType());
                if (itemType == null) {
                    throw StatusHelper.internalError((String)com.ibm.team.filesystem.cli.core.internal.Messages.RepoUtil_INVALID_OWNERTYPE);
                }
                ownerItem = RepoUtil.getItem((IItemType)itemType, (UUID)UUID.valueOf((String)scmHndl.getItemId()), (ITeamRepository)this.repo, (IScmClientConfiguration)this.config);
            }
        } else {
            throw StatusHelper.internalError((String)"Invalid owner handle type. Must be either a type of IAuditableHandle or ScmHandle");
        }
        if (ownerItem != null) {
            ownerObj = this.getOwnerDetails(ownerItem);
            this.ownerIdToInfo.put(ownerItem.getItemId(), ownerObj);
        }
        return ownerObj;
    }

    public JSONArray jsonizeWorkspaces(List<ScmWorkspace> workspaces, boolean verbose) throws FileSystemException {
        JSONArray jWrkspcs = new JSONArray();
        if (workspaces == null || workspaces.isEmpty()) {
            return jWrkspcs;
        }
        Collections.sort(workspaces, new Comparator<ScmWorkspace>(){

            @Override
            public int compare(ScmWorkspace o1, ScmWorkspace o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                return AbstractItemPrinter.this.compareImpl(name1, name2);
            }
        });
        if (verbose) {
            ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>(workspaces.size());
            for (ScmWorkspace ws : workspaces) {
                ParmsWorkspace parmsWs = new ParmsWorkspace(this.repo.getRepositoryURI(), ws.getItemId());
                wsList.add(parmsWs);
            }
            List wsDetails = RepoUtil.getWorkspaceDetails(wsList, (IFilesystemRestClient)this.getClient(), (IScmClientConfiguration)this.config);
            for (WorkspaceDetailsDTO wsDetail : wsDetails) {
                JSONObject ownerInfo = this.fetchOwnerInfo(wsDetail.getOwner());
                JSONObject jWS = JSONPrintUtil.jsonize((String)wsDetail.getName(), (String)wsDetail.getItemId(), (String)wsDetail.getRepositoryURL(), (boolean)wsDetail.isStream(), (JSONObject)ownerInfo);
                JSONPrintUtil.addJsonizedLockOwner((JSONObject)jWS, (ContributorNameDTO)wsDetail.getLockedBy());
                String desc = wsDetail.getDescription();
                if (desc != null && desc.length() > 0) {
                    jWS.put((Object)"desc", (Object)SubcommandUtil.sanitizeText((String)desc));
                }
                JSONArray components = new JSONArray();
                for (WorkspaceComponentDTO comp : wsDetail.getComponents()) {
                    JSONObject jComp = JSONPrintUtil.jsonize((String)comp.getName(), (String)comp.getItemId(), (String)wsDetail.getRepositoryURL());
                    JSONPrintUtil.addJsonizedLockOwner((JSONObject)jComp, (ContributorNameDTO)comp.getLockedBy());
                    components.add((Object)jComp);
                }
                jWS.put((Object)"components", (Object)components);
                jWrkspcs.add((Object)jWS);
            }
        } else {
            for (ScmWorkspace ws : workspaces) {
                JSONObject ownerInfo = this.fetchOwnerInfo(ws.getOwner());
                JSONObject jWS = JSONPrintUtil.jsonize((String)ws.getName(), (String)ws.getItemId(), (String)this.repo.getRepositoryURI(), (boolean)ws.isStream(), (JSONObject)ownerInfo);
                if (ws instanceof ScmWorkspace2) {
                    ScmWorkspace2 ws2 = (ScmWorkspace2)ws;
                    JSONPrintUtil.addJsonizedLockOwner((JSONObject)jWS, (String)ws2.getLockOwner());
                }
                jWrkspcs.add((Object)jWS);
            }
        }
        return jWrkspcs;
    }

    public JSONArray jsonizeSnapshots(List<ScmSnapshot> items) throws FileSystemException {
        SimpleDateFormat format = this.getDateFormat();
        JSONArray jItems = new JSONArray();
        for (ScmSnapshot item : items) {
            JSONObject json = this.jsonizeSnapshot(item, format);
            jItems.add((Object)json);
        }
        return jItems;
    }

    private JSONObject jsonizeSnapshot(ScmSnapshot item, SimpleDateFormat format) throws FileSystemException {
        JSONObject json = JSONPrintUtil.jsonize((String)item.getName(), (String)item.getItemId(), (String)this.repo.getRepositoryURI());
        String comment = item.getComment();
        if (comment == null || comment.isEmpty()) {
            comment = Messages.ListSnapshotsCmd_NO_COMMENT;
        }
        json.put((Object)"comment", (Object)comment);
        ArrayList<ScmWorkspace> ownerList = new ArrayList<ScmWorkspace>(1);
        ownerList.add(item.getOwner());
        JSONArray jWorkspaces = this.jsonizeWorkspaces(ownerList, false);
        json.put((Object)"ownedby", jWorkspaces.get(0));
        json.put((Object)"creationDate", (Object)format.format(item.getCreationDate()));
        return json;
    }

    protected SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = (SimpleDateFormat)DateFormat.getDateTimeInstance(2, 3);
        format = SubcommandUtil.getDateFormat((String)format.toPattern(), (IScmClientConfiguration)this.config);
        return format;
    }

    public JSONArray jsonizeBaselines(List<ScmBaseline> baselines) throws FileSystemException {
        SimpleDateFormat format = this.getDateFormat();
        JSONArray jItems = new JSONArray();
        for (ScmBaseline item : baselines) {
            JSONObject json = this.jsonizeBaseline(item, format);
            jItems.add((Object)json);
        }
        return jItems;
    }

    private JSONObject jsonizeBaseline(ScmBaseline baseline, DateFormat dt) {
        JSONObject json = JSONPrintUtil.jsonize((String)baseline.getName(), (String)baseline.getItemId(), (String)this.repo.getRepositoryURI());
        json.put((Object)"id", (Object)Integer.parseInt(baseline.getId()));
        json.put((Object)"name", (Object)baseline.getName());
        json.put((Object)"uuid", (Object)baseline.getItemId());
        json.put((Object)"creationDate", (Object)dt.format(baseline.getCreationDate()));
        json.put((Object)"contributor", (Object)baseline.getCreator().getName());
        json.put((Object)"comment", (Object)JSONPrintUtil.getBaselineCommentForJson((String)baseline.getComment()));
        return json;
    }

    protected int compareImpl(String name1, String name2) {
        if (name1 == null) {
            return 1;
        }
        if (name2 == null) {
            return -1;
        }
        return name1.compareToIgnoreCase(name2);
    }

    protected void printWorkspaces(JSONArray jWrkspcs, IndentingPrintStream out, boolean verbose) {
        if (verbose) {
            for (Object obj : jWrkspcs) {
                JSONObject jWS = (JSONObject)obj;
                String name = (String)jWS.get((Object)"name");
                String desc = (String)jWS.get((Object)"desc");
                UUID handle = UUID.valueOf((String)((String)jWS.get((Object)"uuid")));
                String url = (String)jWS.get((Object)"url");
                String owner = (String)jWS.get((Object)"owner");
                String ownerString = this.getOwnerString(jWS, url);
                if (ownerString == null || ownerString.isEmpty()) {
                    ownerString = owner;
                }
                RepoUtil.ItemType itemType = PendingChangesUtil.getWorkspaceType((String)((String)jWS.get((Object)"type")));
                String streamLockOwner = JSONPrintUtil.getLockOwnerName((JSONObject)jWS);
                String selector = AliasUtil.selector((AliasUtil.IAliasOptions)this.config.getAliasConfig(), (String)name, (UUID)handle, (String)url, (RepoUtil.ItemType)itemType);
                String publishStatus = (String)jWS.get((Object)"publishStatus");
                if (desc == null || desc.length() == 0) {
                    if (streamLockOwner == null) {
                        if (publishStatus == null) {
                            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)selector, (Object)ownerString));
                        } else {
                            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Publish_Status, (Object[])new String[]{selector, ownerString, publishStatus}));
                        }
                    } else if (publishStatus == null) {
                        out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Lock_Owner, (Object[])new String[]{selector, streamLockOwner, ownerString}));
                    } else {
                        out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Lock_Owner_And_Publish_Status, (Object[])new String[]{selector, streamLockOwner, ownerString, publishStatus}));
                    }
                } else {
                    String sanitizedDescription = SubcommandUtil.sanitizeText((String)desc);
                    if (streamLockOwner == null) {
                        if (publishStatus == null) {
                            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header2, (Object[])new String[]{selector, ownerString, sanitizedDescription}));
                        } else {
                            out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header2_And_Publish_Status, (Object[])new String[]{selector, ownerString, sanitizedDescription, publishStatus}));
                        }
                    } else if (publishStatus == null) {
                        out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header2_With_Lock_Owner, (Object[])new String[]{selector, streamLockOwner, ownerString, sanitizedDescription}));
                    } else {
                        out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header2_With_Lock_Owner_And_Publish_Status, (Object[])new String[]{selector, streamLockOwner, ownerString, sanitizedDescription, publishStatus}));
                    }
                }
                JSONArray comps = (JSONArray)jWS.get((Object)"components");
                if (comps == null) continue;
                IndentingPrintStream verboseOut = out.indent();
                for (Object jobj : comps) {
                    JSONObject jComp = (JSONObject)jobj;
                    String output = AliasUtil.selector((AliasUtil.IAliasOptions)this.config.getAliasConfig(), (String)((String)jComp.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jComp.get((Object)"uuid"))), (String)((String)jComp.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                    String lockedby = JSONPrintUtil.getLockOwnerName((JSONObject)jComp);
                    if (lockedby != null) {
                        verboseOut.println((CharSequence)NLS.bind((String)Messages.ListCmd_2, (Object)output, (Object)lockedby));
                        continue;
                    }
                    verboseOut.println((CharSequence)output);
                }
            }
        } else {
            for (Object obj : jWrkspcs) {
                JSONObject jWS = (JSONObject)obj;
                String name = (String)jWS.get((Object)"name");
                UUID handle = UUID.valueOf((String)((String)jWS.get((Object)"uuid")));
                String url = (String)jWS.get((Object)"url");
                RepoUtil.ItemType itemType = PendingChangesUtil.getWorkspaceType((String)((String)jWS.get((Object)"type")));
                String owner = (String)jWS.get((Object)"owner");
                String ownerString = this.getOwnerString(jWS, url);
                if (ownerString == null || ownerString.isEmpty()) {
                    ownerString = owner;
                }
                String lockOwner = JSONPrintUtil.getLockOwnerName((JSONObject)jWS);
                String selector = AliasUtil.selector((AliasUtil.IAliasOptions)this.config.getAliasConfig(), (String)name, (UUID)handle, (String)url, (RepoUtil.ItemType)itemType);
                String publishStatus = (String)jWS.get((Object)"publishStatus");
                if (lockOwner == null) {
                    if (publishStatus == null) {
                        out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header, (Object)selector, (Object)ownerString));
                        continue;
                    }
                    out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Publish_Status, (Object[])new String[]{selector, ownerString, publishStatus}));
                    continue;
                }
                if (publishStatus == null) {
                    out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Lock_Owner, (Object[])new String[]{selector, lockOwner, ownerString}));
                    continue;
                }
                out.println((CharSequence)NLS.bind((String)Messages.ListCmd_Workspace_Header_With_Lock_Owner_And_Publish_Status, (Object[])new String[]{selector, lockOwner, ownerString, publishStatus}));
            }
        }
    }

    protected void printSnapshot(IndentingPrintStream out, JSONObject item) {
        String selector = AliasUtil.selector((String)((String)item.get((Object)"name")), (UUID)UUID.valueOf((String)((String)item.get((Object)"uuid"))), (String)((String)item.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        JSONObject jOwnedBy = (JSONObject)item.get((Object)"ownedby");
        String ownerSelector = AliasUtil.selector((String)((String)jOwnedBy.get((Object)"name")), (UUID)UUID.valueOf((String)((String)jOwnedBy.get((Object)"uuid"))), (String)((String)jOwnedBy.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        String comment = (String)item.get((Object)"comment");
        String publishStatus = (String)item.get((Object)"publishStatus");
        if (publishStatus == null) {
            out.println((CharSequence)NLS.bind((String)Messages.SnapshotItemPrinter_OUTPUT, (Object[])new String[]{selector, comment, ownerSelector, (String)item.get((Object)"creationDate")}));
        } else {
            out.println((CharSequence)NLS.bind((String)Messages.SnapshotItemPrinter_OUTPUT_WITH_PUBLISH_STATUS, (Object[])new String[]{selector, comment, ownerSelector, (String)item.get((Object)"creationDate"), publishStatus}));
        }
    }

    private String getOwnerString(JSONObject wrkSpcObj, String repoUrl) {
        boolean NAME = false;
        boolean ITEM_ID = true;
        int TYPE = 2;
        String[] ownerInfo = JSONPrintUtil.getOwner((JSONObject)wrkSpcObj);
        String ownerString = null;
        if (ownerInfo.length == 3) {
            RepoUtil.ItemType ownerItemType = PendingChangesUtil.getOwnerType((String)ownerInfo[2]);
            ownerString = AliasUtil.selector((String)ownerInfo[0], (UUID)UUID.valueOf((String)ownerInfo[1]), (String)repoUrl, (RepoUtil.ItemType)ownerItemType);
        } else if (ownerInfo.length == 1) {
            ownerString = ownerInfo[0];
        }
        return ownerString;
    }
}

