/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers.AbstractConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.api.storage.FileOptionsFactory;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.VersionableChangeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.LocalConflictSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class InPlaceConflictHandler
extends AbstractConflictHandler {
    private static final String TEMPORARY_PREFIX = "TMP";
    private static final String TEMPORARY_EXTENSION = ".tmp";
    public static final String MARKER_MY_SECTION = "<<<<<<< mine";
    public static final String MARKER_PROPOSED = "=======";
    public static final String MARKER_END = ">>>>>>> proposed";

    public void writeDiff(IPath toWrite, BufferedReader ancestorReader, BufferedReader leftReader, BufferedReader rightReader, OutputStreamWriter output) throws FileSystemException, IOException {
        LineRangeComparator ancestor = this.streamToComparator(ancestorReader);
        LineRangeComparator left = this.streamToComparator(leftReader);
        LineRangeComparator right = this.streamToComparator(rightReader);
        Writer writer = new Writer(output);
        if (left == null || right == null) {
            if (left != null) {
                writer.write(left);
            } else {
                assert (right != null);
                writer.write(right);
            }
            return;
        }
        RangeDifference[] diffs = RangeDifferencer.findRanges((IRangeComparator)ancestor, (IRangeComparator)left, (IRangeComparator)right);
        RangeDifference[] rangeDifferenceArray = diffs;
        int n = diffs.length;
        int n2 = 0;
        while (n2 < n) {
            RangeDifference diff = rangeDifferenceArray[n2];
            switch (diff.kind()) {
                case 0: {
                    writer.write(ancestor, diff.ancestorStart(), diff.ancestorEnd());
                    break;
                }
                case 3: {
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    break;
                }
                case 2: {
                    writer.write(right, diff.rightStart(), diff.rightEnd());
                    break;
                }
                case 4: {
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    break;
                }
                case 1: {
                    writer.write(MARKER_MY_SECTION);
                    writer.write(left, diff.leftStart(), diff.leftEnd());
                    this.writeAncestor(writer, ancestor, diff);
                    writer.write(this.getMarkerProposed());
                    writer.write(right, diff.rightStart(), diff.rightEnd());
                    writer.write(this.getMarkerEnd());
                    break;
                }
                default: {
                    throw StatusHelper.failure((String)("Unexpected RangeDifference.kind(): " + diff.kind()), null);
                }
            }
            ++n2;
        }
    }

    protected String getMarkerProposed() {
        return MARKER_PROPOSED;
    }

    protected String getMarkerEnd() {
        return MARKER_END;
    }

    protected void writeAncestor(Writer writer, LineRangeComparator ancestor, RangeDifference diff) throws IOException {
    }

    private LineRangeComparator streamToComparator(BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            return null;
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return new LineRangeComparator(lines.toArray(new String[lines.size()]));
    }

    @Override
    protected void writeConflict(IPath cfaRoot, ParmsWorkspace ws, ComponentSyncDTO compSync, ConflictSyncDTO conflictSync, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        if (!conflictSync.isContentConflict() || !conflictSync.getConflictType().equals("modify_modify")) {
            return;
        }
        this.writeConflict(cfaRoot, ws, compSync.getComponentItemId(), conflictSync.getVersionableItemId(), conflictSync.getVersionableItemType(), conflictSync.getPathHint(), conflictSync.getCommonAncestorVersionableStateId(), conflictSync.getOriginalSelectedContributorVersionableStateId(), conflictSync.getProposedContributorVersionableStateId(), client, config);
    }

    @Override
    protected void writeLocalConflict(IPath cfaRoot, Map.Entry<ParmsWorkspace, List<ResolveCmd.LocalConflictToResolve>> entry, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        for (ResolveCmd.LocalConflictToResolve conflict : entry.getValue()) {
            LocalConflictSyncDTO localConflictItem = conflict.getLocalConflictItem();
            if (!localConflictItem.isContentType()) continue;
            this.writeConflict(cfaRoot, entry.getKey(), conflict.getComponentId(), localConflictItem.getVersionableItemId(), localConflictItem.getVersionableItemType(), localConflictItem.getPathHint(), localConflictItem.getCommonAncestorVersionableStateId(), localConflictItem.getProposedContributorVersionableStateId(), client, config);
        }
    }

    @Override
    protected void writeConflict(IPath cfaRoot, ParmsWorkspace ws, String componentId, VersionableChangeDTO changeDTO, ChangeSyncDTO changeSync, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        if (!changeSync.isContentChange() || !changeSync.isModifyType()) {
            return;
        }
        this.writeConflict(cfaRoot, ws, componentId, changeDTO.getVersionableItemId(), changeDTO.getVersionableType(), changeDTO.getParentPathHint(), changeSync.getBeforeStateId(), changeDTO.getConfigurationStateId(), changeSync.getAfterStateId(), client, config);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeConflict(IPath cfaRoot, ParmsWorkspace ws, String componentId, String versionableId, String versionableType, String pathHint, String ancestorId, String proposedId, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ShareableDTO shareableDTO;
        try {
            shareableDTO = RepoUtil.findLocalVersionable((ParmsWorkspace)ws, (String)componentId, (String)versionableId, (String)versionableType, (IFilesystemRestClient)client, (IPath)cfaRoot);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, (Object)pathHint));
        }
        IPath path = new Path(shareableDTO.getSandboxPath()).append(StringUtil.createPathString((List)shareableDTO.getRelativePath().getSegments()));
        ResourcePropertiesDTO resProp = RepoUtil.getResourceProperties((String)path.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (!resProp.getVersionableItemType().equals("file")) return;
        if (resProp.getFileProperties() == null) {
            return;
        }
        boolean requiresTransform = LocalFileStorage.getFileAccessExtension().transformsContents() && resProp.getUserProperties() != null;
        boolean resetToReadOnly = false;
        File file = new File(path.toOSString());
        try {
            InputStream inputStream;
            OutputStream fileStream;
            File tempFile;
            Charset streamEncoding;
            OutputStream outStream;
            BufferedReader right;
            BufferedReader left;
            BufferedReader ancestor;
            OutputStreamWriter out;
            block29: {
                if (file.exists() && !file.canWrite()) {
                    resetToReadOnly = file.setWritable(true);
                }
                out = null;
                ancestor = null;
                left = null;
                right = null;
                outStream = null;
                streamEncoding = null;
                tempFile = null;
                try {
                    tempFile = File.createTempFile(TEMPORARY_PREFIX, null);
                    break block29;
                }
                catch (IOException e) {
                    IPath iPath = path.addFileExtension(TEMPORARY_EXTENSION);
                    tempFile = new File(iPath.toOSString());
                }
                while (tempFile.exists()) {
                    void var25_28;
                    IPath iPath = var25_28.addFileExtension(TEMPORARY_EXTENSION);
                    tempFile = new File(iPath.toOSString());
                }
            }
            try {
                outStream = requiresTransform ? new ByteArrayOutputStream() : this.findOutputStreamFor(tempFile);
                if (outStream == null) {
                    this.safeClose(out);
                    this.safeClose(ancestor);
                    this.safeClose(left);
                    this.safeClose(right);
                    return;
                }
            }
            catch (Throwable throwable) {
                this.safeClose(out);
                this.safeClose(ancestor);
                this.safeClose(left);
                this.safeClose(right);
                throw throwable;
            }
            {
                ITeamRepository repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
                streamEncoding = this.getEncodingFor(resProp);
                ancestor = this.fetchReaderForFileItem(repo, ws.workspaceItemId, componentId, versionableId, ancestorId, config);
                try {
                    left = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), streamEncoding));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)fileNotFoundException);
                }
                right = this.fetchReaderForFileItem(repo, ws.workspaceItemId, componentId, versionableId, proposedId, config);
                Assert.isTrue((left != null && right != null ? 1 : 0) != 0);
                out = new OutputStreamWriter(outStream, streamEncoding);
                try {
                    this.writeDiff(path, ancestor, left, right, out);
                }
                catch (IOException iOException) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)iOException);
                }
            }
            this.safeClose(out);
            this.safeClose(ancestor);
            this.safeClose(left);
            this.safeClose(right);
            if (requiresTransform) {
                InputStream inputStream2;
                fileStream = null;
                Closeable closeable = null;
                try {
                    try {
                        fileStream = this.findOutputStreamFor(path);
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)outStream).toByteArray());
                        IFileOptions fileInfo = FileOptionsFactory.getFileOptions((boolean)false, (FileLineDelimiter)FileLineDelimiter.LINE_DELIMITER_PLATFORM, (String)streamEncoding.toString(), (Map)resProp.getUserProperties());
                        inputStream2 = LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileInfo, (InputStream)byteArrayInputStream);
                        RepoUtil.transfer((InputStream)inputStream2, (OutputStream)fileStream);
                    }
                    catch (IOException e) {
                        throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(fileStream);
                    this.safeClose(closeable);
                    throw throwable;
                }
                this.safeClose(fileStream);
                this.safeClose(inputStream2);
                return;
            }
            if (!file.delete()) return;
            fileStream = null;
            Closeable closeable = null;
            try {
                try {
                    fileStream = this.findOutputStreamFor(path);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(tempFile));
                    IFileOptions fileInfo = FileOptionsFactory.getFileOptions((boolean)false, (FileLineDelimiter)FileLineDelimiter.LINE_DELIMITER_PLATFORM, (String)streamEncoding.toString(), (Map)resProp.getUserProperties());
                    inputStream = LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileInfo, (InputStream)bufferedInputStream);
                    RepoUtil.transfer((InputStream)inputStream, (OutputStream)fileStream);
                }
                catch (IOException e) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(fileStream);
                this.safeClose(closeable);
                throw throwable;
            }
            this.safeClose(fileStream);
            this.safeClose(inputStream);
            tempFile.delete();
            return;
        }
        finally {
            if (resetToReadOnly) {
                file.setWritable(false);
            }
        }
    }

    protected void writeConflict(IPath cfaRoot, ParmsWorkspace ws, String componentId, String versionableId, String versionableType, String pathHint, String ancestorId, String mineId, String proposedId, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        block20: {
            ShareableDTO shareableDTO;
            try {
                shareableDTO = RepoUtil.findLocalVersionable((ParmsWorkspace)ws, (String)componentId, (String)versionableId, (String)versionableType, (IFilesystemRestClient)client, (IPath)cfaRoot);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, (Object)pathHint));
            }
            IPath path = new Path(shareableDTO.getSandboxPath()).append(StringUtil.createPathString((List)shareableDTO.getRelativePath().getSegments()));
            ResourcePropertiesDTO resProp = RepoUtil.getResourceProperties((String)path.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            if (!resProp.getVersionableItemType().equals("file") || resProp.getFileProperties() == null) {
                return;
            }
            boolean requiresTransform = LocalFileStorage.getFileAccessExtension().transformsContents() && resProp.getUserProperties() != null;
            boolean resetToReadOnly = false;
            File file = new File(path.toOSString());
            try {
                Charset streamEncoding;
                OutputStream outStream;
                BufferedReader right;
                BufferedReader left;
                BufferedReader ancestor;
                OutputStreamWriter out;
                block18: {
                    if (file.exists() && !file.canWrite()) {
                        resetToReadOnly = file.setWritable(true);
                    }
                    out = null;
                    ancestor = null;
                    left = null;
                    right = null;
                    outStream = null;
                    streamEncoding = null;
                    try {
                        outStream = requiresTransform ? new ByteArrayOutputStream() : this.findOutputStreamFor(path);
                        if (outStream != null) break block18;
                        this.safeClose(out);
                        this.safeClose(ancestor);
                        this.safeClose(left);
                        this.safeClose(right);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.safeClose(out);
                        this.safeClose(ancestor);
                        this.safeClose(left);
                        this.safeClose(right);
                        throw throwable;
                    }
                }
                ITeamRepository repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
                ancestor = this.fetchReaderForFileItem(repo, ws.workspaceItemId, componentId, versionableId, ancestorId, config);
                left = this.fetchReaderForFileItem(repo, ws.workspaceItemId, componentId, versionableId, mineId, config);
                right = this.fetchReaderForFileItem(repo, ws.workspaceItemId, componentId, versionableId, proposedId, config);
                Assert.isTrue((left != null && right != null ? 1 : 0) != 0);
                streamEncoding = this.getEncodingFor(resProp);
                out = new OutputStreamWriter(outStream, streamEncoding);
                try {
                    this.writeDiff(path, ancestor, left, right, out);
                }
                catch (IOException e) {
                    throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)e);
                }
                this.safeClose(out);
                this.safeClose(ancestor);
                this.safeClose(left);
                this.safeClose(right);
                if (!requiresTransform) break block20;
                OutputStream fileStream = null;
                InputStream in = null;
                try {
                    try {
                        fileStream = this.findOutputStreamFor(path);
                        in = new ByteArrayInputStream(((ByteArrayOutputStream)outStream).toByteArray());
                        IFileOptions fileInfo = FileOptionsFactory.getFileOptions((boolean)false, (FileLineDelimiter)FileLineDelimiter.LINE_DELIMITER_PLATFORM, (String)streamEncoding.toString(), (Map)resProp.getUserProperties());
                        in = LocalFileStorage.getFileAccessExtension().prepareContentsToSet(fileInfo, in);
                        RepoUtil.transfer((InputStream)in, (OutputStream)fileStream);
                    }
                    catch (IOException e) {
                        throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_3, (Object)path.toOSString()), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(fileStream);
                    this.safeClose(in);
                    throw throwable;
                }
                this.safeClose(fileStream);
                this.safeClose(in);
            }
            finally {
                if (resetToReadOnly) {
                    file.setWritable(false);
                }
            }
        }
    }

    private Charset getEncodingFor(ResourcePropertiesDTO resProp) {
        if (resProp.getFileProperties() != null) {
            String encoding = resProp.getFileProperties().getEncoding();
            return this.getEncoding(encoding);
        }
        return Charset.defaultCharset();
    }

    private Charset getEncoding(String encoding) {
        if (encoding != null && encoding.length() > 0) {
            try {
                if (encoding != null) {
                    return Charset.forName(encoding);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }

    private BufferedReader fetchReaderForFileItem(ITeamRepository repo, String wsId, String compId, String itemId, String stateId, IScmClientConfiguration config) throws FileSystemException {
        if (itemId == null || stateId == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BufferedReader reader = null;
        try {
            IFileItem fileItem = RepoUtil.httpDownloadFile((ITeamRepository)repo, (String)wsId, (String)compId, (String)itemId, (String)stateId, (OutputStream)bos, (IScmClientConfiguration)config);
            Charset cs = Charset.defaultCharset();
            if (fileItem.getContent() != null) {
                cs = this.getEncoding(fileItem.getContent().getCharacterEncoding());
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), cs));
        }
        finally {
            this.safeClose(bos);
        }
        return reader;
    }

    private OutputStream findOutputStreamFor(IPath filePath) throws FileSystemException {
        try {
            return new BufferedOutputStream(new FileOutputStream(filePath.toFile()));
        }
        catch (FileNotFoundException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_4, (Object)filePath.toOSString()), (Throwable)e);
        }
    }

    private OutputStream findOutputStreamFor(File file) throws FileSystemException {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.InPlaceConflictHandler_4, (Object)file.getAbsolutePath()), (Throwable)e);
        }
    }

    private final void safeClose(Closeable toClose) {
        if (toClose != null) {
            try {
                toClose.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class LineRangeComparator
    implements IRangeComparator {
        private final String[] lines;

        public LineRangeComparator(String[] lines) {
            this.lines = lines;
        }

        public int getRangeCount() {
            return this.lines.length;
        }

        public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
            if (thisIndex > this.getRangeCount()) {
                return false;
            }
            if (otherIndex > other.getRangeCount()) {
                return false;
            }
            LineRangeComparator otherLrc = (LineRangeComparator)other;
            String s1 = this.lines[thisIndex];
            String s2 = otherLrc.lines[otherIndex];
            if (s1.length() == s2.length() && s1.hashCode() == s2.hashCode()) {
                return s1.equals(s2);
            }
            return false;
        }

        public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
            return false;
        }
    }

    static final class Writer {
        private static final String NEWLINE = System.getProperty("line.separator");
        final OutputStreamWriter out;

        public Writer(OutputStreamWriter output) {
            this.out = output;
        }

        public void write(String s) throws IOException {
            this.out.write(s);
            this.out.write(NEWLINE);
        }

        public void write(LineRangeComparator comp, int start, int end) throws IOException {
            int i = start;
            while (i < end) {
                this.write(comp.lines[i]);
                ++i;
            }
        }

        public void write(LineRangeComparator comp) throws IOException {
            int i = 0;
            while (i < comp.lines.length) {
                this.write(comp.lines[i]);
                ++i;
            }
        }
    }
}

