/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands.conflicthandlers;

import com.ibm.team.filesystem.cli.client.internal.flowcommands.IConflictHandler;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.PortsUtil;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeSetSourceDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ContentChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.VersionableChangeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ConflictSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.UnresolvedFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractConflictHandler
implements IConflictHandler {
    private boolean quiet = false;
    private boolean verbose = false;
    private IUpdateReport report;

    @Override
    public void configureQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void configureVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected final boolean isQuiet() {
        return this.quiet;
    }

    protected final boolean isVerbose() {
        return this.verbose;
    }

    protected final IUpdateReport getReport() {
        return this.report;
    }

    @Override
    public void handleConflicts(IPath cfaRoot, ParmsWorkspace ws, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(ws), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(ws.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                for (UnresolvedFolderSyncDTO unresolvedSync : compSync.getUnresolved()) {
                    for (ConflictSyncDTO conflictSync : unresolvedSync.getConflicts()) {
                        this.handleConflict(cfaRoot, ws, compSync, conflictSync, client, config);
                    }
                }
            }
        }
    }

    @Override
    public void handleLocalConflicts(IPath cfaRoot, Map<ParmsWorkspace, List<ResolveCmd.LocalConflictToResolve>> conflictsToResolve, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        for (Map.Entry<ParmsWorkspace, List<ResolveCmd.LocalConflictToResolve>> entry : conflictsToResolve.entrySet()) {
            this.handleLocalConflict(cfaRoot, entry, client, config);
        }
    }

    protected void handleConflict(IPath cfaRoot, ParmsWorkspace ws, ComponentSyncDTO compSync, ConflictSyncDTO conflictSync, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        this.writeConflict(cfaRoot, ws, compSync, conflictSync, client, config);
    }

    protected void handleLocalConflict(IPath cfaRoot, Map.Entry<ParmsWorkspace, List<ResolveCmd.LocalConflictToResolve>> entry, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        this.writeLocalConflict(cfaRoot, entry, client, config);
    }

    @Override
    public void handleConflicts(IPath cfaRoot, ParmsWorkspace ws, CurrentPatchDTO currentPort, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        this.handleConflicts(cfaRoot, ws, currentPort, currentPort.getChanges(), client, config);
    }

    @Override
    public void handleConflicts(IPath cfaRoot, ParmsWorkspace ws, CurrentPatchDTO currentPort, List<VersionableChangeDTO> changes, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ChangeSetSyncDTO changeSetSync = PortsUtil.getChangeSet((String)ws.repositoryUrl, (ChangeSetSourceDTO)currentPort.getSource(), (boolean)true, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        for (VersionableChangeDTO changeDTO : changes) {
            if (!changeDTO.getVersionableType().equals("file")) continue;
            for (ChangeDetailDTO detailDTO : changeDTO.getChangeDetails()) {
                if (!(detailDTO instanceof ContentChangeDetailDTO) || !detailDTO.getKind().equals("conflict") || detailDTO.isResolved()) continue;
                for (ChangeFolderSyncDTO changeFolderSync : changeSetSync.getChanges()) {
                    for (ChangeSyncDTO changeSync : changeFolderSync.getChanges()) {
                        if (!changeSync.getVersionableItemId().equals(changeDTO.getVersionableItemId())) continue;
                        this.handleConflict(cfaRoot, ws, changeSetSync.getComponentItemId(), changeDTO, changeSync, client, config);
                    }
                }
            }
        }
    }

    protected void handleConflict(IPath cfaRoot, ParmsWorkspace ws, String componentId, VersionableChangeDTO changeDTO, ChangeSyncDTO changeSync, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        this.writeConflict(cfaRoot, ws, componentId, changeDTO, changeSync, client, config);
    }

    protected abstract void writeConflict(IPath var1, ParmsWorkspace var2, ComponentSyncDTO var3, ConflictSyncDTO var4, IFilesystemRestClient var5, IScmClientConfiguration var6) throws FileSystemException;

    protected abstract void writeConflict(IPath var1, ParmsWorkspace var2, String var3, VersionableChangeDTO var4, ChangeSyncDTO var5, IFilesystemRestClient var6, IScmClientConfiguration var7) throws FileSystemException;

    protected abstract void writeLocalConflict(IPath var1, Map.Entry<ParmsWorkspace, List<ResolveCmd.LocalConflictToResolve>> var2, IFilesystemRestClient var3, IScmClientConfiguration var4) throws FileSystemException;
}

