/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.flowcommands;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.flowcommands.DeliverCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.lock.LockListCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmdOpts;
import com.ibm.team.filesystem.cli.client.internal.workspace.AddComponentsCmd;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeLogCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompareCE;
import com.ibm.team.filesystem.client.rest.parameters.ParmsContext;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliver;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverChangeSetsOrBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverComponents;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliverWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeliveryRequiresHistoryReorderingDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStructuredResultOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changelog.ChangeLogEntryDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliverResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DeliveryRequiresHistoryReorderingDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceComponentOperationsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.BaselineSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkItemSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.hierarchy.WorkItemHierarchyNodeDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.subcommands.HelpCmd;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ChangeSetAlreadyInHistoryException;
import com.ibm.team.scm.common.ChangeSetsNotOutgoingException;
import com.ibm.team.scm.common.DeliveryIntroducesConflictsException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.OutstandingConflictsException;
import com.ibm.team.scm.common.StreamLockedException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class DeliverCmd
extends AbstractSubcommand {
    IFilesystemRestClient client = null;
    ParmsWorkspace sourceWs = null;
    WorkspaceDetailsDTO srcWsDetails = null;
    List<ChangeSetSyncDTO> unresolvedCsList = null;

    private static List<String> getOutgoingChanges(ParmsWorkspace srcWs, ParmsWorkspace tgtWs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<String> outgoingChanges = new ArrayList<String>();
        String compareId = DeliverCmd.compare(srcWs, tgtWs, client, config);
        ParmsChangeLogCE parmsChangeLog = new ParmsChangeLogCE();
        parmsChangeLog.inputID = compareId;
        parmsChangeLog.includeChangeSets = true;
        parmsChangeLog.includeBaselines = false;
        ChangeLogEntryDTO changeLogEntry = DeliverCmd.getOutgoing(parmsChangeLog, srcWs.repositoryUrl, client, config);
        if (!changeLogEntry.getEntryType().equals("clentry_changeset")) {
            for (ChangeLogEntryDTO entryDTO : changeLogEntry.getChildEntries()) {
                if (!entryDTO.getEntryType().equals("clentry_changeset")) continue;
                outgoingChanges.add(entryDTO.getItemId());
            }
        }
        return outgoingChanges;
    }

    private static Map<String, String> getOutgoingBaselines(ParmsWorkspace srcWs, ParmsWorkspace tgtWs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<String, String> outgoingBaselines = new HashMap<String, String>();
        try {
            IWorkspaceConnection srcWsConn = srcWs.getWorkspaceConnection(null);
            IWorkspaceConnection tgtWsConn = tgtWs.getWorkspaceConnection(null);
            IChangeHistorySyncReport syncReport = srcWsConn.compareTo((IFlowNodeConnection)tgtWsConn, 3, Collections.EMPTY_LIST, null);
            if (!syncReport.outgoingBaselines().isEmpty()) {
                List baselines = RepoUtil.getItems((IItemType)IBaseline.ITEM_TYPE, (List)syncReport.outgoingBaselines(), (ITeamRepository)srcWsConn.teamRepository(), (IScmClientConfiguration)config);
                for (IBaseline baseline : baselines) {
                    outgoingBaselines.put(baseline.getItemId().getUuidValue(), baseline.getName());
                }
            }
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_ON_WS_COMPARE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)srcWs.repositoryUrl);
        }
        return outgoingBaselines;
    }

    private static String compare(ParmsWorkspace srcWs, ParmsWorkspace tgtWs, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsCompareCE parmsCompare = new ParmsCompareCE();
        parmsCompare.context1 = new ParmsContext("workspace", srcWs.repositoryUrl, srcWs.workspaceItemId);
        parmsCompare.context2 = new ParmsContext("workspace", tgtWs.repositoryUrl, tgtWs.workspaceItemId);
        String compareId = null;
        try {
            compareId = client.postCompareCE(parmsCompare, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_ON_WS_COMPARE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)srcWs.repositoryUrl);
        }
        return compareId;
    }

    private static ChangeLogEntryDTO getOutgoing(ParmsChangeLogCE parmsChangeLog, String repoUri, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        parmsChangeLog.flowDirection = "outgoing";
        parmsChangeLog.includeComponents = false;
        parmsChangeLog.includeContributors = false;
        parmsChangeLog.includeDirection = false;
        parmsChangeLog.includePaths = false;
        parmsChangeLog.includeWorkItems = false;
        parmsChangeLog.pruneEmptyDirections = true;
        parmsChangeLog.pruneUnchangedComponents = true;
        ChangeLogEntryDTO changeLogEntry = null;
        try {
            changeLogEntry = client.getChangeLogCE(parmsChangeLog, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DeliverCmd_ERROR_ON_GET_CHANGELOG, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repoUri);
        }
        return changeLogEntry;
    }

    private static boolean isCsSelectorMatchesWorkItem(ChangeSetSyncDTO cs, String selector) {
        boolean toReturn = false;
        for (WorkItemSyncDTO wi : cs.getWorkItems()) {
            String[] tokens = wi.getLabel().split(":");
            if (!tokens[0].equals(selector)) continue;
            toReturn = true;
            break;
        }
        return toReturn;
    }

    private static List<ChangeSetSyncDTO> getMatchedCsList(List<ChangeSetSyncDTO> csList, List<String> csSelectors, Set<String> matchedSelectors, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<ChangeSetSyncDTO> normalized = new ArrayList<ChangeSetSyncDTO>();
        if (csSelectors != null && csSelectors.size() > 0) {
            HashSet<ChangeSetSyncDTO> tempCsList = new HashSet<ChangeSetSyncDTO>();
            if (csList != null && csList.size() > 0) {
                block0: for (String selector : csSelectors) {
                    for (ChangeSetSyncDTO cs : csList) {
                        if (!cs.getChangeSetComment().equals(selector) && !RepoUtil.uuidAndRepoMatches((UUID)UUID.valueOf((String)cs.getChangeSetItemId()), (String)cs.getRepositoryUrl(), (IUuidAliasRegistry.IUuidAlias)RepoUtil.lookupUuidAndAlias((String)selector)) && !DeliverCmd.isCsSelectorMatchesWorkItem(cs, selector)) continue;
                        tempCsList.add(cs);
                        matchedSelectors.add(selector);
                        continue block0;
                    }
                }
            }
            normalized.addAll(tempCsList);
        }
        return normalized;
    }

    private static List<BaselineSyncDTO> getMatchedBlList(List<BaselineSyncDTO> blList, List<String> blSelectors, Set<String> matchedSelectors, IScmClientConfiguration config, String repoUrl) throws FileSystemException {
        ArrayList<BaselineSyncDTO> normalized = new ArrayList<BaselineSyncDTO>();
        if (blSelectors != null && blSelectors.size() > 0) {
            HashSet<BaselineSyncDTO> tempBlList = new HashSet<BaselineSyncDTO>();
            if (blList != null && blList.size() > 0) {
                block0: for (String selector : blSelectors) {
                    IUuidAliasRegistry.IUuidAlias selectorUuid = RepoUtil.lookupUuidAndAlias((String)selector);
                    for (BaselineSyncDTO bl : blList) {
                        if ((selectorUuid == null || !RepoUtil.uuidAndRepoMatches((UUID)UUID.valueOf((String)bl.getBaselineItemId()), (String)repoUrl, (IUuidAliasRegistry.IUuidAlias)selectorUuid)) && !bl.getBaselineName().equalsIgnoreCase(selector)) continue;
                        tempBlList.add(bl);
                        matchedSelectors.add(selector);
                        continue block0;
                    }
                }
            }
            normalized.addAll(tempBlList);
        }
        return normalized;
    }

    private static ChangeSetSyncDTO[] normalizeCsUuidAndAlias(ParmsWorkspace srcWs, ParmsWorkspace tgtWs, List<String> csSelectors, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        HashMap<String, String> csItemIdToSelectorMap = new HashMap<String, String>();
        HashSet<String> unmatchedSelectors = new HashSet<String>();
        List<String> csList = DeliverCmd.getOutgoingChanges(srcWs, tgtWs, client, config);
        for (String selector : csSelectors) {
            boolean matched = false;
            IUuidAliasRegistry.IUuidAlias uuid = RepoUtil.lookupUuidAndAlias((String)selector);
            if (uuid != null) {
                for (String csId : csList) {
                    if (!RepoUtil.uuidAndRepoMatches((UUID)UUID.valueOf((String)csId), (String)srcWs.repositoryUrl, (IUuidAliasRegistry.IUuidAlias)uuid)) continue;
                    csItemIdToSelectorMap.put(uuid.getUuid().getUuidValue(), selector);
                    matched = true;
                    break;
                }
            }
            if (matched) continue;
            unmatchedSelectors.add(selector);
        }
        if (unmatchedSelectors.size() > 0) {
            DeliverCmd.printUnresolvedChangeSetSelectors(unmatchedSelectors, config);
        }
        ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(new ArrayList(csItemIdToSelectorMap.keySet()), (boolean)false, (String)srcWs.workspaceItemId, (String)"workspace", (String)srcWs.repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        return csDTOList;
    }

    private static List<BaselineDTO> normalizeBlUuidAndAlias(ParmsWorkspace sourceWs, ParmsWorkspace tgtWs, List<String> blSelectors, IScmClientConfiguration config, IFilesystemRestClient client) throws FileSystemException {
        HashMap<String, String> blItemIdToSelectorMap = new HashMap<String, String>();
        HashSet<String> unmatchedSelectors = new HashSet<String>();
        Map<String, String> blList = DeliverCmd.getOutgoingBaselines(sourceWs, tgtWs, client, config);
        for (String selector : blSelectors) {
            boolean matched = false;
            IUuidAliasRegistry.IUuidAlias uuid = RepoUtil.lookupUuidAndAlias((String)selector);
            if (uuid != null) {
                for (String blId : blList.keySet()) {
                    if (!RepoUtil.uuidAndRepoMatches((UUID)UUID.valueOf((String)blId), (String)sourceWs.repositoryUrl, (IUuidAliasRegistry.IUuidAlias)uuid)) continue;
                    blItemIdToSelectorMap.put(uuid.getUuid().getUuidValue(), selector);
                    matched = true;
                    break;
                }
            } else if (blList.values().contains(selector)) {
                String baselineUuid = null;
                for (String blUuid : blList.keySet()) {
                    if (!blList.get(blUuid).equals(selector)) continue;
                    baselineUuid = blUuid;
                    break;
                }
                blItemIdToSelectorMap.put(baselineUuid, selector);
                matched = true;
            }
            if (matched) continue;
            unmatchedSelectors.add(selector);
        }
        if (unmatchedSelectors.size() > 0) {
            DeliverCmd.printUnresolvedBaselines(unmatchedSelectors, config);
        }
        List baselines = RepoUtil.getBaselinesById(new ArrayList(blItemIdToSelectorMap.keySet()), (String)sourceWs.repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        return baselines;
    }

    private static String matchesSelector(IScmClientConfiguration config, String componentItemId, String componentName, Set<String> selectors, String repoUri) throws FileSystemException {
        String compAlias = null;
        IUuidAliasRegistry.IUuidAlias alias = RepoUtil.lookupUuidAndAlias((String)componentItemId, (String)repoUri);
        if (alias != null) {
            compAlias = alias.getMonicker();
        }
        for (String selector : selectors) {
            if (!componentItemId.equals(selector) && !selector.equals(compAlias) && !selector.equals(componentName)) continue;
            return selector;
        }
        return null;
    }

    private static List<ChangeSetSyncDTO> getCsListFromCsCompMapList(Map<ComponentSyncDTO, List<ChangeSetSyncDTO>> compCsMapList) {
        LinkedList<ChangeSetSyncDTO> csList = new LinkedList<ChangeSetSyncDTO>();
        for (Map.Entry<ComponentSyncDTO, List<ChangeSetSyncDTO>> compCsMapSet : compCsMapList.entrySet()) {
            csList.addAll((Collection<ChangeSetSyncDTO>)compCsMapSet.getValue());
        }
        return csList;
    }

    private static List<BaselineSyncDTO> getBlListFromBlCompMapList(Map<ComponentSyncDTO, List<BaselineSyncDTO>> compBlMapList) {
        LinkedList<BaselineSyncDTO> blList = new LinkedList<BaselineSyncDTO>();
        for (Map.Entry<ComponentSyncDTO, List<BaselineSyncDTO>> compCsMapSet : compBlMapList.entrySet()) {
            blList.addAll((Collection<BaselineSyncDTO>)compCsMapSet.getValue());
        }
        return blList;
    }

    private Map<ParmsWorkspace, Set<ComponentSyncDTO>> getTargetWsCompAndChangeSetSyncMapWithCompSelectors(ParmsWorkspace source, List<String> compSelectorList) throws FileSystemException {
        HashMap<ParmsWorkspace, Set<ComponentSyncDTO>> componentFlows = new HashMap<ParmsWorkspace, Set<ComponentSyncDTO>>();
        HashSet<String> compSelectorSet = null;
        if (compSelectorList != null) {
            compSelectorSet = new HashSet<String>(compSelectorList);
        }
        HashSet<String> matchedSelectorSet = new HashSet<String>();
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(source), (boolean)false, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        block0: for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(source.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                String matchedSelector = null;
                if (compSelectorSet != null && compSelectorSet.size() > 0) {
                    matchedSelector = DeliverCmd.matchesSelector(this.config, compSync.getComponentItemId(), compSync.getComponentName(), compSelectorSet, wsSync.getRepositoryUrl());
                    if (matchedSelector == null) continue;
                    matchedSelectorSet.add(matchedSelector);
                }
                if (compSync.getTargetOutgoingWorkspaceItemId() == null || compSync.getTargetOutgoingWorkspaceItemId().equals(wsSync.getWorkspaceItemId()) && compSync.getTargetOutgoingRepositoryUrl().equals(wsSync.getRepositoryUrl())) {
                    if (matchedSelector == null) continue;
                    HashSet<ComponentSyncDTO> allComponents = new HashSet<ComponentSyncDTO>(wsSync.getComponents());
                    DeliverCmd.printNonCollaboratedComponents(wsSync.getWorkspaceName(), wsSync.getWorkspaceItemId(), wsSync.getRepositoryUrl(), allComponents, this.config);
                }
                ParmsWorkspace ws = new ParmsWorkspace(compSync.getTargetOutgoingRepositoryUrl(), compSync.getTargetOutgoingWorkspaceItemId());
                ParmsWorkspace wsMatched = this.findWorkspace(wsList, ws);
                HashSet<ComponentSyncDTO> components = null;
                if (wsMatched != null) {
                    components = (HashSet<ComponentSyncDTO>)componentFlows.get(wsMatched);
                }
                if (components == null) {
                    components = new HashSet<ComponentSyncDTO>();
                    componentFlows.put(ws, components);
                    wsList.add(ws);
                }
                components.add(compSync);
                if (compSelectorSet != null && compSelectorSet.size() == 0) break block0;
            }
            if (compSelectorSet != null || componentFlows.size() != 0) break;
            throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_NO_DELIVERABLE_COMPONENT_FOUND);
        }
        if (compSelectorSet != null) {
            compSelectorSet.removeAll(matchedSelectorSet);
            if (compSelectorSet.size() > 0) {
                DeliverCmd.printUnresolvedComponentSelector(null, compSelectorSet, this.config);
            }
        }
        return componentFlows;
    }

    ParmsWorkspace findWorkspace(List<ParmsWorkspace> wsList, ParmsWorkspace ws) {
        for (ParmsWorkspace wsInList : wsList) {
            if (!wsInList.repositoryUrl.equals(ws.repositoryUrl) || !wsInList.workspaceItemId.equals(ws.workspaceItemId)) continue;
            return wsInList;
        }
        return null;
    }

    private static void printNonCollaboratedComponents(String wsName, String sourceWsItemId, String repoUrl, Set<ComponentSyncDTO> allComponents, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream err = config.getWrappedErrorStream();
        err.println((CharSequence)Messages.FlowCmd_NO_DEFAULT_COLLABORATION);
        err = err.indent();
        for (ComponentSyncDTO component : allComponents) {
            if (!component.getTargetOutgoingWorkspaceItemId().equals(sourceWsItemId)) continue;
            err.println((CharSequence)AliasUtil.selector((String)component.getComponentName(), (UUID)UUID.valueOf((String)component.getComponentItemId()), (String)repoUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
        }
        throw StatusHelper.misconfiguredLocalFS((String)NLS.bind((String)Messages.FlowCmd_NO_DEFAULT_COLLABORATION_ERROR, (Object)wsName));
    }

    private static void printUnresolvedComponentSelector(String wsInfo, Set<String> compSelectorSet, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream err = config.getWrappedErrorStream();
        if (wsInfo != null) {
            err.println((CharSequence)NLS.bind((String)Messages.ReplaceComponentsCmd_COMPONENT_NOT_IN_WORKSPACE, (Object)wsInfo));
        } else {
            err.println((CharSequence)Messages.DeliverCmd_UNRESOLVED_COMPONENT_SELECTOR_LIST);
        }
        err.indent();
        for (String componentSelector : compSelectorSet) {
            err.println((CharSequence)componentSelector);
        }
        throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_UNRESOLVED_COMPONENT_SELECTOR_MESSAGE_FOR_WS);
    }

    static void printUnresolvedChangeSetSelectors(Set<String> csSelectorSet, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream err = config.getWrappedErrorStream();
        err.println((CharSequence)Messages.DeliverCmd_UNRESOLVED_CHANGESET_SELECTOR_LIST);
        err = err.indent();
        for (String componentSelector : csSelectorSet) {
            err.println((CharSequence)componentSelector);
        }
        throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_UNRESOLVED_CHANGESET);
    }

    static void printUnresolvedBaselines(Set<String> blSelectorSet, IScmClientConfiguration config) throws FileSystemException {
        IndentingPrintStream err = config.getWrappedErrorStream();
        err.println((CharSequence)Messages.DeliverCmd_UNRESOLVED_BASELINES_LIST);
        err = err.indent();
        for (String blSelector : blSelectorSet) {
            err.println((CharSequence)blSelector);
        }
        throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_UNRESOLVED_BASELINES);
    }

    private List<WorkspaceComponentDTO> getSyncCompList(ParmsWorkspace targetWs, Set<String> compSelectorList) throws FileSystemException {
        Object wsInfo;
        RepoUtil.ItemType itemType;
        if (compSelectorList == null || compSelectorList.isEmpty()) {
            return null;
        }
        List srcCompDTOList = this.srcWsDetails.getComponents();
        WorkspaceDetailsDTO tgtWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(targetWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        List tgtCompDTOList = tgtWsDetails.getComponents();
        HashSet<String> selectorSet = new HashSet<String>(compSelectorList);
        HashMap<String, String> componentId2Selector = new HashMap<String, String>();
        HashMap<String, WorkspaceComponentDTO> selector2components = new HashMap<String, WorkspaceComponentDTO>();
        for (WorkspaceComponentDTO srcCompDTO : srcCompDTOList) {
            String matchedSelector = DeliverCmd.matchesSelector(this.config, srcCompDTO.getItemId(), srcCompDTO.getName(), selectorSet, this.sourceWs.repositoryUrl);
            if (matchedSelector == null) continue;
            selectorSet.remove(matchedSelector);
            componentId2Selector.put(srcCompDTO.getItemId(), matchedSelector);
            selector2components.put(matchedSelector, srcCompDTO);
        }
        if (selectorSet.size() > 0) {
            itemType = this.srcWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE;
            wsInfo = AliasUtil.selector((String)this.srcWsDetails.getName(), (UUID)UUID.valueOf((String)this.sourceWs.workspaceItemId), (String)this.sourceWs.repositoryUrl, (RepoUtil.ItemType)itemType);
            DeliverCmd.printUnresolvedComponentSelector((String)wsInfo, selectorSet, this.config);
        }
        if (StatusHelper.useLegacyDeliverWithComponentFlows()) {
            selectorSet.clear();
            for (String componentId : componentId2Selector.keySet()) {
                boolean found = false;
                for (WorkspaceComponentDTO tgtCompDTO : tgtCompDTOList) {
                    if (!tgtCompDTO.getItemId().equals(componentId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                String selector = (String)componentId2Selector.get(componentId);
                WorkspaceComponentDTO comp = (WorkspaceComponentDTO)selector2components.get(selector);
                selectorSet.add(AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)targetWs.repositoryUrl, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
            }
            if (selectorSet.size() > 0) {
                itemType = tgtWsDetails.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE;
                wsInfo = AliasUtil.selector((String)tgtWsDetails.getName(), (UUID)UUID.valueOf((String)targetWs.workspaceItemId), (String)targetWs.repositoryUrl, (RepoUtil.ItemType)itemType);
                DeliverCmd.printUnresolvedComponentSelector((String)wsInfo, selectorSet, this.config);
            }
        }
        return new ArrayList<WorkspaceComponentDTO>(selector2components.values());
    }

    private Map<ParmsWorkspace, Map<ComponentSyncDTO, List<ChangeSetSyncDTO>>> getTargetWsCompAndChangeSetSyncMapWithCsSelectors(List<String> csSelectorList) throws FileSystemException {
        HashMap<ParmsWorkspace, Map<ComponentSyncDTO, List<ChangeSetSyncDTO>>> componentFlows = new HashMap<ParmsWorkspace, Map<ComponentSyncDTO, List<ChangeSetSyncDTO>>>();
        HashSet<String> getMatchedSelectors = new HashSet<String>();
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
        boolean isCompInFlowTgt = true;
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(this.sourceWs), (boolean)false, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
        ArrayList<String> localAddedCompList = new ArrayList<String>();
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(this.sourceWs.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                List<ChangeSetSyncDTO> normalized;
                List outgoingChangeSets;
                ParmsWorkspace ws = new ParmsWorkspace(compSync.getTargetOutgoingRepositoryUrl(), compSync.getTargetOutgoingWorkspaceItemId());
                ParmsWorkspace wsMatched = this.findWorkspace(wsList, ws);
                if (compSync.isLocalAddedType()) {
                    localAddedCompList.add(compSync.getComponentItemId());
                }
                HashMap<ComponentSyncDTO, List<ChangeSetSyncDTO>> compCsMap = null;
                if (wsMatched != null) {
                    compCsMap = (HashMap<ComponentSyncDTO, List<ChangeSetSyncDTO>>)componentFlows.get(wsMatched);
                }
                if (compCsMap == null) {
                    compCsMap = new HashMap<ComponentSyncDTO, List<ChangeSetSyncDTO>>();
                    componentFlows.put(ws, compCsMap);
                    wsList.add(ws);
                }
                if ((outgoingChangeSets = compSync.getOutgoingChangeSetsAfterBasis()) == null || outgoingChangeSets.size() <= 0 || (normalized = DeliverCmd.getMatchedCsList(outgoingChangeSets, csSelectorList, getMatchedSelectors, this.config)).size() <= 0) continue;
                compCsMap.put(compSync, normalized);
            }
        }
        csSelectorList.removeAll(getMatchedSelectors);
        if (csSelectorList.size() > 0) {
            HashSet<String> csSelectorSet = new HashSet<String>(csSelectorList);
            HashSet<String> compAliasName = new HashSet<String>();
            ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(csSelectorList, (boolean)false, (String)this.srcWsDetails.getItemId(), (String)"workspace", (String)this.srcWsDetails.getRepositoryURL(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            int i = 0;
            while (i < csDTOList.length) {
                if (localAddedCompList.contains(csDTOList[i].getComponentItemId())) {
                    isCompInFlowTgt = false;
                    String compAlias = AliasUtil.selector((String)csDTOList[i].getComponentName(), (UUID)UUID.valueOf((String)csDTOList[i].getComponentItemId()), (String)this.srcWsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                    compAliasName.add(compAlias);
                }
                ++i;
            }
            if (!isCompInFlowTgt) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.DeliverCmd_COMPONENT_NOT_IN_FLOWTARGET);
                for (String compAlias : compAliasName) {
                    err.indent().println((CharSequence)compAlias);
                }
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, AddComponentsCmd.class);
                err.println((CharSequence)NLS.bind((String)Messages.DeliverCmd_ADD_COMPONENT_TO_FLOWTARGET, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()}));
                StatusHelper.nothingToDeliver();
            }
            this.config.getWrappedOutputStream().println((CharSequence)Messages.DeliverCmd_CHANGESET_NOT_IN_OUTGOINGLIST);
            DeliverCmd.printUnresolvedChangeSetSelectors(csSelectorSet, this.config);
        }
        return componentFlows;
    }

    private Map<ParmsWorkspace, Map<ComponentSyncDTO, List<BaselineSyncDTO>>> getTargetWsCompAndBaselineSyncMapWithBlSelectors(List<String> blSelectorList) throws FileSystemException {
        HashMap<ParmsWorkspace, Map<ComponentSyncDTO, List<BaselineSyncDTO>>> componentFlows = new HashMap<ParmsWorkspace, Map<ComponentSyncDTO, List<BaselineSyncDTO>>>();
        HashSet<String> getMatchedSelectors = new HashSet<String>();
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
        int maxChanges = CommonOptions.getMaxChangesToInterpret((IClientConfiguration)this.config);
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(this.sourceWs), (boolean)false, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config, (int)maxChanges, (boolean)true, (boolean)true);
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(this.sourceWs.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                List outgoingBaselines;
                ParmsWorkspace ws = new ParmsWorkspace(compSync.getTargetOutgoingRepositoryUrl(), compSync.getTargetOutgoingWorkspaceItemId());
                ParmsWorkspace wsMatched = this.findWorkspace(wsList, ws);
                HashMap<ComponentSyncDTO, List<BaselineSyncDTO>> compBlMap = null;
                if (wsMatched != null) {
                    compBlMap = (HashMap<ComponentSyncDTO, List<BaselineSyncDTO>>)componentFlows.get(wsMatched);
                }
                if (compBlMap == null) {
                    compBlMap = new HashMap<ComponentSyncDTO, List<BaselineSyncDTO>>();
                    componentFlows.put(ws, compBlMap);
                    wsList.add(ws);
                }
                if ((outgoingBaselines = compSync.getOutgoingBaselines()) == null || outgoingBaselines.size() <= 0) continue;
                List<BaselineSyncDTO> normalized = DeliverCmd.getMatchedBlList(outgoingBaselines, blSelectorList, getMatchedSelectors, this.config, wsSync.getRepositoryUrl());
                if (normalized.size() > 1) {
                    throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_SPECIFY_ONLY_ONE_BASLELINE_PER_COMPONENT);
                }
                if (normalized.size() != 1) continue;
                compBlMap.put(compSync, normalized);
            }
        }
        blSelectorList.removeAll(getMatchedSelectors);
        if (blSelectorList.size() > 0) {
            HashSet<String> blSelectorSet = new HashSet<String>(blSelectorList);
            DeliverCmd.printUnresolvedBaselines(blSelectorSet, this.config);
        }
        return componentFlows;
    }

    private ParmsDeliverChangeSetsOrBaselines generateChangeSetFlowDeliverParms(ParmsWorkspace targetWs, List<String> selectors) throws FileSystemException {
        ParmsDeliverChangeSetsOrBaselines csParam = new ParmsDeliverChangeSetsOrBaselines();
        csParam.sourceWorkspace = this.sourceWs;
        csParam.targetWorkspace = targetWs;
        ChangeSetSyncDTO[] csList = DeliverCmd.normalizeCsUuidAndAlias(this.sourceWs, targetWs, selectors, this.config, this.client);
        LinkedList<String> csItemIdList = new LinkedList<String>();
        ChangeSetSyncDTO[] changeSetSyncDTOArray = csList;
        int n = csList.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO cs = changeSetSyncDTOArray[n2];
            csItemIdList.add(cs.getChangeSetItemId());
            ++n2;
        }
        HashMap compToCsMap = new HashMap();
        ChangeSetSyncDTO[] changeSetSyncDTOArray2 = csList;
        int n3 = csList.length;
        n = 0;
        while (n < n3) {
            ChangeSetSyncDTO syncCs = changeSetSyncDTOArray2[n];
            HashMap<String, String> compIdToNameMap = new HashMap<String, String>();
            compIdToNameMap.put(syncCs.getComponentItemId(), syncCs.getComponentName());
            if (compToCsMap.get(compIdToNameMap) == null) {
                HashSet csSet = new HashSet();
                compToCsMap.put(compIdToNameMap, csSet);
            }
            ((Set)compToCsMap.get(compIdToNameMap)).add(syncCs);
            ++n;
        }
        csParam.changeSetItemIds = csItemIdList.toArray(new String[csItemIdList.size()]);
        if (csItemIdList.size() > 0) {
            return csParam;
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.DeliverCmd_NO_OUTGOING_CHANGESETS_OR_BASELINES_FOUND);
        return null;
    }

    private ParmsDeliverChangeSetsOrBaselines generateBaselineFlowDeliverParms(ParmsWorkspace targetWs, List<String> selectors) throws FileSystemException {
        ParmsDeliverChangeSetsOrBaselines blParam = new ParmsDeliverChangeSetsOrBaselines();
        blParam.sourceWorkspace = this.sourceWs;
        blParam.targetWorkspace = targetWs;
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(this.sourceWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        HashMap<String, String> compMap = new HashMap<String, String>();
        List wsCompDTO = wsDetails.getComponents();
        for (WorkspaceComponentDTO wsComp : wsCompDTO) {
            compMap.put(wsComp.getItemId(), wsComp.getName());
        }
        List<BaselineDTO> blList = DeliverCmd.normalizeBlUuidAndAlias(this.sourceWs, targetWs, selectors, this.config, this.client);
        LinkedList<String> blItemIdList = new LinkedList<String>();
        LinkedList<String> compItemIdList = new LinkedList<String>();
        for (BaselineDTO bl : blList) {
            blItemIdList.add(bl.getItemId());
            if (compItemIdList.contains(bl.getComponentItemId())) {
                throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_SPECIFY_ONLY_ONE_BASLELINE_PER_COMPONENT);
            }
            compItemIdList.add(bl.getComponentItemId());
        }
        blParam.baselineItemIds = blItemIdList.toArray(new String[blItemIdList.size()]);
        if (blItemIdList.size() > 0) {
            return blParam;
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.DeliverCmd_NO_OUTGOING_CHANGESETS_OR_BASELINES_FOUND);
        return null;
    }

    private List<ParmsDeliverChangeSetsOrBaselines> generateChangeSetFlowDeliverParms(List<String> selectors) throws FileSystemException {
        Map<ParmsWorkspace, Map<ComponentSyncDTO, List<ChangeSetSyncDTO>>> componentFlows = this.getTargetWsCompAndChangeSetSyncMapWithCsSelectors(selectors);
        LinkedList<ParmsDeliverChangeSetsOrBaselines> csBlParamList = new LinkedList<ParmsDeliverChangeSetsOrBaselines>();
        for (Map.Entry<ParmsWorkspace, Map<ComponentSyncDTO, List<ChangeSetSyncDTO>>> entry : componentFlows.entrySet()) {
            ParmsDeliverChangeSetsOrBaselines csParam = new ParmsDeliverChangeSetsOrBaselines();
            LinkedList<ComponentSyncDTO> compList = new LinkedList<ComponentSyncDTO>();
            for (Map.Entry<ComponentSyncDTO, List<ChangeSetSyncDTO>> compCsMapSet : entry.getValue().entrySet()) {
                compList.add(compCsMapSet.getKey());
            }
            if (compList.size() <= 0) continue;
            if (entry.getKey().workspaceItemId.equals(this.sourceWs.workspaceItemId)) {
                HashSet<ComponentSyncDTO> allSyncComp = new HashSet<ComponentSyncDTO>();
                for (Map<ComponentSyncDTO, List<ChangeSetSyncDTO>> compToCsListMap : componentFlows.values()) {
                    allSyncComp.addAll(compToCsListMap.keySet());
                }
                DeliverCmd.printNonCollaboratedComponents(this.srcWsDetails.getName(), this.sourceWs.workspaceItemId, this.sourceWs.repositoryUrl, allSyncComp, this.config);
            }
            csParam.sourceWorkspace = this.sourceWs;
            csParam.targetWorkspace = entry.getKey();
            LinkedList<String> compUuidList = new LinkedList<String>();
            for (ComponentSyncDTO comp : compList) {
                compUuidList.add(comp.getComponentItemId());
            }
            List<ChangeSetSyncDTO> csList = DeliverCmd.getCsListFromCsCompMapList(entry.getValue());
            this.unresolvedCsList = new ArrayList<ChangeSetSyncDTO>();
            this.unresolvedCsList.addAll(csList);
            LinkedList<String> csParamList = new LinkedList<String>();
            for (ChangeSetSyncDTO syncCs : csList) {
                csParamList.add(syncCs.getChangeSetItemId());
            }
            if (csParamList.size() <= 0) continue;
            csParam.changeSetItemIds = csParamList.toArray(new String[csParamList.size()]);
            csBlParamList.add(csParam);
        }
        return csBlParamList;
    }

    private List<ParmsDeliverChangeSetsOrBaselines> generateBaselineFlowDeliverParms(List<String> selectors) throws FileSystemException {
        Map<ParmsWorkspace, Map<ComponentSyncDTO, List<BaselineSyncDTO>>> componentFlows = this.getTargetWsCompAndBaselineSyncMapWithBlSelectors(selectors);
        LinkedList<ParmsDeliverChangeSetsOrBaselines> baselnParamList = new LinkedList<ParmsDeliverChangeSetsOrBaselines>();
        for (Map.Entry<ParmsWorkspace, Map<ComponentSyncDTO, List<BaselineSyncDTO>>> entry : componentFlows.entrySet()) {
            ParmsDeliverChangeSetsOrBaselines blParam = new ParmsDeliverChangeSetsOrBaselines();
            LinkedList<ComponentSyncDTO> compList = new LinkedList<ComponentSyncDTO>();
            for (Map.Entry<ComponentSyncDTO, List<BaselineSyncDTO>> compCsMapSet : entry.getValue().entrySet()) {
                compList.add(compCsMapSet.getKey());
            }
            if (compList.size() <= 0) continue;
            if (entry.getKey().workspaceItemId.equals(this.sourceWs.workspaceItemId)) {
                HashSet<ComponentSyncDTO> allSyncComp = new HashSet<ComponentSyncDTO>();
                for (Map<ComponentSyncDTO, List<BaselineSyncDTO>> compToCsListMap : componentFlows.values()) {
                    allSyncComp.addAll(compToCsListMap.keySet());
                }
                DeliverCmd.printNonCollaboratedComponents(this.srcWsDetails.getName(), this.sourceWs.workspaceItemId, this.sourceWs.repositoryUrl, allSyncComp, this.config);
            }
            blParam.sourceWorkspace = this.sourceWs;
            blParam.targetWorkspace = entry.getKey();
            List<BaselineSyncDTO> blList = DeliverCmd.getBlListFromBlCompMapList(entry.getValue());
            LinkedList<String> blParamList = new LinkedList<String>();
            for (BaselineSyncDTO syncBl : blList) {
                blParamList.add(syncBl.getBaselineItemId());
            }
            if (blParamList.size() <= 0) continue;
            blParam.baselineItemIds = blParamList.toArray(new String[blParamList.size()]);
            baselnParamList.add(blParam);
        }
        return baselnParamList;
    }

    private ParmsDeliverComponents generateComponentFlowDeliverParms(ParmsWorkspace targetWs, List<String> selectors, boolean hierarchicalDeliver) throws FileSystemException {
        List<WorkspaceComponentDTO> syncCompList = this.getSyncCompList(targetWs, new HashSet<String>(selectors));
        ParmsDeliverComponents compParam = new ParmsDeliverComponents();
        compParam.targetWorkspace = targetWs;
        compParam.sourceWorkspace = this.sourceWs;
        compParam.sourceWorkspaceExplicit = true;
        compParam.hierarchicalDeliver = hierarchicalDeliver;
        compParam.reportComponentOps = true;
        LinkedList<String> compList = new LinkedList<String>();
        for (WorkspaceComponentDTO syncComp : syncCompList) {
            compList.add(syncComp.getItemId());
        }
        compParam.componentItemIds = compList.toArray(new String[compList.size()]);
        return compParam;
    }

    private List<ParmsDeliverComponents> generateComponentFlowDeliverParms(List<String> selectors, boolean hierarchicalDeliver) throws FileSystemException {
        Map<ParmsWorkspace, Set<ComponentSyncDTO>> componentFlows = this.getTargetWsCompAndChangeSetSyncMapWithCompSelectors(this.sourceWs, selectors);
        LinkedList<ParmsDeliverComponents> compParamList = new LinkedList<ParmsDeliverComponents>();
        for (Map.Entry<ParmsWorkspace, Set<ComponentSyncDTO>> entry : componentFlows.entrySet()) {
            ParmsDeliverComponents compParam = new ParmsDeliverComponents();
            Set<ComponentSyncDTO> comps = entry.getValue();
            if (comps.size() <= 0) continue;
            LinkedList<String> compList = new LinkedList<String>();
            for (ComponentSyncDTO syncComp : comps) {
                compList.add(syncComp.getComponentItemId());
            }
            compParam.targetWorkspace = entry.getKey();
            compParam.sourceWorkspace = this.sourceWs;
            compParam.componentItemIds = compList.toArray(new String[compList.size()]);
            compParam.sourceWorkspaceExplicit = false;
            compParam.hierarchicalDeliver = hierarchicalDeliver;
            compParam.reportComponentOps = true;
            compParamList.add(compParam);
        }
        if (compParamList.size() == 0) {
            throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_REMOTE_WORKSPACE_NOT_FOUND);
        }
        return compParamList;
    }

    private List<ParmsDeliverComponents> generateDefaultFlowDeliverParms() throws FileSystemException {
        return this.generateComponentFlowDeliverParms(null, false);
    }

    private ParmsDeliverWorkspace generateDefaultFlowDeliverParm(ParmsWorkspace targetWs) throws FileSystemException {
        ParmsDeliverWorkspace wsParam = new ParmsDeliverWorkspace();
        wsParam.sourceWorkspace = this.sourceWs;
        wsParam.targetWorkspace = targetWs;
        return wsParam;
    }

    private void generateDeliverParms(ICommandLine subcmd, ParmsDeliver parms) throws FileSystemException {
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        Mode mode = Mode.UNSET;
        int modeCount = 0;
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_COMPONENTS)) {
            mode = Mode.COMPONENT;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_CHANGESETS)) {
            mode = Mode.CS;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_BASELINES)) {
            mode = Mode.BASELINE;
            ++modeCount;
        }
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_WORKITEMS)) {
            mode = Mode.WI;
            ++modeCount;
        }
        if (modeCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_USE_SINGLE_MODE_ARGUMENT, (Object[])new String[]{DeliverCmdOptions.OPT_MODE_COMPONENTS.getName(), DeliverCmdOptions.OPT_MODE_CHANGESETS.getName(), DeliverCmdOptions.OPT_MODE_BASELINES.getName(), DeliverCmdOptions.OPT_MODE_WORKITEMS.getName()}));
        }
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_WORKITEMS) && subcmd.hasOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)DeliverCmdOptions.OPT_MODE_WORKITEMS.getName(), (Object)CommonOptions.OPT_STREAM_TARGET_SELECTOR.getName()));
        }
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS) && subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS.getName(), (Object)DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS.getName()));
        }
        if ((subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS) || subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS)) && (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_CHANGESETS) || subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_MODE_BASELINES))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_INVALID_ARGUMENT_COMBINATION, (Object[])new String[]{DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS.getName(), DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS.getName(), DeliverCmdOptions.OPT_MODE_CHANGESETS.getName(), DeliverCmdOptions.OPT_MODE_BASELINES.getName()}));
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_OVERWRITE_UNCOMMITTED_DEPRECATED) || subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_IGNORE_UNCOMMITTED) ? "no" : "cancel";
        parms.deliveryRequiresHistoryReorderingDilemmaHandler = new ParmsDeliveryRequiresHistoryReorderingDilemmaHandler();
        parms.deliveryRequiresHistoryReorderingDilemmaHandler.deliveryRequiresHistoryReordering = subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_HARMONIZE_HISTORY) ? "continue" : "cancel";
        parms.deliverDilemmaHandler = new ParmsDeliverDilemmaHandler();
        parms.deliverDilemmaHandler.flowComponents = subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS) ? "continue" : "no";
        parms.deliverDilemmaHandler.flowWithIncomingReplace = subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_OVERWRITE_INCOMING_REPLACE) ? "continue" : (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_SKIP_INCOMING_REPLACE) ? "no" : "cancel");
        parms.deliverDilemmaHandler.flowToNonDefault = "continue";
        parms.deliverDilemmaHandler.multipleParticipantsDirection = subcmd.hasOption((IOptionKey)CommonOptions.OPT_MULTIPLE_PARTICIPANTS) ? "continue" : "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        ScmCommandLineArgument sourceSelector = ScmCommandLineArgument.create((ICommandLineArgument)subcmd.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_SOURCE_SELECTOR, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)sourceSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository srcRepo = null;
        if (sourceSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() == 0) {
                throw StatusHelper.misconfiguredLocalFS((String)Messages.Common_WS_NOT_FOUND);
            }
            if (wsInSandboxList.size() > 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.DeliverCmd_TOO_MANY_WORKSPACES, (Object)CommonOptions.OPT_STREAM_SOURCE_SELECTOR.getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            this.sourceWs = new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox)), wsInSandbox.getWorkspaceItemId());
            srcRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (ConnectionInfo)this.config.getConnectionInfo(this.sourceWs.repositoryUrl));
        } else {
            srcRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)sourceSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)sourceSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)srcRepo, (IScmClientConfiguration)this.config);
            this.sourceWs = new ParmsWorkspace(srcRepo.getRepositoryURI(), ws.getItemId().getUuidValue());
        }
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)this.sourceWs, (String)Messages.DeliverCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)this.config);
        this.srcWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(this.sourceWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config).get(0);
        ScmCommandLineArgument targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)subcmd.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ParmsWorkspace targetWs = null;
        if (targetSelector != null) {
            ITeamRepository targetRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)this.client, (IScmCommandLineArgument)targetSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)targetSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)targetRepo, (IScmClientConfiguration)this.config);
            targetWs = new ParmsWorkspace(targetRepo.getRepositoryURI(), ws.getItemId().getUuidValue());
        } else {
            RepoUtil.loginToWsCollabRepos(Collections.singletonList(this.sourceWs), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config, (boolean)true);
        }
        List<String> selectors = new LinkedList();
        LinkedList<IScmCommandLineArgument> argSelectors = new LinkedList();
        if (subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_SELECTORS)) {
            argSelectors = ScmCommandLineArgument.createList((List)subcmd.getOptionValues((IOptionKey)DeliverCmdOptions.OPT_SELECTORS), (IScmClientConfiguration)this.config, (mode != Mode.WI ? 1 : 0) != 0);
            selectors = RepoUtil.getSelectors(argSelectors);
        }
        if (sourceSelector == null && mode == Mode.UNSET && selectors.size() == 0 && !subcmd.hasOption((IOptionKey)DeliverCmdOptions.OPT_FLOW_ALL_COMPONENTS)) {
            Map compList = RepoUtil.getComponentsInSandbox(null, (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
            if (compList.size() > 0) {
                selectors = new ArrayList(compList.keySet());
            }
            mode = Mode.COMPONENT;
        }
        if (mode == Mode.UNSET && selectors.size() == 0) {
            if (targetWs == null) {
                List<ParmsDeliverComponents> compParamList = this.generateDefaultFlowDeliverParms();
                parms.deliverComponents = compParamList.toArray(new ParmsDeliverComponents[compParamList.size()]);
            } else {
                ParmsDeliverWorkspace wsParam = new ParmsDeliverWorkspace();
                wsParam.sourceWorkspace = this.sourceWs;
                wsParam.targetWorkspace = targetWs;
                parms.deliverWorkspaces = new ParmsDeliverWorkspace[]{wsParam};
            }
        } else if (mode == Mode.BASELINE) {
            if (selectors.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_NO_BASELINES_SPECIFIED, (Object)DeliverCmdOptions.OPT_MODE_BASELINES.toString()));
            }
            SubcommandUtil.validateArgument(argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.BASELINE, argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)this.config);
            List blSelectors = RepoUtil.getSelectors(argSelectors);
            if (targetWs == null) {
                List<ParmsDeliverChangeSetsOrBaselines> csBlParamList = this.generateBaselineFlowDeliverParms(blSelectors);
                parms.deliverChangeSetsOrBaselines = csBlParamList.toArray(new ParmsDeliverChangeSetsOrBaselines[csBlParamList.size()]);
            } else {
                ParmsDeliverChangeSetsOrBaselines csBlParam = this.generateBaselineFlowDeliverParms(targetWs, blSelectors);
                parms.deliverChangeSetsOrBaselines = new ParmsDeliverChangeSetsOrBaselines[]{csBlParam};
            }
        } else if (mode == Mode.UNSET || mode == Mode.CS) {
            if (selectors.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_NO_CHANGESETS_SPECIFIED, (Object)DeliverCmdOptions.OPT_MODE_CHANGESETS.toString()));
            }
            SubcommandUtil.validateArgument(argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)this.config);
            if (targetWs == null) {
                List<ParmsDeliverChangeSetsOrBaselines> csBlParamList = this.generateChangeSetFlowDeliverParms(selectors);
                parms.deliverChangeSetsOrBaselines = csBlParamList.toArray(new ParmsDeliverChangeSetsOrBaselines[csBlParamList.size()]);
            } else {
                ParmsDeliverChangeSetsOrBaselines csBlParam = this.generateChangeSetFlowDeliverParms(targetWs, selectors);
                parms.deliverChangeSetsOrBaselines = new ParmsDeliverChangeSetsOrBaselines[]{csBlParam};
            }
        } else if (mode == Mode.COMPONENT) {
            if (selectors.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_NO_COMPONENTS_SPECIFIED, (Object)DeliverCmdOptions.OPT_MODE_COMPONENTS.toString()));
            }
            if (StatusHelper.useLegacyDeliverWithComponentFlows()) {
                parms.deliverDilemmaHandler.flowComponents = "continue";
            }
            SubcommandUtil.validateArgument(argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, argSelectors, (ITeamRepository)srcRepo, (IScmClientConfiguration)this.config);
            boolean hierarchicalDeliver = this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_COMPONENT_HIERARCHY);
            if (targetWs == null) {
                List<ParmsDeliverComponents> compParamList = this.generateComponentFlowDeliverParms(selectors, hierarchicalDeliver);
                parms.deliverComponents = compParamList.toArray(new ParmsDeliverComponents[compParamList.size()]);
            } else {
                ParmsDeliverComponents compParam = this.generateComponentFlowDeliverParms(targetWs, selectors, hierarchicalDeliver);
                parms.deliverComponents = new ParmsDeliverComponents[]{compParam};
            }
        } else if (mode == Mode.WI) {
            if (selectors.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.DeliverCmd_NO_WORKITEMS_SPECIFIED, (Object)DeliverCmdOptions.OPT_MODE_WORKITEMS.toString()));
            }
            SubcommandUtil.validateArgument(argSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.WORKITEM);
            parms.deliverChangeSetsOrBaselines = this.getWorkitemDeliverParms(argSelectors, this.sourceWs, this.client, this.config, srcRepo, subcmd);
        } else {
            throw StatusHelper.internalError((String)Messages.DeliverCmd_UNEXPECTED_SELECTOR_TYPE);
        }
        parms.autoReleaseLocks = !this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK) ? Boolean.valueOf(((ScmClientConfiguration)this.config).getPersistentPreferences().getReleaseLockForDeliver()) : Boolean.valueOf(Boolean.parseBoolean(this.config.getSubcommandCommandLine().getOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK).toString()));
    }

    private ParmsDeliverChangeSetsOrBaselines[] getWorkitemDeliverParms(List<IScmCommandLineArgument> argSelectors, ParmsWorkspace sourceWs, IFilesystemRestClient client, IScmClientConfiguration config, ITeamRepository repo, ICommandLine subcmd) throws FileSystemException {
        ChangeSetUtil csUtil = new ChangeSetUtil();
        csUtil.validateRepoAndLogin(argSelectors, client, config, subcmd, repo == null);
        ArrayList<WorkItemHierarchyNodeDTO> wiHierarchyList = new ArrayList<WorkItemHierarchyNodeDTO>();
        Map<String, ChangeSetSyncDTO> csList = csUtil.getChangeSetsFromWorkitem(argSelectors, repo, client, config, false, wiHierarchyList);
        if (csList == null || csList.size() == 0) {
            config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetLocateCmd_CS_NOT_FOUND_FOR_WI);
            StatusHelper.nothingToDeliver();
        }
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(sourceWs), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        HashMap<String, ComponentSyncDTO> compIdToDTO = new HashMap<String, ComponentSyncDTO>();
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(sourceWs.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                if (compSync.getTargetOutgoingWorkspaceItemId().equals(sourceWs.workspaceItemId)) continue;
                compIdToDTO.put(compSync.getComponentItemId(), compSync);
            }
        }
        if (compIdToDTO.keySet().size() == 0) {
            config.getWrappedOutputStream().println((CharSequence)Messages.DeliverCmd_NO_TARGET);
            StatusHelper.nothingToDeliver();
        }
        HashMap<String, ParmsWorkspace> wsIdToParmsWorkspace = new HashMap<String, ParmsWorkspace>();
        HashMap<ParmsWorkspace, ArrayList<String>> targetWsToCsList = new HashMap<ParmsWorkspace, ArrayList<String>>();
        for (ChangeSetSyncDTO csDTO : csList.values()) {
            ComponentSyncDTO compDTO = (ComponentSyncDTO)compIdToDTO.get(csDTO.getComponentItemId());
            if (compDTO == null) continue;
            for (ChangeSetSyncDTO outgoingCsDTO : compDTO.getOutgoingChangeSetsAfterBasis()) {
                ArrayList<String> csToDeliverList;
                if (!csDTO.getChangeSetItemId().equals(outgoingCsDTO.getChangeSetItemId())) continue;
                ParmsWorkspace targetWs = (ParmsWorkspace)wsIdToParmsWorkspace.get(compDTO.getTargetOutgoingWorkspaceItemId());
                if (targetWs == null) {
                    targetWs = new ParmsWorkspace(compDTO.getTargetOutgoingRepositoryUrl(), compDTO.getTargetOutgoingWorkspaceItemId());
                    wsIdToParmsWorkspace.put(compDTO.getTargetOutgoingWorkspaceItemId(), targetWs);
                }
                if ((csToDeliverList = (ArrayList<String>)targetWsToCsList.get(targetWs)) == null) {
                    csToDeliverList = new ArrayList<String>();
                    targetWsToCsList.put(targetWs, csToDeliverList);
                }
                csToDeliverList.add(csDTO.getChangeSetItemId());
            }
        }
        if (targetWsToCsList.keySet().size() == 0) {
            config.getWrappedOutputStream().println((CharSequence)Messages.DeliverCmd_NOTHING_TO_DELIVER_WI);
            StatusHelper.nothingToDeliver();
        }
        ParmsDeliverChangeSetsOrBaselines[] csParams = new ParmsDeliverChangeSetsOrBaselines[targetWsToCsList.keySet().size()];
        int index = 0;
        for (Map.Entry entry : targetWsToCsList.entrySet()) {
            ParmsDeliverChangeSetsOrBaselines csParam = new ParmsDeliverChangeSetsOrBaselines();
            csParam.sourceWorkspace = sourceWs;
            csParam.targetWorkspace = (ParmsWorkspace)entry.getKey();
            csParam.changeSetItemIds = ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]);
            csParams[index++] = csParam;
        }
        return csParams;
    }

    private String getComponentSelector(String componentUuid) {
        String componentSelector = "";
        List workspaceComponents = this.srcWsDetails.getComponents();
        for (WorkspaceComponentDTO workspaceComponent : workspaceComponents) {
            if (!workspaceComponent.getItemId().equals(componentUuid)) continue;
            componentSelector = AliasUtil.selector((String)workspaceComponent.getName(), (UUID)UUID.valueOf((String)componentUuid), (String)this.srcWsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            break;
        }
        return componentSelector;
    }

    /*
     * WARNING - void declaration
     */
    public void run() throws FileSystemException {
        DeliverResultDTO result;
        this.client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine subcmd = this.config.getSubcommandCommandLine();
        boolean verbose = subcmd.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        boolean quiet = subcmd.hasOption((IOptionKey)CommonOptions.OPT_QUIET);
        this.config.setEnableJSON(subcmd.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ParmsDeliver parms = new ParmsDeliver();
        this.generateDeliverParms(subcmd, parms);
        if (this.config.isDryRun()) {
            return;
        }
        try {
            parms.structuredResultOptions = new ParmsStructuredResultOptions();
            result = this.client.postDeliver(parms, null);
        }
        catch (TeamRepositoryException e) {
            PermissionDeniedException pde = (PermissionDeniedException)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e);
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)pde, (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            ItemNotFoundException notFound = (ItemNotFoundException)SubcommandUtil.findExceptionByType(ItemNotFoundException.class, (TeamRepositoryException)e);
            if (notFound != null) {
                throw StatusHelper.ambiguousSelector((String)Messages.DeliverCmd_REMOTE_WORKSPACE_NOT_FOUND);
            }
            StreamLockedException streamLocked = (StreamLockedException)SubcommandUtil.findExceptionByType(StreamLockedException.class, (TeamRepositoryException)e);
            if (streamLocked != null) {
                throw StatusHelper.streamLocked((String)Messages.DeliverCmd_0);
            }
            StaleDataException stale = (StaleDataException)SubcommandUtil.findExceptionByType(StaleDataException.class, (TeamRepositoryException)e);
            if (stale != null) {
                throw StatusHelper.gap((String)Messages.DeliverCmd_WORKSPACE_IS_STALE);
            }
            SyncReportInappropriateException syncReportInappropriate = (SyncReportInappropriateException)SubcommandUtil.findExceptionByType(SyncReportInappropriateException.class, (TeamRepositoryException)e);
            if (syncReportInappropriate != null) {
                throw StatusHelper.gap((String)Messages.DeliverCmd_WRONG_SYNC_REPORT);
            }
            GapException gapException = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
            if (gapException != null) {
                throw StatusHelper.gap((String)(String.valueOf(Messages.DeliverCmd_WOULD_CREATE_GAP) + " " + Messages.DeliverCmd_HINT_ON_GAP));
            }
            DeliveryIntroducesConflictsException conflict = (DeliveryIntroducesConflictsException)SubcommandUtil.findExceptionByType(DeliveryIntroducesConflictsException.class, (TeamRepositoryException)e);
            if (conflict != null) {
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, AcceptCmd.class);
                throw StatusHelper.conflict((String)NLS.bind((String)Messages.DeliverCmd_INTRODUCES_CONFLICTS, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), StatusCmdOpts.OPT_EXPAND_CHANGESET.getName(), this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()}));
            }
            OutstandingConflictsException conflicted = (OutstandingConflictsException)SubcommandUtil.findExceptionByType(OutstandingConflictsException.class, (TeamRepositoryException)e);
            if (conflicted != null) {
                throw StatusHelper.conflict((String)Messages.DeliverCmd_REMOTE_WORKSPACE_HAS_CONFLICTS);
            }
            ChangeSetAlreadyInHistoryException csInHistory = (ChangeSetAlreadyInHistoryException)SubcommandUtil.findExceptionByType(ChangeSetAlreadyInHistoryException.class, (TeamRepositoryException)e);
            if (csInHistory != null) {
                throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_ALREADY_IN_HISTORY);
            }
            ChangeSetsNotOutgoingException csNotOutgoing = (ChangeSetsNotOutgoingException)SubcommandUtil.findExceptionByType(ChangeSetsNotOutgoingException.class, (TeamRepositoryException)e);
            if (csNotOutgoing != null) {
                throw StatusHelper.inappropriateArgument((String)Messages.DeliverCmd_NOT_OUTGOING);
            }
            throw StatusHelper.wrap((String)Messages.DeliverCmd_FAILED, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (result.isCancelled()) {
            int noOfUncheckedInChanges;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
            if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.DeliverCmd_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)DeliverCmdOptions.OPT_IGNORE_UNCOMMITTED.getName()));
            }
            List deliveryReqHistoryReorderingList = result.getDeliveryRequiresHistoryReordering();
            if (deliveryReqHistoryReorderingList.size() > 0) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.DeliverCmd_REQUIRES_HISTORY_REORDERING1);
                for (DeliveryRequiresHistoryReorderingDTO deliveryReqHistoryReordering : deliveryReqHistoryReorderingList) {
                    err.indent().println((CharSequence)this.getComponentSelector(deliveryReqHistoryReordering.getComponentItemId()));
                }
                throw StatusHelper.deliveryRequiresHistoryReordering((String)NLS.bind((String)Messages.DeliverCmd_REQUIRES_HISTORY_REORDERING2, (Object)DeliverCmdOptions.OPT_HARMONIZE_HISTORY.getName()));
            }
            if (!result.getComponentsWithConflictingTargets().isEmpty()) {
                ArrayList componentsWithConflictingTargets = new ArrayList(result.getComponentsWithConflictingTargets());
                Collections.sort(componentsWithConflictingTargets, new PendingChangesUtil.ComponentSyncDTOComparator());
                StringBuilder builder = new StringBuilder();
                builder.append(Messages.AcceptCmd_INCOMPATIBLE_COMPONENT_FLOW_TARGETS);
                for (ComponentSyncDTO syncDto : componentsWithConflictingTargets) {
                    builder.append(NLS.bind((String)Messages.DeliverCmd_INCOMPATIBLE_SELECTORS, (Object[])new String[]{AliasUtil.selector((String)syncDto.getLocalWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getLocalWorkspaceItemId()), (String)syncDto.getLocalRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIslocalStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE)), AliasUtil.selector((String)syncDto.getComponentName(), (UUID)UUID.valueOf((String)syncDto.getComponentItemId()), (String)syncDto.getTargetOutgoingRepositoryUrl(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), AliasUtil.selector((String)syncDto.getTargetOutgoingWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getTargetOutgoingWorkspaceItemId()), (String)syncDto.getTargetOutgoingRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIsTargetOutgoingStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))}));
                }
                throw StatusHelper.createException((String)builder.toString(), (int)58, null);
            }
            if (result.getComponentsWithIncomingReplace().size() > 0) {
                throw StatusHelper.createException((String)NLS.bind((String)Messages.DeliverCmd_6, (Object)DeliverCmdOptions.OPT_OVERWRITE_INCOMING_REPLACE.getName(), (Object)DeliverCmdOptions.OPT_SKIP_INCOMING_REPLACE.getName()), (int)69, null);
            }
            if (result.isComponentsToFlow()) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.DeliverCmd_1);
                for (Object o2 : result.getComponentOperations()) {
                    ComponentDTO componentDTO;
                    WorkspaceComponentOperationsDTO workspaceComponentOperationsDTO = (WorkspaceComponentOperationsDTO)o2;
                    for (Object o : workspaceComponentOperationsDTO.getAddedComponents()) {
                        componentDTO = (ComponentDTO)o;
                        err.indent().println((CharSequence)NLS.bind((String)Messages.DeliverCmd_2, (Object)AliasUtil.selector((String)componentDTO.getName(), (UUID)UUID.valueOf((String)componentDTO.getItemId()), (String)workspaceComponentOperationsDTO.getSourceWorkspace().getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                    }
                    for (Object o : workspaceComponentOperationsDTO.getRemovedComponents()) {
                        componentDTO = (ComponentDTO)o;
                        err.indent().println((CharSequence)NLS.bind((String)Messages.DeliverCmd_3, (Object)AliasUtil.selector((String)componentDTO.getName(), (UUID)UUID.valueOf((String)componentDTO.getItemId()), (String)workspaceComponentOperationsDTO.getSourceWorkspace().getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                    }
                    for (Object o : workspaceComponentOperationsDTO.getReplacedComponents()) {
                        componentDTO = (ComponentDTO)o;
                        err.indent().println((CharSequence)NLS.bind((String)Messages.DeliverCmd_4, (Object)AliasUtil.selector((String)componentDTO.getName(), (UUID)UUID.valueOf((String)componentDTO.getItemId()), (String)workspaceComponentOperationsDTO.getSourceWorkspace().getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
                    }
                }
                throw StatusHelper.createException((String)NLS.bind((String)Messages.DeliverCmd_5, (Object)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS.getName(), (Object)DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS.getName()), (int)68, null);
            }
            if (!result.getComponentsWithMultipleParticipants().isEmpty()) {
                ArrayList componentsWithMultipleParticpants = new ArrayList(result.getComponentsWithMultipleParticipants());
                Collections.sort(componentsWithMultipleParticpants, new PendingChangesUtil.ComponentSyncDTOComparator());
                StringBuilder builder = new StringBuilder();
                builder.append(Messages.AcceptCmd_INCOMPATIBLE_COMPONENT_MULTIPLE_PARTICPANT);
                for (ComponentSyncDTO syncDto : componentsWithMultipleParticpants) {
                    builder.append(NLS.bind((String)Messages.DeliverCmd_INCOMPATIBLE_SELECTORS, (Object[])new String[]{AliasUtil.selector((String)syncDto.getLocalWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getLocalWorkspaceItemId()), (String)syncDto.getLocalRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIslocalStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE)), AliasUtil.selector((String)syncDto.getComponentName(), (UUID)UUID.valueOf((String)syncDto.getComponentItemId()), (String)syncDto.getTargetOutgoingRepositoryUrl(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), AliasUtil.selector((String)syncDto.getTargetOutgoingWorkspaceName(), (UUID)UUID.valueOf((String)syncDto.getTargetOutgoingWorkspaceItemId()), (String)syncDto.getTargetOutgoingRepositoryUrl(), (RepoUtil.ItemType)(syncDto.isIsTargetOutgoingStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE))}));
                }
                throw StatusHelper.createException((String)builder.toString(), (int)59, null);
            }
        } else if (result.getStructuredResult().size() == 0) {
            List deliveryReqHistoryReorderingList = result.getDeliveryRequiresHistoryReordering();
            if (deliveryReqHistoryReorderingList.size() > 0) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)Messages.DeliverCmd_CONFLICTS_AFTER_HISTORY_REORDERING1);
                for (DeliveryRequiresHistoryReorderingDTO deliveryReqHistoryReordering : deliveryReqHistoryReorderingList) {
                    err.indent().println((CharSequence)this.getComponentSelector(deliveryReqHistoryReordering.getComponentItemId()));
                }
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ResolveCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ConflictsCmd.class);
                ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
                throw StatusHelper.conflict((String)(String.valueOf(Messages.DeliverCmd_CONFLICTS_AFTER_HISTORY_REORDERING2) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()})));
            }
            if (!result.getLocksWereHeld().isEmpty()) {
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, LockListCmd.class);
                throw StatusHelper.itemLockedInStream((String)NLS.bind((String)Messages.DeliverCmd_ITEM_LOCKED_IN_STREAM, (Object)this.config.getContext().getAppName(), (Object)SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString()));
            }
            if (result.getComponentOperations().size() > 0) {
                for (Object o2 : result.getComponentOperations()) {
                    WorkspaceComponentOperationsDTO wcoDTO = (WorkspaceComponentOperationsDTO)o2;
                    if (wcoDTO.getAddedComponents().size() <= 0 && wcoDTO.getRemovedComponents().size() <= 0 && wcoDTO.getReplacedComponents().size() <= 0) continue;
                    if (!this.config.isJSONEnabled()) {
                        out.println((CharSequence)Messages.DeliverCmd_NOTHING_TO_DELIVER);
                    }
                    if (this.printFlowComponentInfoInOutput()) {
                        JSONArray status = new JSONArray();
                        JSONObject jSONObject = AcceptResultDisplayer.showDeliverResult(this.client, true, parms, result, verbose, this.config, out.indent(), status);
                        if (this.config.isJSONEnabled()) {
                            if (status.size() > 0) {
                                jSONObject.put((Object)"status", (Object)status);
                            }
                            this.config.getOutputStream().print((CharSequence)jSONObject.toString());
                        }
                        StatusHelper.componentOperationEncountered();
                        continue;
                    }
                    if (this.config.isJSONEnabled()) {
                        this.config.getOutputStream().print((CharSequence)new JSONObject().toString());
                    }
                    StatusHelper.nothingToDeliver();
                }
            } else {
                if (result.isComponentsToFlow()) {
                    void var12_49;
                    IndentingPrintStream err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)Messages.DeliverCmd_COMPONENT_NOT_IN_FLOWTARGET);
                    ArrayList<String> csId = new ArrayList<String>();
                    if (this.unresolvedCsList != null) {
                        for (ChangeSetSyncDTO changeset : this.unresolvedCsList) {
                            csId.add(changeset.getChangeSetItemId());
                        }
                    }
                    ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(csId, (boolean)false, (String)this.srcWsDetails.getItemId(), (String)"workspace", (String)this.srcWsDetails.getRepositoryURL(), (IFilesystemRestClient)this.client, (IScmClientConfiguration)this.config);
                    HashSet<Object> compAliasName = new HashSet<Object>();
                    boolean bl = false;
                    while (var12_49 < csDTOList.length) {
                        String compAlias = AliasUtil.selector((String)csDTOList[var12_49].getComponentName(), (UUID)UUID.valueOf((String)csDTOList[var12_49].getComponentItemId()), (String)this.srcWsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                        compAliasName.add(compAlias);
                        ++var12_49;
                    }
                    for (String string : compAliasName) {
                        err.indent().println((CharSequence)string);
                    }
                    ISubcommandDefinition iSubcommandDefinition = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                    ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, AddComponentsCmd.class);
                    err.println((CharSequence)NLS.bind((String)Messages.DeliverCmd_ADD_COMPONENT_TO_FLOWTARGET, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)iSubcommandDefinition).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString()}));
                } else if (this.config.isJSONEnabled()) {
                    this.config.getOutputStream().print((CharSequence)new JSONObject().toString());
                } else {
                    out.println((CharSequence)Messages.DeliverCmd_NOTHING_TO_DELIVER);
                }
                StatusHelper.nothingToDeliver();
            }
        } else if (!quiet) {
            if (!this.config.isJSONEnabled()) {
                out.println((CharSequence)Messages.DeliverCmd_DELIVER_MESSAGE);
            }
            JSONArray status = new JSONArray();
            JSONObject jResult = AcceptResultDisplayer.showDeliverResult(this.client, this.printFlowComponentInfoInOutput(), parms, result, verbose, this.config, out.indent(), status);
            if (this.config.isJSONEnabled()) {
                if (status.size() > 0) {
                    jResult.put((Object)"status", (Object)status);
                }
                this.config.getOutputStream().print((CharSequence)jResult.toString());
            } else {
                out.println((CharSequence)Messages.DeliverCmd_SUCCESSFUL);
            }
        }
    }

    private boolean printFlowComponentInfoInOutput() {
        return !StatusHelper.useLegacyDeliverWithComponentFlows() && !this.config.getSubcommandCommandLine().hasOption((IOptionKey)DeliverCmdOptions.OPT_INCLUDE_COMPONENT_OPERATIONS) && !this.config.getSubcommandCommandLine().hasOption((IOptionKey)DeliverCmdOptions.OPT_EXCLUDE_COMPONENT_OPERATIONS);
    }

    static enum Mode {
        UNSET,
        WS,
        CS,
        COMPONENT,
        BASELINE,
        WI;

    }
}

