/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.export;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.workitems.internal.rest.IFilesystemWorkItemRestService;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExportCodeReviewCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final String SELECTOR_SEPARATOR = ",";
    private static final String QUERY_ID = "queryId";
    private static final String WORKITEM_IDS = "workItemIds";
    private static final String NEXT_PAGE_TOKEN = "nextPageToken";
    private static final String INCLUDE_CS_DELIVERY_INFO = "includeCsDeliveryInfo";
    private static final String INCLUDE_FILE_NAME_INFO = "includeFileNameInfo";
    private static final String INCLUDE_ISSUE_DESCRIPTION_INFO = "includeIssueDescriptionInfo";
    private static final String CODE_REVIEW_REPORT = "codeReviewReport";
    private static final String RESPONSE = "response";
    private static final String RESPONSE_RETURN_FINAL = "returnValue";
    private static final String RESPONSE_VALUE = "value";
    private static final String RESPONSE_CODE_REVIEW_EXPORT = "codeReviewExport";
    private static final String RESPONSE_CODE_REVIEWS = "codeReviews";
    private static final String RESPONSE_WORK_ITEM_QUERY = "workItemQuery";
    private static final String RESPONSE_WORK_ITEM_QUERY_NAME = "workItemQueryName";
    private static final String RESPONSE_SOAPENV_BODY = "soapenv:Body";
    private static final String RESPONE_EQUALIFIED_CLASS_NAME = "_eQualifiedClassName";
    private static final PositionalOptionDefinition OPT_SELECTORS = new PositionalOptionDefinition("selectors", 1, 1);
    private static final PositionalOptionDefinition OPT_DEST = new PositionalOptionDefinition("outputFile", 1, 1);
    private static final NamedOptionDefinition OPT_QUERY_ID = new NamedOptionDefinition("Q", "queryId", 0);
    private static final NamedOptionDefinition OPT_WORKITEM_IDS = new NamedOptionDefinition("W", "workitemIds", 0);
    private static final NamedOptionDefinition OPT_INCLUDE_CS_INFO = new NamedOptionDefinition("c", "includeCsDeliveryInfo", 0);
    private static final NamedOptionDefinition OPT_FORMAT_XML = new NamedOptionDefinition("x", "xml", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.setLongHelp(Messages.ExportCodeReviewCmd_0);
        options.addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_QUERY_ID, Messages.ExportCodeReviewCmd_9, true).addOption((INamedOptionDefinition)OPT_WORKITEM_IDS, Messages.ExportCodeReviewCmd_10, true)).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT, false).addOption((INamedOptionDefinition)OPT_FORMAT_XML, Messages.ExportCodeReviewCmd_3, false)).addOption((INamedOptionDefinition)OPT_INCLUDE_CS_INFO, Messages.ExportCodeReviewCmd_4).addOption((IPositionalOptionDefinition)OPT_SELECTORS, NLS.bind((String)Messages.ExportCodeReviewCmd_1, (Object)OPT_QUERY_ID.getName(), (Object)OPT_WORKITEM_IDS.getName())).addOption((IPositionalOptionDefinition)OPT_DEST, Messages.ExportCodeReviewCmd_2);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ITeamRepository repo = RepoUtil.login((IScmClientConfiguration)this.config, (ConnectionInfo)this.config.getConnectionInfo());
        IClientLibraryContext context = ((WorkspaceManager)SCMPlatform.getWorkspaceManager((ITeamRepository)repo)).getContext();
        String outputLocation = cli.getOption((IOptionKey)OPT_DEST);
        File file = new File(outputLocation);
        if (file.exists()) {
            throw StatusHelper.inappropriateArgument((String)Messages.ExportCodeReviewCmd_5);
        }
        if (cli.hasOption((IOptionKey)OPT_QUERY_ID) && cli.hasOption((IOptionKey)OPT_WORKITEM_IDS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExportCodeReviewCmd_6, (Object)OPT_QUERY_ID.getName(), (Object)OPT_WORKITEM_IDS.getName()));
        }
        ArrayList<String> selectors = new ArrayList<String>(Arrays.asList(cli.getOptionValue((IOptionKey)OPT_SELECTORS).getValue().split(SELECTOR_SEPARATOR)));
        IFilesystemWorkItemRestService.ParmsGetCodeReviewReport parms = new IFilesystemWorkItemRestService.ParmsGetCodeReviewReport();
        if (cli.hasOption((IOptionKey)OPT_WORKITEM_IDS)) {
            ArrayList<String> wiNumbers = new ArrayList<String>();
            ArrayList<String> invalidWiNumbers = new ArrayList<String>();
            for (String selector : selectors) {
                try {
                    Integer.parseInt(selector);
                    wiNumbers.add(selector);
                }
                catch (NumberFormatException e) {
                    invalidWiNumbers.add(selector);
                }
            }
            if (invalidWiNumbers.size() > 0) {
                StringBuilder strBuilder = new StringBuilder(System.lineSeparator());
                for (String invalidWiNumber : invalidWiNumbers) {
                    strBuilder.append(invalidWiNumber).append(System.lineSeparator());
                }
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExportCodeReviewCmd_11, (Object)strBuilder));
            }
            parms.workItemIds = cli.getOptionValue((IOptionKey)OPT_SELECTORS).getValue();
        } else {
            if (selectors.size() > 1) {
                throw StatusHelper.inappropriateArgument((String)Messages.ExportCodeReviewCmd_12);
            }
            String wiQueryId = selectors.get(0);
            if (RepoUtil.lookupUuidAndAlias((String)wiQueryId) == null) {
                throw StatusHelper.inappropriateArgument((String)Messages.ExportCodeReviewCmd_8);
            }
            parms.queryId = wiQueryId;
        }
        parms.nextPageToken = "0";
        parms.includeCsDeliveryInfo = cli.hasOption((IOptionKey)OPT_INCLUDE_CS_INFO);
        parms.includeFileNameInfo = true;
        parms.includeIssueDescriptionInfo = true;
        boolean isXml = cli.hasOption((IOptionKey)OPT_FORMAT_XML);
        if (isXml && cli.hasOption((IOptionKey)CommonOptions.OPT_JSON)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ExportCodeReviewCmd_6, (Object)OPT_FORMAT_XML.getName(), (Object)CommonOptions.OPT_JSON.getName()));
        }
        try {
            ITeamRawRestServiceClient client = context.teamRepository().getRawRestServiceClient();
            JSONObject codeReviewExportJson = null;
            Document codeReviewExportXml = null;
            boolean firstPass = true;
            while (parms.nextPageToken != null && !parms.nextPageToken.isEmpty()) {
                String proposedNextPageToken;
                URI uri = this.getURI(repo.getRepositoryURI(), parms);
                ITeamRawRestServiceClient.IRawRestClientConnection connection = client.getConnection(uri);
                connection.addRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
                connection.addRequestHeader("Accept", isXml ? HttpUtil.MediaType.XML.toString() : HttpUtil.MediaType.JSON.toString());
                ITeamRawRestServiceClient.IRawRestClientConnection.Response response = connection.doGet();
                int code = response.getStatusCode();
                if (code != 200) {
                    throw new FileSystemException(NLS.bind((String)Messages.DebugFetchCmd_BAD_RESPONSE, (Object)code));
                }
                if (isXml) {
                    Document responseDoc = ExportCodeReviewCmd.newDocumentFromInputStream(response.getResponseStream());
                    Element codeReviewElement = (Element)responseDoc.getElementsByTagName(RESPONSE_VALUE).item(0);
                    NodeList nodes = codeReviewElement.getChildNodes();
                    if (firstPass) {
                        Node workItemQuery;
                        firstPass = false;
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setNamespaceAware(true);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        codeReviewExportXml = builder.newDocument();
                        Element codeReviewExportElement = codeReviewExportXml.createElement(RESPONSE_CODE_REVIEW_EXPORT);
                        codeReviewExportElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                        codeReviewExportXml.appendChild(codeReviewExportElement);
                        NodeList queryElement = codeReviewElement.getElementsByTagName(RESPONSE_WORK_ITEM_QUERY);
                        if (queryElement != null && queryElement.getLength() > 0) {
                            workItemQuery = codeReviewExportXml.importNode(queryElement.item(0), true);
                            codeReviewExportXml.getElementsByTagName(RESPONSE_CODE_REVIEW_EXPORT).item(0).appendChild(workItemQuery);
                        }
                        if ((queryElement = codeReviewElement.getElementsByTagName(RESPONSE_WORK_ITEM_QUERY_NAME)) != null && queryElement.getLength() > 0) {
                            workItemQuery = codeReviewExportXml.importNode(queryElement.item(0), true);
                            codeReviewExportXml.getElementsByTagName(RESPONSE_CODE_REVIEW_EXPORT).item(0).appendChild(workItemQuery);
                        }
                    }
                    if (codeReviewExportXml != null) {
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Node newNode = codeReviewExportXml.importNode(nodes.item(i), true);
                            if (newNode.getNodeName().equals(RESPONSE_CODE_REVIEWS)) {
                                codeReviewExportXml.getElementsByTagName(RESPONSE_CODE_REVIEW_EXPORT).item(0).appendChild(newNode);
                            }
                            ++i;
                        }
                    }
                    proposedNextPageToken = null;
                    NodeList nextPageTokenElements = codeReviewElement.getElementsByTagName(NEXT_PAGE_TOKEN);
                    if (nextPageTokenElements != null && nextPageTokenElements.item(0) != null) {
                        proposedNextPageToken = nextPageTokenElements.item(0).getTextContent();
                    }
                    if (proposedNextPageToken == null || proposedNextPageToken.equals(parms.nextPageToken)) {
                        parms.nextPageToken = null;
                        continue;
                    }
                    parms.nextPageToken = proposedNextPageToken;
                    continue;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(response.getResponseStream()));
                JSONObject responseJson = JSONObject.parse((Reader)reader);
                JSONObject values = (JSONObject)((JSONObject)((JSONObject)((JSONObject)responseJson.get((Object)RESPONSE_SOAPENV_BODY)).get((Object)RESPONSE)).get((Object)RESPONSE_RETURN_FINAL)).get((Object)RESPONSE_VALUE);
                ExportCodeReviewCmd.removePropertyFromJsonObject(values, RESPONE_EQUALIFIED_CLASS_NAME);
                if (firstPass) {
                    firstPass = false;
                    codeReviewExportJson = values;
                } else if (codeReviewExportJson != null) {
                    JSONArray codeReviewsArray = (JSONArray)codeReviewExportJson.get((Object)RESPONSE_CODE_REVIEWS);
                    JSONArray codeReviews = (JSONArray)values.get((Object)RESPONSE_CODE_REVIEWS);
                    if (codeReviewsArray != null && codeReviews != null) {
                        codeReviewsArray.addAll((Collection)codeReviews);
                    }
                }
                proposedNextPageToken = null;
                if (values.get((Object)NEXT_PAGE_TOKEN) instanceof String) {
                    proposedNextPageToken = (String)values.get((Object)NEXT_PAGE_TOKEN);
                }
                parms.nextPageToken = proposedNextPageToken == null || proposedNextPageToken.equals(parms.nextPageToken) ? null : proposedNextPageToken;
            }
            if (isXml) {
                this.xmlDumpToFile(file, codeReviewExportXml);
            } else {
                this.jsonDumpToFile(file, codeReviewExportJson);
            }
            this.config.getWrappedOutputStream().println((CharSequence)Messages.ExportCodeReviewCmd_7);
        }
        catch (TeamRepositoryException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected URI getURI(String repoURI, IFilesystemWorkItemRestService.ParmsGetCodeReviewReport parms) throws TeamRepositoryException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repoURI);
        if (!repoURI.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append("service");
        buffer.append("/");
        buffer.append(IFilesystemWorkItemRestService.class.getName());
        buffer.append("/");
        buffer.append(CODE_REVIEW_REPORT);
        buffer.append("?");
        if (parms.queryId != null && !parms.queryId.isEmpty()) {
            buffer.append(QUERY_ID);
            buffer.append("=");
            buffer.append(parms.queryId);
            buffer.append("&");
        } else if (parms.workItemIds != null && !parms.workItemIds.isEmpty()) {
            buffer.append(WORKITEM_IDS);
            buffer.append("=");
            buffer.append(parms.workItemIds);
            buffer.append("&");
        }
        buffer.append(INCLUDE_CS_DELIVERY_INFO);
        buffer.append("=");
        buffer.append(parms.includeCsDeliveryInfo);
        buffer.append("&");
        buffer.append(INCLUDE_FILE_NAME_INFO);
        buffer.append("=");
        buffer.append(parms.includeFileNameInfo);
        buffer.append("&");
        buffer.append(INCLUDE_ISSUE_DESCRIPTION_INFO);
        buffer.append("=");
        buffer.append(parms.includeIssueDescriptionInfo);
        buffer.append("&");
        buffer.append(NEXT_PAGE_TOKEN);
        buffer.append("=");
        buffer.append(parms.nextPageToken);
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void xmlDumpToFile(File file, Document codeReviewExportXml) throws FileSystemException {
        try {
            ExportCodeReviewCmd.trimWhitespace(codeReviewExportXml.getFirstChild());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(file);
            DOMSource input = new DOMSource(codeReviewExportXml);
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private void jsonDumpToFile(File file, JSONObject codeReviewExportJson) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(codeReviewExportJson.toString().getBytes());
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        try {
            RepoUtil.transfer((InputStream)new BufferedInputStream(input), (OutputStream)output);
        }
        finally {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void removePropertyFromJsonObject(JSONObject json, String propertyToBeRemoved) {
        if (json.containsKey((Object)propertyToBeRemoved)) {
            json.remove((Object)propertyToBeRemoved);
        }
        for (Object property : json.keySet()) {
            JSONArray json1;
            if (json.get(property) instanceof JSONArray) {
                json1 = (JSONArray)json.get(property);
                ExportCodeReviewCmd.removePropertyFromJsonArray(json1, propertyToBeRemoved);
                continue;
            }
            if (!(json.get(property) instanceof JSONObject)) continue;
            json1 = (JSONObject)json.get(property);
            ExportCodeReviewCmd.removePropertyFromJsonObject((JSONObject)json1, propertyToBeRemoved);
        }
    }

    private static void removePropertyFromJsonArray(JSONArray jsonArray, String propertyToBeRemoved) {
        int i = 0;
        while (i < jsonArray.size()) {
            JSONArray json;
            if (jsonArray.get(i) instanceof JSONArray) {
                json = (JSONArray)jsonArray.get(i);
                ExportCodeReviewCmd.removePropertyFromJsonArray(json, propertyToBeRemoved);
            } else if (jsonArray.get(i) instanceof JSONObject) {
                json = (JSONObject)jsonArray.get(i);
                ExportCodeReviewCmd.removePropertyFromJsonObject((JSONObject)json, propertyToBeRemoved);
            }
            ++i;
        }
    }

    private static Document newDocumentFromInputStream(InputStream in) throws FileSystemException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document ret = builder.parse(new InputSource(in));
            return ret;
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private static void trimWhitespace(Node node) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            ExportCodeReviewCmd.trimWhitespace(child);
            ++i;
        }
    }
}

