/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.delete;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeleteContent;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IVersionedContentClaimerData;
import com.ibm.team.scm.common.VersionedContentClaimedByMultipleItems;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class DeleteStateContentCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IPositionalOptionDefinition OPT_ITEM = new PositionalOptionDefinition("item", 1, 1, "@");
    public static final IPositionalOptionDefinition OPT_STATES = new PositionalOptionDefinition("states", 1, -1, "@");
    public static final NamedOptionDefinition OPT_FORCE = new NamedOptionDefinition(null, "force", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)OPT_FORCE, Messages.DeleteStateContentCmd_OPT_FORCE_HELP).addOption(OPT_ITEM, Messages.DeleteStateContentCmd_OPT_ITEM_HELP).addOption(OPT_STATES, Messages.DeleteStateContentCmd_OPT_STATES_HELP);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument itemSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(OPT_ITEM.getId()), (IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)itemSelector);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)itemSelector, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
        String itemId = null;
        IUuidAliasRegistry.IUuidAlias itemAlias = RepoUtil.lookupUuidAndAlias((String)itemSelector.getItemSelector(), (String)repo.getRepositoryURI());
        if (itemAlias == null) {
            ResourcePropertiesDTO itemResource = this.getResource(itemSelector.getItemSelector(), client, this.config);
            if (itemResource == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, (Object)itemSelector.getItemSelector()));
            }
            itemId = itemResource.getItemId();
        } else {
            itemId = itemAlias.getUuid().getUuidValue();
        }
        List stateSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(OPT_STATES.getId()), (IScmClientConfiguration)this.config);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE, (List)stateSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)stateSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
        HashMap<String, String> states = new HashMap<String, String>(stateSelectors.size());
        for (IScmCommandLineArgument stateSelector : stateSelectors) {
            IUuidAliasRegistry.IUuidAlias stateAlias = RepoUtil.lookupUuidAndAlias((String)stateSelector.getItemSelector(), (String)repo.getRepositoryURI());
            if (stateAlias != null) {
                if (states.containsKey(stateAlias.getUuid().getUuidValue())) continue;
                states.put(stateAlias.getUuid().getUuidValue(), stateSelector.getItemSelector());
                continue;
            }
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_INVALID_ALIAS_UUID, (Object)stateSelector.getItemSelector()));
        }
        boolean force = cli.hasOption((IOptionKey)OPT_FORCE);
        this.deleteStates(itemId, states, repo, force, client, this.config);
        this.config.getWrappedOutputStream().println((CharSequence)Messages.DeleteStateContentCmd_SUCCESS);
    }

    private ResourcePropertiesDTO getResource(String itemSelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        List resourceProperties;
        ResourcePropertiesDTO dto;
        ILocation itemPath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)itemSelector);
        File itemFile = new File(itemPath.toOSString());
        if (!itemFile.exists()) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)itemSelector));
        }
        RepoUtil.getSandboxPathsAndRegister((String)itemPath.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        ParmsResourceProperties parms = new ParmsResourceProperties(false, new String[]{itemPath.toOSString()});
        ResourcesDTO resourcesDTO = null;
        try {
            resourcesDTO = client.postFetchResourceProperties(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.propertiesUnavailable((String)NLS.bind((String)Messages.HistoryCmd_UNABLE_TO_GET_PROPERTY, (Object)itemSelector));
        }
        if (resourcesDTO != null && (dto = (ResourcePropertiesDTO)(resourceProperties = resourcesDTO.getResourceProperties()).get(0)) != null && dto.getShare() != null) {
            return dto;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private void deleteStates(String itemId, Map<String, String> states, ITeamRepository repo, boolean forceDelete, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        deletedStates = new ArrayList<String>();
        for (Map.Entry<String, String> entry : states.entrySet()) {
            block8: {
                parms = new ParmsDeleteContent();
                parms.repositoryUrl = repo.getRepositoryURI();
                parms.itemId = itemId;
                parms.stateId = entry.getKey();
                parms.force = forceDelete;
                try {
                    client.postDeleteContent(parms, null);
                    deletedStates.add(entry.getValue());
                    continue;
                }
                catch (TeamRepositoryException e) {
                    if (deletedStates.size() <= 0) break block8;
                    out = config.getWrappedOutputStream();
                    out.println((CharSequence)Messages.DeleteStateContentCmd_PARTIAL_SUCCESS);
                    ** for (state : deletedStates)
                }
lbl-1000:
                // 1 sources

                {
                    out.indent().println((CharSequence)state);
                    continue;
                }
            }
            if (e instanceof VersionedContentClaimedByMultipleItems) {
                err = config.getWrappedErrorStream();
                multiClaim = (VersionedContentClaimedByMultipleItems)e;
                if (multiClaim.getData() != null) {
                    multiItemsData = multiClaim.getData();
                    err.println((CharSequence)NLS.bind((String)Messages.DeleteStateContentCmd_MULTI_ITEM_CLAIM, (Object)entry.getValue(), (Object)multiItemsData.getTotalClaimers()));
                    for (IVersionedContentClaimerData data : multiItemsData.getClaimerData()) {
                        err.indent().println((CharSequence)data.getApproximatePath());
                    }
                    if (multiItemsData.getTotalClaimers() > multiItemsData.getClaimerData().size()) {
                        err.indent().println((CharSequence)"...");
                    }
                    err.println((CharSequence)NLS.bind((String)Messages.DeleteStateContentCmd_MULTI_ITEM_CLAIM_ACTION, (Object)DeleteStateContentCmd.OPT_FORCE.getName()));
                }
                throw StatusHelper.orphan((String)Messages.DeleteStateContentCmd_FAILURE, (TeamRepositoryException)e);
            }
            throw StatusHelper.wrap((String)Messages.DeleteStateContentCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
    }
}

