/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteInputStream;
import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteOutputStream;
import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.rtc.cli.infrastructure.internal.core.AbstractExecutionContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.Map;

public class RemoteContext
extends AbstractExecutionContext {
    final String appName;
    final FSDaemon daemon;
    final String[] arguments;
    final Map<String, String> env;
    final String cwd;
    private String[] terminatingError = null;
    private final InputStream in;
    private final OutputStream out;
    private final PrintStream stderr;
    private final PrintStream stdout;
    private final Charset charset;
    private InputStream stdin;

    public RemoteContext(long start, String appName, FSDaemon daemon, InputStream in, OutputStream responseStream, LinkedList<String> args, Map<String, String> env, String cwd) {
        this(start, appName, daemon, in, responseStream, args, env, cwd, Charset.forName("UTF-8"));
    }

    public RemoteContext(long start, String appName, FSDaemon daemon, InputStream in, OutputStream responseStream, LinkedList<String> args, Map<String, String> env, String cwd, Charset charset) {
        super(start);
        this.appName = appName;
        this.daemon = daemon;
        this.arguments = args.toArray(new String[args.size()]);
        this.env = env;
        this.in = in;
        this.out = responseStream;
        this.cwd = cwd;
        this.stdout = new PrintStream(new RemoteOutputStream((Object)this, responseStream, MessageType.STDOUT));
        this.stderr = new PrintStream(new RemoteOutputStream((Object)this, responseStream, MessageType.STDERR));
        this.charset = charset;
    }

    public String getAppName() {
        return this.appName;
    }

    public String[] arguments() {
        return this.arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readInput(String prompt, boolean mask) throws IOException {
        RemoteContext remoteContext = this;
        synchronized (remoteContext) {
            ProtocolUtil.writeMessage((OutputStream)this.out, (MessageType)MessageType.PASSWORD_READ, (byte[][])new byte[][]{prompt.getBytes("UTF-8"), Boolean.toString(mask).getBytes("UTF-8")});
            this.out.flush();
            Message msg = Reader.readMessage((InputStream)this.in);
            if (msg.getMessageType() != MessageType.PASSWORD_RESPONSE) {
                throw new IOException("Unexpected message: " + msg.getMessageType());
            }
            if (ProtocolUtil.isCharsetUtf8((Charset)this.charset)) {
                return new String(msg.getFields()[0], "UTF-8");
            }
            byte[] utf8Bytes = ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[0], (Charset)this.charset);
            if (utf8Bytes != null && utf8Bytes.length > 0) {
                return new String(utf8Bytes, "UTF-8");
            }
            return null;
        }
    }

    public void setTerminatingError(String title, String message) {
        boolean hasMessage;
        boolean bl = hasMessage = title != null && title.length() != 0 || message != null && message.length() != 0;
        if (hasMessage) {
            this.terminatingError = new String[]{title, message};
        }
    }

    public PrintStream stderr() {
        return this.stderr;
    }

    public PrintStream stdout() {
        return this.stdout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream stdin() {
        RemoteContext remoteContext = this;
        synchronized (remoteContext) {
            if (this.stdin == null) {
                this.stdin = new RemoteInputStream((Object)this, this.out, this.in, this.charset);
            }
            return this.stdin;
        }
    }

    public String[] getTerminatingError() {
        return this.terminatingError;
    }

    public Map<String, String> environment() {
        return this.env;
    }

    public String getCurrentWorkingDirectory() {
        return this.cwd;
    }

    public boolean isLocal() {
        return false;
    }

    public Object getRemoteObject() {
        return this.daemon;
    }
}

