/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.internal.daemon.MultiplexingStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiplexingOutputStream
extends OutputStream {
    private final MultiplexingStream<OutputStream> multiplexer;

    MultiplexingOutputStream(OutputStream defaultOut) {
        this.multiplexer = new MultiplexingStream<OutputStream>(defaultOut);
    }

    @Override
    public void write(int b) throws IOException {
        this.multiplexer.findStream().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] toWrite = null;
        if (off == 0 && len == b.length) {
            toWrite = b;
        } else {
            toWrite = new byte[len];
            System.arraycopy(b, off, toWrite, 0, len);
        }
        this.multiplexer.findStream().write(toWrite, 0, len);
    }

    @Override
    public void close() throws IOException {
        this.multiplexer.findStream().close();
    }

    public void enroll(OutputStream out) {
        this.multiplexer.enroll(out);
    }

    public void cancel() throws IOException {
        this.multiplexer.cancel();
    }
}

