/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.restproxy.DaemonRegistry;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.rtc.cli.infrastructure.internal.util.StringUtil;
import java.util.Collection;

public class ListDaemonCmd
extends AbstractSubcommand
implements IOptionSource {
    private static final int COLWIDTH_PORT = 6;
    private static final int COLWIDTH_KEY = 34;

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, Messages.ListDaemonCmd_VERBOSE_OPTION_HELP);
        return opts;
    }

    public void run() throws FileSystemException {
        DaemonRegistry reg = new DaemonRegistry(this.config.getConfigDirectory());
        boolean verbose = this.config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        Collection entries = reg.listDaemons(null);
        IndentingPrintStream root = this.config.getWrappedOutputStream();
        if (entries.size() == 0) {
            root.println((CharSequence)Messages.ListDaemonCmd_NO_DAEMONS);
            return;
        }
        StringBuilder line = new StringBuilder();
        line.append(StringUtil.pad((CharSequence)Messages.ListDaemonCmd_COLUMN_LOCAL_PORT_NUMBER, (int)6));
        if (verbose) {
            line.append(StringUtil.pad((CharSequence)Messages.ListDaemonCmd_COLUMN_LOCAL_PASSWORD, (int)34));
        }
        line.append(Messages.ListDaemonCmd_COLUMN_DESCRIPTION_OF_DAEMON);
        root.println((CharSequence)line.toString());
        for (IDaemonRegistry.IRegistryEntry entry : entries) {
            String desc;
            line.setLength(0);
            line.append(StringUtil.pad((CharSequence)Integer.toString(entry.getPort()), (int)6));
            if (verbose) {
                line.append(StringUtil.pad((CharSequence)entry.getKey(), (int)34));
            }
            line.append((desc = entry.getDescription()) == null ? "" : desc);
            root.println((CharSequence)line.toString());
            IDaemonRegistry.IDaemonSandbox[] sandboxes = entry.getRegisteredSandboxes();
            if (sandboxes.length == 0) continue;
            IndentingPrintStream sbPrinter = root.indent();
            IDaemonRegistry.IDaemonSandbox[] iDaemonSandboxArray = sandboxes;
            int n = sandboxes.length;
            int n2 = 0;
            while (n2 < n) {
                IDaemonRegistry.IDaemonSandbox sb = iDaemonSandboxArray[n2];
                sbPrinter.println((CharSequence)sb.getSandboxRoot().getAbsolutePath());
                ++n2;
            }
        }
    }
}

