/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.daemon;

import com.ibm.team.filesystem.cli.client.internal.daemon.RemoteContext;
import com.ibm.team.filesystem.cli.minimal.protocol.Message;
import com.ibm.team.filesystem.cli.minimal.protocol.MessageType;
import com.ibm.team.filesystem.cli.minimal.protocol.ProtocolUtil;
import com.ibm.team.filesystem.cli.minimal.protocol.Reader;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.IExternalManager;
import com.ibm.team.filesystem.client.internal.http.ProtocolSwitchingHttpHandler;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IExecutionContext;
import com.ibm.team.rtc.cli.infrastructure.internal.core.SubcommandLauncher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class CommandLineClient
extends ProtocolSwitchingHttpHandler
implements IExternalManager {
    private static final String GROUP_FEC = "FrontEndClient";
    private FSDaemon daemon;
    private static Logger logger = Logger.getLogger(CommandLineClient.class.getName());

    public boolean willManage(HttpRequest request, HttpResponse response) {
        return true;
    }

    protected String getProtocol() {
        return "vnd.ibm.jazz.cli.minimal-1.0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest(HttpRequest request, HttpResponse response) throws IOException {
        int result;
        RemoteContext ctx;
        InputStream in;
        block35: {
            long start = System.currentTimeMillis();
            String charsetName = "UTF-8";
            Charset charset = Charset.forName(charsetName);
            List charsetNames = request.getHeader("Accept-Charset");
            if (charsetNames != null && charsetNames.size() > 0) {
                logger.info("Accept Charset received: " + charsetNames.toString());
                if (Charset.isSupported((String)charsetNames.get(0))) {
                    logger.info("Charset is supported by this JRE");
                    charsetName = (String)charsetNames.get(0);
                    charset = Charset.forName(charsetName);
                } else {
                    logger.warning("Charset received is not supported; defaulting to UTF-8");
                }
            }
            logger.info("charset = " + charsetName);
            in = response.getServerInputStream();
            String appName = null;
            LinkedList<String> args = new LinkedList<String>();
            HashMap<String, String> env = new HashMap<String, String>();
            String cwd = null;
            block19: while (true) {
                Message msg = Reader.readMessage((InputStream)in);
                switch (msg.getMessageType()) {
                    case APP_NAME: {
                        if (ProtocolUtil.isCharsetUtf8((Charset)charset)) {
                            appName = new String(msg.getFields()[0], "UTF-8");
                            continue block19;
                        }
                        appName = new String(ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[0], (Charset)charset), "UTF-8");
                        continue block19;
                    }
                    case ARGUMENT: {
                        if (ProtocolUtil.isCharsetUtf8((Charset)charset)) {
                            args.add(new String(msg.getFields()[0], "UTF-8"));
                            continue block19;
                        }
                        args.add(new String(ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[0], (Charset)charset), "UTF-8"));
                        continue block19;
                    }
                    case ENVIRONMENT: {
                        if (ProtocolUtil.isCharsetUtf8((Charset)charset)) {
                            env.put(new String(msg.getFields()[0], "UTF-8"), new String(msg.getFields()[1], "UTF-8"));
                            continue block19;
                        }
                        env.put(new String(ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[0], (Charset)charset), "UTF-8"), new String(ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[1], (Charset)charset), "UTF-8"));
                        continue block19;
                    }
                    case CWD: {
                        if (ProtocolUtil.isCharsetUtf8((Charset)charset)) {
                            cwd = new String(msg.getFields()[0], "UTF-8");
                            continue block19;
                        }
                        cwd = new String(ProtocolUtil.transcodeToUtf8((byte[])msg.getFields()[0], (Charset)charset), "UTF-8");
                        continue block19;
                    }
                    case PREAMBLE_DONE: {
                        break block19;
                    }
                    default: {
                        throw new IOException("Unexpected message: " + msg.getMessageType());
                    }
                }
                break;
            }
            File resultantCwd = new File(cwd);
            try {
                resultantCwd = resultantCwd.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ctx = new RemoteContext(start, appName, this.daemon, in, response.getResponseStream(), args, env, resultantCwd.getAbsolutePath(), charset);
            SubcommandLauncher runner = new SubcommandLauncher(GROUP_FEC, ctx.stderr());
            result = -1;
            try {
                block33: {
                    block32: {
                        if (cwd != null) break block32;
                        ctx.stderr().print(new RuntimeException("CWD not defined"));
                        if (ctx.getTerminatingError() != null) {
                            ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                            ctx.stderr().println(ctx.getTerminatingError()[1]);
                        }
                        ctx.stdout().flush();
                        ctx.stderr().flush();
                        ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
                        in.close();
                        response.getResponseStream().close();
                        System.gc();
                        return;
                    }
                    if (appName != null) break block33;
                    ctx.stderr().print(new RuntimeException(MessageType.APP_NAME + " not defined"));
                    if (ctx.getTerminatingError() != null) {
                        ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                        ctx.stderr().println(ctx.getTerminatingError()[1]);
                    }
                    ctx.stdout().flush();
                    ctx.stderr().flush();
                    ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
                    in.close();
                    response.getResponseStream().close();
                    System.gc();
                    return;
                }
                try {
                    try {
                        result = runner.run((IExecutionContext)ctx, null, null);
                    }
                    catch (Exception e) {
                        ctx.stderr().print(e.toString());
                        result = -13;
                        if (ctx.getTerminatingError() != null) {
                            ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                            ctx.stderr().println(ctx.getTerminatingError()[1]);
                        }
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    if (ctx.getTerminatingError() != null) {
                        ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                        ctx.stderr().println(ctx.getTerminatingError()[1]);
                    }
                    throw throwable;
                }
                if (ctx.getTerminatingError() != null) {
                    ctx.stderr().println(String.valueOf(ctx.getTerminatingError()[0]) + ":");
                    ctx.stderr().println(ctx.getTerminatingError()[1]);
                }
            }
            catch (Throwable throwable) {
                ctx.stdout().flush();
                ctx.stderr().flush();
                ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
                in.close();
                response.getResponseStream().close();
                System.gc();
                throw throwable;
            }
        }
        ctx.stdout().flush();
        ctx.stderr().flush();
        ProtocolUtil.writeMessage((OutputStream)response.getResponseStream(), (MessageType)MessageType.EXIT_CODE, (byte[][])new byte[][]{{(byte)result}});
        in.close();
        response.getResponseStream().close();
        System.gc();
    }

    public void registered(FSDaemon fsd, HttpServer httpServer, Collection<HttpContext> contexts) {
        this.daemon = fsd;
    }

    public void remoteClosed() {
    }

    public void shutdown() {
    }
}

