/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.createcommand.CreateStreamCmd;
import com.ibm.team.filesystem.cli.client.internal.createcommand.CreateWorkspaceBaseOptions;
import com.ibm.team.filesystem.cli.client.internal.createcommand.CreateWorkspaceOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IAlias;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.CLIFileSystemClientException;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspaceFromHistoryReference;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistory;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmWorkspaceHistoryEntry;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.sql.Timestamp;
import java.text.DateFormat;
import org.eclipse.osgi.util.NLS;

public class CreateWorkspaceCmd
extends CreateStreamCmd {
    @Override
    public void validateArguments(ICommandLine subargs) throws FileSystemException {
        int contentArgCount = (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_STREAM) ? 1 : 0) + (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_SNAPSHOT) ? 1 : 0) + (subargs.hasOption(CreateWorkspaceOptions.OPT_EMPTY) ? 1 : 0) + (subargs.hasOption(CreateWorkspaceOptions.OPT_HREF) ? 1 : 0);
        if (contentArgCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateWorkspaceCmd_4, (Object[])new Object[]{subargs.getDefinition().getOption(CreateWorkspaceOptions.OPT_EMPTY).getName(), subargs.getDefinition().getOption(CreateWorkspaceBaseOptions.OPT_STREAM).getName(), subargs.getDefinition().getOption(CreateWorkspaceBaseOptions.OPT_SNAPSHOT).getName(), subargs.getDefinition().getOption(CreateWorkspaceOptions.OPT_HREF).getName()}));
        }
        if (!subargs.hasOption(CreateWorkspaceOptions.OPT_HREF) && !subargs.hasOption(CreateWorkspaceBaseOptions.OPT_NAME)) {
            throw StatusHelper.argSyntax((String)Messages.CreateWorkspaceCmdOptions_NameRequired);
        }
        if (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_DUPLICATE) && (contentArgCount > 0 || subargs.hasOption((IOptionKey)CreateWorkspaceBaseOptions.OPT_DESC))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateWorkspaceCmd_DUPLICATE_MUTUALLY_EXCLUSIVE, (Object[])new String[]{CreateWorkspaceBaseOptions.OPT_STREAM.getName(), CreateWorkspaceBaseOptions.OPT_SNAPSHOT.getName(), CreateWorkspaceOptions.OPT_HREF.getName(), CreateWorkspaceBaseOptions.OPT_DESC.getName(), CreateWorkspaceOptions.OPT_EMPTY.getName()}));
        }
    }

    @Override
    protected void run(ICommandLine subargs, IFilesystemRestClient client) throws FileSystemException {
        ScmCommandLineArgument historyRefArg = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceOptions.OPT_HREF, null), (IScmClientConfiguration)this.config);
        if (historyRefArg != null) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceBaseOptions.OPT_NAME), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateRepos((IScmClientConfiguration)this.config, (IScmCommandLineArgument[])new IScmCommandLineArgument[]{wsSelector, historyRefArg});
            String description = subargs.getOption((IOptionKey)CreateWorkspaceBaseOptions.OPT_DESC, "");
            this.createFromHistoryReference(client, (IScmCommandLineArgument)wsSelector, (IScmCommandLineArgument)historyRefArg, description);
        } else {
            super.run(subargs, client);
        }
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    public String getCreationFailureMsg() {
        return Messages.CreateWorkspaceCmd_0;
    }

    @Override
    public String getSuccessfulCreationMsg() {
        return Messages.CreateWorkspaceCmd_12;
    }

    @Override
    public String getSnapshotUpdateFailureMsg() {
        return Messages.CreateWorkspaceCmd_UPDATE_WITH_SNAPSHOT_FAILURE;
    }

    @Override
    protected String getActiveChangeSetErrorMessageNoName() {
        return Messages.CreateWorkspaceCmd_UNKNOWN_COMPONENT_HAS_ACTIVE_CHANGES;
    }

    @Override
    protected String getActiveChangeSetErrorMessageWithComponentName() {
        return Messages.CreateWorkspaceCmd_ACTIVE_CHANGESETS_IN_COMPONENT;
    }

    @Override
    public String getFlowUpdateFailureMsg() {
        return Messages.CreateWorkspaceCmd_FLOW_TARGET_UPDATE_FAILURE;
    }

    @Override
    public IProjectArea getProjectArea(ICommandLine subargs, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        return null;
    }

    @Override
    public ITeamArea getTeamArea(ICommandLine subargs, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        return null;
    }

    @Override
    public void createComponent(WorkspaceDetailsDTO wsDetails, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs, JSONObject wsObj) throws FileSystemException {
        if (!subargs.hasOption(CreateWorkspaceOptions.OPT_EMPTY)) {
            PutWorkspaceResultDTO wsResult;
            ParmsPutWorkspace parmsPutWs = new ParmsPutWorkspace();
            parmsPutWs.workspace = new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId());
            parmsPutWs.configurationChanges = new ParmsConfigurationChanges();
            parmsPutWs.configurationChanges.components = new ParmsComponentChange[1];
            ParmsComponentChange newComp = new ParmsComponentChange();
            newComp.cmd = "addComponent";
            newComp.name = NLS.bind((String)Messages.CreateWorkspaceCmd_13, (Object)wsDetails.getName());
            parmsPutWs.configurationChanges.components[0] = newComp;
            try {
                wsResult = client.postPutWorkspace(parmsPutWs, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.CreateWorkspaceCmd_DEFAULT_COMP_ADD_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)wsDetails.getRepositoryURL());
            }
            if (wsResult.getComponentsAdded().size() != 1) {
                throw StatusHelper.failure((String)Messages.CreateWorkspaceCmd_DEFAULT_COMP_ADD_FAILURE, null);
            }
            ConfigurationDescriptorDTO configDesc = (ConfigurationDescriptorDTO)wsResult.getComponentsAdded().get(0);
            JSONPrintUtil.jsonizeResult((JSONObject)wsObj, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT, (String)Messages.CreateComponentCommand_ComponentSuccessfullyCreated, (String)newComp.name, (String)configDesc.getComponentItemId(), (String)configDesc.getConnection().getRepositoryURL());
        }
    }

    protected void createFromHistoryReference(IFilesystemRestClient client, IScmCommandLineArgument wsSelector, IScmCommandLineArgument historyRefArg, String description) throws FileSystemException, CLIFileSystemClientException {
        ITeamRepository targetRepository = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        ITeamRepository sourceRepository = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)historyRefArg);
        IAlias alias = RepoUtil.lookupByIdOrAlias((String)historyRefArg.getItemSelector(), (String)sourceRepository.getRepositoryURI());
        ParmsHistoryReference parmsHistoryReference = SubcommandUtil.createParmsHistoryReference((String)historyRefArg.getItemSelector(), (String)sourceRepository.getRepositoryURI());
        if (parmsHistoryReference != null) {
            String workspaceName = this.getWorkspaceName(sourceRepository, wsSelector, parmsHistoryReference, alias);
            ParmsPostWorkspaceFromHistoryReference parms = new ParmsPostWorkspaceFromHistoryReference();
            parms.description = description;
            parms.name = workspaceName;
            parms.repositoryUrl = targetRepository.getRepositoryURI();
            parms.seed = parmsHistoryReference;
            try {
                WorkspaceDetailsDTO wsDetails = client.postWorkspaceFromHistoryReference(parms, null);
                JSONObject wsObj = JSONPrintUtil.jsonizeResult((String)this.getSuccessfulCreationMsg(), (String)wsDetails.getName(), (String)wsDetails.getItemId(), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
                PendingChangesUtil.printSuccess((JSONObject)wsObj, (IScmClientConfiguration)this.config, (IndentingPrintStream)this.config.getWrappedOutputStream());
                return;
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)this.getCreationFailureMsg(), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)parms.repositoryUrl);
            }
        }
        throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CreateStreamCmd_HISTORY_REF_NOT_FOUND, (Object)historyRefArg.getItemSelector()));
    }

    private String getWorkspaceName(ITeamRepository repository, IScmCommandLineArgument wsSelector, ParmsHistoryReference parmsHistoryReference, IAlias alias) throws FileSystemException {
        if (wsSelector != null && wsSelector.getItemSelector() != null) {
            return wsSelector.getItemSelector();
        }
        if (parmsHistoryReference == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.CreateStreamCmd_HISTORY_REF_NOT_FOUND, (Object)alias.getMonicker()));
        }
        try {
            long date = -1L;
            IWorkspace workspace = RepoUtil.getWorkspace((String)parmsHistoryReference.workspaceId, (boolean)true, (boolean)true, (boolean)false, (ITeamRepository)repository, (IScmClientConfiguration)this.config);
            IScmRichClientRestService.ParmsGetWorkspaceHistory parms = new IScmRichClientRestService.ParmsGetWorkspaceHistory();
            parms.workspaceId = parmsHistoryReference.workspaceId;
            parms.historyReferenceId = alias.getId();
            parms.includeDetails = false;
            parms.maxResultSize = 1;
            IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repository).getServiceInterface(IScmRichClientRestService.class);
            ScmWorkspaceHistory workspaceHistory = scmService.postGetWorkspaceHistory(parms);
            if (workspaceHistory.getHistoryEntries().size() > 0) {
                ScmWorkspaceHistoryEntry entry = (ScmWorkspaceHistoryEntry)workspaceHistory.getHistoryEntries().get(0);
                date = entry.getDate();
            }
            String wsName = workspace != null ? workspace.getName() : NLS.bind((String)Messages.WorkspaceHistory_DeletedItem, (Object)parmsHistoryReference.workspaceId);
            String dateString = DateFormat.getDateTimeInstance().format(new Timestamp(date));
            return NLS.bind((String)Messages.CreateWorkspaceCmd_defaultName, (Object)wsName, (Object)dateString);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateStreamCmd_HISTORY_REF_NOT_FOUND, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repository.getRepositoryURI());
        }
    }
}

