/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.createcommand.CreateStreamOptions;
import com.ibm.team.filesystem.cli.client.internal.createcommand.CreateWorkspaceBaseOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsFlowTargetChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPostWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsReadScope;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceReplaceWithSnapshot;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ReadScopeDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceFlowEntryDTO;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateStreamCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.validateArguments(subargs);
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        this.run(subargs, client);
    }

    protected void run(ICommandLine subargs, IFilesystemRestClient client) throws FileSystemException {
        WorkspaceDetailsDTO wsDetails;
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceBaseOptions.OPT_NAME), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument flowToStream = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceBaseOptions.OPT_STREAM, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)flowToStream, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ScmCommandLineArgument snapshot = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceBaseOptions.OPT_SNAPSHOT, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)snapshot, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
        ScmCommandLineArgument duplicateWsArg = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateWorkspaceBaseOptions.OPT_DUPLICATE, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)duplicateWsArg, (RepoUtil.ItemType)(this.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
        SubcommandUtil.validateRepos((IScmClientConfiguration)this.config, (IScmCommandLineArgument[])new IScmCommandLineArgument[]{wsSelector, flowToStream, snapshot, duplicateWsArg});
        ScmCommandLineArgument autoFileLockPatternsArg = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateStreamOptions.OPT_AUTOFILELOCKPATTERNS, null), (IScmClientConfiguration)this.config);
        ITeamRepository streamOrSnapshotRepo = null;
        ITeamRepository duplicateWsRepo = null;
        ParmsWorkspace stream = null;
        ParmsWorkspace duplicateWs = null;
        IBaselineSet snap = null;
        if (flowToStream != null) {
            streamOrSnapshotRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)flowToStream);
            IWorkspace streamFound = RepoUtil.getWorkspace((String)flowToStream.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)streamOrSnapshotRepo, (IScmClientConfiguration)this.config);
            stream = new ParmsWorkspace(streamOrSnapshotRepo.getRepositoryURI(), streamFound.getItemId().getUuidValue());
        } else if (snapshot != null) {
            streamOrSnapshotRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)snapshot);
            snap = RepoUtil.getSnapshot(null, (String)snapshot.getItemSelector(), (ITeamRepository)streamOrSnapshotRepo, (IScmClientConfiguration)this.config);
        } else if (duplicateWsArg != null) {
            duplicateWsRepo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)duplicateWsArg);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)duplicateWsArg.getItemSelector(), (!this.isStream() ? 1 : 0) != 0, (boolean)this.isStream(), (ITeamRepository)duplicateWsRepo, (IScmClientConfiguration)this.config);
            duplicateWs = new ParmsWorkspace(duplicateWsRepo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        }
        ITeamRepository repo = null;
        repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        ParmsPostWorkspace parms = new ParmsPostWorkspace();
        parms.name = wsSelector.getItemSelector();
        parms.isStream = this.isStream();
        parms.repositoryUrl = repo.getRepositoryURI();
        if (this.isStream() && autoFileLockPatternsArg != null) {
            parms.autoFileLockPatterns = autoFileLockPatternsArg.getStringValue();
        }
        WorkspaceDetailsDTO duplicateWsDetails = null;
        if (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_DUPLICATE)) {
            duplicateWsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(duplicateWs), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
            this.setDuplicateParams(parms, duplicateWsDetails, client, subargs);
        } else {
            this.setParams(parms, stream, repo, client, subargs);
        }
        try {
            wsDetails = client.postWorkspace(parms, null);
        }
        catch (ActiveChangeSetsException e) {
            if (e.getData() instanceof IChangeSetHandle) {
                String compName;
                IChangeSetHandle csHandle = (IChangeSetHandle)e.getData();
                try {
                    IChangeSet cs = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, null);
                    IComponent comp = (IComponent)repo.itemManager().fetchCompleteItem((IItemHandle)cs.getComponent(), 0, null);
                    compName = comp.getName();
                }
                catch (TeamRepositoryException e1) {
                    compName = null;
                }
                if (compName != null) {
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)this.getActiveChangeSetErrorMessageWithComponentName(), compName));
                }
            }
            throw StatusHelper.inappropriateArgument((String)this.getActiveChangeSetErrorMessageNoName());
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)this.getCreationFailureMsg(), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)parms.repositoryUrl);
        }
        if (duplicateWsDetails != null && duplicateWsDetails.getFlowEntries().size() > 0) {
            this.updateFlowTargets(wsDetails, duplicateWsDetails, repo, client);
        }
        if (snap != null) {
            this.updateWithSnapshotInfo(wsDetails, snap, streamOrSnapshotRepo, repo, client);
        }
        JSONObject wsObj = JSONPrintUtil.jsonizeResult((String)this.getSuccessfulCreationMsg(), (String)wsDetails.getName(), (String)wsDetails.getItemId(), (String)wsDetails.getRepositoryURL(), (RepoUtil.ItemType)(this.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE));
        if (flowToStream == null && snap == null && duplicateWs == null) {
            this.createComponent(wsDetails, client, this.config, subargs, wsObj);
        }
        PendingChangesUtil.printSuccess((JSONObject)wsObj, (IScmClientConfiguration)this.config, (IndentingPrintStream)this.config.getWrappedOutputStream());
    }

    private void setDuplicateParams(ParmsPostWorkspace parms, WorkspaceDetailsDTO wsDetails, IFilesystemRestClient client, ICommandLine subargs) throws FileSystemException {
        parms.description = wsDetails.getDescription();
        parms.seed = new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId());
        ReadScopeDTO readScope = wsDetails.getReadScope();
        if (readScope != null) {
            parms.readScope = new ParmsReadScope();
            parms.readScope.scope = readScope.getReadScope();
            if (readScope.getDefersTo() != null) {
                parms.readScope.defer_to = readScope.getDefersTo().getItemId().getUuidValue();
            }
        }
        if (this.isStream()) {
            parms.processAreaId = wsDetails.getOwner().getItemId().getUuidValue();
            parms.processAreaType = wsDetails.getOwner().getItemType().getName();
            parms.autoFileLockPatterns = wsDetails.getExclusiveFileLockPatterns();
        }
    }

    private void setParams(ParmsPostWorkspace parms, ParmsWorkspace stream, ITeamRepository repo, IFilesystemRestClient client, ICommandLine subargs) throws FileSystemException {
        ITeamArea teamArea;
        String wsDesc;
        parms.description = wsDesc = subargs.getOption((IOptionKey)CreateWorkspaceBaseOptions.OPT_DESC, "");
        if (stream != null) {
            parms.seed = stream;
        }
        if ((teamArea = this.getTeamArea(subargs, repo, this.config)) != null) {
            parms.processAreaId = teamArea.getItemId().getUuidValue();
            parms.processAreaType = teamArea.getItemType().getName();
        } else {
            IProjectArea projectArea = this.getProjectArea(subargs, repo, this.config);
            if (projectArea != null) {
                parms.processAreaId = projectArea.getItemId().getUuidValue();
                parms.processAreaType = projectArea.getItemType().getName();
            }
        }
    }

    private void updateFlowTargets(WorkspaceDetailsDTO wsDetails, WorkspaceDetailsDTO duplicateWsDetails, ITeamRepository repo, IFilesystemRestClient client) throws FileSystemException {
        ParmsPutWorkspace parms = new ParmsPutWorkspace();
        parms.workspace = new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId());
        List wsFlowList = duplicateWsDetails.getFlowEntries();
        parms.flowTargets = new ParmsFlowTargetChange[wsFlowList.size()];
        int flowCount = 0;
        for (WorkspaceFlowEntryDTO wsFlow : wsFlowList) {
            ParmsFlowTargetChange parmsFlow = new ParmsFlowTargetChange();
            parmsFlow.workspace = new ParmsWorkspace(wsFlow.getRepositoryURL(), wsFlow.getWorkspaceItemId());
            List compIds = wsFlow.getScopedComponentItemIds();
            parmsFlow.scopedComponentItemIds = compIds.toArray(new String[compIds.size()]);
            if (wsFlow.isCurrentIncomingFlow()) {
                parms.currentIncomingFlowTarget = parmsFlow.workspace;
            }
            if (wsFlow.isCurrentOutgoingFlow()) {
                parms.currentOutgoingFlowTarget = parmsFlow.workspace;
            }
            if (wsFlow.isDefaultIncomingFlow()) {
                parms.defaultIncomingFlowTarget = parmsFlow.workspace;
            }
            if (wsFlow.isDefaultOutgoingFlow()) {
                parms.defaultOutgoingFlowTarget = parmsFlow.workspace;
            }
            parms.flowTargets[flowCount++] = parmsFlow;
        }
        if (!this.isStream()) {
            parms.flowTargetsToRemove = new ParmsWorkspace[1];
            parms.flowTargetsToRemove[0] = new ParmsWorkspace(wsDetails.getRepositoryURL(), duplicateWsDetails.getItemId());
        }
        try {
            client.postPutWorkspace(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)this.getFlowUpdateFailureMsg(), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }

    private void updateWithSnapshotInfo(WorkspaceDetailsDTO wsDetails, IBaselineSet snap, ITeamRepository streamOrSnapshotRepo, ITeamRepository repo, IFilesystemRestClient client) throws FileSystemException {
        WorkspaceUpdateResultDTO result;
        ParmsWorkspaceUpdate updateParms = new ParmsWorkspaceUpdate();
        updateParms.workspaceReplaceWithSnapshot = new ParmsWorkspaceReplaceWithSnapshot[1];
        ParmsWorkspaceReplaceWithSnapshot replaceWithSnapshot = new ParmsWorkspaceReplaceWithSnapshot();
        replaceWithSnapshot.workspace = new ParmsWorkspace(wsDetails.getRepositoryURL(), wsDetails.getItemId());
        replaceWithSnapshot.baselineSet = new ParmsBaselineSet();
        replaceWithSnapshot.baselineSet.baselineSetItemId = snap.getItemId().getUuidValue();
        replaceWithSnapshot.baselineSet.repositoryUrl = streamOrSnapshotRepo.getRepositoryURI();
        updateParms.workspaceReplaceWithSnapshot[0] = replaceWithSnapshot;
        ParmsWorkspaceUpdateDilemmaHandler wsUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        wsUpdateDilemmaHandler.componentFlowDirection = "continue";
        updateParms.workspaceUpdateDilemmaHandler = wsUpdateDilemmaHandler;
        try {
            result = client.postWorkspaceUpdate(updateParms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)this.getSnapshotUpdateFailureMsg(), (Object)snap.getName()), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)replaceWithSnapshot.workspace.repositoryUrl);
        }
        if (result.isSetEclipseReadFailureMessage()) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            for (Object nextMsg : result.getEclipseReadFailureMessage()) {
                err.println((CharSequence)((String)nextMsg));
            }
        }
    }

    protected String getActiveChangeSetErrorMessageNoName() {
        return Messages.CreateStreamCmd_UNKNOWN_COMPONENT_HAS_ACTIVE_CHANGES;
    }

    protected String getActiveChangeSetErrorMessageWithComponentName() {
        return Messages.CreateStreamCmd_ACTIVE_CHANGESETS_IN_COMPONENT;
    }

    public void validateArguments(ICommandLine subargs) throws FileSystemException {
        int contentArgCount = (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_STREAM) ? 1 : 0) + (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_SNAPSHOT) ? 1 : 0);
        if (contentArgCount > 1) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateStreamCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object[])new Object[]{subargs.getDefinition().getOption(CreateWorkspaceBaseOptions.OPT_STREAM).getName(), subargs.getDefinition().getOption(CreateWorkspaceBaseOptions.OPT_SNAPSHOT).getName()}));
        }
        if (subargs.hasOption(CreateWorkspaceBaseOptions.OPT_DUPLICATE) && (contentArgCount > 0 || subargs.hasOption((IOptionKey)CreateWorkspaceBaseOptions.OPT_DESC) || subargs.hasOption(CreateStreamOptions.OPT_TEAMAREA) || subargs.hasOption(CreateStreamOptions.OPT_PROJECTAREA))) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateStreamCmd_DUPLICATE_MUTUALLY_EXCLUSIVE, (Object[])new String[]{CreateWorkspaceBaseOptions.OPT_STREAM.getName(), CreateWorkspaceBaseOptions.OPT_SNAPSHOT.getName(), CreateStreamOptions.OPT_PROJECTAREA.getName(), CreateStreamOptions.OPT_TEAMAREA.getName(), CreateWorkspaceBaseOptions.OPT_DESC.getName()}));
        }
        if (!subargs.hasOption(CreateWorkspaceBaseOptions.OPT_DUPLICATE)) {
            if (!subargs.hasOption(CreateStreamOptions.OPT_OWNER)) {
                String commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
                throw StatusHelper.argSyntax((String)NLS.bind((String)com.ibm.team.rtc.cli.infrastructure.internal.Messages.Application_12, (Object)commandName, (Object)CreateStreamOptions.OPT_OWNER.getName()));
            }
            if (!subargs.hasOption(CreateStreamOptions.OPT_PROJECTAREA) && !subargs.hasOption(CreateStreamOptions.OPT_TEAMAREA)) {
                throw StatusHelper.argSyntax((String)Messages.CreateStreamCmd_MISSING_OWNER_INFO);
            }
            if (subargs.hasOption(CreateStreamOptions.OPT_PROJECTAREA) && subargs.hasOption(CreateStreamOptions.OPT_TEAMAREA)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateStreamCmd_MUTUALLY_EXCLUSIVE_OPTIONS, (Object)subargs.getDefinition().getOption(CreateStreamOptions.OPT_PROJECTAREA).getName(), (Object)subargs.getDefinition().getOption(CreateStreamOptions.OPT_TEAMAREA).getName()));
            }
            ScmCommandLineArgument owner = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CreateStreamOptions.OPT_OWNER), (IScmClientConfiguration)this.config);
            if (subargs.hasOption(CreateStreamOptions.OPT_PROJECTAREA)) {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)owner, (RepoUtil.ItemType)RepoUtil.ItemType.PROJECTAREA);
            } else {
                SubcommandUtil.validateArgument((IScmCommandLineArgument)owner, (RepoUtil.ItemType)RepoUtil.ItemType.TEAMAREA);
            }
        } else if (subargs.hasOption(CreateStreamOptions.OPT_OWNER)) {
            String commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
            throw StatusHelper.argSyntax((String)NLS.bind((String)com.ibm.team.rtc.cli.infrastructure.internal.Messages.Application_11, (Object)commandName, (Object)CreateStreamOptions.OPT_OWNER.getName()));
        }
    }

    public boolean isStream() {
        return true;
    }

    public String getCreationFailureMsg() {
        return Messages.CreateStreamCmd_CREATE_FAILURE;
    }

    public String getSuccessfulCreationMsg() {
        return Messages.CreateStreamCmd_SUCCESS;
    }

    public String getSnapshotUpdateFailureMsg() {
        return Messages.CreateStreamCmd_UPDATE_WITH_SNAPSHOT_FAILURE;
    }

    public String getFlowUpdateFailureMsg() {
        return Messages.CreateStreamCmd_FLOW_TARGET_UPDATE_FAILURE;
    }

    public IProjectArea getProjectArea(ICommandLine subargs, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        String projAreaSelector;
        IProjectArea projArea = null;
        if (subargs.hasOption(CreateStreamOptions.OPT_PROJECTAREA) && (projArea = RepoUtil.getProjectArea((ITeamRepository)repo, (String)(projAreaSelector = subargs.getOption(CreateStreamOptions.OPT_OWNER)), (IScmClientConfiguration)config)) == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projAreaSelector));
        }
        return projArea;
    }

    public ITeamArea getTeamArea(ICommandLine subargs, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        String teamAreaSelector;
        ITeamArea teamArea = null;
        if (subargs.hasOption(CreateStreamOptions.OPT_TEAMAREA) && (teamArea = RepoUtil.getTeamArea((String)(teamAreaSelector = subargs.getOption(CreateStreamOptions.OPT_OWNER)), null, (IScmClientConfiguration)config, (ITeamRepository)repo)) == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_TeamAreaNotFound, (Object)teamAreaSelector));
        }
        return teamArea;
    }

    public void createComponent(WorkspaceDetailsDTO wsDetails, IFilesystemRestClient client, IScmClientConfiguration config, ICommandLine subargs, JSONObject wsObj) throws FileSystemException {
    }
}

