/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmd;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineSetDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsGetBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.GetBaselinesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineSetResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreateSnapshotCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_DESC = new OptionKey("desc");
    public static final IOptionKey OPT_NAME = new OptionKey("name");
    public static final NamedOptionDefinition OPT_DESC_DEPRECATED = new NamedOptionDefinition("d", "descDeprecatedShortOption", 1);
    public static final NamedOptionDefinition OPT_FORCE_BASELINE_CREATION = new NamedOptionDefinition("f", "forceBaselineCreation", 0);
    public static final NamedOptionDefinition OPT_FAILED_ON_OPEN_CHANGE_SETS = new NamedOptionDefinition("a", "failOnActiveCS", 0);
    public static final NamedOptionDefinition OPT_ALLOW_PARTIAL_HIERARCHY = new NamedOptionDefinition("p", "allowPartialHierarchy", 0);
    public static final NamedOptionDefinition OPT_INCLUDE_COMPONENTS_FLAG = new NamedOptionDefinition("i", "include", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY_LONG_OPTION, CommonOptions.OPT_DIRECTORY_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_COMPS_SELECTOR, Messages.CreateSnapshotCmd_ExcludeComponents).addOption((INamedOptionDefinition)OPT_INCLUDE_COMPONENTS_FLAG, NLS.bind((String)Messages.CreateSnapshotCmd_INCLUDE_LIST_HELP, (Object)CommonOptions.OPT_COMPS_SELECTOR.getShortOpt(), (Object[])new Object[0])).addOption((INamedOptionDefinition)OPT_FAILED_ON_OPEN_CHANGE_SETS, Messages.CreateSnapshotCmd_OPEN_CHANGE_SETS_HELP, false).addOption((INamedOptionDefinition)OPT_ALLOW_PARTIAL_HIERARCHY, Messages.CreateSnapshotCmd_OPT_ALLOW_PARTIAL_HIERARCHY_HELP, false).addOption((INamedOptionDefinition)OPT_FORCE_BASELINE_CREATION, Messages.CreateSnapshotCmd_ForceBaselineCreation).addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.CreateBaselineCmd_HELP_IGNORE_UNCOMMITTED_LOCAL_CHANGES).addOption(OPT_NAME, "n", "name", Messages.CreateSnapshotCmd_Name, 1).addOption(OPT_DESC, null, "description", Messages.CreateSnapshotCmd_Description, 1).addOption((INamedOptionDefinition)OPT_DESC_DEPRECATED, Messages.CreateSnapshotCmd_Description).addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PositionalArgSeparator_Help, (Object)CommonOptions.OPT_WORKSPACE.getName(), (Object[])new Object[0])).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.CreateSnapshotCmd_Workspace);
        OPT_DESC_DEPRECATED.hideOption();
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        if (cli.hasOption((IOptionKey)OPT_INCLUDE_COMPONENTS_FLAG) && !cli.hasOption((IOptionKey)CommonOptions.OPT_COMPS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateSnapshotCmd_ERROR_INCLUDE_LIST_NO_COMPONENTS, (Object)OPT_INCLUDE_COMPONENTS_FLAG.getShortOpt(), (Object[])new Object[]{CommonOptions.OPT_COMPS_SELECTOR.getShortOpt()}));
        }
        ArrayList<String> components = new ArrayList<String>();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_COMPS_SELECTOR)) {
            List compSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)CommonOptions.OPT_COMPS_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)compSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            List comps = RepoUtil.getSelectors((List)compSelectors);
            ArrayList<String> compNotFound = new ArrayList<String>();
            for (String comp : comps) {
                boolean isComponentFound = false;
                IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)comp);
                if (compNotFound.contains(comp)) continue;
                for (Object compDTO : wsDetails.getComponents()) {
                    if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !comp.equals(compDTO.getName())) continue;
                    if (!components.contains(compDTO.getItemId())) {
                        components.add(compDTO.getItemId());
                    }
                    isComponentFound = true;
                    break;
                }
                if (isComponentFound) continue;
                compNotFound.add(comp);
            }
            if (compNotFound.size() != 0) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)NLS.bind((String)Messages.CreateSnapshotCmd_ERROR_WRONG_COMPONENT, (Object)wsDetails.getName(), (Object[])new Object[0]));
                for (String comp : compNotFound) {
                    err.indent().println((CharSequence)comp);
                }
                throw StatusHelper.itemNotFound((String)Messages.CreateSnapshotCmd_ERROR_MSG_WRONG_COMPONENT);
            }
        }
        ParmsCreateBaselineSet parms = new ParmsCreateBaselineSet();
        parms.workspace = ws;
        parms.componentItemIds = components.toArray(new String[components.size()]);
        parms.isComponentIncludesList = cli.hasOption((IOptionKey)OPT_INCLUDE_COMPONENTS_FLAG);
        parms.createNewBaselines = true;
        parms.name = wsDetails.getName();
        if (cli.hasOption(OPT_NAME)) {
            parms.name = cli.getOption(OPT_NAME);
        }
        parms.comment = "";
        if (cli.hasOption(OPT_DESC)) {
            parms.comment = cli.getOption(OPT_DESC);
        } else if (cli.hasOption((IOptionKey)OPT_DESC_DEPRECATED)) {
            parms.comment = cli.getOption((IOptionKey)OPT_DESC_DEPRECATED);
        }
        parms.forceBaselineCreation = false;
        if (cli.hasOption((IOptionKey)OPT_FORCE_BASELINE_CREATION)) {
            parms.forceBaselineCreation = true;
        }
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)this.config);
        parms.createBaselineSetDilemmaHandler = new ParmsCreateBaselineSetDilemmaHandler();
        parms.createBaselineSetDilemmaHandler.conflictedConfigurationsDirection = "cancel";
        parms.createBaselineSetDilemmaHandler.conflictedConfigurationsInSubcomponentsDirection = "cancel";
        parms.createBaselineSetDilemmaHandler.inaccessibleConfigurationsInSubcomponentsDirection = "continue";
        parms.createBaselineSetDilemmaHandler.notFoundConfigurationsInSubcomponentsDirection = "continue";
        parms.createBaselineSetDilemmaHandler.entireHierarchyNotInSnapshotDirection = cli.hasOption((IOptionKey)OPT_ALLOW_PARTIAL_HIERARCHY) ? "continue" : "cancel";
        if (cli.hasOption((IOptionKey)OPT_FAILED_ON_OPEN_CHANGE_SETS)) {
            parms.createBaselineSetDilemmaHandler.activeChangeSetsInSubcomponentsDirection = "cancel";
            parms.createBaselineSetDilemmaHandler.activeChangeSetsInConfigurationsDirection = "cancel";
        }
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED)) {
            parms.pendingChangesDilemmaHandler.pendingChangesInstruction = "no";
            parms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "no";
        } else {
            parms.pendingChangesDilemmaHandler.pendingChangesInstruction = "cancel";
            parms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "cancel";
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        CreateBaselineSetResultDTO result = null;
        try {
            result = client.postCreateBaselineSet(parms, null);
        }
        catch (TeamRepositoryException e) {
            if (e instanceof PermissionDeniedException) {
                String message = e.getMessage();
                if (e.getData() instanceof IComponentHandle) {
                    IComponentHandle inaccessibleComponent = (IComponentHandle)e.getData();
                    message = wsFound.isStream() ? Messages.CreateSnapshotCmd_ERROR_COMPONENT_PERMISSION_STREAM : Messages.CreateSnapshotCmd_ERROR_COMPONENT_PERMISSION_REPOSITORY_WORKSPACE;
                    message = NLS.bind((String)message, (Object)inaccessibleComponent.getItemId().getUuidValue(), (Object[])new Object[0]);
                }
                throw StatusHelper.permissionFailure((String)message);
            }
            throw StatusHelper.wrap((String)Messages.CreateSnapshotCmd_CouldNotCreateSnapshotTRE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        if (result.isCancelled()) {
            List changeSets;
            ISubcommandDefinition defnTemp3;
            ISubcommandDefinition defnTemp1;
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
            int noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges());
            if ((noOfUncheckedInChanges += SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChangesInSubcomponents())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNRESOLVED_ITEMS_PRESENT, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName(), (Object[])new Object[0]));
            }
            int noOfConflicts = result.getConfigurationsWithConflicts().size();
            if (noOfConflicts > 0) {
                defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ResolveCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ConflictsCmd.class);
                defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
                throw StatusHelper.conflict((String)(String.valueOf(Messages.CreateSnapshotCmd_CouldNotCreateSnapshotConflict) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()}, (Object[])new Object[0])));
            }
            noOfConflicts = result.getConfigurationsWithConflictsInSubcomponents().size();
            if (noOfConflicts > 0) {
                defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ResolveCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ConflictsCmd.class);
                defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
                throw StatusHelper.conflict((String)(String.valueOf(Messages.CreateSnapshotCmd_CouldNotCreateSnapshotConflict_subcomponents) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()}, (Object[])new Object[0])));
            }
            List activeChangeSets = result.getActiveChangeSetsInSubcomponents();
            if (activeChangeSets.size() != 0) {
                if (!this.config.isJSONEnabled()) {
                    IndentingPrintStream err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)Messages.CreateSnapshotCmd_activeChangeSetsHeaderSubcomponents);
                    for (ProblemChangeSetsDTO changeSet : activeChangeSets) {
                        changeSets = PendingChangesUtil.getChangeSets2((String)changeSet.getRepositoryURL(), (List)changeSet.getChangeSetItemIds(), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                        IndentingPrintStream indent = err.indent();
                        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                        options.enablePrinter(4);
                        for (ChangeSetSyncDTO cs : changeSets) {
                            JSONObject csObj = new JSONObject();
                            JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)cs, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)this.config);
                            PendingChangesUtil.printChangeSetHeader((JSONObject)csObj, (String)changeSet.getRepositoryURL(), null, null, null, (IndentingPrintStream)indent);
                        }
                    }
                }
                throw StatusHelper.activeCSFailure((String)NLS.bind((String)Messages.CreateSnapshotCmd_ERROR_ACTIVE_CHANGESETS_SUBCOMPONENTS, (Object)OPT_FAILED_ON_OPEN_CHANGE_SETS.getShortOpt(), (Object[])new Object[]{OPT_FAILED_ON_OPEN_CHANGE_SETS.getName()}));
            }
            activeChangeSets = result.getActiveChangeSetsInConfigurations();
            if (activeChangeSets.size() != 0) {
                if (!this.config.isJSONEnabled()) {
                    IndentingPrintStream err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)Messages.CreateSnapshotCmd_activeChangeSetsHeader);
                    for (ProblemChangeSetsDTO changeSet : activeChangeSets) {
                        changeSets = PendingChangesUtil.getChangeSets2((String)changeSet.getRepositoryURL(), (List)changeSet.getChangeSetItemIds(), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
                        IndentingPrintStream indent = err.indent();
                        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                        options.enablePrinter(4);
                        for (ChangeSetSyncDTO cs : changeSets) {
                            JSONObject csObj = new JSONObject();
                            JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)cs, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)this.config);
                            PendingChangesUtil.printChangeSetHeader((JSONObject)csObj, (String)changeSet.getRepositoryURL(), null, null, null, (IndentingPrintStream)indent);
                        }
                    }
                }
                throw StatusHelper.activeCSFailure((String)NLS.bind((String)Messages.CreateSnapshotCmd_ERROR_ACTIVE_CHANGESETS, (Object)OPT_FAILED_ON_OPEN_CHANGE_SETS.getShortOpt(), (Object[])new Object[]{OPT_FAILED_ON_OPEN_CHANGE_SETS.getName()}));
            }
            List entireHierarchyConfigs = result.getEntireHierarchyNotIncludedInSnapshot();
            if (entireHierarchyConfigs.size() != 0) {
                if (!this.config.isJSONEnabled()) {
                    IndentingPrintStream err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)Messages.CreateBaselineCmd_ERROR_ENTIRE_HIERARCHY_COMPONENTS_HEADER);
                    ArrayList<String> compIds = new ArrayList<String>(entireHierarchyConfigs.size());
                    for (ConfigurationDescriptorDTO descriptorDTO : entireHierarchyConfigs) {
                        compIds.add(descriptorDTO.getComponentItemId());
                    }
                    List comps = RepoUtil.getComponentsByIds(compIds, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
                    for (ScmComponent2 comp : comps) {
                        err.indent().println((CharSequence)AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT));
                    }
                }
                throw StatusHelper.notEntireHierarchyInSnapshot((String)NLS.bind((String)Messages.CreateSnapshotCmd_ERROR_ENTIRE_HIERARCHY_COMPONENTS, (Object)OPT_ALLOW_PARTIAL_HIERARCHY.getShortOpt(), (Object[])new Object[]{OPT_ALLOW_PARTIAL_HIERARCHY.getName()}));
            }
        } else {
            boolean isPartialSuccess;
            BaselineSetDTO baselineSet = result.getBaselineSet();
            JSONObject snapshot = JSONPrintUtil.jsonizeResult((String)Messages.CreateSnapshotCmd_SnapshotSuccessfullyCreated, (String)baselineSet.getName(), (String)baselineSet.getItemId(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            ParmsGetBaselines parmsGetBaselines = new ParmsGetBaselines();
            parmsGetBaselines.repositoryUrl = repo.getRepositoryURI();
            parmsGetBaselines.baselineItemIds = baselineSet.getBaselineItemIds().toArray(new String[baselineSet.getBaselineItemIds().size()]);
            GetBaselinesDTO resultGetBaselines = null;
            try {
                resultGetBaselines = client.postGetBaselines(parmsGetBaselines, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.Common_BASELINES_NOT_FOUND, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
            }
            JSONArray baselines = new JSONArray();
            JSONObject baseline = new JSONObject();
            boolean printSnaphotSucessMessage = true;
            IndentingPrintStream out = this.config.getWrappedOutputStream();
            for (BaselineDTO baselineDTO : resultGetBaselines.getBaselinesInRepository()) {
                JSONPrintUtil.jsonizeResult((JSONObject)baseline, (BaselineDTO)baselineDTO, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                if (!((ScmClientConfiguration)this.config).isJSONEnabled()) {
                    this.printSuccessNonJson(snapshot, baseline, printSnaphotSucessMessage, this.config, out);
                    printSnaphotSucessMessage = false;
                }
                baselines.add((Object)baseline);
            }
            List inaccessibleCompList = null;
            List compNotFoundInWSList = null;
            boolean bl = isPartialSuccess = result.isSetNotFoundConfigurationsInSubcomponents() || result.isSetInaccessibleConfigurationsInSubcomponents();
            if (isPartialSuccess) {
                inaccessibleCompList = result.getInaccessibleConfigurationsInSubcomponents();
                compNotFoundInWSList = result.getNotFoundConfigurationsInSubcomponents();
            }
            if (((ScmClientConfiguration)this.config).isJSONEnabled()) {
                JSONObject warning;
                if (baselines.size() > 0) {
                    snapshot.put((Object)"baselines", (Object)baselines);
                }
                JSONArray status = new JSONArray();
                if (result.isSetNotFoundConfigurationsInSubcomponents()) {
                    warning = this.handleMissingCompWarning(compNotFoundInWSList, wsDetails, repo);
                    status.add((Object)warning);
                }
                if (result.isSetInaccessibleConfigurationsInSubcomponents()) {
                    warning = this.populateWarningInJsonObject(64, Messages.CreateBaselineCmd_ERROR_COMPONENTS_PERMISSION_JSON, Constants.Severity.warning.toString(), wsDetails, null, inaccessibleCompList);
                    status.add((Object)warning);
                }
                snapshot.put((Object)"status", (Object)status);
                PendingChangesUtil.printSuccess((JSONObject)snapshot, (IScmClientConfiguration)this.config, (IndentingPrintStream)this.config.getWrappedOutputStream());
            } else {
                IndentingPrintStream err;
                if (result.isSetNotFoundConfigurationsInSubcomponents()) {
                    err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS, (Object)wsDetails.getName(), (Object[])new Object[0]));
                    this.handleMissingCompWarning(compNotFoundInWSList, wsDetails, repo);
                }
                if (result.isSetInaccessibleConfigurationsInSubcomponents()) {
                    err = this.config.getWrappedErrorStream();
                    err.println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_COMPONENTS_PERMISSION, (Object)wsDetails.getName(), (Object[])new Object[0]));
                    for (ConfigurationDescriptorDTO comp : inaccessibleCompList) {
                        err.indent().println((CharSequence)comp.getComponentItemId());
                    }
                }
            }
            if (isPartialSuccess) {
                throw StatusHelper.partialStatus();
            }
        }
    }

    private JSONObject handleMissingCompWarning(List<ConfigurationDescriptorDTO> compNotFoundInWSList, WorkspaceDetailsDTO wsDetails, ITeamRepository repo) throws FileSystemException {
        ArrayList<String> compIds = new ArrayList<String>(compNotFoundInWSList.size());
        boolean fetchComponentFailed = false;
        for (ConfigurationDescriptorDTO comp : compNotFoundInWSList) {
            compIds.add(comp.getComponentItemId());
        }
        List missingComps = null;
        try {
            missingComps = RepoUtil.getComponentsByIds(compIds, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        }
        catch (TeamRepositoryException e) {
            fetchComponentFailed = true;
        }
        if (this.config.isJSONEnabled()) {
            if (fetchComponentFailed) {
                return this.populateWarningInJsonObject(25, Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS_JSON, Constants.Severity.warning.toString(), wsDetails, null, compNotFoundInWSList);
            }
            return this.populateWarningInJsonObject(25, Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS_JSON, Constants.Severity.warning.toString(), wsDetails, missingComps, null);
        }
        if (fetchComponentFailed) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            for (ConfigurationDescriptorDTO comp : compNotFoundInWSList) {
                err.indent().println((CharSequence)comp.getComponentItemId());
            }
        } else {
            for (ScmComponent2 comp : missingComps) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                String detailedComp = AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                err.indent().println((CharSequence)detailedComp);
            }
        }
        return null;
    }

    private JSONObject populateWarningInJsonObject(int code, String message, String severity, WorkspaceDetailsDTO wsDetails, List<ScmComponent2> missingCompList, List<ConfigurationDescriptorDTO> inaccessibleCompList) {
        JSONObject warning = new JSONObject();
        warning.put((Object)"code", (Object)code);
        warning.put((Object)"message", (Object)message);
        warning.put((Object)"severity", (Object)severity);
        JSONObject details = new JSONObject();
        JSONArray invalidComps = new JSONArray();
        if (missingCompList != null) {
            for (ScmComponent2 comp : missingCompList) {
                JSONObject compDetails = new JSONObject();
                compDetails.put((Object)"component_name", (Object)comp.getName());
                compDetails.put((Object)"component_uuid", (Object)comp.getItemId());
                invalidComps.add((Object)compDetails);
            }
        } else if (inaccessibleCompList != null) {
            for (ConfigurationDescriptorDTO comp : inaccessibleCompList) {
                invalidComps.add((Object)comp.getComponentItemId());
            }
        }
        details.put((Object)"invalid-components", (Object)invalidComps);
        warning.put((Object)"details", (Object)details);
        return warning;
    }

    private void printSuccessNonJson(JSONObject snapshot, JSONObject baseline, boolean printSnaphotSucessMessage, IScmClientConfiguration config, IndentingPrintStream out) {
        if (printSnaphotSucessMessage) {
            PendingChangesUtil.printSuccess((JSONObject)snapshot, (IScmClientConfiguration)config, (IndentingPrintStream)out);
        }
        out.indent().println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_INCLUDED_COMPONENTS, (Object)AliasUtil.selector((String)((String)baseline.get((Object)"component")), (UUID)UUID.valueOf((String)((String)baseline.get((Object)"component_uuid"))), (String)((String)baseline.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT), (Object[])new Object[0]));
        out.indent().indent().println((CharSequence)NLS.bind((String)Messages.CreateSnapshotCmd_BaselineSuccessfullyIncluded, (Object)AliasUtil.selector((String)((String)baseline.get((Object)"name")), (UUID)UUID.valueOf((String)((String)baseline.get((Object)"uuid"))), (String)((String)baseline.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE), (Object[])new Object[0]));
    }
}

