/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadRuleSerializationInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxLoadRules;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.load.SandboxLoadRulesResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateLoadRulesCmd
extends AbstractSubcommand
implements IOptionSource {
    static final IPositionalOptionDefinition OPT_RESULTFOLDER_PATH = new PositionalOptionDefinition("rulesfolder-path", 1, 1);
    static final NamedOptionDefinition OPT_WORKSPACE_NAME = new NamedOptionDefinition("w", "workspace", 1);
    static final NamedOptionDefinition OPT_COMPONENT_NAME = new NamedOptionDefinition("C", "component", 1);
    static final NamedOptionDefinition OPT_COMMENTS = new NamedOptionDefinition("c", "comment", 1);
    static final NamedOptionDefinition OPT_FILENAME = new NamedOptionDefinition("f", "filename", 1);
    static final NamedOptionDefinition OPT_USE_COMPONENT_NAME = new NamedOptionDefinition(null, "use-component-name", 0);
    static final NamedOptionDefinition OPT_USE_REPOSITORY_PATH = new NamedOptionDefinition(null, "use-repository-path", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((IOptionKey)CommonOptions.OPT_DIRECTORY, "d", "directory", Messages.CreateLoadRulesCmdOptions_SANDBOX_PATH, 1).addOption((INamedOptionDefinition)OPT_WORKSPACE_NAME, Messages.CreateLoadRulesCmdOptions_WS).addOption((INamedOptionDefinition)OPT_COMPONENT_NAME, Messages.CreateLoadRulesCmdOptions_COMP).addOption((INamedOptionDefinition)OPT_COMMENTS, Messages.CreateLoadRulesCmdOptions_COMMENTS).addOption((INamedOptionDefinition)OPT_FILENAME, Messages.CreateLoadRulesCmdOptions_PREF_FILENAME).addOption((INamedOptionDefinition)OPT_USE_COMPONENT_NAME, Messages.CreateLoadRulesCmdOptions_USE_COMPONENT_NAME).addOption((INamedOptionDefinition)OPT_USE_REPOSITORY_PATH, Messages.CreateLoadRulesCmdOptions_USE_REPOSITORY_PATH).addOption(OPT_RESULTFOLDER_PATH, Messages.CreateLoadRulesCmdOptions_RESULT_PATH);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        File resultFolderPath = SubcommandUtil.canonicalize((File)new File(cli.getOption(OPT_RESULTFOLDER_PATH.getId())));
        if (resultFolderPath.exists() && !resultFolderPath.isDirectory()) {
            throw StatusHelper.argSyntax((String)Messages.CreateLoadRulesCmd_INVALID_RESUTLFOLDER_PATH);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsWorkspace ws = null;
        if (cli.hasOption((IOptionKey)OPT_WORKSPACE_NAME)) {
            ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_WORKSPACE_NAME, null), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
            ITeamRepository repo = null;
            if (wsSelector.getRepositorySelector() != null) {
                repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(wsSelector.getRepositorySelector()));
            }
            ws = RepoUtil.findWorkspaceInSandbox((String)wsSelector.getItemSelector(), (UUID)(repo != null ? repo.getId() : null), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        ShareDTO compShare = null;
        if (cli.hasOption((IOptionKey)OPT_COMPONENT_NAME)) {
            ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT_NAME, null), (IScmClientConfiguration)this.config);
            String wsId = ws != null ? ws.workspaceItemId : null;
            List shareList = RepoUtil.getSharesInSandbox((String)wsId, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector.getItemSelector());
            HashMap<String, ShareDTO> compToShare = new HashMap<String, ShareDTO>();
            for (ShareDTO share : shareList) {
                if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(share.getComponentItemId())) && !compSelector.getItemSelector().equals(share.getComponentName()) || compToShare.keySet().contains(share.getComponentItemId())) continue;
                compToShare.put(share.getComponentItemId(), share);
            }
            if (compToShare.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compSelector.getItemSelector()));
            }
            if (compToShare.size() > 1) {
                ArrayList<SubcommandUtil.ItemInfo> compsMatched = new ArrayList<SubcommandUtil.ItemInfo>(compToShare.size());
                for (ShareDTO comp : compToShare.values()) {
                    compsMatched.add(new SubcommandUtil.ItemInfo(comp.getComponentName(), comp.getComponentItemId(), RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ShareDTO)comp), RepoUtil.ItemType.COMPONENT));
                }
                SubcommandUtil.displayAmbiguousSelectorException((String)compSelector.getItemSelector(), compsMatched, (IScmClientConfiguration)this.config);
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.Common_AMBIGUOUS_COMPONENT, (Object)compSelector.getItemSelector()));
            }
            compShare = (ShareDTO)compToShare.values().iterator().next();
            ws = new ParmsWorkspace(RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ShareDTO)compShare), compShare.getContextItemId());
        }
        if (ws != null) {
            RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(ws.repositoryUrl));
        } else {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_NOT_A_SANDBOX, (Object)this.config.getContext().getCurrentWorkingDirectory()));
            }
            ArrayList<String> repoIds = new ArrayList<String>();
            for (ISandboxWorkspace wsFound : wsInSandboxList) {
                if (repoIds.contains(wsFound.getRepositoryId())) continue;
                String repoUri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsFound.getRepositoryId(), Collections.singletonList(wsFound));
                RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
                repoIds.add(wsFound.getRepositoryId());
            }
        }
        ParmsSandboxLoadRules parms = new ParmsSandboxLoadRules();
        parms.sandboxPath = this.config.getCurrentWorkingDirectory().getAbsolutePath();
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.serializationInstructions = new ParmsLoadRuleSerializationInstructions();
        parms.serializationInstructions.resultFolder = resultFolderPath.getAbsolutePath();
        if (cli.hasOption((IOptionKey)OPT_FILENAME)) {
            parms.serializationInstructions.preferredFileName = cli.getOption((IOptionKey)OPT_FILENAME);
        } else {
            PathLocation sandboxLoc = new PathLocation(parms.sandboxPath);
            if (sandboxLoc.getName().length() == 0) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateLoadRulesCmd_SPECIFY_FILENAME, (Object)cli.getDefinition().getOption((IOptionKey)OPT_FILENAME).getName()));
            }
            parms.serializationInstructions.preferredFileName = sandboxLoc.getName();
        }
        if (cli.hasOption((IOptionKey)OPT_COMMENTS)) {
            parms.serializationInstructions.comments = new String[1];
            parms.serializationInstructions.comments[0] = cli.getOption((IOptionKey)OPT_COMMENTS);
        }
        parms.serializationInstructions.useComponentName = cli.hasOption((IOptionKey)OPT_USE_COMPONENT_NAME);
        parms.serializationInstructions.useRepositoryPath = cli.hasOption((IOptionKey)OPT_USE_REPOSITORY_PATH);
        if (ws != null) {
            parms.workspace = ws;
        }
        if (compShare != null) {
            parms.componentItemId = compShare.getComponentItemId();
        }
        SandboxLoadRulesResultDTO result = null;
        try {
            result = client.getSandboxLoadRules(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateLoadRulesCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), null);
        }
        if (result.isCancelled() && result.getOutOfSyncShares().size() > 0) {
            AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
        }
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
            SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
        }
        out.println((CharSequence)Messages.CreateLoadRulesCmd_SUCCESS);
    }
}

