/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsComponentChange;
import com.ibm.team.filesystem.client.rest.parameters.ParmsConfigurationChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPutWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.PutWorkspaceResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.OptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IWorkspace;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateComponentCommand
extends AbstractSubcommand
implements IOptionSource {
    public static final IOptionKey OPT_NAME = new OptionKey("name");

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(OPT_NAME, "name", 1, 1), Messages.CreateComponentCommand_NameForTheComponent).addOption((IPositionalOptionDefinition)new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@"), Messages.CreateComponentCommand_WorkspaceToAddComponent);
        return options;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace ws = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        String name = cli.getOption(OPT_NAME).trim();
        UUID componentItemId = null;
        try {
            ParmsPutWorkspace parms = new ParmsPutWorkspace();
            parms.workspace = new ParmsWorkspace();
            parms.workspace.repositoryUrl = repo.getRepositoryURI();
            parms.workspace.workspaceItemId = ws.getItemId().getUuidValue();
            parms.configurationChanges = new ParmsConfigurationChanges();
            parms.configurationChanges.components = new ParmsComponentChange[]{new ParmsComponentChange()};
            parms.configurationChanges.components[0].cmd = "addComponent";
            parms.configurationChanges.components[0].name = name;
            PutWorkspaceResultDTO result = client.postPutWorkspace(parms, null);
            if (!result.isSetComponentsAdded()) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), null);
            }
            List componentsAdded = result.getComponentsAdded();
            if (componentsAdded.size() != 1) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), null);
            }
            ConfigurationDescriptorDTO componentDTO = (ConfigurationDescriptorDTO)componentsAdded.get(0);
            componentItemId = UUID.valueOf((String)componentDTO.getComponentItemId());
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)NLS.bind((String)Messages.CreateComponentCommand_CouldNotCreateComponent, (Object)name), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        JSONObject comp = JSONPrintUtil.jsonizeResult((String)Messages.CreateComponentCommand_ComponentSuccessfullyCreated, (String)name, (String)componentItemId.getUuidValue(), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        PendingChangesUtil.printSuccess((JSONObject)comp, (IScmClientConfiguration)this.config, (IndentingPrintStream)this.config.getWrappedOutputStream());
    }
}

