/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CreateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CreateChangeSetCmd
extends AbstractSubcommand
implements IOptionSource {
    static final NamedOptionDefinition OPT_COMPONENT_NAME = new NamedOptionDefinition(null, "component", 1, "@");
    static final NamedOptionDefinition OPT_NO_CURRENT = new NamedOptionDefinition("n", "no-current", 0);
    static final PositionalOptionDefinition OPT_COMMENT = new PositionalOptionDefinition("comment", 0, 1);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)opts);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption((INamedOptionDefinition)OPT_NO_CURRENT, Messages.CreateChangeSetCmd_11).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.CreateChangeSetCmd_0).addOption((INamedOptionDefinition)OPT_COMPONENT_NAME, Messages.CreateChangeSetCmd_1).addOption((IPositionalOptionDefinition)OPT_COMMENT, Messages.CreateChangeSetCmd_10);
        return opts;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument compSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_COMPONENT_NAME, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)compSelector, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsWorkspace ws = null;
        ITeamRepository repo = null;
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            if (compSelector != null) {
                RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(compSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            }
        } else if (compSelector != null) {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)compSelector);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        } else {
            ws = RepoUtil.findWorkspaceInSandbox(null, null, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(ws.repositoryUrl));
        }
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        WorkspaceComponentDTO component = this.findComponent(wsDetails, (IScmCommandLineArgument)compSelector, client, this.config);
        ParmsCreateChangeSet parms = new ParmsCreateChangeSet();
        parms.workspace = ws;
        parms.componentItemId = component.getItemId();
        parms.comment = cli.getOption((IOptionKey)OPT_COMMENT, "");
        parms.current = !cli.hasOption((IOptionKey)OPT_NO_CURRENT);
        CreateResultDTO result = null;
        try {
            result = client.postCreateChangeSet(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.CreateChangeSetCmd_8, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        JSONObject jObj = JSONPrintUtil.jsonizeResult((String)Messages.CreateChangeSetCmd_9, (String)result.getChangeSetItemId(), (String)ws.repositoryUrl, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        PendingChangesUtil.printSuccess((JSONObject)jObj, (IScmClientConfiguration)this.config, (IndentingPrintStream)this.config.getWrappedOutputStream());
    }

    private WorkspaceComponentDTO findComponent(WorkspaceDetailsDTO wsDetails, IScmCommandLineArgument compSelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        WorkspaceComponentDTO component = null;
        String compToFind = null;
        if (compSelector == null) {
            if (wsDetails.getComponents().size() == 1) {
                compToFind = ((WorkspaceComponentDTO)wsDetails.getComponents().get(0)).getItemId();
            } else {
                List shareList = RepoUtil.getSharesInSandbox((String)wsDetails.getItemId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                if (shareList.size() != 1) {
                    throw StatusHelper.ambiguousSelector((String)Messages.CreateChangeSetCmd_3);
                }
                compToFind = ((ShareDTO)shareList.get(0)).getComponentItemId();
            }
        } else {
            compToFind = compSelector.getItemSelector();
        }
        IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compToFind);
        for (WorkspaceComponentDTO comp : wsDetails.getComponents()) {
            if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(comp.getItemId())) && !compToFind.equals(comp.getName())) continue;
            component = comp;
            break;
        }
        if (component == null) {
            if (compSelector == null) {
                throw StatusHelper.ambiguousSelector((String)Messages.CreateChangeSetCmd_3);
            }
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.Common_COMP_NOT_FOUND, (Object)compToFind));
        }
        return component;
    }
}

