/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.createcommand;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmd;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselineRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateBaselines;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.ProblemChangeSetsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceComponentDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.WorkspaceDetailsDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.workspace.CreateBaselineResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmComponent2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;

public class CreateBaselineCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_BASELINE_DESCRIPTION = new NamedOptionDefinition(null, "description", 1);
    public static final PositionalOptionDefinition OPT_WORKSPACE_NAME = new PositionalOptionDefinition(CommonOptions.OPT_WORKSPACE, "workspace", 1, 1, "@");
    public static final PositionalOptionDefinition OPT_BASELINE_NAME = new PositionalOptionDefinition("baseline-name", 1, 1);
    public static final NamedOptionDefinition OPT_COMPLETE = new NamedOptionDefinition(null, "complete", 0);

    public void run() throws FileSystemException {
        boolean isPartialSuccess;
        ICommandLine subargs = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subargs.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        boolean allComponents = subargs.hasOption((IOptionKey)CommonOptions.OPT_ALL);
        if (allComponents && subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateBaselineCmd_5, (Object)CommonOptions.OPT_ALL.getName()));
        }
        List components = null;
        if (!allComponents) {
            if (!subargs.hasOption((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR)) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CreateBaselineCmd_6, (Object)CommonOptions.OPT_ALL.getName()));
            }
            List compSelectors = ScmCommandLineArgument.createList((List)subargs.getOptionValues((IOptionKey)CommonOptions.OPT_COMPONENTS_SELECTOR), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)compSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
            components = RepoUtil.getSelectors((List)compSelectors);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)subargs.getOptionValue(CommonOptions.OPT_WORKSPACE), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
        ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
        IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ParmsWorkspace ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        WorkspaceDetailsDTO wsDetails = (WorkspaceDetailsDTO)RepoUtil.getWorkspaceDetails(Collections.singletonList(ws), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config).get(0);
        ArrayList<WorkspaceComponentDTO> baselineComponents = new ArrayList<WorkspaceComponentDTO>();
        block0: for (WorkspaceComponentDTO compDTO : wsDetails.getComponents()) {
            if (components != null) {
                Iterator iterator = components.iterator();
                while (iterator.hasNext()) {
                    String compSelector = (String)iterator.next();
                    IUuidAliasRegistry.IUuidAlias compAlias = RepoUtil.lookupUuidAndAlias((String)compSelector);
                    if ((compAlias == null || !compAlias.getUuid().getUuidValue().equals(compDTO.getItemId())) && !compSelector.equals(compDTO.getName())) continue;
                    baselineComponents.add(compDTO);
                    iterator.remove();
                    continue block0;
                }
                continue;
            }
            baselineComponents.add(compDTO);
        }
        if (components != null && components.size() > 0) {
            String compList = components.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
            if (wsFound.isStream()) {
                throw StatusHelper.createException((String)NLS.bind((String)Messages.CreateBaselineCmd_ComponentNotFound, (Object)compList, (Object)NLS.bind((String)Messages.CreateBaselineCmd_Stream_Nametag, (Object)wsFound.getName())), (int)30, null);
            }
            throw StatusHelper.createException((String)NLS.bind((String)Messages.CreateBaselineCmd_ComponentNotFound, (Object)compList, (Object)NLS.bind((String)Messages.CreateBaselineCmd_Workspace_Nametag, (Object)wsFound.getName())), (int)30, null);
        }
        if (allComponents && baselineComponents.isEmpty()) {
            if (wsFound.isStream()) {
                throw StatusHelper.createException((String)NLS.bind((String)Messages.CreateBaselineCmd_NoComponent, (Object)NLS.bind((String)Messages.CreateBaselineCmd_Stream_Nametag, (Object)wsFound.getName())), (int)30, null);
            }
            throw StatusHelper.createException((String)NLS.bind((String)Messages.CreateBaselineCmd_NoComponent, (Object)NLS.bind((String)Messages.CreateBaselineCmd_Workspace_Nametag, (Object)wsFound.getName())), (int)30, null);
        }
        ArrayList<BaselineDTO> baselineDTOs = new ArrayList<BaselineDTO>();
        CreateBaselineResultDTO result = this.createBaselines(baselineDTOs, ws, baselineComponents, wsFound.isStream(), client, this.config);
        List inaccessibleCompList = null;
        List compNotFoundInWSList = null;
        boolean bl = isPartialSuccess = result.isSetNotFoundConfigurationsInSubcomponents() || result.isSetInaccessibleConfigurationsInSubcomponents();
        if (isPartialSuccess) {
            inaccessibleCompList = result.getInaccessibleConfigurationsInSubcomponents();
            compNotFoundInWSList = result.getNotFoundConfigurationsInSubcomponents();
        }
        if (this.config.isJSONEnabled()) {
            JSONObject warning;
            JSONObject root = JSONPrintUtil.jsonizeBaselines(baselineDTOs, (PendingChangesUtil.PendingChangesOptions)new PendingChangesUtil.PendingChangesOptions(), baselineComponents);
            JSONArray status = new JSONArray();
            if (result.isSetNotFoundConfigurationsInSubcomponents()) {
                warning = this.handleMissingCompWarning(compNotFoundInWSList, wsDetails, repo);
                status.add((Object)warning);
            }
            if (result.isSetInaccessibleConfigurationsInSubcomponents()) {
                warning = this.populateWarningInJsonObject(64, Messages.CreateBaselineCmd_ERROR_COMPONENTS_PERMISSION_JSON, Constants.Severity.warning.toString(), wsDetails, null, inaccessibleCompList);
                status.add((Object)warning);
            }
            root.put((Object)"status", (Object)status);
            this.config.getOutputStream().print((CharSequence)root.toString());
        } else {
            IndentingPrintStream err;
            for (BaselineDTO baseline : baselineDTOs) {
                JSONObject baselineSuccess = JSONPrintUtil.jsonizeBaselineResult((String)Messages.CreateBaseLineCmd_Success_RETURN_UUID, (BaselineDTO)baseline, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
                CreateBaselineCmd.printSuccess(baselineSuccess, this.config, baseline.getRepositoryURL());
            }
            if (result.isSetNotFoundConfigurationsInSubcomponents()) {
                err = this.config.getWrappedErrorStream();
                err.println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS, (Object)wsDetails.getName()));
                this.handleMissingCompWarning(compNotFoundInWSList, wsDetails, repo);
            }
            if (result.isSetInaccessibleConfigurationsInSubcomponents()) {
                err = this.config.getWrappedErrorStream();
                err.println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_COMPONENTS_PERMISSION, (Object)wsDetails.getName()));
                for (ConfigurationDescriptorDTO comp : inaccessibleCompList) {
                    err.indent().println((CharSequence)comp.getComponentItemId());
                }
            }
        }
        if (isPartialSuccess) {
            throw StatusHelper.partialStatus();
        }
    }

    private JSONObject handleMissingCompWarning(List<ConfigurationDescriptorDTO> compNotFoundInWSList, WorkspaceDetailsDTO wsDetails, ITeamRepository repo) throws FileSystemException {
        ArrayList<String> compIds = new ArrayList<String>(compNotFoundInWSList.size());
        boolean fetchComponentFailed = false;
        for (ConfigurationDescriptorDTO comp : compNotFoundInWSList) {
            compIds.add(comp.getComponentItemId());
        }
        List missingComps = null;
        try {
            missingComps = RepoUtil.getComponentsByIds(compIds, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        }
        catch (TeamRepositoryException e) {
            fetchComponentFailed = true;
        }
        if (this.config.isJSONEnabled()) {
            if (fetchComponentFailed) {
                return this.populateWarningInJsonObject(25, Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS_JSON, Constants.Severity.warning.toString(), wsDetails, null, compNotFoundInWSList);
            }
            return this.populateWarningInJsonObject(25, Messages.CreateBaselineCmd_ERROR_COMPONENTS_NOT_IN_WS_JSON, Constants.Severity.warning.toString(), wsDetails, missingComps, null);
        }
        if (fetchComponentFailed) {
            IndentingPrintStream err = this.config.getWrappedErrorStream();
            for (ConfigurationDescriptorDTO comp : compNotFoundInWSList) {
                err.indent().println((CharSequence)comp.getComponentItemId());
            }
        } else {
            for (ScmComponent2 comp : missingComps) {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                String detailedComp = AliasUtil.selector((String)comp.getName(), (UUID)UUID.valueOf((String)comp.getItemId()), (String)repo.getRepositoryURI(), (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT);
                err.indent().println((CharSequence)detailedComp);
            }
        }
        return null;
    }

    private JSONObject populateWarningInJsonObject(int code, String message, String severity, WorkspaceDetailsDTO wsDetails, List<ScmComponent2> missingCompList, List<ConfigurationDescriptorDTO> inaccessibleCompList) {
        JSONObject warning = new JSONObject();
        warning.put((Object)"code", (Object)code);
        warning.put((Object)"message", (Object)message);
        warning.put((Object)"severity", (Object)severity);
        JSONObject details = new JSONObject();
        JSONObject workspace = new JSONObject();
        workspace.put((Object)"name", (Object)wsDetails.getName());
        workspace.put((Object)"uuid", (Object)wsDetails.getItemId());
        workspace.put((Object)"repository", (Object)wsDetails.getRepositoryURL());
        details.put((Object)"workspace", (Object)workspace);
        JSONArray invalidComps = new JSONArray();
        if (missingCompList != null) {
            for (ScmComponent2 comp : missingCompList) {
                JSONObject compDetails = new JSONObject();
                compDetails.put((Object)"component_name", (Object)comp.getName());
                compDetails.put((Object)"component_uuid", (Object)comp.getItemId());
                invalidComps.add((Object)compDetails);
            }
        } else if (inaccessibleCompList != null) {
            for (ConfigurationDescriptorDTO comp : inaccessibleCompList) {
                invalidComps.add((Object)comp.getComponentItemId());
            }
        }
        details.put((Object)"invalid-components", (Object)invalidComps);
        warning.put((Object)"details", (Object)details);
        return warning;
    }

    private static void printSuccess(JSONObject jObj, IScmClientConfiguration config, String url) {
        IndentingPrintStream out = config.getWrappedOutputStream();
        JSONObject comp = (JSONObject)jObj.get((Object)"component_details");
        out.println((CharSequence)NLS.bind((String)Messages.CreateBaselineCmd_INCLUDED_COMPONENTS, (Object)AliasUtil.selector((String)((String)comp.get((Object)"component_name")), (UUID)UUID.valueOf((String)((String)comp.get((Object)"component_uuid"))), (String)url, (RepoUtil.ItemType)RepoUtil.ItemType.COMPONENT)));
        JSONArray mesgs = (JSONArray)jObj.get((Object)"messages");
        if (mesgs == null) {
            return;
        }
        for (Object obj : mesgs) {
            String mesg = (String)obj;
            out.indent().println((CharSequence)mesg);
        }
    }

    private CreateBaselineResultDTO createBaselines(List<BaselineDTO> baselineDTO, ParmsWorkspace ws, List<WorkspaceComponentDTO> baselineComponents, boolean isStream, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine subargs = config.getSubcommandCommandLine();
        String baselineDescription = null;
        String baselineName = subargs.getOption((IOptionKey)OPT_BASELINE_NAME);
        if (subargs.hasOption((IOptionKey)OPT_BASELINE_DESCRIPTION)) {
            baselineDescription = subargs.getOption((IOptionKey)OPT_BASELINE_DESCRIPTION);
        }
        ParmsCreateBaselines parms = new ParmsCreateBaselines();
        parms.requests = new ParmsCreateBaselineRequest[baselineComponents.size()];
        int count = 0;
        for (WorkspaceComponentDTO baselineComponent : baselineComponents) {
            ParmsCreateBaselineRequest parmsBaselineRequest = new ParmsCreateBaselineRequest();
            parmsBaselineRequest.workspace = ws;
            parmsBaselineRequest.componentItemId = baselineComponent.getItemId();
            parmsBaselineRequest.name = baselineName;
            parmsBaselineRequest.comment = baselineDescription;
            parms.requests[count++] = parmsBaselineRequest;
        }
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.createBaselineDilemmaHandler = new ParmsCreateBaselineDilemmaHandler();
        parms.createBaselineDilemmaHandler.conflictedConfigurationsDirection = "cancel";
        parms.createBaselineDilemmaHandler.conflictedConfigurationsInSubcomponentsDirection = "cancel";
        parms.createBaselineDilemmaHandler.inaccessibleConfigurationsInSubcomponentsDirection = "continue";
        parms.createBaselineDilemmaHandler.notFoundConfigurationsInSubcomponentsDirection = "continue";
        parms.createBaselineDilemmaHandler.activeChangeSetsInSubcomponentsDirection = subargs.hasOption((IOptionKey)OPT_COMPLETE) ? "continue" : "cancel";
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        if (subargs.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED)) {
            parms.pendingChangesDilemmaHandler.pendingChangesInstruction = "no";
            parms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "no";
        } else {
            parms.pendingChangesDilemmaHandler.pendingChangesInstruction = "cancel";
            parms.pendingChangesDilemmaHandler.pendingChangesInSubcomponentsInstruction = "cancel";
        }
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        CreateBaselineResultDTO result = null;
        try {
            result = client.postCreateBaselines(parms, null);
        }
        catch (TeamRepositoryException e) {
            if (e instanceof PermissionDeniedException) {
                String message = e.getMessage();
                if (e.getData() instanceof IComponentHandle) {
                    IComponentHandle inaccessibleComponent = (IComponentHandle)e.getData();
                    message = isStream ? Messages.CreateBaselineCmd_ERROR_COMPONENT_PERMISSION_STREAM : Messages.CreateBaselineCmd_ERROR_COMPONENT_PERMISSION_REPOSITORY_WORKSPACE;
                    message = NLS.bind((String)message, (Object)inaccessibleComponent.getItemId().getUuidValue());
                }
                throw StatusHelper.permissionFailure((String)message);
            }
            throw StatusHelper.wrap((String)Messages.CreateBaselineCmd_14, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)ws.repositoryUrl);
        }
        if (result.isCancelled()) {
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
            }
            int noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges());
            if ((noOfUncheckedInChanges += SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChangesInSubcomponents())) > 0) {
                throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
            }
            int noOfConflicts = result.getConfigurationsWithConflicts().size();
            if (noOfConflicts > 0) {
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ResolveCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ConflictsCmd.class);
                ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, StatusCmd.class);
                throw StatusHelper.conflict((String)(String.valueOf(Messages.CreateBaselineCmd_ERROR_UNRESOLVED_REMOTE_CONFLICTS) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()})));
            }
            noOfConflicts = result.getConfigurationsWithConflictsInSubcomponents().size();
            if (noOfConflicts > 0) {
                ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ResolveCmd.class);
                ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, ConflictsCmd.class);
                ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, StatusCmd.class);
                throw StatusHelper.conflict((String)(String.valueOf(Messages.CreateBaselineCmd_ERROR_UNRESOLVED_REMOTE_CONFLICTS_SUBCOMPONENTS) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()})));
            }
            List activeChangeSets = result.getActiveChangeSetsInSubcomponents();
            if (activeChangeSets.size() != 0 && !config.isJSONEnabled()) {
                IndentingPrintStream err = config.getWrappedErrorStream();
                err.println((CharSequence)Messages.CreateBaselineCmd_activeChangeSetsHeader);
                for (ProblemChangeSetsDTO changeSet : activeChangeSets) {
                    List changeSets = PendingChangesUtil.getChangeSets2((String)changeSet.getRepositoryURL(), (List)changeSet.getChangeSetItemIds(), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    IndentingPrintStream indent = err.indent();
                    PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
                    options.enablePrinter(4);
                    for (ChangeSetSyncDTO cs : changeSets) {
                        JSONObject csObj = new JSONObject();
                        JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)cs, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
                        PendingChangesUtil.printChangeSetHeader((JSONObject)csObj, (String)changeSet.getRepositoryURL(), null, null, null, (IndentingPrintStream)indent);
                    }
                }
                throw StatusHelper.activeCSFailure((String)NLS.bind((String)Messages.CreateBaselineCmd_ERROR_ACTIVE_CHANGESETS, (Object)OPT_COMPLETE.getName()));
            }
        }
        baselineDTO.addAll(result.getBaselines());
        return result;
    }

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        options.setLongHelp(Messages.CreateBaselineCmd_15);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)OPT_BASELINE_DESCRIPTION, Messages.CreateBaselineCmd_16).addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP, false).addOption((INamedOptionDefinition)CommonOptions.OPT_OVERWRITE_UNCOMMITTED, Messages.CreateBaselineCmd_HELP_IGNORE_UNCOMMITTED_LOCAL_CHANGES).addOption((INamedOptionDefinition)CommonOptions.OPT_NO_LOCAL_REFRESH, Messages.Common_DO_NOT_SCAN_FS).addOption((INamedOptionDefinition)OPT_COMPLETE, Messages.CreateBaselineCmd_COMPLETE_HELP, false).addOption((IPositionalOptionDefinition)OPT_WORKSPACE_NAME, Messages.CreateBaselineCmd_17).addOption((IPositionalOptionDefinition)OPT_BASELINE_NAME, Messages.CreateBaselineCmd_18).addOption((IOptionGroup)new MutuallyExclusiveGroup(true).addOption((INamedOptionDefinition)CommonOptions.OPT_ALL, CommonOptions.OPT_ALL_HELP, true).addOption((IPositionalOptionDefinition)CommonOptions.OPT_COMPONENTS_SELECTOR, Messages.Common_SELECT_COMPONENTS_HELP));
        return options;
    }
}

