/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSuspendChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.SuspendResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.DiscardNotInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class SuspendCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ArrayList<IScmCommandLineArgument> csSelectors = new ArrayList<IScmCommandLineArgument>(cli.getOptionValues((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS).size());
        for (ICommandLineArgument csArg : cli.getOptionValues((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            csSelectors.add((IScmCommandLineArgument)ScmCommandLineArgument.create((ICommandLineArgument)csArg, (IScmClientConfiguration)this.config));
        }
        SubcommandUtil.validateArgument(csSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        Map<ParmsWorkspace, ChangeSetSyncDTO[]> wsToCsMap = this.findSuspendChangesets(csSelectors, client, (IScmCommandLineArgument)wsSelector, this.config, out);
        this.suspendChangesets(wsToCsMap, client, this.config, out);
        if (!this.config.isJSONEnabled()) {
            out.println((CharSequence)Messages.SuspendCmd_CHANGESETS_SUCCESSFULLY_SUSPENDED);
        }
    }

    private Map<ParmsWorkspace, ChangeSetSyncDTO[]> findSuspendChangesets(List<IScmCommandLineArgument> csSelectors, IFilesystemRestClient client, IScmCommandLineArgument wsSelector, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        ChangeSetSyncDTO[] changeSetsToSuspend;
        HashMap<ParmsWorkspace, ChangeSetSyncDTO[]> wsToCsMap = new HashMap<ParmsWorkspace, ChangeSetSyncDTO[]>();
        ArrayList<String> csSelectorList = new ArrayList<String>();
        ParmsWorkspace ws = null;
        ITeamRepository repo = null;
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, null);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)ws, (String)Messages.SuspendCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)config);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, csSelectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
        ArrayList<IScmCommandLineArgument> notFound = new ArrayList<IScmCommandLineArgument>();
        for (IScmCommandLineArgument csSelector : csSelectors) {
            IUuidAliasRegistry.IUuidAlias csUuidAlias = RepoUtil.lookupUuidAndAlias((String)csSelector.getItemSelector());
            if (csUuidAlias == null) {
                notFound.add(csSelector);
                continue;
            }
            csSelectorList.add(csSelector.getItemSelector());
        }
        if (notFound.size() > 0) {
            this.printError(notFound, config.getWrappedErrorStream());
        }
        if ((changeSetsToSuspend = RepoUtil.findChangeSets(csSelectorList, (boolean)false, (String)ws.workspaceItemId, (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config)).length == 0) {
            this.printError(csSelectors, config.getWrappedErrorStream());
        }
        wsToCsMap.put(ws, changeSetsToSuspend);
        return wsToCsMap;
    }

    private void printError(List<IScmCommandLineArgument> csSelectors, IndentingPrintStream out) throws FileSystemException {
        if (csSelectors.size() == 1) {
            out.println((CharSequence)Messages.Common_CS_NOT_FOUND_HEADER_SINGLE);
            out.indent().println((CharSequence)csSelectors.get(0).getItemSelector());
            out.println((CharSequence)Messages.SuspendCmd_HINT_SINGLE);
            throw StatusHelper.itemNotFound((String)Messages.Common_CS_NOT_FOUND_SINGLE);
        }
        out.println((CharSequence)Messages.Common_CS_NOT_FOUND_HEADER);
        for (IScmCommandLineArgument csSelector : csSelectors) {
            out.indent().println((CharSequence)csSelector.getItemSelector());
        }
        out.println((CharSequence)Messages.SuspendCmd_HINT);
        throw StatusHelper.itemNotFound((String)Messages.Common_CS_NOT_FOUND);
    }

    private void suspendChangesets(Map<ParmsWorkspace, ChangeSetSyncDTO[]> wsToCsMap, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        boolean printHeader = true;
        for (Map.Entry<ParmsWorkspace, ChangeSetSyncDTO[]> entry : wsToCsMap.entrySet()) {
            SuspendResultDTO result;
            ParmsSuspendChangeSets parmsCs = new ParmsSuspendChangeSets();
            parmsCs.workspace = entry.getKey();
            ChangeSetSyncDTO[] csDTOList = entry.getValue();
            parmsCs.changeSetItemIds = new String[csDTOList.length];
            int i = 0;
            while (i < csDTOList.length) {
                parmsCs.changeSetItemIds[i] = csDTOList[i].getChangeSetItemId();
                ++i;
            }
            parmsCs.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
            parmsCs.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            parmsCs.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
            parmsCs.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parmsCs.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parmsCs.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            parmsCs.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parmsCs.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parmsCs.autoReleaseLocks = !cli.hasOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK) ? Boolean.valueOf(((ScmClientConfiguration)config).getPersistentPreferences().getReleaseLockForSuspend()) : Boolean.valueOf(Boolean.parseBoolean(cli.getOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK).toString()));
            try {
                result = client.postSuspendChangeSets(parmsCs, null);
            }
            catch (TeamRepositoryException e) {
                PatchInProgressException port = (PatchInProgressException)SubcommandUtil.findExceptionByType(PatchInProgressException.class, (TeamRepositoryException)e);
                if (port != null) {
                    throw StatusHelper.portsInProgress((String)port.getLocalizedMessage());
                }
                GapException gap = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
                if (gap != null) {
                    throw StatusHelper.gap((String)(String.valueOf(Messages.SuspendCmd_9) + " " + Messages.DeliverCmd_HINT_ON_GAP));
                }
                NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
                if (nway != null) {
                    throw StatusHelper.nWayConflict((String)Messages.SuspendCmd_10);
                }
                DiscardNotInHistoryException notinHistory = (DiscardNotInHistoryException)SubcommandUtil.findExceptionByType(DiscardNotInHistoryException.class, (TeamRepositoryException)e);
                if (notinHistory != null) {
                    throw StatusHelper.discardNotInHistory((String)Messages.SuspendCmd_CS_NOT_IN_HISTORY);
                }
                throw StatusHelper.wrap((String)Messages.SuspendCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (result.isCancelled()) {
                int noOfUncheckedInChanges;
                if (result.getOutOfSyncShares().size() > 0) {
                    AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
                }
                if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                    throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
                }
            }
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                if (printHeader && !config.isJSONEnabled()) {
                    out.println((CharSequence)Messages.SuspendCmd_7);
                    printHeader = false;
                }
                this.printSuspendedChangesets(entry.getKey(), csDTOList, client, config, out);
            }
            if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
                SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
        }
    }

    private void printSuspendedChangesets(ParmsWorkspace ws, ChangeSetSyncDTO[] csDTOList, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.setVerbose(true);
        options.enablePrinter(0);
        options.enablePrinter(1);
        options.enablePrinter(10);
        options.enablePrinter(4);
        options.enablePrinter(6);
        options.enableFilter(0);
        options.enableFilter(11);
        options.enableFilter(24);
        options.enableFilter(25);
        options.enableFilter(1);
        options.enableFilter(4);
        int maxChanges = CommonOptions.getMaxChangesToInterpret((IClientConfiguration)config);
        options.setMaxChanges(maxChanges);
        options.addFilter(UUID.valueOf((String)ws.workspaceItemId), 0);
        ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOList;
        int n = csDTOList.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO cs = changeSetSyncDTOArray[n2];
            options.addFilter(UUID.valueOf((String)cs.getChangeSetItemId()), 4);
            if (!options.isInFilter(UUID.valueOf((String)cs.getComponentItemId()), 1)) {
                options.addFilter(UUID.valueOf((String)cs.getComponentItemId()), 1);
            }
            ++n2;
        }
        IWorkspaceConnection wsConn = null;
        try {
            wsConn = ws.getWorkspaceConnection(null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.DiffCmd_84, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        PendingChangesUtil.printPendingChanges((IFilesystemRestClient)client, Collections.singletonList(wsConn), (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out.indent(), (IScmClientConfiguration)config);
    }
}

